/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Connect;
import de.independit.scheduler.server.parser.ManipJob;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSAuditTrailTable;
import de.independit.scheduler.server.repository.SDMSEntityVariable;
import de.independit.scheduler.server.repository.SDMSEntityVariableTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.repository.SDMSSystemMessage;
import java.util.Date;
import java.util.Vector;

public class SetParameter
extends ManipJob {
    public static final String __version = "@(#) $Id: SetParameter.java,v 2.4.14.1 2013/03/14 10:24:48 ronald Exp $";
    private WithHash parms;
    private Long jobid;
    private String key;
    private String auditComment;

    public SetParameter(WithHash withHash) {
        this.cmdtype = 4;
        this.parms = withHash;
        this.jobid = null;
        this.auditComment = null;
    }

    public SetParameter(WithHash withHash, Long l, String string, WithHash withHash2) {
        this.cmdtype = 1;
        this.parms = withHash;
        this.jobid = l;
        this.key = string;
        this.auditComment = withHash2 == null ? null : (String)withHash2.get("COMMENT");
    }

    private void writeAudit(SystemEnvironment systemEnvironment, Long l, String string, String string2) throws SDMSException {
        Date date = new Date();
        Long l2 = date.getTime();
        SDMSAuditTrailTable.table.create(systemEnvironment, systemEnvironment.cEnv.uid(), l2, SDMSConstants.AT_SET_PARAMETERS, SDMSConstants.AT_JOB, l, l, Boolean.FALSE, string, string2);
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSSubmittedEntity sDMSSubmittedEntity;
        SDMSPrivilege sDMSPrivilege;
        if (this.jobid == null) {
            this.jobid = systemEnvironment.cEnv.uid();
        }
        if (this.key != null) {
            Connect.validateJobConnect(systemEnvironment, this.jobid, this.key, true);
        }
        if (!(sDMSPrivilege = (sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, this.jobid)).getPrivileges(systemEnvironment)).can(0x40000000L)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03105201628", "Insufficient privileges to modify job parameters"));
        }
        Vector vector = new Vector(this.parms.keySet());
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            boolean bl;
            String string;
            String string2 = (String)vector.get(i);
            Vector vector2 = (Vector)this.parms.get(string2);
            String string3 = (String)vector2.get(1);
            if (this.cmdtype == 4) {
                sDMSSubmittedEntity.setVariableValue(systemEnvironment, string2, string3);
                continue;
            }
            try {
                string = sDMSSubmittedEntity.getVariableValue(systemEnvironment, string2, true, "DEFAULT", false, null, false);
                if (string.equals(string3) && SDMSEntityVariableTable.idx_smeId_Name.containsKey(systemEnvironment, new SDMSKey(sDMSSubmittedEntity.getId(systemEnvironment), (Comparable)((Object)string2)))) {
                    continue;
                }
            }
            catch (SDMSException sDMSException) {
                string = "UNKNOWN";
            }
            String string4 = " ";
            if (string3.contains("\n") || string.contains("\n")) {
                string4 = "\n";
            }
            String string5 = "Parameter '" + string2 + "'," + string4 + "NEW VALUE =" + string4 + "'" + string3 + "',\nOLD VALUE =" + string4 + "'" + string + "'";
            int n2 = sDMSSubmittedEntity.getApprovalMode(systemEnvironment);
            int n3 = n2 & 0x300000;
            boolean bl2 = bl = (n3 & 0x200000) == 0x200000;
            if (n3 != 0) {
                SDMSSystemMessage sDMSSystemMessage = this.createSystemMessage(systemEnvironment, 1, sDMSSubmittedEntity.getId(systemEnvironment), sDMSSubmittedEntity.getMasterId(systemEnvironment), 11, bl, systemEnvironment.cEnv.uid(), this.auditComment, SDMSConstants.lZERO, null, null, string2, string5);
                Long l = sDMSSystemMessage.getId(systemEnvironment);
                SDMSEntityVariable sDMSEntityVariable = SDMSEntityVariableTable.table.create(systemEnvironment, l, string2, string3, Boolean.TRUE, null);
                sDMSSystemMessage.setAdditionalLong(systemEnvironment, sDMSEntityVariable.getId(systemEnvironment));
            }
            if (bl) continue;
            sDMSSubmittedEntity.setVariableValue(systemEnvironment, string2, string3);
            this.writeAudit(systemEnvironment, this.jobid, string5, this.auditComment);
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03206060017", "Parameter set"));
    }
}

