/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.ShowCommented;
import de.independit.scheduler.server.repository.SDMSExitStateDefinition;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSExitStateMapping;
import de.independit.scheduler.server.repository.SDMSExitStateMappingProfile;
import de.independit.scheduler.server.repository.SDMSExitStateMappingTable;
import de.independit.scheduler.server.repository.SDMSUserTable;
import java.util.Collections;
import java.util.Date;
import java.util.Vector;

public class ShowExitStateMapping
extends ShowCommented {
    public static final String __version = "@(#) $Id: ShowExitStateMapping.java,v 2.5.8.2 2013/06/18 09:49:35 ronald Exp $";
    private final ObjectURL url;

    public ShowExitStateMapping(ObjectURL objectURL) {
        this.url = objectURL;
        this.txMode = 1;
        this.auditFlag = false;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector = new Vector<String>();
        SDMSExitStateMappingProfile sDMSExitStateMappingProfile = (SDMSExitStateMappingProfile)this.url.resolve(systemEnvironment);
        if (!sDMSExitStateMappingProfile.checkPrivileges(systemEnvironment, 0x10000000L)) {
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03402041712", "Insufficient privileges"));
        }
        Long l = sDMSExitStateMappingProfile.getId(systemEnvironment);
        vector.add("ID");
        vector.add("NAME");
        vector.add("COMMENT");
        vector.add("COMMENTTYPE");
        vector.add("CREATOR");
        vector.add("CREATE_TIME");
        vector.add("CHANGER");
        vector.add("CHANGE_TIME");
        vector.add("PRIVS");
        vector.add("RANGES");
        Vector<Object> vector2 = new Vector<Object>();
        vector2.add(l);
        vector2.add(sDMSExitStateMappingProfile.getName(systemEnvironment));
        vector2.add(this.getCommentContainer(systemEnvironment, l));
        vector2.add(this.getCommentInfoType(systemEnvironment, l));
        Date date = new Date();
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSExitStateMappingProfile.getCreatorUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(sDMSExitStateMappingProfile.getCreateTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSExitStateMappingProfile.getChangerUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(sDMSExitStateMappingProfile.getChangeTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        vector2.add(sDMSExitStateMappingProfile.getPrivileges(systemEnvironment).toString());
        Vector<String> vector3 = new Vector<String>();
        vector3.add("ECR_START");
        vector3.add("ECR_END");
        vector3.add("ESD_NAME");
        SDMSOutputContainer sDMSOutputContainer2 = new SDMSOutputContainer(systemEnvironment, null, vector3);
        Vector vector4 = SDMSExitStateMappingTable.idx_esmpId.getVector(systemEnvironment, l);
        for (SDMSExitStateMapping sDMSExitStateMapping : vector4) {
            Vector<Object> vector5 = new Vector<Object>();
            vector5.add(sDMSExitStateMapping.getEcrStart(systemEnvironment));
            vector5.add(sDMSExitStateMapping.getEcrEnd(systemEnvironment));
            SDMSExitStateDefinition sDMSExitStateDefinition = SDMSExitStateDefinitionTable.getObject(systemEnvironment, sDMSExitStateMapping.getEsdId(systemEnvironment));
            vector5.add(sDMSExitStateDefinition.getName(systemEnvironment));
            sDMSOutputContainer2.addData(systemEnvironment, vector5);
        }
        Collections.sort(sDMSOutputContainer2.dataset, sDMSOutputContainer2.getComparator(systemEnvironment, 0));
        vector2.add(sDMSOutputContainer2);
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, new SDMSMessage(systemEnvironment, "03201292005", "Exit State Mapping"), vector, vector2);
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "02111082035", "Exit State Mapping shown"));
    }
}

