/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.ShowCommented;
import de.independit.scheduler.server.repository.SDMSEnvironment;
import de.independit.scheduler.server.repository.SDMSEnvironmentTable;
import de.independit.scheduler.server.repository.SDMSFolder;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSFootprint;
import de.independit.scheduler.server.repository.SDMSFootprintTable;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSObjectComment;
import de.independit.scheduler.server.repository.SDMSObjectCommentTable;
import de.independit.scheduler.server.repository.SDMSParameterDefinition;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionTable;
import de.independit.scheduler.server.repository.SDMSPool;
import de.independit.scheduler.server.repository.SDMSPoolProxyGeneric;
import de.independit.scheduler.server.repository.SDMSPoolTable;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceReqStates;
import de.independit.scheduler.server.repository.SDMSResourceReqStatesTable;
import de.independit.scheduler.server.repository.SDMSResourceRequirement;
import de.independit.scheduler.server.repository.SDMSResourceRequirementTable;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSResourceStateMappingProfile;
import de.independit.scheduler.server.repository.SDMSResourceStateMappingProfileTable;
import de.independit.scheduler.server.repository.SDMSResourceStateProfileTable;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSResourceTemplate;
import de.independit.scheduler.server.repository.SDMSResourceTemplateTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.repository.SDMSUserTable;
import de.independit.scheduler.server.util.Lockmode;
import de.independit.scheduler.server.util.PathVector;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Vector;

public class ShowNamedResource
extends ShowCommented {
    private ObjectURL url;
    HashSet expandIds;
    Boolean condensed;

    public ShowNamedResource(ObjectURL objectURL) {
        this.url = objectURL;
        this.expandIds = null;
        this.txMode = 1;
        this.auditFlag = false;
    }

    public ShowNamedResource(ObjectURL objectURL, HashSet hashSet, Boolean bl) {
        this.url = objectURL;
        this.expandIds = hashSet;
        this.condensed = bl;
        this.txMode = 1;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector = new Vector<String>();
        SDMSNamedResource sDMSNamedResource = (SDMSNamedResource)this.url.resolve(systemEnvironment);
        if (!sDMSNamedResource.checkPrivileges(systemEnvironment, 0x10000000L)) {
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "034020411718", "Insufficient privileges"));
        }
        Long l = sDMSNamedResource.getId(systemEnvironment);
        vector.add("ID");
        vector.add("NAME");
        vector.add("OWNER");
        vector.add("USAGE");
        vector.add("INHERIT_PRIVS");
        vector.add("RESOURCE_STATE_PROFILE");
        vector.add("FACTOR");
        vector.add("COMMENT");
        vector.add("COMMENTTYPE");
        vector.add("CREATOR");
        vector.add("CREATE_TIME");
        vector.add("CHANGER");
        vector.add("CHANGE_TIME");
        vector.add("PRIVS");
        vector.add("RESOURCES");
        vector.add("PARAMETERS");
        if (!this.condensed.booleanValue()) {
            vector.add("JOB_DEFINITIONS");
        }
        Vector<Object> vector2 = new Vector<Object>();
        vector2.add(l);
        vector2.add(sDMSNamedResource.pathVector(systemEnvironment));
        SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, sDMSNamedResource.getOwnerId(systemEnvironment));
        vector2.add(sDMSGroup.getName(systemEnvironment));
        vector2.add(sDMSNamedResource.getUsageAsString(systemEnvironment));
        vector2.add(new SDMSPrivilege(systemEnvironment, sDMSNamedResource.getInheritPrivs(systemEnvironment)).toString());
        Long l2 = sDMSNamedResource.getRspId(systemEnvironment);
        if (l2 != null) {
            vector2.add(SDMSResourceStateProfileTable.getObject(systemEnvironment, l2).getName(systemEnvironment));
        } else {
            vector2.add(null);
        }
        vector2.add(sDMSNamedResource.getFactor(systemEnvironment));
        vector2.add(this.getCommentContainer(systemEnvironment, l));
        vector2.add(this.getCommentInfoType(systemEnvironment, l));
        Date date = new Date();
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSNamedResource.getCreatorUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(sDMSNamedResource.getCreateTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSNamedResource.getChangerUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(sDMSNamedResource.getChangeTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        vector2.add(sDMSNamedResource.getPrivileges(systemEnvironment).toString());
        this.add_resources(systemEnvironment, l, vector2);
        this.add_parameters(systemEnvironment, l, vector2);
        if (!this.condensed.booleanValue()) {
            this.add_job_definitions(systemEnvironment, sDMSNamedResource, l, vector2);
        }
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "Named Resource", vector, vector2);
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03112182117", "Named Resource shown"));
    }

    private void add_resources(SystemEnvironment systemEnvironment, Long l, Vector vector) throws SDMSException {
        Integer n;
        Comparable comparable;
        SDMSGroup sDMSGroup;
        SDMSScope sDMSScope;
        Vector<Object> vector2;
        int n2;
        Vector<String> vector3 = new Vector<String>();
        vector3.add("ID");
        vector3.add("SCOPE");
        vector3.add("TYPE");
        vector3.add("OWNER");
        vector3.add("STATE");
        vector3.add("REQUESTABLE_AMOUNT");
        vector3.add("AMOUNT");
        vector3.add("FREE_AMOUNT");
        vector3.add("IS_ONLINE");
        vector3.add("PRIVS");
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, null, vector3);
        Vector vector4 = SDMSResourceTable.idx_nrId.getVector(systemEnvironment, l);
        for (n2 = 0; n2 < vector4.size(); ++n2) {
            SDMSResource sDMSResource = (SDMSResource)vector4.get(n2);
            vector2 = new Vector<Object>();
            vector2.add(sDMSResource.getId(systemEnvironment));
            try {
                sDMSScope = SDMSScopeTable.getObject(systemEnvironment, sDMSResource.getScopeId(systemEnvironment));
                vector2.add(sDMSScope.pathVector(systemEnvironment));
                vector2.add(sDMSScope.getTypeAsString(systemEnvironment));
            }
            catch (NotFoundException notFoundException) {
                try {
                    SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, sDMSResource.getScopeId(systemEnvironment));
                    vector2.add(sDMSFolder.pathVector(systemEnvironment));
                    vector2.add("FOLDER");
                }
                catch (NotFoundException notFoundException2) {
                    SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, sDMSResource.getScopeId(systemEnvironment));
                    SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), sDMSSubmittedEntity.getSeVersion(systemEnvironment));
                    PathVector pathVector = sDMSSchedulingEntity.pathVector(systemEnvironment, sDMSSubmittedEntity.getSeVersion(systemEnvironment));
                    pathVector.add("[" + sDMSSubmittedEntity.getId(systemEnvironment) + "]");
                    vector2.add(pathVector);
                    vector2.add("JOB");
                }
            }
            sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, sDMSResource.getOwnerId(systemEnvironment));
            vector2.add(sDMSGroup.getName(systemEnvironment));
            if (sDMSResource.getRsdId(systemEnvironment) != null) {
                vector2.add(SDMSResourceStateDefinitionTable.getObject(systemEnvironment, sDMSResource.getRsdId(systemEnvironment)).getName(systemEnvironment));
            } else {
                vector2.add(null);
            }
            comparable = sDMSResource.getRequestableAmount(systemEnvironment);
            vector2.add(comparable == null ? "INFINITE" : comparable);
            comparable = sDMSResource.getAmount(systemEnvironment);
            vector2.add(comparable == null ? "INFINITE" : comparable);
            comparable = sDMSResource.getFreeAmount(systemEnvironment);
            vector2.add(comparable == null ? "INFINITE" : comparable);
            vector2.add(sDMSResource.getIsOnline(systemEnvironment));
            vector2.add(sDMSResource.getPrivileges(systemEnvironment).toString());
            sDMSOutputContainer.addData(systemEnvironment, vector2);
        }
        vector4 = SDMSResourceTemplateTable.idx_nrId.getVector(systemEnvironment, l);
        for (n2 = 0; n2 < vector4.size(); ++n2) {
            SDMSResourceTemplate sDMSResourceTemplate = (SDMSResourceTemplate)vector4.get(n2);
            vector2 = new Vector();
            vector2.add(sDMSResourceTemplate.getId(systemEnvironment));
            comparable = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSResourceTemplate.getSeId(systemEnvironment));
            vector2.add(((SDMSSchedulingEntity)comparable).pathVector(systemEnvironment));
            vector2.add("JOB");
            sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, sDMSResourceTemplate.getOwnerId(systemEnvironment));
            vector2.add(sDMSGroup.getName(systemEnvironment));
            if (sDMSResourceTemplate.getRsdId(systemEnvironment) != null) {
                vector2.add(SDMSResourceStateDefinitionTable.getObject(systemEnvironment, sDMSResourceTemplate.getRsdId(systemEnvironment)).getName(systemEnvironment));
            } else {
                vector2.add(null);
            }
            n = sDMSResourceTemplate.getRequestableAmount(systemEnvironment);
            vector2.add(n == null ? "INFINITE" : n);
            n = sDMSResourceTemplate.getAmount(systemEnvironment);
            vector2.add(n == null ? "INFINITE" : n);
            vector2.add(n == null ? "INFINITE" : n);
            vector2.add(sDMSResourceTemplate.getIsOnline(systemEnvironment));
            vector2.add(sDMSResourceTemplate.getPrivileges(systemEnvironment).toString());
            sDMSOutputContainer.addData(systemEnvironment, vector2);
        }
        Vector vector5 = SDMSPoolTable.idx_nrId.getVector(systemEnvironment, l);
        for (n2 = 0; n2 < vector5.size(); ++n2) {
            comparable = (SDMSPool)vector5.get(n2);
            vector2 = new Vector();
            vector2.add(((SDMSProxy)comparable).getId(systemEnvironment));
            sDMSScope = SDMSScopeTable.getObject(systemEnvironment, ((SDMSPoolProxyGeneric)comparable).getScopeId(systemEnvironment));
            vector2.add(sDMSScope.pathVector(systemEnvironment));
            vector2.add(sDMSScope.getTypeAsString(systemEnvironment));
            sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, ((SDMSPoolProxyGeneric)comparable).getOwnerId(systemEnvironment));
            vector2.add(sDMSGroup.getName(systemEnvironment));
            vector2.add(null);
            n = 0;
            vector2.add(n);
            vector2.add(n);
            vector2.add(n);
            vector2.add(Boolean.TRUE);
            vector2.add(((SDMSPoolProxyGeneric)comparable).getPrivileges(systemEnvironment).toString());
            sDMSOutputContainer.addData(systemEnvironment, vector2);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 2, 1));
        vector.add(sDMSOutputContainer);
    }

    private void add_parameters(SystemEnvironment systemEnvironment, Long l, Vector vector) throws SDMSException {
        Vector<String> vector2 = new Vector<String>();
        vector2.add("ID");
        vector2.add("NAME");
        vector2.add("TYPE");
        vector2.add("DEFAULT_VALUE");
        vector2.add("TAG");
        vector2.add("COMMENT");
        vector2.add("COMMENTTYPE");
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, null, vector2);
        SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, l);
        Vector vector3 = SDMSParameterDefinitionTable.idx_seId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector3.size(); ++i) {
            SDMSParameterDefinition sDMSParameterDefinition = (SDMSParameterDefinition)vector3.get(i);
            this.render_parameter(systemEnvironment, sDMSNamedResource, sDMSOutputContainer, sDMSParameterDefinition);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 1));
        vector.add(sDMSOutputContainer);
    }

    private void render_parameter(SystemEnvironment systemEnvironment, SDMSNamedResource sDMSNamedResource, SDMSOutputContainer sDMSOutputContainer, SDMSParameterDefinition sDMSParameterDefinition) throws SDMSException {
        String string = sDMSParameterDefinition.getName(systemEnvironment);
        String string2 = sDMSParameterDefinition.getDefaultValue(systemEnvironment);
        Long l = sDMSParameterDefinition.getId(systemEnvironment);
        Vector<Object> vector = new Vector<Object>();
        vector.add(l);
        vector.add(string);
        vector.add(sDMSParameterDefinition.getTypeAsString(systemEnvironment));
        if (string2 != null) {
            vector.add(string2.substring(1));
        } else {
            vector.add(null);
        }
        try {
            SDMSObjectComment sDMSObjectComment = SDMSObjectCommentTable.idx_objectId_getFirst(systemEnvironment, l);
            vector.add(sDMSObjectComment.getTag(systemEnvironment));
            vector.add(sDMSObjectComment.getDescription(systemEnvironment));
            vector.add(sDMSObjectComment.getInfoTypeAsString(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector.add(null);
            vector.add(null);
            vector.add(null);
        }
        sDMSOutputContainer.addData(systemEnvironment, vector);
    }

    public Vector fillHeadInfo() {
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("NAME");
        vector.add("AMOUNT");
        vector.add("KEEP_MODE");
        vector.add("IS_STICKY");
        vector.add("STICKY_NAME");
        vector.add("STICKY_PARENT");
        vector.add("RESOURCE_STATE_MAPPING");
        vector.add("EXPIRED_AMOUNT");
        vector.add("EXPIRED_BASE");
        vector.add("IGNORE_ON_RERUN");
        vector.add("LOCKMODE");
        vector.add("STATES");
        vector.add("CONDITION");
        vector.add("PRIVS");
        return vector;
    }

    private void add_job_definitions(SystemEnvironment systemEnvironment, SDMSNamedResource sDMSNamedResource, Long l, Vector vector) throws SDMSException {
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, null, this.fillHeadInfo());
        switch (sDMSNamedResource.getUsage(systemEnvironment)) {
            case 1: {
                this.searchAndRenderStatic(systemEnvironment, l, sDMSOutputContainer);
                break;
            }
            case 2: {
                this.searchAndRenderSystem(systemEnvironment, l, sDMSOutputContainer);
                break;
            }
            case 4: {
                this.searchAndRenderSync(systemEnvironment, l, sDMSOutputContainer);
            }
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 1));
        vector.add(sDMSOutputContainer);
    }

    private void searchAndRenderStatic(SystemEnvironment systemEnvironment, Long l, SDMSOutputContainer sDMSOutputContainer) throws SDMSException {
        SDMSSchedulingEntity sDMSSchedulingEntity;
        HashSet<Long> hashSet = new HashSet<Long>();
        Vector vector = SDMSResourceRequirementTable.idx_nrId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSResourceRequirement sDMSResourceRequirement = (SDMSResourceRequirement)vector.get(i);
            sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSResourceRequirement.getSeId(systemEnvironment));
            Vector vector2 = new Vector();
            this.render_rr(systemEnvironment, vector2, sDMSResourceRequirement, sDMSSchedulingEntity);
            hashSet.add(sDMSSchedulingEntity.getId(systemEnvironment));
            sDMSOutputContainer.addData(systemEnvironment, vector2);
        }
        Vector vector3 = SDMSEnvironmentTable.idx_nrId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector3.size(); ++i) {
            SDMSEnvironment sDMSEnvironment = (SDMSEnvironment)vector3.get(i);
            vector = SDMSSchedulingEntityTable.idx_neId.getVector(systemEnvironment, sDMSEnvironment.getNeId(systemEnvironment));
            for (int j = 0; j < vector.size(); ++j) {
                sDMSSchedulingEntity = (SDMSSchedulingEntity)vector.get(j);
                if (hashSet.contains(sDMSSchedulingEntity.getId(systemEnvironment))) continue;
                Vector vector4 = new Vector();
                this.render_env(systemEnvironment, vector4, sDMSSchedulingEntity, sDMSEnvironment);
                hashSet.add(sDMSSchedulingEntity.getId(systemEnvironment));
                sDMSOutputContainer.addData(systemEnvironment, vector4);
            }
        }
    }

    private void searchAndRenderSystem(SystemEnvironment systemEnvironment, Long l, SDMSOutputContainer sDMSOutputContainer) throws SDMSException {
        SDMSSchedulingEntity sDMSSchedulingEntity;
        SDMSResourceRequirement sDMSResourceRequirement;
        int n;
        HashSet<Long> hashSet = new HashSet<Long>();
        Vector<SDMSResourceRequirement> vector = new Vector<SDMSResourceRequirement>();
        Vector vector2 = SDMSResourceRequirementTable.idx_nrId.getVector(systemEnvironment, l);
        for (n = 0; n < vector2.size(); ++n) {
            sDMSResourceRequirement = (SDMSResourceRequirement)vector2.get(n);
            try {
                sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSResourceRequirement.getSeId(systemEnvironment));
            }
            catch (NotFoundException notFoundException) {
                vector.add(sDMSResourceRequirement);
                continue;
            }
            Vector vector3 = new Vector();
            this.render_rr(systemEnvironment, vector3, sDMSResourceRequirement, sDMSSchedulingEntity);
            hashSet.add(sDMSSchedulingEntity.getId(systemEnvironment));
            sDMSOutputContainer.addData(systemEnvironment, vector3);
        }
        for (n = 0; n < vector.size(); ++n) {
            sDMSResourceRequirement = (SDMSResourceRequirement)vector.get(n);
            SDMSFootprint sDMSFootprint = SDMSFootprintTable.getObject(systemEnvironment, sDMSResourceRequirement.getSeId(systemEnvironment));
            vector2 = SDMSSchedulingEntityTable.idx_fpId.getVector(systemEnvironment, sDMSFootprint.getId(systemEnvironment));
            for (int i = 0; i < vector2.size(); ++i) {
                sDMSSchedulingEntity = (SDMSSchedulingEntity)vector2.get(i);
                if (hashSet.contains(sDMSSchedulingEntity.getId(systemEnvironment))) continue;
                Vector vector4 = new Vector();
                this.render_rr(systemEnvironment, vector4, sDMSResourceRequirement, sDMSSchedulingEntity);
                hashSet.add(sDMSSchedulingEntity.getId(systemEnvironment));
                sDMSOutputContainer.addData(systemEnvironment, vector4);
            }
        }
    }

    private void searchAndRenderSync(SystemEnvironment systemEnvironment, Long l, SDMSOutputContainer sDMSOutputContainer) throws SDMSException {
        Vector vector = SDMSResourceRequirementTable.idx_nrId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSResourceRequirement sDMSResourceRequirement = (SDMSResourceRequirement)vector.get(i);
            SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSResourceRequirement.getSeId(systemEnvironment));
            Vector vector2 = new Vector();
            this.render_rr(systemEnvironment, vector2, sDMSResourceRequirement, sDMSSchedulingEntity);
            sDMSOutputContainer.addData(systemEnvironment, vector2);
        }
    }

    private void render_rr(SystemEnvironment systemEnvironment, Vector vector, SDMSResourceRequirement sDMSResourceRequirement, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        Comparable comparable;
        vector.add(sDMSSchedulingEntity.getId(systemEnvironment));
        vector.add(sDMSSchedulingEntity.pathVector(systemEnvironment));
        vector.add(sDMSResourceRequirement.getAmount(systemEnvironment));
        vector.add(sDMSResourceRequirement.getKeepModeAsString(systemEnvironment));
        vector.add(sDMSResourceRequirement.getIsSticky(systemEnvironment));
        vector.add(sDMSResourceRequirement.getStickyName(systemEnvironment));
        Long l = sDMSResourceRequirement.getStickyParent(systemEnvironment);
        if (l == null) {
            vector.add(null);
        } else {
            comparable = SDMSSchedulingEntityTable.getObject(systemEnvironment, l);
            vector.add(comparable.pathString(systemEnvironment));
        }
        comparable = sDMSResourceRequirement.getRsmpId(systemEnvironment);
        if (comparable != null) {
            SDMSResourceStateMappingProfile sDMSResourceStateMappingProfile = SDMSResourceStateMappingProfileTable.getObject(systemEnvironment, (Long)comparable);
            vector.add(sDMSResourceStateMappingProfile.getName(systemEnvironment));
        } else {
            vector.add(null);
        }
        vector.add(sDMSResourceRequirement.getExpiredAmount(systemEnvironment));
        vector.add(sDMSResourceRequirement.getExpiredBaseAsString(systemEnvironment));
        vector.add(sDMSResourceRequirement.getIgnoreOnRerun(systemEnvironment));
        Integer n = sDMSResourceRequirement.getLockmode(systemEnvironment);
        if (n != null) {
            vector.add(new Lockmode(systemEnvironment, n).str(systemEnvironment));
        } else {
            vector.add(null);
        }
        Vector vector2 = SDMSResourceReqStatesTable.idx_rrId.getVector(systemEnvironment, sDMSResourceRequirement.getId(systemEnvironment));
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < vector2.size(); ++i) {
            SDMSResourceReqStates sDMSResourceReqStates = (SDMSResourceReqStates)vector2.get(i);
            String string2 = SDMSResourceStateDefinitionTable.getObject(systemEnvironment, sDMSResourceReqStates.getRsdId(systemEnvironment)).getName(systemEnvironment);
            stringBuffer.append(string);
            stringBuffer.append(string2);
            string = ",";
        }
        vector.add(new String(stringBuffer));
        vector.add(sDMSResourceRequirement.getCondition(systemEnvironment));
        vector.add(sDMSSchedulingEntity.getPrivileges(systemEnvironment).toString());
    }

    private void render_env(SystemEnvironment systemEnvironment, Vector vector, SDMSSchedulingEntity sDMSSchedulingEntity, SDMSEnvironment sDMSEnvironment) throws SDMSException {
        vector.add(sDMSSchedulingEntity.getId(systemEnvironment));
        vector.add(sDMSSchedulingEntity.pathVector(systemEnvironment));
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(sDMSEnvironment.getCondition(systemEnvironment));
        vector.add(sDMSSchedulingEntity.getPrivileges(systemEnvironment).toString());
    }
}

