/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.ShowCommented;
import de.independit.scheduler.server.repository.SDMSFolder;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSPoolProxyGeneric;
import de.independit.scheduler.server.repository.SDMSPoolTable;
import de.independit.scheduler.server.repository.SDMSPooledResourceProxyGeneric;
import de.independit.scheduler.server.repository.SDMSPooledResourceTable;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceAllocation;
import de.independit.scheduler.server.repository.SDMSResourceRequirement;
import de.independit.scheduler.server.repository.SDMSResourceRequirementTable;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSResourceStateMappingProfileProxyGeneric;
import de.independit.scheduler.server.repository.SDMSResourceStateMappingProfileTable;
import de.independit.scheduler.server.repository.SDMSResourceStateProfileTable;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSResourceTemplate;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityProxyGeneric;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeProxyGeneric;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.repository.SDMSUserTable;
import de.independit.scheduler.server.util.MasterReservationInfo;
import java.util.Collections;
import java.util.Date;
import java.util.Vector;

public class ShowResource
extends ShowCommented {
    private Vector resourcepath;
    private Vector path;
    private Long rId;
    private ObjectURL resource;
    private static final Integer ALLOCATION = 1;
    private static final Integer MASTER_RESERVATION = 2;
    private static final Integer RESERVATION = 3;
    private static final Integer AVAILABLE = 4;
    private static final Integer BLOCKED = 5;
    private static final Integer MASTER_REQUEST = 6;
    private static final Integer REQUESTED = 7;
    private static final Integer IGNORED = 8;
    private static final int[] sortcols = new int[]{14, 16, 1};

    public ShowResource(ObjectURL objectURL) {
        this.resource = objectURL;
    }

    private Vector fill_desc(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("NAME");
        vector.add("SCOPENAME");
        vector.add("SCOPE_TYPE");
        vector.add("OWNER");
        vector.add("LINK_ID");
        vector.add("LINK_SCOPE");
        vector.add("LINK_SCOPE_TYPE");
        vector.add("BASE_ID");
        vector.add("BASE_SCOPE");
        vector.add("MANAGER_ID");
        vector.add("MANAGER_NAME");
        vector.add("MANAGER_SCOPENAME");
        vector.add("MANAGER_SCOPE_TYPE");
        vector.add("USAGE");
        vector.add("RESOURCE_STATE_PROFILE");
        vector.add("COMMENT");
        vector.add("COMMENTTYPE");
        vector.add("TAG");
        vector.add("STATE");
        vector.add("TIMESTAMP");
        vector.add("REQUESTABLE_AMOUNT");
        vector.add("DEFINED_AMOUNT");
        vector.add("AMOUNT");
        vector.add("FREE_AMOUNT");
        vector.add("IS_ONLINE");
        vector.add("FACTOR");
        vector.add("TRACE_INTERVAL");
        vector.add("TRACE_BASE");
        vector.add("TRACE_BASE_MULTIPLIER");
        vector.add("TD0_AVG");
        vector.add("TD1_AVG");
        vector.add("TD2_AVG");
        vector.add("LW_AVG");
        vector.add("LAST_WRITE");
        vector.add("CREATOR");
        vector.add("CREATE_TIME");
        vector.add("CHANGER");
        vector.add("CHANGE_TIME");
        vector.add("PRIVS");
        vector.add("ALLOCATIONS");
        vector.add("PARAMETERS");
        return vector;
    }

    private Long getId(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, SDMSResourceTemplate sDMSResourceTemplate) throws SDMSException {
        return sDMSResource == null ? sDMSResourceTemplate.getId(systemEnvironment) : sDMSResource.getId(systemEnvironment);
    }

    private Long getOwnerId(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, SDMSResourceTemplate sDMSResourceTemplate) throws SDMSException {
        return sDMSResource == null ? sDMSResourceTemplate.getOwnerId(systemEnvironment) : sDMSResource.getOwnerId(systemEnvironment);
    }

    private String getTag(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, SDMSResourceTemplate sDMSResourceTemplate) throws SDMSException {
        return sDMSResource == null ? null : sDMSResource.getTag(systemEnvironment);
    }

    private Long getRsdId(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, SDMSResourceTemplate sDMSResourceTemplate) throws SDMSException {
        return sDMSResource == null ? sDMSResourceTemplate.getRsdId(systemEnvironment) : sDMSResource.getRsdId(systemEnvironment);
    }

    private Long getRsdTime(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, SDMSResourceTemplate sDMSResourceTemplate) throws SDMSException {
        return sDMSResource == null ? null : sDMSResource.getRsdTime(systemEnvironment);
    }

    private Integer getRequestableAmount(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, SDMSResourceTemplate sDMSResourceTemplate) throws SDMSException {
        return sDMSResource == null ? sDMSResourceTemplate.getRequestableAmount(systemEnvironment) : sDMSResource.getRequestableAmount(systemEnvironment);
    }

    private Integer getDefinedAmount(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, SDMSResourceTemplate sDMSResourceTemplate) throws SDMSException {
        return sDMSResource == null ? sDMSResourceTemplate.getAmount(systemEnvironment) : sDMSResource.getDefinedAmount(systemEnvironment);
    }

    private Integer getAmount(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, SDMSResourceTemplate sDMSResourceTemplate) throws SDMSException {
        return sDMSResource == null ? sDMSResourceTemplate.getAmount(systemEnvironment) : sDMSResource.getAmount(systemEnvironment);
    }

    private Integer getFreeAmount(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, SDMSResourceTemplate sDMSResourceTemplate) throws SDMSException {
        return sDMSResource == null ? null : sDMSResource.getFreeAmount(systemEnvironment);
    }

    private Boolean getIsOnline(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, SDMSResourceTemplate sDMSResourceTemplate) throws SDMSException {
        return sDMSResource == null ? sDMSResourceTemplate.getIsOnline(systemEnvironment) : sDMSResource.getIsOnline(systemEnvironment);
    }

    private Float getFactor(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, SDMSResourceTemplate sDMSResourceTemplate) throws SDMSException {
        return sDMSResource == null ? null : sDMSResource.getFactor(systemEnvironment);
    }

    private Integer getTraceInterval(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, SDMSResourceTemplate sDMSResourceTemplate) throws SDMSException {
        return sDMSResource == null ? null : sDMSResource.getTraceInterval(systemEnvironment);
    }

    private Integer getTraceBase(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, SDMSResourceTemplate sDMSResourceTemplate) throws SDMSException {
        return sDMSResource == null ? null : sDMSResource.getTraceBase(systemEnvironment);
    }

    private Integer getTraceBaseMultiplier(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, SDMSResourceTemplate sDMSResourceTemplate) throws SDMSException {
        return sDMSResource == null ? null : sDMSResource.getTraceBaseMultiplier(systemEnvironment);
    }

    private Float getTd0Avg(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, SDMSResourceTemplate sDMSResourceTemplate) throws SDMSException {
        return sDMSResource == null ? null : sDMSResource.getTd0Avg(systemEnvironment);
    }

    private Float getTd1Avg(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, SDMSResourceTemplate sDMSResourceTemplate) throws SDMSException {
        return sDMSResource == null ? null : sDMSResource.getTd1Avg(systemEnvironment);
    }

    private Float getTd2Avg(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, SDMSResourceTemplate sDMSResourceTemplate) throws SDMSException {
        return sDMSResource == null ? null : sDMSResource.getTd2Avg(systemEnvironment);
    }

    private Float getLwAvg(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, SDMSResourceTemplate sDMSResourceTemplate) throws SDMSException {
        return sDMSResource == null ? null : sDMSResource.getLwAvg(systemEnvironment);
    }

    private Long getLastWrite(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, SDMSResourceTemplate sDMSResourceTemplate) throws SDMSException {
        return sDMSResource == null ? null : sDMSResource.getLastWrite(systemEnvironment);
    }

    private Long getCreatorUId(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, SDMSResourceTemplate sDMSResourceTemplate) throws SDMSException {
        return sDMSResource == null ? sDMSResourceTemplate.getCreatorUId(systemEnvironment) : sDMSResource.getCreatorUId(systemEnvironment);
    }

    private Long getCreateTs(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, SDMSResourceTemplate sDMSResourceTemplate) throws SDMSException {
        return sDMSResource == null ? sDMSResourceTemplate.getCreateTs(systemEnvironment) : sDMSResource.getCreateTs(systemEnvironment);
    }

    private Long getChangerUId(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, SDMSResourceTemplate sDMSResourceTemplate) throws SDMSException {
        return sDMSResource == null ? sDMSResourceTemplate.getChangerUId(systemEnvironment) : sDMSResource.getChangerUId(systemEnvironment);
    }

    private Long getChangeTs(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, SDMSResourceTemplate sDMSResourceTemplate) throws SDMSException {
        return sDMSResource == null ? sDMSResourceTemplate.getChangeTs(systemEnvironment) : sDMSResource.getChangeTs(systemEnvironment);
    }

    private SDMSPrivilege getPrivileges(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, SDMSResourceTemplate sDMSResourceTemplate) throws SDMSException {
        return sDMSResource == null ? sDMSResourceTemplate.getPrivileges(systemEnvironment) : sDMSResource.getPrivileges(systemEnvironment);
    }

    private SDMSOutputContainer getVariables(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, SDMSResourceTemplate sDMSResourceTemplate) throws SDMSException {
        SDMSOutputContainer sDMSOutputContainer = null;
        if (sDMSResource != null) {
            sDMSOutputContainer = sDMSResource.getVariables(systemEnvironment);
        } else if (sDMSResourceTemplate != null) {
            sDMSOutputContainer = sDMSResourceTemplate.getVariables(systemEnvironment);
        }
        return sDMSOutputContainer;
    }

    private Vector fill_master(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy, SDMSNamedResource sDMSNamedResource, String string, String string2) throws SDMSException {
        Comparable comparable;
        Comparable comparable2;
        Comparable comparable3;
        Comparable comparable4;
        Long l;
        SDMSResource sDMSResource = null;
        SDMSResourceTemplate sDMSResourceTemplate = null;
        try {
            sDMSResource = (SDMSResource)sDMSProxy;
        }
        catch (ClassCastException classCastException) {
            sDMSResourceTemplate = (SDMSResourceTemplate)sDMSProxy;
        }
        Vector<Object> vector = new Vector<Object>();
        Long l2 = this.getId(systemEnvironment, sDMSResource, sDMSResourceTemplate);
        vector.add(this.getId(systemEnvironment, sDMSResource, sDMSResourceTemplate));
        vector.add(sDMSNamedResource.pathString(systemEnvironment));
        vector.add(string);
        vector.add(string2);
        vector.add(SDMSGroupTable.getObject(systemEnvironment, this.getOwnerId(systemEnvironment, sDMSResource, sDMSResourceTemplate)).getName(systemEnvironment));
        if (sDMSResource != null) {
            l = sDMSResource.getLinkId(systemEnvironment);
            vector.add(l);
            if (l != null) {
                sDMSResource = SDMSResourceTable.getObject(systemEnvironment, l);
                comparable4 = SDMSScopeTable.getObject(systemEnvironment, sDMSResource.getScopeId(systemEnvironment));
                vector.add(((SDMSScopeProxyGeneric)comparable4).pathString(systemEnvironment));
                vector.add(((SDMSScopeProxyGeneric)comparable4).getTypeAsString(systemEnvironment));
                while (l != null) {
                    sDMSResource = SDMSResourceTable.getObject(systemEnvironment, l);
                    l = sDMSResource.getLinkId(systemEnvironment);
                }
                vector.add(sDMSResource.getId(systemEnvironment));
                comparable4 = SDMSScopeTable.getObject(systemEnvironment, sDMSResource.getScopeId(systemEnvironment));
                vector.add(((SDMSScopeProxyGeneric)comparable4).pathString(systemEnvironment));
            } else {
                vector.add(null);
                vector.add(null);
                vector.add(null);
                vector.add(null);
            }
            comparable4 = sDMSResource.getManagerId(systemEnvironment);
            vector.add(comparable4);
            if (comparable4 != null) {
                comparable3 = SDMSPooledResourceTable.getObject(systemEnvironment, (Long)comparable4);
                comparable2 = SDMSPoolTable.getObject(systemEnvironment, ((SDMSPooledResourceProxyGeneric)comparable3).getPId(systemEnvironment));
                vector.add(SDMSNamedResourceTable.getObject(systemEnvironment, ((SDMSPoolProxyGeneric)comparable2).getNrId(systemEnvironment)).pathVector(systemEnvironment));
                comparable = SDMSScopeTable.getObject(systemEnvironment, ((SDMSPoolProxyGeneric)comparable2).getScopeId(systemEnvironment));
                vector.add(comparable.pathVector(systemEnvironment));
                vector.add(comparable.getTypeAsString(systemEnvironment));
            } else {
                vector.add(null);
                vector.add(null);
                vector.add(null);
            }
        } else {
            vector.add(null);
            vector.add(null);
            vector.add(null);
            vector.add(null);
            vector.add(null);
            vector.add(null);
            vector.add(null);
            vector.add(null);
            vector.add(null);
        }
        vector.add(sDMSNamedResource.getUsageAsString(systemEnvironment));
        l = sDMSNamedResource.getRspId(systemEnvironment);
        if (l != null) {
            vector.add(SDMSResourceStateProfileTable.getObject(systemEnvironment, l).getName(systemEnvironment));
        } else {
            vector.add(null);
        }
        vector.add(this.getCommentContainer(systemEnvironment, l2));
        vector.add(this.getCommentInfoType(systemEnvironment, l2));
        vector.add(this.getTag(systemEnvironment, sDMSResource, sDMSResourceTemplate));
        comparable4 = this.getRsdId(systemEnvironment, sDMSResource, sDMSResourceTemplate);
        if (comparable4 != null) {
            vector.add(SDMSResourceStateDefinitionTable.getObject(systemEnvironment, (Long)comparable4).getName(systemEnvironment));
        } else {
            vector.add(null);
        }
        comparable3 = this.getRsdTime(systemEnvironment, sDMSResource, sDMSResourceTemplate);
        comparable2 = new Date();
        if (comparable3 != null && sDMSNamedResource.getUsage(systemEnvironment) == 4 && sDMSNamedResource.getRspId(systemEnvironment) != null) {
            ((Date)comparable2).setTime((Long)comparable3);
            vector.add(systemEnvironment.systemDateFormat.format((Date)comparable2));
        } else {
            vector.add(null);
        }
        comparable = this.getRequestableAmount(systemEnvironment, sDMSResource, sDMSResourceTemplate);
        vector.add(comparable == null ? "INFINITE" : comparable);
        comparable = this.getDefinedAmount(systemEnvironment, sDMSResource, sDMSResourceTemplate);
        vector.add(comparable == null ? "INFINITE" : comparable);
        comparable = this.getAmount(systemEnvironment, sDMSResource, sDMSResourceTemplate);
        vector.add(comparable == null ? "INFINITE" : comparable);
        comparable = this.getFreeAmount(systemEnvironment, sDMSResource, sDMSResourceTemplate);
        vector.add(comparable == null ? "INFINITE" : comparable);
        vector.add(this.getIsOnline(systemEnvironment, sDMSResource, sDMSResourceTemplate));
        vector.add(this.getFactor(systemEnvironment, sDMSResource, sDMSResourceTemplate));
        vector.add(this.getTraceInterval(systemEnvironment, sDMSResource, sDMSResourceTemplate));
        vector.add(this.getTraceBase(systemEnvironment, sDMSResource, sDMSResourceTemplate));
        vector.add(this.getTraceBaseMultiplier(systemEnvironment, sDMSResource, sDMSResourceTemplate));
        vector.add(this.getTd0Avg(systemEnvironment, sDMSResource, sDMSResourceTemplate));
        vector.add(this.getTd1Avg(systemEnvironment, sDMSResource, sDMSResourceTemplate));
        vector.add(this.getTd2Avg(systemEnvironment, sDMSResource, sDMSResourceTemplate));
        vector.add(this.getLwAvg(systemEnvironment, sDMSResource, sDMSResourceTemplate));
        comparable3 = this.getLastWrite(systemEnvironment, sDMSResource, sDMSResourceTemplate);
        if (comparable3 == null || (Long)comparable3 == 0L) {
            vector.add(null);
        } else {
            ((Date)comparable2).setTime((Long)comparable3);
            vector.add(systemEnvironment.systemDateFormat.format((Date)comparable2));
        }
        try {
            vector.add(SDMSUserTable.getObject(systemEnvironment, this.getCreatorUId(systemEnvironment, sDMSResource, sDMSResourceTemplate)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector.add("unknown");
        }
        ((Date)comparable2).setTime(this.getCreateTs(systemEnvironment, sDMSResource, sDMSResourceTemplate));
        vector.add(systemEnvironment.systemDateFormat.format((Date)comparable2));
        try {
            try {
                vector.add(SDMSUserTable.getObject(systemEnvironment, this.getChangerUId(systemEnvironment, sDMSResource, sDMSResourceTemplate)).getName(systemEnvironment));
            }
            catch (NotFoundException notFoundException) {
                vector.add(SDMSScopeTable.getObject(systemEnvironment, this.getChangerUId(systemEnvironment, sDMSResource, sDMSResourceTemplate)).pathString(systemEnvironment));
            }
        }
        catch (NotFoundException notFoundException) {
            vector.add("unknown");
        }
        ((Date)comparable2).setTime(this.getChangeTs(systemEnvironment, sDMSResource, sDMSResourceTemplate));
        vector.add(systemEnvironment.systemDateFormat.format((Date)comparable2));
        vector.add(this.getPrivileges(systemEnvironment, sDMSResource, sDMSResourceTemplate).toString());
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, null, this.fill_rdesc(systemEnvironment));
        if (sDMSResource != null) {
            Vector vector2 = sDMSResource.getAllocations(systemEnvironment);
            for (int i = 0; i < vector2.size(); ++i) {
                SDMSResourceAllocation sDMSResourceAllocation = (SDMSResourceAllocation)vector2.get(i);
                if (sDMSResourceAllocation.getAllocationType(systemEnvironment) == 6) continue;
                sDMSOutputContainer.addData(systemEnvironment, this.fill_detail(systemEnvironment, sDMSResourceAllocation, sDMSNamedResource, sDMSResource));
            }
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, sortcols));
        vector.add(sDMSOutputContainer);
        vector.add(this.getVariables(systemEnvironment, sDMSResource, sDMSResourceTemplate));
        return vector;
    }

    private Vector fill_rdesc(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("JOBID");
        vector.add("MASTERID");
        vector.add("JOBTYPE");
        vector.add("JOBNAME");
        vector.add("AMOUNT");
        vector.add("KEEP_MODE");
        vector.add("IS_STICKY");
        vector.add("STICKY_NAME");
        vector.add("STICKY_PARENT");
        vector.add("STICKY_PARENT_TYPE");
        vector.add("LOCKMODE");
        vector.add("RSM_NAME");
        vector.add("TYPE");
        vector.add("TYPESORT");
        vector.add("P");
        vector.add("EP");
        vector.add("PRIVS");
        return vector;
    }

    private Vector fill_detail(SystemEnvironment systemEnvironment, SDMSResourceAllocation sDMSResourceAllocation, SDMSNamedResource sDMSNamedResource, SDMSResource sDMSResource) throws SDMSException {
        SDMSProxy sDMSProxy;
        Comparable comparable;
        Vector<Object> vector = new Vector<Object>();
        vector.add(sDMSResourceAllocation.getId(systemEnvironment));
        long l = sDMSResourceAllocation.getSmeId(systemEnvironment);
        Long l2 = l < 0L ? -l : l;
        vector.add(l2);
        SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, l2);
        vector.add(sDMSSubmittedEntity.getMasterId(systemEnvironment));
        long l3 = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
        Long l4 = sDMSSubmittedEntity.getSeId(systemEnvironment);
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l4, l3);
        vector.add(sDMSSchedulingEntity.getTypeAsString(systemEnvironment));
        vector.add(sDMSSubmittedEntity.getSubmitPathString(systemEnvironment, true));
        vector.add(sDMSResourceAllocation.getAmount(systemEnvironment));
        vector.add(sDMSResourceAllocation.getKeepModeAsString(systemEnvironment));
        vector.add(sDMSResourceAllocation.getIsSticky(systemEnvironment));
        vector.add(sDMSResourceAllocation.getStickyName(systemEnvironment));
        Long l5 = sDMSResourceAllocation.getStickyParent(systemEnvironment);
        vector.add(l5);
        if (l5 == null) {
            vector.add(null);
        } else {
            comparable = SDMSSubmittedEntityTable.getObject(systemEnvironment, l5);
            sDMSProxy = SDMSSchedulingEntityTable.getObject(systemEnvironment, comparable.getSeId(systemEnvironment), l3);
            vector.add(((SDMSSchedulingEntityProxyGeneric)sDMSProxy).getTypeAsString(systemEnvironment));
        }
        vector.add(sDMSResourceAllocation.getLockmodeAsString(systemEnvironment));
        comparable = sDMSResourceAllocation.getRsmpId(systemEnvironment);
        if (comparable != null) {
            sDMSProxy = SDMSResourceStateMappingProfileTable.getObject(systemEnvironment, sDMSResourceAllocation.getRsmpId(systemEnvironment), l3);
            vector.add(((SDMSResourceStateMappingProfileProxyGeneric)sDMSProxy).getName(systemEnvironment));
        } else {
            vector.add(null);
        }
        int n = sDMSResourceAllocation.getAllocationType(systemEnvironment);
        if (n == 1) {
            SDMSResourceRequirement sDMSResourceRequirement;
            Long l6 = sDMSNamedResource.getId(systemEnvironment);
            try {
                sDMSResourceRequirement = SDMSResourceRequirementTable.idx_seId_nrId_getUnique(systemEnvironment, new SDMSKey(l4, l6), l3);
            }
            catch (NotFoundException notFoundException) {
                Long l7 = sDMSSchedulingEntity.getFpId(systemEnvironment);
                sDMSResourceRequirement = SDMSResourceRequirementTable.idx_seId_nrId_getUnique(systemEnvironment, new SDMSKey(l7, l6), l3);
            }
            if (sDMSResource.checkAllocate(systemEnvironment, sDMSResourceRequirement, sDMSSubmittedEntity, sDMSResourceAllocation) == 0) {
                if (SystemEnvironment.sched.isBlocked(systemEnvironment, l2, sDMSResource.getId(systemEnvironment))) {
                    vector.add("BLOCKED");
                    vector.add(BLOCKED);
                } else if (sDMSResourceAllocation.getIsSticky(systemEnvironment).booleanValue()) {
                    MasterReservationInfo masterReservationInfo = SystemEnvironment.sched.checkMasterReservation(systemEnvironment, sDMSSubmittedEntity, sDMSResourceRequirement, sDMSResourceAllocation.getStickyParent(systemEnvironment), sDMSResource);
                    if (masterReservationInfo.canAllocate) {
                        vector.add("AVAILABLE");
                        vector.add(AVAILABLE);
                    } else {
                        vector.add("BLOCKED");
                        vector.add(BLOCKED);
                    }
                } else {
                    vector.add("AVAILABLE");
                    vector.add(AVAILABLE);
                }
            } else {
                vector.add("BLOCKED");
                vector.add(BLOCKED);
            }
        } else if (n == 6) {
            vector.add(sDMSResourceAllocation.getAllocationTypeAsString(systemEnvironment));
            vector.add(MASTER_REQUEST);
        } else {
            vector.add(sDMSResourceAllocation.getAllocationTypeAsString(systemEnvironment));
            switch (n) {
                case 4: {
                    vector.add(ALLOCATION);
                    break;
                }
                case 3: {
                    vector.add(MASTER_RESERVATION);
                    break;
                }
                case 2: {
                    vector.add(RESERVATION);
                    break;
                }
                case 5: {
                    vector.add(IGNORED);
                }
            }
        }
        vector.add(sDMSSubmittedEntity.getPriority(systemEnvironment));
        vector.add(SystemEnvironment.sched.getDynPriority(systemEnvironment, sDMSSubmittedEntity));
        vector.add(sDMSSubmittedEntity.getPrivileges(systemEnvironment).toString());
        return vector;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSNamedResource sDMSNamedResource;
        SDMSResource sDMSResource = null;
        SDMSResourceTemplate sDMSResourceTemplate = null;
        String string = null;
        String string2 = null;
        SDMSOutputContainer sDMSOutputContainer = null;
        SDMSProxy sDMSProxy = this.resource.resolve(systemEnvironment);
        if (sDMSProxy instanceof SDMSResource) {
            sDMSResource = (SDMSResource)sDMSProxy;
            if (!sDMSResource.checkPrivileges(systemEnvironment, 0x10000000L)) {
                throw new AccessViolationException(new SDMSMessage(systemEnvironment, "034020411719", "Insufficient privileges"));
            }
            sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, sDMSResource.getNrId(systemEnvironment));
            Long l = sDMSResource.getScopeId(systemEnvironment);
            try {
                SDMSScope sDMSScope = SDMSScopeTable.getObject(systemEnvironment, l);
                string = sDMSScope.pathString(systemEnvironment);
                string2 = sDMSScope.getTypeAsString(systemEnvironment);
            }
            catch (NotFoundException notFoundException) {
                try {
                    SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, l);
                    string = sDMSFolder.pathString(systemEnvironment);
                    string2 = "FOLDER";
                }
                catch (NotFoundException notFoundException2) {
                    SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, l);
                    string = sDMSSubmittedEntity.getSubmitPathString(systemEnvironment, true) + "[" + l.toString() + "]";
                    SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment));
                    string2 = sDMSSchedulingEntity.getTypeAsString(systemEnvironment);
                }
            }
        } else {
            sDMSResourceTemplate = (SDMSResourceTemplate)sDMSProxy;
            if (!sDMSResourceTemplate.checkPrivileges(systemEnvironment, 0x10000000L)) {
                throw new AccessViolationException(new SDMSMessage(systemEnvironment, "034020411719", "Insufficient privileges"));
            }
            sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, sDMSResourceTemplate.getNrId(systemEnvironment));
            Long l = sDMSResourceTemplate.getSeId(systemEnvironment);
            SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l);
            string = sDMSSchedulingEntity.pathString(systemEnvironment);
            string2 = sDMSSchedulingEntity.getTypeAsString(systemEnvironment);
        }
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "Resource", this.fill_desc(systemEnvironment), this.fill_master(systemEnvironment, sDMSResource == null ? sDMSResourceTemplate : sDMSResource, sDMSNamedResource, string, string2));
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03303071132", "Resource shown"));
    }
}

