/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

class ObjectCounter {
    private static final long QUANTUM = 1000L;
    private static long nextId = 0L;
    private static long lastId;

    public ObjectCounter(SystemEnvironment systemEnvironment) throws SDMSException {
        lastId = this.getNextQuantum(systemEnvironment);
        nextId = lastId - 1000L + 1L;
    }

    public synchronized long next(SystemEnvironment systemEnvironment) throws SDMSException {
        if (nextId == lastId) {
            lastId = this.getNextQuantum(systemEnvironment);
        }
        return ++nextId;
    }

    private synchronized long getNextQuantum(SystemEnvironment systemEnvironment) throws SDMSException {
        long l;
        try {
            Statement statement = systemEnvironment.dbConnection.createStatement();
            statement.executeUpdate("UPDATE OBJECTCOUNTER SET LASTID = LASTID + 1000");
            ResultSet resultSet = statement.executeQuery("SELECT LASTID FROM OBJECTCOUNTER");
            if (!resultSet.next()) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "03110181618", "Counter Value Missing"));
            }
            l = resultSet.getLong(1);
            if (resultSet.next()) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "03110181619", "Duplicate Counter Value"));
            }
            resultSet.close();
            statement.close();
            systemEnvironment.dbConnection.commit();
        }
        catch (SQLException sQLException) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03110181620", "Error on updating the ObjectCounter:\n$1", "SQLError : " + sQLException.getMessage()));
        }
        return l;
    }
}

