/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSDependencyState;
import de.independit.scheduler.server.repository.SDMSDependencyStateGeneric;
import de.independit.scheduler.server.repository.SDMSDependencyStateTable;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSDependencyStateTableGeneric
extends SDMSTable {
    public static final String tableName = "DEPENDENCY_STATE";
    public static SDMSDependencyStateTable table = null;
    public static final String[] columnNames = new String[]{"ID", "DD_ID", "ESD_ID", "CONDITION", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_ddId;
    public static SDMSIndex idx_ddId_esdId;

    public SDMSDependencyStateTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "DependencyState"));
        }
        table = (SDMSDependencyStateTable)this;
        table = (SDMSDependencyStateTable)this;
        this.isVersioned = true;
        idx_ddId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "ddId");
        idx_ddId_esdId = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "ddId_esdId");
    }

    public SDMSDependencyState create(SystemEnvironment systemEnvironment, Long l, Long l2, String string) throws SDMSException {
        SDMSDependencyState sDMSDependencyState;
        Long l3 = systemEnvironment.cEnv.uid();
        Long l4 = systemEnvironment.txTime();
        Long l5 = systemEnvironment.cEnv.uid();
        Long l6 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "DependencyState"));
        }
        this.validate(systemEnvironment, l, l2, string, l3, l4, l5, l6);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSDependencyStateGeneric sDMSDependencyStateGeneric = new SDMSDependencyStateGeneric(systemEnvironment, l, l2, string, l3, l4, l5, l6);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSDependencyStateGeneric.versions, true);
            table.put(systemEnvironment, sDMSDependencyStateGeneric.id, sDMSDependencyStateGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSDependencyState = (SDMSDependencyState)sDMSDependencyStateGeneric.toProxy(systemEnvironment);
            sDMSDependencyState.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSDependencyState sDMSDependencyState2 = (SDMSDependencyState)sDMSDependencyStateGeneric.toProxy(systemEnvironment);
            sDMSDependencyState2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSDependencyState)) {
            throw new AccessViolationException(sDMSDependencyState.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSDependencyState.touchMaster(systemEnvironment);
        return sDMSDependencyState;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSDependencyState sDMSDependencyState) throws SDMSException {
        return sDMSDependencyState.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Long l2, String string, Long l3, Long l4, Long l5, Long l6) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        String string;
        Long l7;
        Long l8;
        Long l9;
        try {
            l9 = resultSet.getLong(1);
            l8 = resultSet.getLong(2);
            l7 = resultSet.getLong(3);
            string = resultSet.getString(4);
            if (resultSet.wasNull()) {
                string = null;
            }
            l6 = resultSet.getLong(5);
            l5 = resultSet.getLong(6);
            l4 = resultSet.getLong(7);
            l3 = resultSet.getLong(8);
            l2 = resultSet.getLong(9);
            l = resultSet.getLong(10);
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "DependencyState: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSDependencyStateGeneric(l9, l8, l7, string, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "DD_ID" + string2 + ", " + string + "ESD_ID" + string2 + ", " + string + "CONDITION" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + ", VALID_FROM, VALID_TO  FROM " + string + this.tableName() + string2 + " WHERE VALID_TO >= " + (bl ? "CAST ('" + systemEnvironment.lowestActiveVersion + "' AS DECIMAL)" : "" + systemEnvironment.lowestActiveVersion) + "");
        while (resultSet.next()) {
            try {
                if (this.loadObject(systemEnvironment, resultSet)) {
                    ++n2;
                }
                ++n;
            }
            catch (Exception exception) {
                SDMSThread.doTrace(null, "Exception caught while loading table " + this.tableName() + ", ID = " + Long.valueOf(resultSet.getLong(1)), -1);
                throw exception;
            }
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_ddId.check(((SDMSDependencyStateGeneric)sDMSObject).ddId, sDMSObject);
        string = string + "idx_ddId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSDependencyStateGeneric)sDMSObject).ddId);
        sDMSKey.add(((SDMSDependencyStateGeneric)sDMSObject).esdId);
        bl = idx_ddId_esdId.check(sDMSKey, sDMSObject);
        string = string + "idx_ddId_esdId: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_ddId.put(systemEnvironment, ((SDMSDependencyStateGeneric)sDMSObject).ddId, sDMSObject, (1L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSDependencyStateGeneric)sDMSObject).ddId);
        sDMSKey.add(((SDMSDependencyStateGeneric)sDMSObject).esdId);
        idx_ddId_esdId.put(systemEnvironment, sDMSKey, sDMSObject, (2L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_ddId.remove(systemEnvironment, ((SDMSDependencyStateGeneric)sDMSObject).ddId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSDependencyStateGeneric)sDMSObject).ddId);
        sDMSKey.add(((SDMSDependencyStateGeneric)sDMSObject).esdId);
        idx_ddId_esdId.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSDependencyState getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSDependencyState)table.get(systemEnvironment, l);
    }

    public static SDMSDependencyState getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSDependencyState)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSDependencyState getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSDependencyState)table.get(systemEnvironment, l, l2);
    }

    public static SDMSDependencyState idx_ddId_esdId_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSDependencyState)idx_ddId_esdId.getUnique(systemEnvironment, object);
    }

    public static SDMSDependencyState idx_ddId_esdId_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSDependencyState)idx_ddId_esdId.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSDependencyState idx_ddId_esdId_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSDependencyState)idx_ddId_esdId.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

