/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSEnvironment;
import de.independit.scheduler.server.repository.SDMSEnvironmentGeneric;
import de.independit.scheduler.server.repository.SDMSEnvironmentTable;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSEnvironmentTableGeneric
extends SDMSTable {
    public static final String tableName = "ENVIRONMENT";
    public static SDMSEnvironmentTable table = null;
    public static final String[] columnNames = new String[]{"ID", "NE_ID", "NR_ID", "CONDITION", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_neId;
    public static SDMSIndex idx_nrId;
    public static SDMSIndex idx_neId_nrId;

    public SDMSEnvironmentTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "Environment"));
        }
        table = (SDMSEnvironmentTable)this;
        table = (SDMSEnvironmentTable)this;
        this.isVersioned = true;
        idx_neId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "neId");
        idx_nrId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "nrId");
        idx_neId_nrId = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "neId_nrId");
    }

    public SDMSEnvironment create(SystemEnvironment systemEnvironment, Long l, Long l2, String string) throws SDMSException {
        SDMSEnvironment sDMSEnvironment;
        Long l3 = systemEnvironment.cEnv.uid();
        Long l4 = systemEnvironment.txTime();
        Long l5 = systemEnvironment.cEnv.uid();
        Long l6 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "Environment"));
        }
        this.validate(systemEnvironment, l, l2, string, l3, l4, l5, l6);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSEnvironmentGeneric sDMSEnvironmentGeneric = new SDMSEnvironmentGeneric(systemEnvironment, l, l2, string, l3, l4, l5, l6);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSEnvironmentGeneric.versions, true);
            table.put(systemEnvironment, sDMSEnvironmentGeneric.id, sDMSEnvironmentGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSEnvironment = (SDMSEnvironment)sDMSEnvironmentGeneric.toProxy(systemEnvironment);
            sDMSEnvironment.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSEnvironment sDMSEnvironment2 = (SDMSEnvironment)sDMSEnvironmentGeneric.toProxy(systemEnvironment);
            sDMSEnvironment2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSEnvironment)) {
            throw new AccessViolationException(sDMSEnvironment.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSEnvironment.touchMaster(systemEnvironment);
        return sDMSEnvironment;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSEnvironment sDMSEnvironment) throws SDMSException {
        return sDMSEnvironment.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Long l2, String string, Long l3, Long l4, Long l5, Long l6) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        String string;
        Long l7;
        Long l8;
        Long l9;
        try {
            l9 = resultSet.getLong(1);
            l8 = resultSet.getLong(2);
            l7 = resultSet.getLong(3);
            string = resultSet.getString(4);
            if (resultSet.wasNull()) {
                string = null;
            }
            l6 = resultSet.getLong(5);
            l5 = resultSet.getLong(6);
            l4 = resultSet.getLong(7);
            l3 = resultSet.getLong(8);
            l2 = resultSet.getLong(9);
            l = resultSet.getLong(10);
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "Environment: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSEnvironmentGeneric(l9, l8, l7, string, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "NE_ID" + string2 + ", " + string + "NR_ID" + string2 + ", " + string + "CONDITION" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + ", VALID_FROM, VALID_TO  FROM " + string + this.tableName() + string2 + " WHERE VALID_TO >= " + (bl ? "CAST ('" + systemEnvironment.lowestActiveVersion + "' AS DECIMAL)" : "" + systemEnvironment.lowestActiveVersion) + "");
        while (resultSet.next()) {
            try {
                if (this.loadObject(systemEnvironment, resultSet)) {
                    ++n2;
                }
                ++n;
            }
            catch (Exception exception) {
                SDMSThread.doTrace(null, "Exception caught while loading table " + this.tableName() + ", ID = " + Long.valueOf(resultSet.getLong(1)), -1);
                throw exception;
            }
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_neId.check(((SDMSEnvironmentGeneric)sDMSObject).neId, sDMSObject);
        string = string + "idx_neId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_nrId.check(((SDMSEnvironmentGeneric)sDMSObject).nrId, sDMSObject);
        string = string + "idx_nrId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSEnvironmentGeneric)sDMSObject).neId);
        sDMSKey.add(((SDMSEnvironmentGeneric)sDMSObject).nrId);
        bl = idx_neId_nrId.check(sDMSKey, sDMSObject);
        string = string + "idx_neId_nrId: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_neId.put(systemEnvironment, ((SDMSEnvironmentGeneric)sDMSObject).neId, sDMSObject, (1L & l) != 0L);
        idx_nrId.put(systemEnvironment, ((SDMSEnvironmentGeneric)sDMSObject).nrId, sDMSObject, (2L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSEnvironmentGeneric)sDMSObject).neId);
        sDMSKey.add(((SDMSEnvironmentGeneric)sDMSObject).nrId);
        idx_neId_nrId.put(systemEnvironment, sDMSKey, sDMSObject, (4L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_neId.remove(systemEnvironment, ((SDMSEnvironmentGeneric)sDMSObject).neId, sDMSObject);
        idx_nrId.remove(systemEnvironment, ((SDMSEnvironmentGeneric)sDMSObject).nrId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSEnvironmentGeneric)sDMSObject).neId);
        sDMSKey.add(((SDMSEnvironmentGeneric)sDMSObject).nrId);
        idx_neId_nrId.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSEnvironment getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSEnvironment)table.get(systemEnvironment, l);
    }

    public static SDMSEnvironment getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSEnvironment)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSEnvironment getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSEnvironment)table.get(systemEnvironment, l, l2);
    }

    public static SDMSEnvironment idx_neId_nrId_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSEnvironment)idx_neId_nrId.getUnique(systemEnvironment, object);
    }

    public static SDMSEnvironment idx_neId_nrId_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSEnvironment)idx_neId_nrId.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSEnvironment idx_neId_nrId_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSEnvironment)idx_neId_nrId.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

