/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSFolder;
import de.independit.scheduler.server.repository.SDMSFolderGeneric;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSGrant;
import de.independit.scheduler.server.repository.SDMSGrantTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSObjectCommentTable;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSRepository;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.util.PathVector;
import java.util.HashMap;
import java.util.Vector;

public class SDMSFolderProxyGeneric
extends SDMSProxy {
    public static final long privilegeMask = 12868064031L;
    public static final int name_size = 64;

    protected SDMSFolderProxyGeneric(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    protected static SDMSFolder getProxy(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) {
        int n = SDMSFolderTable.table.tableIndex;
        SDMSProxy sDMSProxy = SDMSRepository.getProxy(n);
        if (sDMSProxy == null) {
            sDMSProxy = new SDMSFolder(sDMSObject);
        } else {
            sDMSProxy.initProxy(sDMSObject);
        }
        systemEnvironment.tx.addUsedProxy(n, sDMSProxy);
        return (SDMSFolder)sDMSProxy;
    }

    public String getName(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSFolderGeneric)this.object).getName(systemEnvironment);
    }

    public void setName(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSFolderGeneric)this.object).setName(systemEnvironment, string);
    }

    public static int getNameMaxLength() {
        return 64;
    }

    @Override
    public Long getOwnerId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSFolderGeneric)this.object).getOwnerId(systemEnvironment);
    }

    public void setOwnerId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSFolderGeneric)this.object).setOwnerId(systemEnvironment, l);
    }

    public Long getEnvId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSFolderGeneric)this.object).getEnvId(systemEnvironment);
    }

    public void setEnvId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSFolderGeneric)this.object).setEnvId(systemEnvironment, l);
    }

    @Override
    public Long getParentId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSFolderGeneric)this.object).getParentId(systemEnvironment);
    }

    public void setParentId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSFolderGeneric)this.object).setParentId(systemEnvironment, l);
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSFolderGeneric)this.object).getCreatorUId(systemEnvironment);
    }

    private void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSFolderGeneric)this.object).setCreatorUId(systemEnvironment, l);
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSFolderGeneric)this.object).getCreateTs(systemEnvironment);
    }

    private void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSFolderGeneric)this.object).setCreateTs(systemEnvironment, l);
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSFolderGeneric)this.object).getChangerUId(systemEnvironment);
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSFolderGeneric)this.object).setChangerUId(systemEnvironment, l);
    }

    protected SDMSFolder setChangerUIdNoCheck(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        ((SDMSFolderGeneric)this.object).setChangerUId(systemEnvironment, l);
        return (SDMSFolder)this;
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSFolderGeneric)this.object).getChangeTs(systemEnvironment);
    }

    private void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSFolderGeneric)this.object).setChangeTs(systemEnvironment, l);
    }

    protected SDMSFolder setChangeTsNoCheck(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        ((SDMSFolderGeneric)this.object).setChangeTs(systemEnvironment, l);
        return (SDMSFolder)this;
    }

    @Override
    public Long getInheritPrivs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSFolderGeneric)this.object).getInheritPrivs(systemEnvironment);
    }

    public void setInheritPrivs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 0x200000100L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSFolderGeneric)this.object).setInheritPrivs(systemEnvironment, l);
    }

    public SDMSFolder set_ParentIdName(SystemEnvironment systemEnvironment, Long l, String string) throws SDMSException {
        this.checkRead(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181242"));
        }
        ((SDMSFolderGeneric)this.object).set_ParentIdName(systemEnvironment, l, string);
        return (SDMSFolder)this;
    }

    @Override
    public SDMSKey getSortKey(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSKey sDMSKey = null;
        Long l = this.getId(systemEnvironment);
        if (systemEnvironment.tx.sortKeyMap == null) {
            systemEnvironment.tx.sortKeyMap = new HashMap();
        } else {
            sDMSKey = (SDMSKey)systemEnvironment.tx.sortKeyMap.get(l);
        }
        if (sDMSKey != null) {
            return sDMSKey;
        }
        boolean bl = false;
        sDMSKey = new SDMSKey();
        sDMSKey.add((Comparable)((Object)this.pathString(systemEnvironment)));
        systemEnvironment.tx.sortKeyMap.put(l, sDMSKey);
        return sDMSKey;
    }

    @Override
    public SDMSProxy getParent(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getParentId(systemEnvironment);
        if (l == null) {
            return null;
        }
        return SDMSFolderTable.getObject(systemEnvironment, l);
    }

    public String pathString(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.pathVector(systemEnvironment).toString();
    }

    @Override
    public PathVector pathVector(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getParentId(systemEnvironment);
        PathVector pathVector = new PathVector();
        pathVector.add(this.getName(systemEnvironment));
        while (l != null) {
            SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, l);
            pathVector.add(0, sDMSFolder.getName(systemEnvironment));
            l = sDMSFolder.getParentId(systemEnvironment);
        }
        return pathVector;
    }

    public String pathString(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        return this.pathVector(systemEnvironment, l).toString();
    }

    public PathVector pathVector(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        Long l2 = this.getParentId(systemEnvironment);
        PathVector pathVector = new PathVector();
        pathVector.add(this.getName(systemEnvironment));
        while (l2 != null) {
            SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, l2, l);
            pathVector.add(0, sDMSFolder.getName(systemEnvironment));
            l2 = sDMSFolder.getParentId(systemEnvironment);
        }
        return pathVector;
    }

    public PathVector idPathVector(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getParentId(systemEnvironment);
        PathVector pathVector = new PathVector();
        pathVector.add(this.getId(systemEnvironment).toString());
        while (l != null) {
            SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, l);
            pathVector.add(0, sDMSFolder.getId(systemEnvironment).toString());
            l = sDMSFolder.getParentId(systemEnvironment);
        }
        return pathVector;
    }

    public PathVector idPathVector(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        Long l2 = this.getParentId(systemEnvironment);
        PathVector pathVector = new PathVector();
        pathVector.add(this.getId(systemEnvironment).toString());
        while (l2 != null) {
            SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, l2, l);
            pathVector.add(0, sDMSFolder.getId(systemEnvironment).toString());
            l2 = sDMSFolder.getParentId(systemEnvironment);
        }
        return pathVector;
    }

    @Override
    public Vector getContent(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector = new Vector();
        Long l = this.getId(systemEnvironment);
        Vector vector2 = SDMSFolderTable.idx_parentId.getVector(systemEnvironment, l);
        vector.addAll(vector2);
        vector2 = SDMSSchedulingEntityTable.idx_folderId.getVector(systemEnvironment, l);
        vector.addAll(vector2);
        return vector;
    }

    @Override
    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSObjectCommentTable.dropComment(systemEnvironment, this.getId(systemEnvironment));
        Vector vector = SDMSGrantTable.idx_objectId.getVector(systemEnvironment, this.getId(systemEnvironment));
        for (int i = 0; i < vector.size(); ++i) {
            SDMSGrant sDMSGrant = (SDMSGrant)vector.get(i);
            sDMSGrant.setDeleteVersion(systemEnvironment, systemEnvironment.tx.txId);
        }
        super.delete(systemEnvironment);
    }

    @Override
    public final boolean checkPrivileges(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        return (this.getPrivileges(systemEnvironment, l, true, null) & l) == l;
    }

    public final boolean checkPrivileges(SystemEnvironment systemEnvironment, long l, long l2) throws SDMSException {
        return (this.getPrivileges(systemEnvironment, l, true, null, l2) & l) == l;
    }

    @Override
    public long getPrivilegeMask() {
        return 12868064031L;
    }

    @Override
    public final SDMSPrivilege getPrivileges(SystemEnvironment systemEnvironment) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 12868064031L, false, null));
    }

    @Override
    public final SDMSPrivilege getPrivilegesForGroups(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 12868064031L, false, vector));
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector) throws SDMSException {
        Vector vector2 = vector == null ? new Vector() : vector;
        long l2 = 0L;
        if (systemEnvironment.cEnv.isUser()) {
            long l3;
            if (vector == null) {
                vector2.addAll(systemEnvironment.cEnv.gid());
            }
            if (vector2.contains(SDMSObject.adminGId)) {
                return l;
            }
            if (vector2.contains(this.getOwnerId(systemEnvironment))) {
                l2 = l & 0xFFFFFFFFFFFFFFFBL;
                if (l2 == l) {
                    return l2;
                }
            } else {
                for (int i = 0; i < vector2.size(); ++i) {
                    try {
                        SDMSGrant sDMSGrant = SDMSGrantTable.idx_objectId_gId_getUnique(systemEnvironment, new SDMSKey(this.getId(systemEnvironment), (Long)vector2.get(i)));
                        l2 |= sDMSGrant.getPrivs(systemEnvironment).longValue();
                        l2 = this.addImplicitPrivs(l2) & l;
                        if (l2 != l) continue;
                        return l2;
                    }
                    catch (NotFoundException notFoundException) {
                        // empty catch block
                    }
                }
            }
            long l4 = this.getInheritPrivs(systemEnvironment);
            l4 = this.addImplicitPrivs(l4);
            if ((l & 4L) != 0L) {
                l4 |= 4L;
            }
            if ((l2 | (l3 = l & (l2 ^ 0xFFFFFFFFFFFFFFFFL) & l4)) != l && bl) {
                return 0L;
            }
            Long l5 = this.getParentId(systemEnvironment);
            if (l5 != null && l3 != 0L) {
                SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, l5);
                long l6 = (l3 & 4L) != 0L ? l3 & 0xFFFFFFFFFFFFFFFBL | 2L : l3;
                if (((l6 = sDMSFolder.getPrivileges(systemEnvironment, l6, bl, vector)) & 2L) != 0L) {
                    l6 |= 4L;
                }
                l2 |= l6 & l4;
            }
        }
        return l2;
    }

    public final SDMSPrivilege getPrivileges(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 12868064031L, false, null, l));
    }

    public final SDMSPrivilege getPrivilegesForGroups(SystemEnvironment systemEnvironment, Vector vector, long l) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 12868064031L, false, vector, l));
    }

    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector, long l2) throws SDMSException {
        Vector vector2 = vector == null ? new Vector() : vector;
        long l3 = 0L;
        if (systemEnvironment.cEnv.isUser()) {
            long l4;
            if (vector == null) {
                vector2.addAll(systemEnvironment.cEnv.gid());
            }
            if (vector2.contains(SDMSObject.adminGId)) {
                return l;
            }
            if (vector2.contains(this.getOwnerId(systemEnvironment))) {
                l3 = l & 0xFFFFFFFFFFFFFFFBL;
                if (l3 == l) {
                    return l3;
                }
            } else {
                for (int i = 0; i < vector2.size(); ++i) {
                    try {
                        SDMSGrant sDMSGrant = SDMSGrantTable.idx_objectId_gId_getUnique(systemEnvironment, new SDMSKey(this.getId(systemEnvironment), (Long)vector2.get(i)));
                        l3 |= sDMSGrant.getPrivs(systemEnvironment).longValue();
                        l3 = this.addImplicitPrivs(l3) & l;
                        if (l3 != l) continue;
                        return l3;
                    }
                    catch (NotFoundException notFoundException) {
                        // empty catch block
                    }
                }
            }
            long l5 = 0L;
            try {
                SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, this.getId(systemEnvironment));
                l5 = sDMSFolder.getInheritPrivs(systemEnvironment);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            if ((l & 4L) != 0L) {
                l5 |= 4L;
            }
            if ((l3 | (l4 = l & (l3 ^ 0xFFFFFFFFFFFFFFFFL) & (l5 = this.addImplicitPrivs(l5)))) != l && bl) {
                return 0L;
            }
            Long l6 = this.getParentId(systemEnvironment);
            if (l6 != null && l4 != 0L) {
                SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, l6, l2);
                long l7 = (l4 & 4L) != 0L ? l4 & 0xFFFFFFFFFFFFFFFBL | 2L : l4;
                if (((l7 = sDMSFolder.getPrivileges(systemEnvironment, l7, bl, vector, l2)) & 2L) != 0L) {
                    l7 |= 4L;
                }
                l3 |= l7 & l5;
            }
        }
        return l3;
    }

    @Override
    public SDMSMessage accessViolationMessage(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        SDMSMessage sDMSMessage = new SDMSMessage(systemEnvironment, string, "Insufficient privileges accessing Folder $1", this.pathString(systemEnvironment));
        return sDMSMessage;
    }

    @Override
    protected void touch(SystemEnvironment systemEnvironment) throws SDMSException {
        this.setChangerUIdNoCheck(systemEnvironment, systemEnvironment.cEnv.uid());
        this.setChangeTsNoCheck(systemEnvironment, systemEnvironment.txTime());
    }

    public void print() {
        ((SDMSFolderGeneric)this.object).print();
    }
}

