/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSInstanceValue;
import de.independit.scheduler.server.repository.SDMSInstanceValueTableGeneric;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSInstanceValueGeneric
extends SDMSObject
implements Cloneable {
    public static final int nr_id = 1;
    public static final int nr_value = 2;
    public static final int nr_oiId = 3;
    public static final int nr_wtpId = 4;
    public static final int nr_creatorUId = 5;
    public static final int nr_createTs = 6;
    public static final int nr_changerUId = 7;
    public static final int nr_changeTs = 8;
    public static String tableName = "INSTANCE_VALUE";
    protected String value;
    protected Long oiId;
    protected Long wtpId;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSInstanceValueGeneric(SystemEnvironment systemEnvironment, String string, Long l, Long l2, Long l3, Long l4, Long l5, Long l6) throws SDMSException {
        super(systemEnvironment, SDMSInstanceValueTableGeneric.table);
        if (string != null && string.length() > 256) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(InstanceValue) Length of $1 exceeds maximum length $2", "value", "256"));
        }
        this.value = string;
        this.oiId = l;
        this.wtpId = l2;
        this.creatorUId = l3;
        this.createTs = l4;
        this.changerUId = l5;
        this.changeTs = l6;
    }

    public String getValue(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.value;
    }

    public void setValue(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.value)) {
            return;
        }
        if (string == null && this.value == null) {
            return;
        }
        SDMSInstanceValueGeneric sDMSInstanceValueGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(InstanceValue) Change of system object not allowed"));
        }
        if (sDMSInstanceValueGeneric.versions.o_v == null || sDMSInstanceValueGeneric.versions.o_v.size() == 0 || sDMSInstanceValueGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSInstanceValueGeneric = (SDMSInstanceValueGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 256) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(InstanceValue) Length of $1 exceeds maximum length $2", "value", "256"));
        }
        sDMSInstanceValueGeneric.value = string;
        sDMSInstanceValueGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSInstanceValueGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSInstanceValueGeneric != this) {
            sDMSInstanceValueGeneric.versions.table.index(systemEnvironment, sDMSInstanceValueGeneric, 0L);
        }
    }

    public Long getOiId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.oiId;
    }

    public void setOiId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.oiId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(InstanceValue) Change of system object not allowed"));
            }
            SDMSInstanceValueGeneric sDMSInstanceValueGeneric = (SDMSInstanceValueGeneric)this.change(systemEnvironment);
            sDMSInstanceValueGeneric.oiId = l;
            sDMSInstanceValueGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSInstanceValueGeneric.changeTs = systemEnvironment.txTime();
            sDMSInstanceValueGeneric.versions.table.index(systemEnvironment, sDMSInstanceValueGeneric, 5L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getWtpId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.wtpId;
    }

    public void setWtpId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.wtpId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(InstanceValue) Change of system object not allowed"));
            }
            SDMSInstanceValueGeneric sDMSInstanceValueGeneric = (SDMSInstanceValueGeneric)this.change(systemEnvironment);
            sDMSInstanceValueGeneric.wtpId = l;
            sDMSInstanceValueGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSInstanceValueGeneric.changeTs = systemEnvironment.txTime();
            sDMSInstanceValueGeneric.versions.table.index(systemEnvironment, sDMSInstanceValueGeneric, 6L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSInstanceValueGeneric sDMSInstanceValueGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(InstanceValue) Change of system object not allowed"));
        }
        if (sDMSInstanceValueGeneric.versions.o_v == null || sDMSInstanceValueGeneric.versions.o_v.size() == 0 || sDMSInstanceValueGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSInstanceValueGeneric = (SDMSInstanceValueGeneric)this.change(systemEnvironment);
        }
        sDMSInstanceValueGeneric.creatorUId = l;
        sDMSInstanceValueGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSInstanceValueGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSInstanceValueGeneric != this) {
            sDMSInstanceValueGeneric.versions.table.index(systemEnvironment, sDMSInstanceValueGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSInstanceValueGeneric sDMSInstanceValueGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(InstanceValue) Change of system object not allowed"));
        }
        if (sDMSInstanceValueGeneric.versions.o_v == null || sDMSInstanceValueGeneric.versions.o_v.size() == 0 || sDMSInstanceValueGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSInstanceValueGeneric = (SDMSInstanceValueGeneric)this.change(systemEnvironment);
        }
        sDMSInstanceValueGeneric.createTs = l;
        sDMSInstanceValueGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSInstanceValueGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSInstanceValueGeneric != this) {
            sDMSInstanceValueGeneric.versions.table.index(systemEnvironment, sDMSInstanceValueGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSInstanceValueGeneric sDMSInstanceValueGeneric = this;
        if (sDMSInstanceValueGeneric.versions.o_v == null || sDMSInstanceValueGeneric.versions.o_v.size() == 0 || sDMSInstanceValueGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSInstanceValueGeneric = (SDMSInstanceValueGeneric)this.change(systemEnvironment);
        }
        sDMSInstanceValueGeneric.changerUId = l;
        sDMSInstanceValueGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSInstanceValueGeneric != this) {
            sDMSInstanceValueGeneric.versions.table.index(systemEnvironment, sDMSInstanceValueGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSInstanceValueGeneric sDMSInstanceValueGeneric = this;
        if (sDMSInstanceValueGeneric.versions.o_v == null || sDMSInstanceValueGeneric.versions.o_v.size() == 0 || sDMSInstanceValueGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSInstanceValueGeneric = (SDMSInstanceValueGeneric)this.change(systemEnvironment);
        }
        sDMSInstanceValueGeneric.changeTs = l;
        sDMSInstanceValueGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSInstanceValueGeneric != this) {
            sDMSInstanceValueGeneric.versions.table.index(systemEnvironment, sDMSInstanceValueGeneric, 0L);
        }
    }

    public SDMSInstanceValueGeneric set_OiIdWtpId(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        SDMSInstanceValueGeneric sDMSInstanceValueGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(InstanceValue) Change of system object not allowed"));
            }
            sDMSInstanceValueGeneric = (SDMSInstanceValueGeneric)this.change(systemEnvironment);
            sDMSInstanceValueGeneric.oiId = l;
            sDMSInstanceValueGeneric.wtpId = l2;
            sDMSInstanceValueGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSInstanceValueGeneric.changeTs = systemEnvironment.txTime();
            sDMSInstanceValueGeneric.versions.table.index(systemEnvironment, sDMSInstanceValueGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSInstanceValueGeneric;
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSInstanceValue(this);
    }

    protected SDMSInstanceValueGeneric(Long l, String string, Long l2, Long l3, Long l4, Long l5, Long l6, Long l7, long l8, long l9) {
        this.id = l;
        this.value = string;
        this.oiId = l2;
        this.wtpId = l3;
        this.creatorUId = l4;
        this.createTs = l5;
        this.changerUId = l6;
        this.changeTs = l7;
        this.validFrom = l8;
        this.validTo = l9;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "INSTANCE_VALUE" + string3 + " (ID, " + string2 + "VALUE" + string3 + ", " + string2 + "OI_ID" + string3 + ", " + string2 + "WTP_ID" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
                SDMSInstanceValueGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "InstanceValue: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            if (this.value == null) {
                preparedStatement.setNull(2, 12);
            } else {
                preparedStatement.setString(2, this.value);
            }
            preparedStatement.setLong(3, this.oiId);
            preparedStatement.setLong(4, this.wtpId);
            preparedStatement.setLong(5, this.creatorUId);
            preparedStatement.setLong(6, this.createTs);
            preparedStatement.setLong(7, this.changerUId);
            preparedStatement.setLong(8, this.changeTs);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "InstanceValue: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pDelete[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "DELETE FROM " + string2 + "INSTANCE_VALUE" + string3 + " WHERE ID = ?";
                SDMSInstanceValueGeneric.pDelete[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182001", "InstanceValue: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pDelete[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182002", "InstanceValue: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string2 + "INSTANCE_VALUE" + string3 + " SET " + string2 + "VALUE" + string3 + " = ? , " + string2 + "OI_ID" + string3 + " = ? , " + string2 + "WTP_ID" + string3 + " = ? , " + string2 + "CREATOR_U_ID" + string3 + " = ? , " + string2 + "CREATE_TS" + string3 + " = ? , " + string2 + "CHANGER_U_ID" + string3 + " = ? , " + string2 + "CHANGE_TS" + string3 + " = ? WHERE ID = ?";
                SDMSInstanceValueGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182005", "InstanceValue: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            if (this.value == null) {
                preparedStatement.setNull(1, 12);
            } else {
                preparedStatement.setString(1, this.value);
            }
            preparedStatement.setLong(2, this.oiId);
            preparedStatement.setLong(3, this.wtpId);
            preparedStatement.setLong(4, this.creatorUId);
            preparedStatement.setLong(5, this.createTs);
            preparedStatement.setLong(6, this.changerUId);
            preparedStatement.setLong(7, this.changeTs);
            preparedStatement.setLong(8, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182006", "InstanceValue: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : InstanceValue", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "value : " + this.value, 2);
        SDMSThread.doTrace(null, "oiId : " + this.oiId, 2);
        SDMSThread.doTrace(null, "wtpId : " + this.wtpId, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "value      : " + this.value + "\n" + string + "oiId       : " + this.oiId + "\n" + string + "wtpId      : " + this.wtpId + "\n" + string + "creatorUId : " + this.creatorUId + "\n" + string + "createTs   : " + this.createTs + "\n" + string + "changerUId : " + this.changerUId + "\n" + string + "changeTs   : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

