/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSIntervalHierarchy;
import de.independit.scheduler.server.repository.SDMSIntervalHierarchyGeneric;
import de.independit.scheduler.server.repository.SDMSIntervalHierarchyTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSIntervalHierarchyTableGeneric
extends SDMSTable {
    public static final String tableName = "INTERVAL_HIERARCHY";
    public static SDMSIntervalHierarchyTable table = null;
    public static final String[] columnNames = new String[]{"ID", "CHILD_ID", "PARENT_ID", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_childId;
    public static SDMSIndex idx_parentId;

    public SDMSIntervalHierarchyTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "IntervalHierarchy"));
        }
        table = (SDMSIntervalHierarchyTable)this;
        table = (SDMSIntervalHierarchyTable)this;
        this.isVersioned = false;
        idx_childId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "childId");
        idx_parentId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "parentId");
    }

    public SDMSIntervalHierarchy create(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        SDMSIntervalHierarchy sDMSIntervalHierarchy;
        Long l3 = systemEnvironment.cEnv.uid();
        Long l4 = systemEnvironment.txTime();
        Long l5 = systemEnvironment.cEnv.uid();
        Long l6 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "IntervalHierarchy"));
        }
        this.validate(systemEnvironment, l, l2, l3, l4, l5, l6);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSIntervalHierarchyGeneric sDMSIntervalHierarchyGeneric = new SDMSIntervalHierarchyGeneric(systemEnvironment, l, l2, l3, l4, l5, l6);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSIntervalHierarchyGeneric.versions, true);
            table.put(systemEnvironment, sDMSIntervalHierarchyGeneric.id, sDMSIntervalHierarchyGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSIntervalHierarchy = (SDMSIntervalHierarchy)sDMSIntervalHierarchyGeneric.toProxy(systemEnvironment);
            sDMSIntervalHierarchy.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSIntervalHierarchy sDMSIntervalHierarchy2 = (SDMSIntervalHierarchy)sDMSIntervalHierarchyGeneric.toProxy(systemEnvironment);
            sDMSIntervalHierarchy2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSIntervalHierarchy)) {
            throw new AccessViolationException(sDMSIntervalHierarchy.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSIntervalHierarchy.touchMaster(systemEnvironment);
        return sDMSIntervalHierarchy;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSIntervalHierarchy sDMSIntervalHierarchy) throws SDMSException {
        return sDMSIntervalHierarchy.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Long l4, Long l5, Long l6) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Long l7;
        Long l8;
        Long l9;
        try {
            l9 = resultSet.getLong(1);
            l8 = resultSet.getLong(2);
            l7 = resultSet.getLong(3);
            l6 = resultSet.getLong(4);
            l5 = resultSet.getLong(5);
            l4 = resultSet.getLong(6);
            l3 = resultSet.getLong(7);
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "IntervalHierarchy: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSIntervalHierarchyGeneric(l9, l8, l7, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "CHILD_ID" + string2 + ", " + string + "PARENT_ID" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2 + "");
        while (resultSet.next()) {
            try {
                if (this.loadObject(systemEnvironment, resultSet)) {
                    ++n2;
                }
                ++n;
            }
            catch (Exception exception) {
                SDMSThread.doTrace(null, "Exception caught while loading table " + this.tableName() + ", ID = " + Long.valueOf(resultSet.getLong(1)), -1);
                throw exception;
            }
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_childId.check(((SDMSIntervalHierarchyGeneric)sDMSObject).childId, sDMSObject);
        string = string + "idx_childId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_parentId.check(((SDMSIntervalHierarchyGeneric)sDMSObject).parentId, sDMSObject);
        string = string + "idx_parentId: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_childId.put(systemEnvironment, ((SDMSIntervalHierarchyGeneric)sDMSObject).childId, sDMSObject, (1L & l) != 0L);
        idx_parentId.put(systemEnvironment, ((SDMSIntervalHierarchyGeneric)sDMSObject).parentId, sDMSObject, (2L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_childId.remove(systemEnvironment, ((SDMSIntervalHierarchyGeneric)sDMSObject).childId, sDMSObject);
        idx_parentId.remove(systemEnvironment, ((SDMSIntervalHierarchyGeneric)sDMSObject).parentId, sDMSObject);
    }

    public static SDMSIntervalHierarchy getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSIntervalHierarchy)table.get(systemEnvironment, l);
    }

    public static SDMSIntervalHierarchy getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSIntervalHierarchy)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSIntervalHierarchy getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSIntervalHierarchy)table.get(systemEnvironment, l, l2);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

