/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.locking.LockingSystem;
import de.independit.scheduler.server.repository.ObjectCounter;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.repository.SDMSVersions;
import de.independit.scheduler.server.util.SDMSThread;
import java.util.LinkedList;

public abstract class SDMSObject
implements Cloneable,
Comparable {
    public static final String __version = "@(#) $Id: SDMSObject.java,v 2.9.2.1 2013/03/14 10:25:20 ronald Exp $";
    protected long validFrom;
    protected long validTo;
    public SDMSVersions versions;
    protected Long id;
    protected int subTxId;
    protected boolean isDeleted = false;
    protected boolean memOnly = false;
    protected boolean isCurrent = false;
    private static ObjectCounter nextId = null;
    public static final Long systemUId = 0L;
    public static final Long nobodyUId = 1L;
    public static final Long internalUId = 2L;
    public static final Long adminGId = 81L;
    public static final Long publicGId = 80L;
    public static final Long dummyShId = 30L;
    public static final Long systemFId = 40L;
    public static final Long rootScId = 70L;

    protected SDMSObject() {
    }

    protected SDMSObject(SystemEnvironment systemEnvironment, SDMSTable sDMSTable) throws SDMSException {
        if (nextId == null) {
            nextId = new ObjectCounter(systemEnvironment);
        }
        this.id = nextId.next(systemEnvironment);
        this.validFrom = -1L;
        this.validTo = -1L;
        this.versions = new SDMSVersions(sDMSTable, this.id);
        if (SystemEnvironment.maxWriter > 1) {
            LockingSystem.lock(systemEnvironment, this.versions, 1);
        }
        this.versions.tx = systemEnvironment.tx;
        this.subTxId = systemEnvironment.tx.subTxId;
        this.versions.o_v = new LinkedList();
        this.versions.o_v.add(this);
        this.versions.table = sDMSTable;
        this.isCurrent = true;
    }

    protected SDMSObject change(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSObject sDMSObject;
        if (this.versions.tx != null) {
            if (systemEnvironment.tx != this.versions.tx) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "03110181611", "Trying to change object locked by other transaction"));
            }
            if (this.versions.o_v == null) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "03110181612", "Already touched versions without vector o_v"));
            }
            if (this.versions.o_v.size() != 0 && this.subTxId == systemEnvironment.tx.subTxId) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "03111021044", "No two changes within the same subtx permitted"));
            }
        } else {
            this.versions.o_v = new LinkedList();
            this.versions.tx = systemEnvironment.tx;
        }
        try {
            sDMSObject = (SDMSObject)this.clone();
            sDMSObject.subTxId = systemEnvironment.tx.subTxId;
            this.isCurrent = false;
            sDMSObject.isCurrent = true;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03110181614", "Trying to clone uncloneable Object"));
        }
        sDMSObject.validFrom = -1L;
        sDMSObject.validTo = -1L;
        this.versions.o_v.add(sDMSObject);
        systemEnvironment.tx.addToTouchSet(systemEnvironment, this.versions, false);
        return sDMSObject;
    }

    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        this.deleteObject(systemEnvironment, false);
    }

    public void memDelete(SystemEnvironment systemEnvironment) throws SDMSException {
        this.deleteObject(systemEnvironment, true);
    }

    private void deleteObject(SystemEnvironment systemEnvironment, boolean bl) throws SDMSException {
        SDMSObject sDMSObject;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03201292032", "Change of system object not allowed"));
        }
        if (bl && this.versions.table.getIsVersioned()) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03204260808", "Trying to do a memOnly delete on a versioned table"));
        }
        if (this.versions.tx != null) {
            if (systemEnvironment.tx != this.versions.tx) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "03110181615", "Trying to delete object locked by other transaction"));
            }
            if (this.versions.o_v == null) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "03110261614", "Already touched versions without vector o_v"));
            }
            if (this.versions.o_v.size() != 0 && this.subTxId == systemEnvironment.tx.subTxId) {
                this.versions.table.unIndex(systemEnvironment, this);
                this.isDeleted = true;
                this.isCurrent = false;
                return;
            }
        } else {
            this.versions.tx = systemEnvironment.tx;
            this.versions.o_v = new LinkedList();
        }
        try {
            sDMSObject = (SDMSObject)this.clone();
            sDMSObject.subTxId = systemEnvironment.tx.subTxId;
            sDMSObject.isDeleted = true;
            sDMSObject.memOnly = bl;
            this.isCurrent = false;
            sDMSObject.isCurrent = false;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "02110261714", "Trying to clone uncloneable Object"));
        }
        this.versions.o_v.add(sDMSObject);
        systemEnvironment.tx.addToTouchSet(systemEnvironment, this.versions, false);
    }

    protected abstract SDMSProxy toProxy(SystemEnvironment var1);

    protected abstract void insertDBObject(SystemEnvironment var1) throws SDMSException;

    protected abstract void updateDBObject(SystemEnvironment var1, SDMSObject var2) throws SDMSException;

    protected abstract void deleteDBObject(SystemEnvironment var1) throws SDMSException;

    public long getValidFrom(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.validFrom;
    }

    public long getValidTo(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.validTo;
    }

    public Long getId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.id;
    }

    public abstract void print();

    public abstract String toString(int var1);

    public String toShortString() {
        return "SDMSObject(" + this.versions.table.tableName() + ", " + this.id + ")";
    }

    public void dumpVersions() {
        this.dumpVersions(3);
    }

    public void dumpVersions(int n) {
        SDMSThread.doTrace(null, "-- Object is --", n);
        SDMSThread.doTrace(null, "id : " + this.id.toString(), n);
        SDMSThread.doTrace(null, "subTxId : " + this.subTxId, n);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, n);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, n);
        SDMSThread.doTrace(null, "subTxId : " + this.subTxId, n);
        SDMSThread.doTrace(null, "isDeleted : " + this.isDeleted, n);
        SDMSThread.doTrace(null, "memOnly : " + this.memOnly, n);
        SDMSThread.doTrace(null, "isCurrent : " + this.isCurrent, n);
        this.versions.dump(n);
    }

    public int compareTo(Object object) {
        SDMSObject sDMSObject = (SDMSObject)object;
        if (this.id > sDMSObject.id) {
            return 1;
        }
        if (this.id < sDMSObject.id) {
            return -1;
        }
        if (this.validFrom > sDMSObject.validFrom) {
            return 1;
        }
        if (this.validFrom < sDMSObject.validFrom) {
            return -1;
        }
        return 0;
    }
}

