/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSObjectEvent;
import de.independit.scheduler.server.repository.SDMSObjectEventTableGeneric;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSObjectEventGeneric
extends SDMSObject
implements Cloneable {
    public static final int CREATE = 1;
    public static final int CHANGE = 2;
    public static final int DELETE = 3;
    public static final int nr_id = 1;
    public static final int nr_trId = 2;
    public static final int nr_oiId = 3;
    public static final int nr_eventType = 4;
    public static final int nr_smeId = 5;
    public static final int nr_seId = 6;
    public static final int nr_submitTs = 7;
    public static final int nr_finalTs = 8;
    public static final int nr_finalEsdId = 9;
    public static final int nr_mainSmeId = 10;
    public static final int nr_mainSeId = 11;
    public static final int nr_mainFinalTs = 12;
    public static final int nr_mainFinalEsdId = 13;
    public static final int nr_seVersion = 14;
    public static final int nr_creatorUId = 15;
    public static final int nr_createTs = 16;
    public static final int nr_changerUId = 17;
    public static final int nr_changeTs = 18;
    public static String tableName = "OBJECT_EVENT";
    protected Long trId;
    protected Long oiId;
    protected Integer eventType;
    protected Long smeId;
    protected Long seId;
    protected Long submitTs;
    protected Long finalTs;
    protected Long finalEsdId;
    protected Long mainSmeId;
    protected Long mainSeId;
    protected Long mainFinalTs;
    protected Long mainFinalEsdId;
    protected Long seVersion;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSObjectEventGeneric(SystemEnvironment systemEnvironment, Long l, Long l2, Integer n, Long l3, Long l4, Long l5, Long l6, Long l7, Long l8, Long l9, Long l10, Long l11, Long l12, Long l13, Long l14, Long l15, Long l16) throws SDMSException {
        super(systemEnvironment, SDMSObjectEventTableGeneric.table);
        this.trId = l;
        this.oiId = l2;
        this.eventType = n;
        this.smeId = l3;
        this.seId = l4;
        this.submitTs = l5;
        this.finalTs = l6;
        this.finalEsdId = l7;
        this.mainSmeId = l8;
        this.mainSeId = l9;
        this.mainFinalTs = l10;
        this.mainFinalEsdId = l11;
        this.seVersion = l12;
        this.creatorUId = l13;
        this.createTs = l14;
        this.changerUId = l15;
        this.changeTs = l16;
    }

    public Long getTrId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.trId;
    }

    public void setTrId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.trId)) {
            return;
        }
        if (l == null && this.trId == null) {
            return;
        }
        SDMSObjectEventGeneric sDMSObjectEventGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectEvent) Change of system object not allowed"));
        }
        if (sDMSObjectEventGeneric.versions.o_v == null || sDMSObjectEventGeneric.versions.o_v.size() == 0 || sDMSObjectEventGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectEventGeneric = (SDMSObjectEventGeneric)this.change(systemEnvironment);
        }
        sDMSObjectEventGeneric.trId = l;
        sDMSObjectEventGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSObjectEventGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSObjectEventGeneric != this) {
            sDMSObjectEventGeneric.versions.table.index(systemEnvironment, sDMSObjectEventGeneric, 0L);
        }
    }

    public Long getOiId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.oiId;
    }

    public void setOiId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.oiId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectEvent) Change of system object not allowed"));
            }
            SDMSObjectEventGeneric sDMSObjectEventGeneric = (SDMSObjectEventGeneric)this.change(systemEnvironment);
            sDMSObjectEventGeneric.oiId = l;
            sDMSObjectEventGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSObjectEventGeneric.changeTs = systemEnvironment.txTime();
            sDMSObjectEventGeneric.versions.table.index(systemEnvironment, sDMSObjectEventGeneric, 1L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getEventType(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.eventType;
    }

    public String getEventTypeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getEventType(systemEnvironment);
        switch (n) {
            case 1: {
                return "CREATE";
            }
            case 2: {
                return "CHANGE";
            }
            case 3: {
                return "DELETE";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown ObjectEvent.eventType: $1", this.getEventType(systemEnvironment)));
    }

    public void setEventType(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.eventType.equals(n)) {
            return;
        }
        SDMSObjectEventGeneric sDMSObjectEventGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectEvent) Change of system object not allowed"));
        }
        if (sDMSObjectEventGeneric.versions.o_v == null || sDMSObjectEventGeneric.versions.o_v.size() == 0 || sDMSObjectEventGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectEventGeneric = (SDMSObjectEventGeneric)this.change(systemEnvironment);
        }
        sDMSObjectEventGeneric.eventType = n;
        sDMSObjectEventGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSObjectEventGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSObjectEventGeneric != this) {
            sDMSObjectEventGeneric.versions.table.index(systemEnvironment, sDMSObjectEventGeneric, 0L);
        }
    }

    public Long getSmeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.smeId;
    }

    public void setSmeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.smeId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectEvent) Change of system object not allowed"));
            }
            SDMSObjectEventGeneric sDMSObjectEventGeneric = (SDMSObjectEventGeneric)this.change(systemEnvironment);
            sDMSObjectEventGeneric.smeId = l;
            sDMSObjectEventGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSObjectEventGeneric.changeTs = systemEnvironment.txTime();
            sDMSObjectEventGeneric.versions.table.index(systemEnvironment, sDMSObjectEventGeneric, 2L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getSeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.seId;
    }

    public void setSeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.seId.equals(l)) {
            return;
        }
        SDMSObjectEventGeneric sDMSObjectEventGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectEvent) Change of system object not allowed"));
        }
        if (sDMSObjectEventGeneric.versions.o_v == null || sDMSObjectEventGeneric.versions.o_v.size() == 0 || sDMSObjectEventGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectEventGeneric = (SDMSObjectEventGeneric)this.change(systemEnvironment);
        }
        sDMSObjectEventGeneric.seId = l;
        sDMSObjectEventGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSObjectEventGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSObjectEventGeneric != this) {
            sDMSObjectEventGeneric.versions.table.index(systemEnvironment, sDMSObjectEventGeneric, 0L);
        }
    }

    public Long getSubmitTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.submitTs;
    }

    public void setSubmitTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.submitTs)) {
            return;
        }
        if (l == null && this.submitTs == null) {
            return;
        }
        SDMSObjectEventGeneric sDMSObjectEventGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectEvent) Change of system object not allowed"));
        }
        if (sDMSObjectEventGeneric.versions.o_v == null || sDMSObjectEventGeneric.versions.o_v.size() == 0 || sDMSObjectEventGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectEventGeneric = (SDMSObjectEventGeneric)this.change(systemEnvironment);
        }
        sDMSObjectEventGeneric.submitTs = l;
        sDMSObjectEventGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSObjectEventGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSObjectEventGeneric != this) {
            sDMSObjectEventGeneric.versions.table.index(systemEnvironment, sDMSObjectEventGeneric, 0L);
        }
    }

    public Long getFinalTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.finalTs;
    }

    public void setFinalTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.finalTs)) {
            return;
        }
        if (l == null && this.finalTs == null) {
            return;
        }
        SDMSObjectEventGeneric sDMSObjectEventGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectEvent) Change of system object not allowed"));
        }
        if (sDMSObjectEventGeneric.versions.o_v == null || sDMSObjectEventGeneric.versions.o_v.size() == 0 || sDMSObjectEventGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectEventGeneric = (SDMSObjectEventGeneric)this.change(systemEnvironment);
        }
        sDMSObjectEventGeneric.finalTs = l;
        sDMSObjectEventGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSObjectEventGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSObjectEventGeneric != this) {
            sDMSObjectEventGeneric.versions.table.index(systemEnvironment, sDMSObjectEventGeneric, 0L);
        }
    }

    public Long getFinalEsdId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.finalEsdId;
    }

    public void setFinalEsdId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.finalEsdId)) {
            return;
        }
        if (l == null && this.finalEsdId == null) {
            return;
        }
        SDMSObjectEventGeneric sDMSObjectEventGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectEvent) Change of system object not allowed"));
        }
        if (sDMSObjectEventGeneric.versions.o_v == null || sDMSObjectEventGeneric.versions.o_v.size() == 0 || sDMSObjectEventGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectEventGeneric = (SDMSObjectEventGeneric)this.change(systemEnvironment);
        }
        sDMSObjectEventGeneric.finalEsdId = l;
        sDMSObjectEventGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSObjectEventGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSObjectEventGeneric != this) {
            sDMSObjectEventGeneric.versions.table.index(systemEnvironment, sDMSObjectEventGeneric, 0L);
        }
    }

    public Long getMainSmeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.mainSmeId;
    }

    public void setMainSmeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.mainSmeId)) {
            return;
        }
        if (l == null && this.mainSmeId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectEvent) Change of system object not allowed"));
            }
            SDMSObjectEventGeneric sDMSObjectEventGeneric = (SDMSObjectEventGeneric)this.change(systemEnvironment);
            sDMSObjectEventGeneric.mainSmeId = l;
            sDMSObjectEventGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSObjectEventGeneric.changeTs = systemEnvironment.txTime();
            sDMSObjectEventGeneric.versions.table.index(systemEnvironment, sDMSObjectEventGeneric, 4L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getMainSeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.mainSeId;
    }

    public void setMainSeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.mainSeId)) {
            return;
        }
        if (l == null && this.mainSeId == null) {
            return;
        }
        SDMSObjectEventGeneric sDMSObjectEventGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectEvent) Change of system object not allowed"));
        }
        if (sDMSObjectEventGeneric.versions.o_v == null || sDMSObjectEventGeneric.versions.o_v.size() == 0 || sDMSObjectEventGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectEventGeneric = (SDMSObjectEventGeneric)this.change(systemEnvironment);
        }
        sDMSObjectEventGeneric.mainSeId = l;
        sDMSObjectEventGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSObjectEventGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSObjectEventGeneric != this) {
            sDMSObjectEventGeneric.versions.table.index(systemEnvironment, sDMSObjectEventGeneric, 0L);
        }
    }

    public Long getMainFinalTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.mainFinalTs;
    }

    public void setMainFinalTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.mainFinalTs)) {
            return;
        }
        if (l == null && this.mainFinalTs == null) {
            return;
        }
        SDMSObjectEventGeneric sDMSObjectEventGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectEvent) Change of system object not allowed"));
        }
        if (sDMSObjectEventGeneric.versions.o_v == null || sDMSObjectEventGeneric.versions.o_v.size() == 0 || sDMSObjectEventGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectEventGeneric = (SDMSObjectEventGeneric)this.change(systemEnvironment);
        }
        sDMSObjectEventGeneric.mainFinalTs = l;
        sDMSObjectEventGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSObjectEventGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSObjectEventGeneric != this) {
            sDMSObjectEventGeneric.versions.table.index(systemEnvironment, sDMSObjectEventGeneric, 0L);
        }
    }

    public Long getMainFinalEsdId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.mainFinalEsdId;
    }

    public void setMainFinalEsdId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.mainFinalEsdId)) {
            return;
        }
        if (l == null && this.mainFinalEsdId == null) {
            return;
        }
        SDMSObjectEventGeneric sDMSObjectEventGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectEvent) Change of system object not allowed"));
        }
        if (sDMSObjectEventGeneric.versions.o_v == null || sDMSObjectEventGeneric.versions.o_v.size() == 0 || sDMSObjectEventGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectEventGeneric = (SDMSObjectEventGeneric)this.change(systemEnvironment);
        }
        sDMSObjectEventGeneric.mainFinalEsdId = l;
        sDMSObjectEventGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSObjectEventGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSObjectEventGeneric != this) {
            sDMSObjectEventGeneric.versions.table.index(systemEnvironment, sDMSObjectEventGeneric, 0L);
        }
    }

    public Long getSeVersion(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.seVersion;
    }

    public void setSeVersion(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.seVersion.equals(l)) {
            return;
        }
        SDMSObjectEventGeneric sDMSObjectEventGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectEvent) Change of system object not allowed"));
        }
        if (sDMSObjectEventGeneric.versions.o_v == null || sDMSObjectEventGeneric.versions.o_v.size() == 0 || sDMSObjectEventGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectEventGeneric = (SDMSObjectEventGeneric)this.change(systemEnvironment);
        }
        sDMSObjectEventGeneric.seVersion = l;
        sDMSObjectEventGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSObjectEventGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSObjectEventGeneric != this) {
            sDMSObjectEventGeneric.versions.table.index(systemEnvironment, sDMSObjectEventGeneric, 0L);
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSObjectEventGeneric sDMSObjectEventGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectEvent) Change of system object not allowed"));
        }
        if (sDMSObjectEventGeneric.versions.o_v == null || sDMSObjectEventGeneric.versions.o_v.size() == 0 || sDMSObjectEventGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectEventGeneric = (SDMSObjectEventGeneric)this.change(systemEnvironment);
        }
        sDMSObjectEventGeneric.creatorUId = l;
        sDMSObjectEventGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSObjectEventGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSObjectEventGeneric != this) {
            sDMSObjectEventGeneric.versions.table.index(systemEnvironment, sDMSObjectEventGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSObjectEventGeneric sDMSObjectEventGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectEvent) Change of system object not allowed"));
        }
        if (sDMSObjectEventGeneric.versions.o_v == null || sDMSObjectEventGeneric.versions.o_v.size() == 0 || sDMSObjectEventGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectEventGeneric = (SDMSObjectEventGeneric)this.change(systemEnvironment);
        }
        sDMSObjectEventGeneric.createTs = l;
        sDMSObjectEventGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSObjectEventGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSObjectEventGeneric != this) {
            sDMSObjectEventGeneric.versions.table.index(systemEnvironment, sDMSObjectEventGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSObjectEventGeneric sDMSObjectEventGeneric = this;
        if (sDMSObjectEventGeneric.versions.o_v == null || sDMSObjectEventGeneric.versions.o_v.size() == 0 || sDMSObjectEventGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectEventGeneric = (SDMSObjectEventGeneric)this.change(systemEnvironment);
        }
        sDMSObjectEventGeneric.changerUId = l;
        sDMSObjectEventGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSObjectEventGeneric != this) {
            sDMSObjectEventGeneric.versions.table.index(systemEnvironment, sDMSObjectEventGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSObjectEventGeneric sDMSObjectEventGeneric = this;
        if (sDMSObjectEventGeneric.versions.o_v == null || sDMSObjectEventGeneric.versions.o_v.size() == 0 || sDMSObjectEventGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectEventGeneric = (SDMSObjectEventGeneric)this.change(systemEnvironment);
        }
        sDMSObjectEventGeneric.changeTs = l;
        sDMSObjectEventGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSObjectEventGeneric != this) {
            sDMSObjectEventGeneric.versions.table.index(systemEnvironment, sDMSObjectEventGeneric, 0L);
        }
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSObjectEvent(this);
    }

    protected SDMSObjectEventGeneric(Long l, Long l2, Long l3, Integer n, Long l4, Long l5, Long l6, Long l7, Long l8, Long l9, Long l10, Long l11, Long l12, Long l13, Long l14, Long l15, Long l16, Long l17, long l18, long l19) {
        this.id = l;
        this.trId = l2;
        this.oiId = l3;
        this.eventType = n;
        this.smeId = l4;
        this.seId = l5;
        this.submitTs = l6;
        this.finalTs = l7;
        this.finalEsdId = l8;
        this.mainSmeId = l9;
        this.mainSeId = l10;
        this.mainFinalTs = l11;
        this.mainFinalEsdId = l12;
        this.seVersion = l13;
        this.creatorUId = l14;
        this.createTs = l15;
        this.changerUId = l16;
        this.changeTs = l17;
        this.validFrom = l18;
        this.validTo = l19;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "OBJECT_EVENT" + string3 + " (ID, " + string2 + "TR_ID" + string3 + ", " + string2 + "OI_ID" + string3 + ", " + string2 + "EVENT_TYPE" + string3 + ", " + string2 + "SME_ID" + string3 + ", " + string2 + "SE_ID" + string3 + ", " + string2 + "SUBMIT_TS" + string3 + ", " + string2 + "FINAL_TS" + string3 + ", " + string2 + "FINAL_ESD_ID" + string3 + ", " + string2 + "MAIN_SME_ID" + string3 + ", " + string2 + "MAIN_SE_ID" + string3 + ", " + string2 + "MAIN_FINAL_TS" + string3 + ", " + string2 + "MAIN_FINAL_ESD_ID" + string3 + ", " + string2 + "SE_VERSION" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                SDMSObjectEventGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "ObjectEvent: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            if (this.trId == null) {
                preparedStatement.setNull(2, 4);
            } else {
                preparedStatement.setLong(2, this.trId);
            }
            preparedStatement.setLong(3, this.oiId);
            preparedStatement.setInt(4, this.eventType);
            preparedStatement.setLong(5, this.smeId);
            preparedStatement.setLong(6, this.seId);
            if (this.submitTs == null) {
                preparedStatement.setNull(7, 4);
            } else {
                preparedStatement.setLong(7, this.submitTs);
            }
            if (this.finalTs == null) {
                preparedStatement.setNull(8, 4);
            } else {
                preparedStatement.setLong(8, this.finalTs);
            }
            if (this.finalEsdId == null) {
                preparedStatement.setNull(9, 4);
            } else {
                preparedStatement.setLong(9, this.finalEsdId);
            }
            if (this.mainSmeId == null) {
                preparedStatement.setNull(10, 4);
            } else {
                preparedStatement.setLong(10, this.mainSmeId);
            }
            if (this.mainSeId == null) {
                preparedStatement.setNull(11, 4);
            } else {
                preparedStatement.setLong(11, this.mainSeId);
            }
            if (this.mainFinalTs == null) {
                preparedStatement.setNull(12, 4);
            } else {
                preparedStatement.setLong(12, this.mainFinalTs);
            }
            if (this.mainFinalEsdId == null) {
                preparedStatement.setNull(13, 4);
            } else {
                preparedStatement.setLong(13, this.mainFinalEsdId);
            }
            preparedStatement.setLong(14, this.seVersion);
            preparedStatement.setLong(15, this.creatorUId);
            preparedStatement.setLong(16, this.createTs);
            preparedStatement.setLong(17, this.changerUId);
            preparedStatement.setLong(18, this.changeTs);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "ObjectEvent: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pDelete[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "DELETE FROM " + string2 + "OBJECT_EVENT" + string3 + " WHERE ID = ?";
                SDMSObjectEventGeneric.pDelete[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182001", "ObjectEvent: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pDelete[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182002", "ObjectEvent: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string2 + "OBJECT_EVENT" + string3 + " SET " + string2 + "TR_ID" + string3 + " = ? , " + string2 + "OI_ID" + string3 + " = ? , " + string2 + "EVENT_TYPE" + string3 + " = ? , " + string2 + "SME_ID" + string3 + " = ? , " + string2 + "SE_ID" + string3 + " = ? , " + string2 + "SUBMIT_TS" + string3 + " = ? , " + string2 + "FINAL_TS" + string3 + " = ? , " + string2 + "FINAL_ESD_ID" + string3 + " = ? , " + string2 + "MAIN_SME_ID" + string3 + " = ? , " + string2 + "MAIN_SE_ID" + string3 + " = ? , " + string2 + "MAIN_FINAL_TS" + string3 + " = ? , " + string2 + "MAIN_FINAL_ESD_ID" + string3 + " = ? , " + string2 + "SE_VERSION" + string3 + " = ? , " + string2 + "CREATOR_U_ID" + string3 + " = ? , " + string2 + "CREATE_TS" + string3 + " = ? , " + string2 + "CHANGER_U_ID" + string3 + " = ? , " + string2 + "CHANGE_TS" + string3 + " = ? WHERE ID = ?";
                SDMSObjectEventGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182005", "ObjectEvent: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            if (this.trId == null) {
                preparedStatement.setNull(1, 4);
            } else {
                preparedStatement.setLong(1, this.trId);
            }
            preparedStatement.setLong(2, this.oiId);
            preparedStatement.setInt(3, this.eventType);
            preparedStatement.setLong(4, this.smeId);
            preparedStatement.setLong(5, this.seId);
            if (this.submitTs == null) {
                preparedStatement.setNull(6, 4);
            } else {
                preparedStatement.setLong(6, this.submitTs);
            }
            if (this.finalTs == null) {
                preparedStatement.setNull(7, 4);
            } else {
                preparedStatement.setLong(7, this.finalTs);
            }
            if (this.finalEsdId == null) {
                preparedStatement.setNull(8, 4);
            } else {
                preparedStatement.setLong(8, this.finalEsdId);
            }
            if (this.mainSmeId == null) {
                preparedStatement.setNull(9, 4);
            } else {
                preparedStatement.setLong(9, this.mainSmeId);
            }
            if (this.mainSeId == null) {
                preparedStatement.setNull(10, 4);
            } else {
                preparedStatement.setLong(10, this.mainSeId);
            }
            if (this.mainFinalTs == null) {
                preparedStatement.setNull(11, 4);
            } else {
                preparedStatement.setLong(11, this.mainFinalTs);
            }
            if (this.mainFinalEsdId == null) {
                preparedStatement.setNull(12, 4);
            } else {
                preparedStatement.setLong(12, this.mainFinalEsdId);
            }
            preparedStatement.setLong(13, this.seVersion);
            preparedStatement.setLong(14, this.creatorUId);
            preparedStatement.setLong(15, this.createTs);
            preparedStatement.setLong(16, this.changerUId);
            preparedStatement.setLong(17, this.changeTs);
            preparedStatement.setLong(18, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182006", "ObjectEvent: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    public static boolean checkEventType(Integer n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : ObjectEvent", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "trId : " + this.trId, 2);
        SDMSThread.doTrace(null, "oiId : " + this.oiId, 2);
        SDMSThread.doTrace(null, "eventType : " + this.eventType, 2);
        SDMSThread.doTrace(null, "smeId : " + this.smeId, 2);
        SDMSThread.doTrace(null, "seId : " + this.seId, 2);
        SDMSThread.doTrace(null, "submitTs : " + this.submitTs, 2);
        SDMSThread.doTrace(null, "finalTs : " + this.finalTs, 2);
        SDMSThread.doTrace(null, "finalEsdId : " + this.finalEsdId, 2);
        SDMSThread.doTrace(null, "mainSmeId : " + this.mainSmeId, 2);
        SDMSThread.doTrace(null, "mainSeId : " + this.mainSeId, 2);
        SDMSThread.doTrace(null, "mainFinalTs : " + this.mainFinalTs, 2);
        SDMSThread.doTrace(null, "mainFinalEsdId : " + this.mainFinalEsdId, 2);
        SDMSThread.doTrace(null, "seVersion : " + this.seVersion, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "trId           : " + this.trId + "\n" + string + "oiId           : " + this.oiId + "\n" + string + "eventType      : " + this.eventType + "\n" + string + "smeId          : " + this.smeId + "\n" + string + "seId           : " + this.seId + "\n" + string + "submitTs       : " + this.submitTs + "\n" + string + "finalTs        : " + this.finalTs + "\n" + string + "finalEsdId     : " + this.finalEsdId + "\n" + string + "mainSmeId      : " + this.mainSmeId + "\n" + string + "mainSeId       : " + this.mainSeId + "\n" + string + "mainFinalTs    : " + this.mainFinalTs + "\n" + string + "mainFinalEsdId : " + this.mainFinalEsdId + "\n" + string + "seVersion      : " + this.seVersion + "\n" + string + "creatorUId     : " + this.creatorUId + "\n" + string + "createTs       : " + this.createTs + "\n" + string + "changerUId     : " + this.changerUId + "\n" + string + "changeTs       : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

