/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSOwnedObject;
import de.independit.scheduler.server.repository.SDMSPoolDistribution;
import de.independit.scheduler.server.repository.SDMSPoolDistributionTable;
import de.independit.scheduler.server.repository.SDMSPoolProxyGeneric;
import de.independit.scheduler.server.repository.SDMSPoolTable;
import de.independit.scheduler.server.repository.SDMSPooledResource;
import de.independit.scheduler.server.repository.SDMSPooledResourceTable;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSSysResource;
import de.independit.scheduler.server.util.SDMSThread;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Vector;

public class SDMSPool
extends SDMSPoolProxyGeneric
implements SDMSSysResource,
SDMSOwnedObject {
    public static final String __version = "SDMSPool $Revision: 2.17.6.1 $ / @(#) $Id: SDMSPool.java,v 2.17.6.1 2013/03/14 10:25:21 ronald Exp $";
    private static final Object protectTraceInsert = new Object();
    private static PreparedStatement traceInsert = null;

    protected SDMSPool(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    @Override
    public void setManagerId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Long l2 = this.getManagerId(systemEnvironment);
        if (l2 == null && l == null) {
            return;
        }
        if (l2 != null && l != null) {
            if (l2.equals(l)) {
                return;
            }
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603161738", "The $1 is already managed", this.getURL(systemEnvironment)));
        }
        int n = this.getAmount(systemEnvironment);
        if (l == null) {
            super.setManagerId(systemEnvironment, l);
            SDMSPooledResource sDMSPooledResource = SDMSPooledResourceTable.getObject(systemEnvironment, l2);
            SDMSPool sDMSPool = SDMSPoolTable.getObject(systemEnvironment, sDMSPooledResource.getPId(systemEnvironment));
            Integer n2 = sDMSPool.getFreeAmount(systemEnvironment) + n;
            sDMSPool.setFreeAmount(systemEnvironment, n2);
            this.setAmount(systemEnvironment, this.getDefinedAmount(systemEnvironment));
        } else {
            SDMSPooledResource sDMSPooledResource = SDMSPooledResourceTable.getObject(systemEnvironment, l);
            SDMSPool sDMSPool = SDMSPoolTable.getObject(systemEnvironment, sDMSPooledResource.getPId(systemEnvironment));
            Integer n3 = sDMSPool.getFreeAmount(systemEnvironment) - n;
            sDMSPool.setFreeAmount(systemEnvironment, n3);
            super.setManagerId(systemEnvironment, l);
        }
    }

    @Override
    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSProxy sDMSProxy;
        int n;
        if (this.getManagerId(systemEnvironment) != null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603181808", "The pool is still managed"));
        }
        Long l = this.getId(systemEnvironment);
        Vector vector = SDMSPooledResourceTable.idx_pId.getVector(systemEnvironment, l);
        Vector vector2 = SDMSPoolDistributionTable.idx_pId.getVector(systemEnvironment, l);
        Vector vector3 = SDMSPooledResourceTable.idx_rId.getVector(systemEnvironment, l);
        for (n = 0; n < vector.size(); ++n) {
            sDMSProxy = (SDMSPooledResource)vector.get(n);
            ((SDMSPooledResource)sDMSProxy).delete(systemEnvironment);
        }
        for (n = 0; n < vector3.size(); ++n) {
            sDMSProxy = (SDMSPooledResource)vector3.get(n);
            ((SDMSPooledResource)sDMSProxy).delete(systemEnvironment);
        }
        for (n = 0; n < vector2.size(); ++n) {
            sDMSProxy = (SDMSPoolDistribution)vector2.get(n);
            ((SDMSPoolDistribution)sDMSProxy).delete(systemEnvironment);
        }
        super.delete(systemEnvironment);
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSPool sDMSPool) throws SDMSException {
        SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, sDMSPool.getNrId(systemEnvironment));
        SDMSScope sDMSScope = SDMSScopeTable.getObject(systemEnvironment, sDMSPool.getScopeId(systemEnvironment));
        SDMSPrivilege sDMSPrivilege = sDMSNamedResource.getPrivileges(systemEnvironment);
        sDMSPrivilege.merge(sDMSScope.getPrivileges(systemEnvironment));
        return sDMSPrivilege.can(8L);
    }

    @Override
    public String getURLName(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, this.getNrId(systemEnvironment));
        SDMSScope sDMSScope = SDMSScopeTable.getObject(systemEnvironment, this.getScopeId(systemEnvironment));
        return sDMSNamedResource.pathString(systemEnvironment) + " in " + sDMSScope.pathString(systemEnvironment);
    }

    @Override
    public String getURL(SystemEnvironment systemEnvironment) throws SDMSException {
        return "pool " + this.getURLName(systemEnvironment);
    }

    @Override
    public void releaseAmount(SystemEnvironment systemEnvironment, int n) throws SDMSException {
        Integer n2 = this.getFreeAmount(systemEnvironment);
        if (n2 != null) {
            int n3;
            SDMSPooledResource sDMSPooledResource;
            int n4;
            n2 = n2 + n;
            this.setFreeAmount(systemEnvironment, n2);
            Long l = this.getManagerId(systemEnvironment);
            if (l != null && (n4 = (sDMSPooledResource = SDMSPooledResourceTable.getObject(systemEnvironment, l)).releaseAmount(systemEnvironment, n, n3 = this.getAmount(systemEnvironment).intValue())) > 0) {
                this.setAmount(systemEnvironment, n3 - n4);
            }
        }
    }

    @Override
    public void setAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        Integer n2 = this.getFreeAmount(systemEnvironment) + n - this.getAmount(systemEnvironment);
        super.setFreeAmount(systemEnvironment, n2);
        super.setAmount(systemEnvironment, n);
    }

    @Override
    public void setFreeAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        int n2 = n;
        Long l = this.getManagerId(systemEnvironment);
        if (n2 < 0 && l != null) {
            SDMSPooledResource sDMSPooledResource = SDMSPooledResourceTable.getObject(systemEnvironment, l);
            SDMSPool sDMSPool = SDMSPoolTable.getObject(systemEnvironment, sDMSPooledResource.getPId(systemEnvironment));
            Integer n3 = sDMSPool.getFreeAmount(systemEnvironment) + n2;
            sDMSPool.setFreeAmount(systemEnvironment, n3);
            n = SDMSConstants.iZERO;
        }
        super.setFreeAmount(systemEnvironment, n);
    }

    public int requestAmount(SystemEnvironment systemEnvironment, int n, int n2, int n3, int n4) throws SDMSException {
        int n5;
        SDMSProxy sDMSProxy;
        Comparable comparable;
        int n6;
        int n7 = this.getFreeAmount(systemEnvironment);
        SDMSThread.doTrace(systemEnvironment.cEnv, "reqAmount : " + n + ", curAmount :  " + n4 + ", minAmount : " + n2 + ", freeAmount : " + n7 + " (" + this.getURL(systemEnvironment) + ")", 3);
        int n8 = n3 * this.getAmount(systemEnvironment) / 100;
        Vector vector = SDMSPooledResourceTable.idx_pId.getVector(systemEnvironment, this.getId(systemEnvironment));
        int n9 = 0;
        for (n6 = 0; n6 < vector.size(); ++n6) {
            comparable = (SDMSPooledResource)vector.get(n6);
            try {
                sDMSProxy = SDMSResourceTable.getObject(systemEnvironment, comparable.getRId(systemEnvironment));
            }
            catch (NotFoundException notFoundException) {
                sDMSProxy = SDMSPoolTable.getObject(systemEnvironment, comparable.getRId(systemEnvironment));
            }
            n5 = comparable.getTargetAmount(systemEnvironment) - sDMSProxy.getAmount(systemEnvironment);
            if (n5 <= 0) continue;
            n9 += n5;
        }
        n6 = n7 + n2 - n9;
        if (n6 < n2 && n7 >= n2) {
            n6 = n2;
        }
        if (n6 > n) {
            n6 = n;
        }
        if (n4 + n6 > n8) {
            n6 = n8 - n4;
        }
        if (n6 < n && (comparable = this.getManagerId(systemEnvironment)) != null) {
            sDMSProxy = SDMSPooledResourceTable.getObject(systemEnvironment, (Long)comparable);
            n5 = ((SDMSPooledResource)sDMSProxy).requestAmount(systemEnvironment, n - n6, this.getAmount(systemEnvironment));
            SDMSThread.doTrace(systemEnvironment.cEnv, "   we got " + n5 + " from our pool", 3);
            if (n5 > 0) {
                this.setAmount(systemEnvironment, this.getAmount(systemEnvironment) + n5);
                n7 = this.getFreeAmount(systemEnvironment);
            }
            n6 += n5;
        }
        SDMSThread.doTrace(systemEnvironment.cEnv, "   we can grant " + n6 + " for this request", 3);
        if (n6 <= 0) {
            return 0;
        }
        this.setFreeAmount(systemEnvironment, n7 - n6);
        return n6;
    }

    public void adjustChildAllocated(SystemEnvironment systemEnvironment, int n) throws SDMSException {
        int n2;
        Comparable comparable;
        Serializable serializable;
        if (n == 0) {
            return;
        }
        Integer n3 = this.getTraceBase(systemEnvironment);
        int n4 = this.getChildAllocated(systemEnvironment);
        if (n3 != null) {
            serializable = (HashMap)systemEnvironment.tx.txData.get("RESOURCETRACE");
            if (serializable == null) {
                serializable = new HashMap();
                systemEnvironment.tx.txData.put("RESOURCETRACE", serializable);
            }
            if (!((HashMap)serializable).containsKey(comparable = this.getId(systemEnvironment))) {
                ((HashMap)serializable).put(comparable, n4);
            }
        }
        if ((serializable = this.getManagerId(systemEnvironment)) != null) {
            comparable = SDMSPooledResourceTable.getObject(systemEnvironment, (Long)serializable);
            SDMSPool sDMSPool = SDMSPoolTable.getObject(systemEnvironment, comparable.getPId(systemEnvironment));
            sDMSPool.adjustChildAllocated(systemEnvironment, n);
        }
        if (SystemEnvironment.runMode.equals("TEST") && (n2 = this.getCA(systemEnvironment)) != n4 + n) {
            SDMSThread.doTrace(systemEnvironment.cEnv, "Inconsistent adjustChildAllocated(correction=" + n + ",alloc=" + n4 + "realCa=" + n2, -1);
        }
        this.setChildAllocated(systemEnvironment, n4 + n);
    }

    @Override
    public void setDistId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        super.setDistId(systemEnvironment, l);
        this.setChildAllocated(systemEnvironment, this.getAmount(systemEnvironment) - this.getChildFree(systemEnvironment));
    }

    @Override
    public void setTag(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null) {
            if (string.equals(this.getTag(systemEnvironment))) {
                return;
            }
            Vector vector = SDMSResourceTable.idx_tag.getVector(systemEnvironment, string);
            int n = vector.size();
            vector = SDMSPoolTable.idx_tag.getVector(systemEnvironment, string);
            if ((n += vector.size()) > 0) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03704272133", "The tag \"$1\" is already in use by another resource or pool", string));
            }
        }
        super.setTag(systemEnvironment, string);
    }

    @Override
    public Integer getTotalFreeAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.getAmount(systemEnvironment) - this.getChildAllocated(systemEnvironment);
    }

    public int getChildFree(SystemEnvironment systemEnvironment) throws SDMSException {
        int n = this.getFreeAmount(systemEnvironment);
        Vector vector = SDMSPooledResourceTable.idx_pId.getVector(systemEnvironment, this.getId(systemEnvironment));
        for (int i = 0; i < vector.size(); ++i) {
            Long l;
            SDMSPooledResource sDMSPooledResource = (SDMSPooledResource)vector.get(i);
            Long l2 = sDMSPooledResource.getId(systemEnvironment);
            try {
                SDMSResource sDMSResource = SDMSResourceTable.getObject(systemEnvironment, sDMSPooledResource.getRId(systemEnvironment));
                l = sDMSResource.getManagerId(systemEnvironment);
                if (l == null || !l.equals(l2)) continue;
                n += sDMSResource.getFreeAmount(systemEnvironment).intValue();
                continue;
            }
            catch (NotFoundException notFoundException) {
                SDMSPool sDMSPool = SDMSPoolTable.getObject(systemEnvironment, sDMSPooledResource.getRId(systemEnvironment));
                l = sDMSPool.getManagerId(systemEnvironment);
                if (l == null || !l.equals(l2)) continue;
                n += sDMSPool.getChildFree(systemEnvironment);
            }
        }
        return n;
    }

    public int getCA(SystemEnvironment systemEnvironment) throws SDMSException {
        int n = 0;
        Vector vector = SDMSPooledResourceTable.idx_pId.getVector(systemEnvironment, this.getId(systemEnvironment));
        for (int i = 0; i < vector.size(); ++i) {
            Long l;
            SDMSPooledResource sDMSPooledResource = (SDMSPooledResource)vector.get(i);
            Long l2 = sDMSPooledResource.getId(systemEnvironment);
            try {
                SDMSResource sDMSResource = SDMSResourceTable.getObject(systemEnvironment, sDMSPooledResource.getRId(systemEnvironment));
                l = sDMSResource.getManagerId(systemEnvironment);
                if (l == null || !l.equals(l2)) continue;
                n += sDMSResource.getAmount(systemEnvironment) - sDMSResource.getFreeAmount(systemEnvironment);
                continue;
            }
            catch (NotFoundException notFoundException) {
                SDMSPool sDMSPool = SDMSPoolTable.getObject(systemEnvironment, sDMSPooledResource.getRId(systemEnvironment));
                l = sDMSPool.getManagerId(systemEnvironment);
                if (l == null || !l.equals(l2)) continue;
                n += sDMSPool.getCA(systemEnvironment);
            }
        }
        return n;
    }

    @Override
    public Float getTd0Avg(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getTraceBase(systemEnvironment);
        if (n == null) {
            return null;
        }
        int n2 = n;
        long l = this.getLastEval(systemEnvironment);
        long l2 = systemEnvironment.tx.startTime;
        long l3 = l2 - l;
        int n3 = this.getTraceBaseMultiplier(systemEnvironment);
        long l4 = (long)n2 * 1000L;
        int n4 = this.getChildAllocated(systemEnvironment);
        float f = super.getTd0Avg(systemEnvironment).floatValue();
        f = l4 > l3 ? ((float)(l3 * (long)n4) + (float)(l4 - l3) * f) / (float)l4 : (float)n4;
        return Float.valueOf(f);
    }

    @Override
    public Float getTd1Avg(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getTraceBase(systemEnvironment);
        if (n == null) {
            return null;
        }
        int n2 = n;
        long l = this.getLastEval(systemEnvironment);
        long l2 = systemEnvironment.tx.startTime;
        long l3 = l2 - l;
        int n3 = this.getTraceBaseMultiplier(systemEnvironment);
        long l4 = (long)(n3 * n2) * 1000L;
        int n4 = this.getChildAllocated(systemEnvironment);
        float f = super.getTd1Avg(systemEnvironment).floatValue();
        f = l4 > l3 ? ((float)(l3 * (long)n4) + (float)(l4 - l3) * f) / (float)l4 : (float)n4;
        return Float.valueOf(f);
    }

    @Override
    public Float getTd2Avg(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getTraceBase(systemEnvironment);
        if (n == null) {
            return null;
        }
        int n2 = n;
        long l = this.getLastEval(systemEnvironment);
        long l2 = systemEnvironment.tx.startTime;
        long l3 = l2 - l;
        int n3 = this.getTraceBaseMultiplier(systemEnvironment);
        long l4 = (long)(n3 * n3 * n2) * 1000L;
        int n4 = this.getChildAllocated(systemEnvironment);
        float f = super.getTd2Avg(systemEnvironment).floatValue();
        f = l4 > l3 ? ((float)(l3 * (long)n4) + (float)(l4 - l3) * f) / (float)l4 : (float)n4;
        return Float.valueOf(f);
    }

    @Override
    public Float getLwAvg(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getTraceBase(systemEnvironment);
        if (n == null) {
            return null;
        }
        Integer n2 = this.getTraceInterval(systemEnvironment);
        if (n2 == null) {
            return null;
        }
        long l = (long)n2.intValue() * 1000L;
        long l2 = this.getLastEval(systemEnvironment);
        long l3 = systemEnvironment.tx.startTime;
        long l4 = l3 - l2;
        int n3 = this.getChildAllocated(systemEnvironment);
        float f = super.getLwAvg(systemEnvironment).floatValue();
        f = l > l4 ? ((float)(l4 * (long)n3) + (float)(l - l4) * f) / (float)l : (float)n3;
        return Float.valueOf(f);
    }

    protected void writeTrace(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        long l = this.getLastWrite(systemEnvironment);
        long l2 = this.getLastEval(systemEnvironment);
        long l3 = systemEnvironment.tx.startTime;
        long l4 = l3 - l2;
        int n2 = n;
        int n3 = this.getTraceBaseMultiplier(systemEnvironment);
        int n4 = this.getTraceBase(systemEnvironment);
        long l5 = (long)n4 * 1000L;
        long l6 = (long)n3 * l5;
        long l7 = (long)n3 * l6;
        float f = super.getTd0Avg(systemEnvironment).floatValue();
        float f2 = super.getTd1Avg(systemEnvironment).floatValue();
        float f3 = super.getTd2Avg(systemEnvironment).floatValue();
        f = l5 > l4 ? ((float)(l4 * (long)n2) + (float)(l5 - l4) * f) / (float)l5 : (float)n2;
        f2 = l6 > l4 ? ((float)(l4 * (long)n2) + (float)(l6 - l4) * f2) / (float)l6 : (float)n2;
        f3 = l7 > l4 ? ((float)(l4 * (long)n2) + (float)(l7 - l4) * f3) / (float)l7 : (float)n2;
        this.setTd0Avg(systemEnvironment, Float.valueOf(f));
        this.setTd1Avg(systemEnvironment, Float.valueOf(f2));
        this.setTd2Avg(systemEnvironment, Float.valueOf(f3));
        this.setLastEval(systemEnvironment, l3);
        Integer n5 = this.getTraceInterval(systemEnvironment);
        if (n5 != null) {
            long l8 = (long)n5.intValue() * 1000L;
            float f4 = super.getLwAvg(systemEnvironment).floatValue();
            f4 = l8 > l4 ? ((float)(l4 * (long)n2) + (float)(l8 - l4) * f4) / (float)l8 : (float)n2;
            this.setLwAvg(systemEnvironment, Float.valueOf(f4));
            if (l3 - l8 >= l) {
                this.writeTraceRecord(systemEnvironment, this.getId(systemEnvironment), this.getTag(systemEnvironment), n5, n4, n3, f, f2, f3, f4, l3, l);
                this.setLastWrite(systemEnvironment, l3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void writeTraceRecord(SystemEnvironment systemEnvironment, Long l, String string, int n, int n2, int n3, float f, float f2, float f3, float f4, long l2, long l3) throws SDMSException {
        String string2 = "";
        Object object = protectTraceInsert;
        synchronized (object) {
            if (traceInsert == null) {
                try {
                    string2 = "INSERT INTO RESOURCE_TRACE (r_id,    tag,     trace_interval, trace_base, trace_base_multiplier, td0_avg, td1_avg, td2_avg,        lw_avg,     write_time,  last_write ) VALUES (?,       ?,       ?,              ?,           ?, ?,       ?,       ?,              ?,           ?,            ? )";
                    traceInsert = systemEnvironment.dbConnection.prepareStatement(string2);
                }
                catch (SQLException sQLException) {
                    throw new FatalException(new SDMSMessage(systemEnvironment, "03704241640", "ResourceTrace: $1\n$2", string2, sQLException.toString()));
                }
            }
            try {
                traceInsert.clearParameters();
                traceInsert.setLong(1, l);
                if (string == null) {
                    traceInsert.setNull(2, 12);
                } else {
                    traceInsert.setString(2, string);
                }
                traceInsert.setInt(3, n);
                traceInsert.setInt(4, n2);
                traceInsert.setInt(5, n3);
                traceInsert.setFloat(6, f);
                traceInsert.setFloat(7, f2);
                traceInsert.setFloat(8, f3);
                traceInsert.setFloat(9, f4);
                traceInsert.setLong(10, l2);
                traceInsert.setLong(11, l3);
                traceInsert.executeUpdate();
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "03704241658", "ResourceTrace: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
            }
        }
    }
}

