/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSResourceAllocation;
import de.independit.scheduler.server.repository.SDMSResourceAllocationGeneric;
import de.independit.scheduler.server.repository.SDMSResourceAllocationTable;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSResourceAllocationTableGeneric
extends SDMSTable {
    public static final String tableName = "RESOURCE_ALLOCATION";
    public static SDMSResourceAllocationTable table = null;
    public static final String[] columnNames = new String[]{"ID", "R_ID", "SME_ID", "NR_ID", "AMOUNT", "ORIG_AMOUNT", "KEEP_MODE", "IS_STICKY", "STICKY_NAME", "STICKY_PARENT", "ALLOCATION_TYPE", "RSMP_ID", "LOCKMODE", "REFCOUNT", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_rId;
    public static SDMSIndex idx_smeId;
    public static SDMSIndex idx_nrId;
    public static SDMSIndex idx_smeId_rId_stickyName;
    public static SDMSIndex idx_stickyParent_rId_stickyName;
    public static SDMSIndex idx_smeId_nrId;

    public SDMSResourceAllocationTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "ResourceAllocation"));
        }
        table = (SDMSResourceAllocationTable)this;
        table = (SDMSResourceAllocationTable)this;
        this.isVersioned = false;
        idx_rId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "rId");
        idx_smeId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "smeId");
        idx_nrId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "nrId");
        idx_smeId_rId_stickyName = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "smeId_rId_stickyName");
        idx_stickyParent_rId_stickyName = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "stickyParent_rId_stickyName");
        idx_smeId_nrId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "smeId_nrId");
    }

    public SDMSResourceAllocation create(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Integer n, Integer n2, Integer n3, Boolean bl, String string, Long l4, Integer n4, Long l5, Integer n5, Integer n6) throws SDMSException {
        SDMSResourceAllocation sDMSResourceAllocation;
        Long l6 = systemEnvironment.cEnv.uid();
        Long l7 = systemEnvironment.txTime();
        Long l8 = systemEnvironment.cEnv.uid();
        Long l9 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "ResourceAllocation"));
        }
        this.validate(systemEnvironment, l, l2, l3, n, n2, n3, bl, string, l4, n4, l5, n5, n6, l6, l7, l8, l9);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSResourceAllocationGeneric sDMSResourceAllocationGeneric = new SDMSResourceAllocationGeneric(systemEnvironment, l, l2, l3, n, n2, n3, bl, string, l4, n4, l5, n5, n6, l6, l7, l8, l9);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSResourceAllocationGeneric.versions, true);
            table.put(systemEnvironment, sDMSResourceAllocationGeneric.id, sDMSResourceAllocationGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSResourceAllocation = (SDMSResourceAllocation)sDMSResourceAllocationGeneric.toProxy(systemEnvironment);
            sDMSResourceAllocation.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSResourceAllocation sDMSResourceAllocation2 = (SDMSResourceAllocation)sDMSResourceAllocationGeneric.toProxy(systemEnvironment);
            sDMSResourceAllocation2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSResourceAllocation)) {
            throw new AccessViolationException(sDMSResourceAllocation.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSResourceAllocation.touchMaster(systemEnvironment);
        return sDMSResourceAllocation;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSResourceAllocation sDMSResourceAllocation) throws SDMSException {
        return sDMSResourceAllocation.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Integer n, Integer n2, Integer n3, Boolean bl, String string, Long l4, Integer n4, Long l5, Integer n5, Integer n6, Long l6, Long l7, Long l8, Long l9) throws SDMSException {
        if (!SDMSResourceAllocationGeneric.checkKeepMode(n3)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "ResourceAllocation: $1 $2", "keepMode", n3));
        }
        if (!SDMSResourceAllocationGeneric.checkAllocationType(n4)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "ResourceAllocation: $1 $2", "allocationType", n4));
        }
        if (!SDMSResourceAllocationGeneric.checkLockmode(n5)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "ResourceAllocation: $1 $2", "lockmode", n5));
        }
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Integer n;
        Integer n2;
        Long l7;
        Integer n3;
        Long l8;
        String string;
        Boolean bl;
        Integer n4;
        Integer n5;
        Integer n6;
        Long l9;
        Long l10;
        Long l11;
        Long l12;
        try {
            l12 = resultSet.getLong(1);
            l11 = resultSet.getLong(2);
            l10 = resultSet.getLong(3);
            l9 = resultSet.getLong(4);
            n6 = resultSet.getInt(5);
            if (resultSet.wasNull()) {
                n6 = null;
            }
            n5 = resultSet.getInt(6);
            if (resultSet.wasNull()) {
                n5 = null;
            }
            n4 = resultSet.getInt(7);
            bl = resultSet.getInt(8) != 0;
            string = resultSet.getString(9);
            if (resultSet.wasNull()) {
                string = null;
            }
            l8 = resultSet.getLong(10);
            if (resultSet.wasNull()) {
                l8 = null;
            }
            n3 = resultSet.getInt(11);
            l7 = resultSet.getLong(12);
            if (resultSet.wasNull()) {
                l7 = null;
            }
            n2 = resultSet.getInt(13);
            if (resultSet.wasNull()) {
                n2 = null;
            }
            n = resultSet.getInt(14);
            l6 = resultSet.getLong(15);
            l5 = resultSet.getLong(16);
            l4 = resultSet.getLong(17);
            l3 = resultSet.getLong(18);
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "ResourceAllocation: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSResourceAllocationGeneric(l12, l11, l10, l9, n6, n5, n4, bl, string, l8, n3, l7, n2, n, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "R_ID" + string2 + ", " + string + "SME_ID" + string2 + ", " + string + "NR_ID" + string2 + ", " + string + "AMOUNT" + string2 + ", " + string + "ORIG_AMOUNT" + string2 + ", " + string + "KEEP_MODE" + string2 + ", " + string + "IS_STICKY" + string2 + ", " + string + "STICKY_NAME" + string2 + ", " + string + "STICKY_PARENT" + string2 + ", " + string + "ALLOCATION_TYPE" + string2 + ", " + string + "RSMP_ID" + string2 + ", " + string + "LOCKMODE" + string2 + ", " + string + "REFCOUNT" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2 + "");
        while (resultSet.next()) {
            try {
                if (this.loadObject(systemEnvironment, resultSet)) {
                    ++n2;
                }
                ++n;
            }
            catch (Exception exception) {
                SDMSThread.doTrace(null, "Exception caught while loading table " + this.tableName() + ", ID = " + Long.valueOf(resultSet.getLong(1)), -1);
                throw exception;
            }
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_rId.check(((SDMSResourceAllocationGeneric)sDMSObject).rId, sDMSObject);
        string = string + "idx_rId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_smeId.check(((SDMSResourceAllocationGeneric)sDMSObject).smeId, sDMSObject);
        string = string + "idx_smeId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_nrId.check(((SDMSResourceAllocationGeneric)sDMSObject).nrId, sDMSObject);
        string = string + "idx_nrId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSResourceAllocationGeneric)sDMSObject).smeId);
        sDMSKey.add(((SDMSResourceAllocationGeneric)sDMSObject).rId);
        sDMSKey.add((Comparable)((Object)((SDMSResourceAllocationGeneric)sDMSObject).stickyName));
        bl = idx_smeId_rId_stickyName.check(sDMSKey, sDMSObject);
        string = string + "idx_smeId_rId_stickyName: " + (bl ? "ok" : "missing") + "\n";
        sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSResourceAllocationGeneric)sDMSObject).stickyParent);
        sDMSKey.add(((SDMSResourceAllocationGeneric)sDMSObject).rId);
        sDMSKey.add((Comparable)((Object)((SDMSResourceAllocationGeneric)sDMSObject).stickyName));
        bl = idx_stickyParent_rId_stickyName.check(sDMSKey, sDMSObject);
        string = string + "idx_stickyParent_rId_stickyName: " + (bl ? "ok" : "missing") + "\n";
        sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSResourceAllocationGeneric)sDMSObject).smeId);
        sDMSKey.add(((SDMSResourceAllocationGeneric)sDMSObject).nrId);
        bl = idx_smeId_nrId.check(sDMSKey, sDMSObject);
        string = string + "idx_smeId_nrId: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_rId.put(systemEnvironment, ((SDMSResourceAllocationGeneric)sDMSObject).rId, sDMSObject, (1L & l) != 0L);
        idx_smeId.put(systemEnvironment, ((SDMSResourceAllocationGeneric)sDMSObject).smeId, sDMSObject, (2L & l) != 0L);
        idx_nrId.put(systemEnvironment, ((SDMSResourceAllocationGeneric)sDMSObject).nrId, sDMSObject, (4L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSResourceAllocationGeneric)sDMSObject).smeId);
        sDMSKey.add(((SDMSResourceAllocationGeneric)sDMSObject).rId);
        sDMSKey.add((Comparable)((Object)((SDMSResourceAllocationGeneric)sDMSObject).stickyName));
        idx_smeId_rId_stickyName.put(systemEnvironment, sDMSKey, sDMSObject, (8L & l) != 0L);
        sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSResourceAllocationGeneric)sDMSObject).stickyParent);
        sDMSKey.add(((SDMSResourceAllocationGeneric)sDMSObject).rId);
        sDMSKey.add((Comparable)((Object)((SDMSResourceAllocationGeneric)sDMSObject).stickyName));
        idx_stickyParent_rId_stickyName.put(systemEnvironment, sDMSKey, sDMSObject, (0x10L & l) != 0L);
        sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSResourceAllocationGeneric)sDMSObject).smeId);
        sDMSKey.add(((SDMSResourceAllocationGeneric)sDMSObject).nrId);
        idx_smeId_nrId.put(systemEnvironment, sDMSKey, sDMSObject, (0x20L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_rId.remove(systemEnvironment, ((SDMSResourceAllocationGeneric)sDMSObject).rId, sDMSObject);
        idx_smeId.remove(systemEnvironment, ((SDMSResourceAllocationGeneric)sDMSObject).smeId, sDMSObject);
        idx_nrId.remove(systemEnvironment, ((SDMSResourceAllocationGeneric)sDMSObject).nrId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSResourceAllocationGeneric)sDMSObject).smeId);
        sDMSKey.add(((SDMSResourceAllocationGeneric)sDMSObject).rId);
        sDMSKey.add((Comparable)((Object)((SDMSResourceAllocationGeneric)sDMSObject).stickyName));
        idx_smeId_rId_stickyName.remove(systemEnvironment, sDMSKey, sDMSObject);
        sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSResourceAllocationGeneric)sDMSObject).stickyParent);
        sDMSKey.add(((SDMSResourceAllocationGeneric)sDMSObject).rId);
        sDMSKey.add((Comparable)((Object)((SDMSResourceAllocationGeneric)sDMSObject).stickyName));
        idx_stickyParent_rId_stickyName.remove(systemEnvironment, sDMSKey, sDMSObject);
        sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSResourceAllocationGeneric)sDMSObject).smeId);
        sDMSKey.add(((SDMSResourceAllocationGeneric)sDMSObject).nrId);
        idx_smeId_nrId.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSResourceAllocation getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSResourceAllocation)table.get(systemEnvironment, l);
    }

    public static SDMSResourceAllocation getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSResourceAllocation)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSResourceAllocation getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSResourceAllocation)table.get(systemEnvironment, l, l2);
    }

    public static SDMSResourceAllocation idx_smeId_rId_stickyName_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSResourceAllocation)idx_smeId_rId_stickyName.getUnique(systemEnvironment, object);
    }

    public static SDMSResourceAllocation idx_smeId_rId_stickyName_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSResourceAllocation)idx_smeId_rId_stickyName.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSResourceAllocation idx_smeId_rId_stickyName_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSResourceAllocation)idx_smeId_rId_stickyName.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

