/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSFootprintTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSRepository;
import de.independit.scheduler.server.repository.SDMSResourceRequirement;
import de.independit.scheduler.server.repository.SDMSResourceRequirementGeneric;
import de.independit.scheduler.server.repository.SDMSResourceRequirementTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSTable;
import java.util.HashMap;
import java.util.Vector;

public class SDMSResourceRequirementProxyGeneric
extends SDMSProxy {
    public static final int N = 255;
    public static final int X = 0;
    public static final int SX = 2;
    public static final int S = 4;
    public static final int SC = 6;
    public static final int NOKEEP = 0;
    public static final int KEEP = 1;
    public static final int KEEP_FINAL = 2;
    public static final int MINUTE = 0;
    public static final int HOUR = 1;
    public static final int DAY = 2;
    public static final int WEEK = 3;
    public static final int MONTH = 4;
    public static final int YEAR = 5;
    public static final long privilegeMask = 0x10000111L;
    public static final int stickyName_size = 64;
    public static final int condition_size = 1024;
    private static SDMSTable[] masterTables = null;

    protected SDMSResourceRequirementProxyGeneric(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    protected static SDMSResourceRequirement getProxy(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) {
        int n = SDMSResourceRequirementTable.table.tableIndex;
        SDMSProxy sDMSProxy = SDMSRepository.getProxy(n);
        if (sDMSProxy == null) {
            sDMSProxy = new SDMSResourceRequirement(sDMSObject);
        } else {
            sDMSProxy.initProxy(sDMSObject);
        }
        systemEnvironment.tx.addUsedProxy(n, sDMSProxy);
        return (SDMSResourceRequirement)sDMSProxy;
    }

    public Long getNrId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceRequirementGeneric)this.object).getNrId(systemEnvironment);
    }

    public void setNrId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSResourceRequirementGeneric)this.object).setNrId(systemEnvironment, l);
    }

    public Long getSeId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceRequirementGeneric)this.object).getSeId(systemEnvironment);
    }

    public void setSeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSResourceRequirementGeneric)this.object).setSeId(systemEnvironment, l);
    }

    public Integer getAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceRequirementGeneric)this.object).getAmount(systemEnvironment);
    }

    public void setAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSResourceRequirementGeneric)this.object).setAmount(systemEnvironment, n);
    }

    public Integer getKeepMode(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceRequirementGeneric)this.object).getKeepMode(systemEnvironment);
    }

    public String getKeepModeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceRequirementGeneric)this.object).getKeepModeAsString(systemEnvironment);
    }

    public void setKeepMode(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSResourceRequirementGeneric)this.object).setKeepMode(systemEnvironment, n);
    }

    public Boolean getIsSticky(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceRequirementGeneric)this.object).getIsSticky(systemEnvironment);
    }

    public void setIsSticky(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSResourceRequirementGeneric)this.object).setIsSticky(systemEnvironment, bl);
    }

    public String getStickyName(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceRequirementGeneric)this.object).getStickyName(systemEnvironment);
    }

    public void setStickyName(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSResourceRequirementGeneric)this.object).setStickyName(systemEnvironment, string);
    }

    public static int getStickyNameMaxLength() {
        return 64;
    }

    public Long getStickyParent(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceRequirementGeneric)this.object).getStickyParent(systemEnvironment);
    }

    public void setStickyParent(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSResourceRequirementGeneric)this.object).setStickyParent(systemEnvironment, l);
    }

    public Long getRsmpId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceRequirementGeneric)this.object).getRsmpId(systemEnvironment);
    }

    public void setRsmpId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSResourceRequirementGeneric)this.object).setRsmpId(systemEnvironment, l);
    }

    public Integer getExpiredAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceRequirementGeneric)this.object).getExpiredAmount(systemEnvironment);
    }

    public void setExpiredAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSResourceRequirementGeneric)this.object).setExpiredAmount(systemEnvironment, n);
    }

    public Integer getExpiredBase(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceRequirementGeneric)this.object).getExpiredBase(systemEnvironment);
    }

    public String getExpiredBaseAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceRequirementGeneric)this.object).getExpiredBaseAsString(systemEnvironment);
    }

    public void setExpiredBase(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSResourceRequirementGeneric)this.object).setExpiredBase(systemEnvironment, n);
    }

    public Boolean getIgnoreOnRerun(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceRequirementGeneric)this.object).getIgnoreOnRerun(systemEnvironment);
    }

    public void setIgnoreOnRerun(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSResourceRequirementGeneric)this.object).setIgnoreOnRerun(systemEnvironment, bl);
    }

    public Integer getLockmode(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceRequirementGeneric)this.object).getLockmode(systemEnvironment);
    }

    public String getLockmodeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceRequirementGeneric)this.object).getLockmodeAsString(systemEnvironment);
    }

    public void setLockmode(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSResourceRequirementGeneric)this.object).setLockmode(systemEnvironment, n);
    }

    public String getCondition(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceRequirementGeneric)this.object).getCondition(systemEnvironment);
    }

    public void setCondition(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSResourceRequirementGeneric)this.object).setCondition(systemEnvironment, string);
    }

    public static int getConditionMaxLength() {
        return 1024;
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceRequirementGeneric)this.object).getCreatorUId(systemEnvironment);
    }

    private void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSResourceRequirementGeneric)this.object).setCreatorUId(systemEnvironment, l);
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceRequirementGeneric)this.object).getCreateTs(systemEnvironment);
    }

    private void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSResourceRequirementGeneric)this.object).setCreateTs(systemEnvironment, l);
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceRequirementGeneric)this.object).getChangerUId(systemEnvironment);
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSResourceRequirementGeneric)this.object).setChangerUId(systemEnvironment, l);
    }

    protected SDMSResourceRequirement setChangerUIdNoCheck(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        this.touchMaster(systemEnvironment);
        ((SDMSResourceRequirementGeneric)this.object).setChangerUId(systemEnvironment, l);
        return (SDMSResourceRequirement)this;
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceRequirementGeneric)this.object).getChangeTs(systemEnvironment);
    }

    private void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSResourceRequirementGeneric)this.object).setChangeTs(systemEnvironment, l);
    }

    protected SDMSResourceRequirement setChangeTsNoCheck(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        this.touchMaster(systemEnvironment);
        ((SDMSResourceRequirementGeneric)this.object).setChangeTs(systemEnvironment, l);
        return (SDMSResourceRequirement)this;
    }

    public SDMSResourceRequirement set_SeIdNrId(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        this.checkRead(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181242"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSResourceRequirementGeneric)this.object).set_SeIdNrId(systemEnvironment, l, l2);
        return (SDMSResourceRequirement)this;
    }

    @Override
    public SDMSKey getSortKey(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSKey sDMSKey = null;
        Long l = this.getId(systemEnvironment);
        if (systemEnvironment.tx.sortKeyMap == null) {
            systemEnvironment.tx.sortKeyMap = new HashMap();
        } else {
            sDMSKey = (SDMSKey)systemEnvironment.tx.sortKeyMap.get(l);
        }
        if (sDMSKey != null) {
            return sDMSKey;
        }
        boolean bl = false;
        sDMSKey = new SDMSKey();
        bl = false;
        Long l2 = this.getSeId(systemEnvironment);
        if (!bl) {
            try {
                sDMSKey.add(SDMSSchedulingEntityTable.getObject(systemEnvironment, l2).getSortKey(systemEnvironment));
                bl = true;
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        if (!bl) {
            try {
                sDMSKey.add(SDMSFootprintTable.getObject(systemEnvironment, l2).getSortKey(systemEnvironment));
                bl = true;
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        bl = false;
        Long l3 = this.getNrId(systemEnvironment);
        if (!bl) {
            try {
                sDMSKey.add(SDMSNamedResourceTable.getObject(systemEnvironment, l3).getSortKey(systemEnvironment));
                bl = true;
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        systemEnvironment.tx.sortKeyMap.put(l, sDMSKey);
        return sDMSKey;
    }

    @Override
    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        this.touchMaster(systemEnvironment);
        super.delete(systemEnvironment);
    }

    @Override
    public final boolean checkPrivileges(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        return (this.getPrivileges(systemEnvironment, l, true, null) & l) == l;
    }

    public final boolean checkPrivileges(SystemEnvironment systemEnvironment, long l, long l2) throws SDMSException {
        return (this.getPrivileges(systemEnvironment, l, true, null, l2) & l) == l;
    }

    @Override
    public long getPrivilegeMask() {
        return 0x10000111L;
    }

    @Override
    public final SDMSPrivilege getPrivileges(SystemEnvironment systemEnvironment) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 0x10000111L, false, null));
    }

    @Override
    public final SDMSPrivilege getPrivilegesForGroups(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 0x10000111L, false, vector));
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector) throws SDMSException {
        long l2;
        SDMSProxy sDMSProxy;
        if (vector == null) {
            Vector vector2 = new Vector();
        } else {
            Vector vector3 = vector;
        }
        long l3 = 0L;
        l3 = l;
        SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SCHEDULING_ENTITY");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getSeId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "FOOTPRINT");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getSeId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return l3;
    }

    public final SDMSPrivilege getPrivileges(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 0x10000111L, false, null, l));
    }

    public final SDMSPrivilege getPrivilegesForGroups(SystemEnvironment systemEnvironment, Vector vector, long l) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 0x10000111L, false, vector, l));
    }

    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector, long l2) throws SDMSException {
        long l3;
        SDMSProxy sDMSProxy;
        if (vector == null) {
            Vector vector2 = new Vector();
        } else {
            Vector vector3 = vector;
        }
        long l4 = 0L;
        l4 = l;
        SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SCHEDULING_ENTITY");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getSeId(systemEnvironment), l2);
            l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l4 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "FOOTPRINT");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getSeId(systemEnvironment), l2);
            l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l4 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return l4;
    }

    @Override
    public SDMSMessage accessViolationMessage(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        SDMSMessage sDMSMessage = new SDMSMessage(systemEnvironment, string, "Insufficient privileges accessing ResourceRequirement $1", this.getId(systemEnvironment));
        return sDMSMessage;
    }

    void touchMaster(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSProxy sDMSProxy;
        SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SCHEDULING_ENTITY");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getSeId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "FOOTPRINT");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getSeId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Override
    protected void touch(SystemEnvironment systemEnvironment) throws SDMSException {
        this.setChangerUIdNoCheck(systemEnvironment, systemEnvironment.cEnv.uid());
        this.setChangeTsNoCheck(systemEnvironment, systemEnvironment.txTime());
    }

    public void print() {
        ((SDMSResourceRequirementGeneric)this.object).print();
    }
}

