/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSResourceState;
import de.independit.scheduler.server.repository.SDMSResourceStateGeneric;
import de.independit.scheduler.server.repository.SDMSResourceStateTable;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSResourceStateTableGeneric
extends SDMSTable {
    public static final String tableName = "RESOURCE_STATE";
    public static SDMSResourceStateTable table = null;
    public static final String[] columnNames = new String[]{"ID", "RSD_ID", "RSP_ID", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_rsdId;
    public static SDMSIndex idx_rspId;
    public static SDMSIndex idx_rsdId_rspId;

    public SDMSResourceStateTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "ResourceState"));
        }
        table = (SDMSResourceStateTable)this;
        table = (SDMSResourceStateTable)this;
        this.isVersioned = false;
        idx_rsdId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "rsdId");
        idx_rspId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "rspId");
        idx_rsdId_rspId = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "rsdId_rspId");
    }

    public SDMSResourceState create(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        SDMSResourceState sDMSResourceState;
        Long l3 = systemEnvironment.cEnv.uid();
        Long l4 = systemEnvironment.txTime();
        Long l5 = systemEnvironment.cEnv.uid();
        Long l6 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "ResourceState"));
        }
        this.validate(systemEnvironment, l, l2, l3, l4, l5, l6);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSResourceStateGeneric sDMSResourceStateGeneric = new SDMSResourceStateGeneric(systemEnvironment, l, l2, l3, l4, l5, l6);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSResourceStateGeneric.versions, true);
            table.put(systemEnvironment, sDMSResourceStateGeneric.id, sDMSResourceStateGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSResourceState = (SDMSResourceState)sDMSResourceStateGeneric.toProxy(systemEnvironment);
            sDMSResourceState.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSResourceState sDMSResourceState2 = (SDMSResourceState)sDMSResourceStateGeneric.toProxy(systemEnvironment);
            sDMSResourceState2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSResourceState)) {
            throw new AccessViolationException(sDMSResourceState.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSResourceState.touchMaster(systemEnvironment);
        return sDMSResourceState;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSResourceState sDMSResourceState) throws SDMSException {
        return sDMSResourceState.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Long l4, Long l5, Long l6) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Long l7;
        Long l8;
        Long l9;
        try {
            l9 = resultSet.getLong(1);
            l8 = resultSet.getLong(2);
            l7 = resultSet.getLong(3);
            l6 = resultSet.getLong(4);
            l5 = resultSet.getLong(5);
            l4 = resultSet.getLong(6);
            l3 = resultSet.getLong(7);
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "ResourceState: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSResourceStateGeneric(l9, l8, l7, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "RSD_ID" + string2 + ", " + string + "RSP_ID" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2 + "");
        while (resultSet.next()) {
            try {
                if (this.loadObject(systemEnvironment, resultSet)) {
                    ++n2;
                }
                ++n;
            }
            catch (Exception exception) {
                SDMSThread.doTrace(null, "Exception caught while loading table " + this.tableName() + ", ID = " + Long.valueOf(resultSet.getLong(1)), -1);
                throw exception;
            }
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_rsdId.check(((SDMSResourceStateGeneric)sDMSObject).rsdId, sDMSObject);
        string = string + "idx_rsdId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_rspId.check(((SDMSResourceStateGeneric)sDMSObject).rspId, sDMSObject);
        string = string + "idx_rspId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSResourceStateGeneric)sDMSObject).rsdId);
        sDMSKey.add(((SDMSResourceStateGeneric)sDMSObject).rspId);
        bl = idx_rsdId_rspId.check(sDMSKey, sDMSObject);
        string = string + "idx_rsdId_rspId: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_rsdId.put(systemEnvironment, ((SDMSResourceStateGeneric)sDMSObject).rsdId, sDMSObject, (1L & l) != 0L);
        idx_rspId.put(systemEnvironment, ((SDMSResourceStateGeneric)sDMSObject).rspId, sDMSObject, (2L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSResourceStateGeneric)sDMSObject).rsdId);
        sDMSKey.add(((SDMSResourceStateGeneric)sDMSObject).rspId);
        idx_rsdId_rspId.put(systemEnvironment, sDMSKey, sDMSObject, (4L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_rsdId.remove(systemEnvironment, ((SDMSResourceStateGeneric)sDMSObject).rsdId, sDMSObject);
        idx_rspId.remove(systemEnvironment, ((SDMSResourceStateGeneric)sDMSObject).rspId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSResourceStateGeneric)sDMSObject).rsdId);
        sDMSKey.add(((SDMSResourceStateGeneric)sDMSObject).rspId);
        idx_rsdId_rspId.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSResourceState getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSResourceState)table.get(systemEnvironment, l);
    }

    public static SDMSResourceState getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSResourceState)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSResourceState getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSResourceState)table.get(systemEnvironment, l, l2);
    }

    public static SDMSResourceState idx_rsdId_rspId_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSResourceState)idx_rsdId_rspId.getUnique(systemEnvironment, object);
    }

    public static SDMSResourceState idx_rsdId_rspId_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSResourceState)idx_rsdId_rspId.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSResourceState idx_rsdId_rspId_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSResourceState)idx_rsdId_rspId.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

