/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSRunnableQueue;
import de.independit.scheduler.server.repository.SDMSRunnableQueueTableGeneric;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSRunnableQueueGeneric
extends SDMSObject
implements Cloneable {
    public static final int DEPENDENCY_WAIT = 1;
    public static final int SYNCHRONIZE_WAIT = 2;
    public static final int RESOURCE_WAIT = 3;
    public static final int RUNNABLE = 4;
    public static final int STARTING = 5;
    public static final int nr_id = 1;
    public static final int nr_smeId = 2;
    public static final int nr_scopeId = 3;
    public static final int nr_state = 4;
    public static final int nr_creatorUId = 5;
    public static final int nr_createTs = 6;
    public static final int nr_changerUId = 7;
    public static final int nr_changeTs = 8;
    public static String tableName = "RUNNABLE_QUEUE";
    protected Long smeId;
    protected Long scopeId;
    protected Integer state;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSRunnableQueueGeneric(SystemEnvironment systemEnvironment, Long l, Long l2, Integer n, Long l3, Long l4, Long l5, Long l6) throws SDMSException {
        super(systemEnvironment, SDMSRunnableQueueTableGeneric.table);
        this.smeId = l;
        this.scopeId = l2;
        this.state = n;
        this.creatorUId = l3;
        this.createTs = l4;
        this.changerUId = l5;
        this.changeTs = l6;
    }

    public Long getSmeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.smeId;
    }

    public void setSmeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.smeId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(RunnableQueue) Change of system object not allowed"));
            }
            SDMSRunnableQueueGeneric sDMSRunnableQueueGeneric = (SDMSRunnableQueueGeneric)this.change(systemEnvironment);
            sDMSRunnableQueueGeneric.smeId = l;
            sDMSRunnableQueueGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSRunnableQueueGeneric.changeTs = systemEnvironment.txTime();
            sDMSRunnableQueueGeneric.versions.table.index(systemEnvironment, sDMSRunnableQueueGeneric, 9L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getScopeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.scopeId;
    }

    public void setScopeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.scopeId)) {
            return;
        }
        if (l == null && this.scopeId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(RunnableQueue) Change of system object not allowed"));
            }
            SDMSRunnableQueueGeneric sDMSRunnableQueueGeneric = (SDMSRunnableQueueGeneric)this.change(systemEnvironment);
            sDMSRunnableQueueGeneric.scopeId = l;
            sDMSRunnableQueueGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSRunnableQueueGeneric.changeTs = systemEnvironment.txTime();
            sDMSRunnableQueueGeneric.versions.table.index(systemEnvironment, sDMSRunnableQueueGeneric, 26L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getState(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.state;
    }

    public String getStateAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getState(systemEnvironment);
        switch (n) {
            case 1: {
                return "DEPENDENCY_WAIT";
            }
            case 2: {
                return "SYNCHRONIZE_WAIT";
            }
            case 3: {
                return "RESOURCE_WAIT";
            }
            case 4: {
                return "RUNNABLE";
            }
            case 5: {
                return "STARTING";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown RunnableQueue.state: $1", this.getState(systemEnvironment)));
    }

    public void setState(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.state.equals(n)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(RunnableQueue) Change of system object not allowed"));
            }
            SDMSRunnableQueueGeneric sDMSRunnableQueueGeneric = (SDMSRunnableQueueGeneric)this.change(systemEnvironment);
            sDMSRunnableQueueGeneric.state = n;
            sDMSRunnableQueueGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSRunnableQueueGeneric.changeTs = systemEnvironment.txTime();
            sDMSRunnableQueueGeneric.versions.table.index(systemEnvironment, sDMSRunnableQueueGeneric, 20L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSRunnableQueueGeneric sDMSRunnableQueueGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(RunnableQueue) Change of system object not allowed"));
        }
        if (sDMSRunnableQueueGeneric.versions.o_v == null || sDMSRunnableQueueGeneric.versions.o_v.size() == 0 || sDMSRunnableQueueGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSRunnableQueueGeneric = (SDMSRunnableQueueGeneric)this.change(systemEnvironment);
        }
        sDMSRunnableQueueGeneric.creatorUId = l;
        sDMSRunnableQueueGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSRunnableQueueGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSRunnableQueueGeneric != this) {
            sDMSRunnableQueueGeneric.versions.table.index(systemEnvironment, sDMSRunnableQueueGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSRunnableQueueGeneric sDMSRunnableQueueGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(RunnableQueue) Change of system object not allowed"));
        }
        if (sDMSRunnableQueueGeneric.versions.o_v == null || sDMSRunnableQueueGeneric.versions.o_v.size() == 0 || sDMSRunnableQueueGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSRunnableQueueGeneric = (SDMSRunnableQueueGeneric)this.change(systemEnvironment);
        }
        sDMSRunnableQueueGeneric.createTs = l;
        sDMSRunnableQueueGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSRunnableQueueGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSRunnableQueueGeneric != this) {
            sDMSRunnableQueueGeneric.versions.table.index(systemEnvironment, sDMSRunnableQueueGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSRunnableQueueGeneric sDMSRunnableQueueGeneric = this;
        if (sDMSRunnableQueueGeneric.versions.o_v == null || sDMSRunnableQueueGeneric.versions.o_v.size() == 0 || sDMSRunnableQueueGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSRunnableQueueGeneric = (SDMSRunnableQueueGeneric)this.change(systemEnvironment);
        }
        sDMSRunnableQueueGeneric.changerUId = l;
        sDMSRunnableQueueGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSRunnableQueueGeneric != this) {
            sDMSRunnableQueueGeneric.versions.table.index(systemEnvironment, sDMSRunnableQueueGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSRunnableQueueGeneric sDMSRunnableQueueGeneric = this;
        if (sDMSRunnableQueueGeneric.versions.o_v == null || sDMSRunnableQueueGeneric.versions.o_v.size() == 0 || sDMSRunnableQueueGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSRunnableQueueGeneric = (SDMSRunnableQueueGeneric)this.change(systemEnvironment);
        }
        sDMSRunnableQueueGeneric.changeTs = l;
        sDMSRunnableQueueGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSRunnableQueueGeneric != this) {
            sDMSRunnableQueueGeneric.versions.table.index(systemEnvironment, sDMSRunnableQueueGeneric, 0L);
        }
    }

    public SDMSRunnableQueueGeneric set_SmeIdScopeId(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        SDMSRunnableQueueGeneric sDMSRunnableQueueGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(RunnableQueue) Change of system object not allowed"));
            }
            sDMSRunnableQueueGeneric = (SDMSRunnableQueueGeneric)this.change(systemEnvironment);
            sDMSRunnableQueueGeneric.smeId = l;
            sDMSRunnableQueueGeneric.scopeId = l2;
            sDMSRunnableQueueGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSRunnableQueueGeneric.changeTs = systemEnvironment.txTime();
            sDMSRunnableQueueGeneric.versions.table.index(systemEnvironment, sDMSRunnableQueueGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSRunnableQueueGeneric;
    }

    public SDMSRunnableQueueGeneric set_ScopeIdState(SystemEnvironment systemEnvironment, Long l, Integer n) throws SDMSException {
        SDMSRunnableQueueGeneric sDMSRunnableQueueGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(RunnableQueue) Change of system object not allowed"));
            }
            sDMSRunnableQueueGeneric = (SDMSRunnableQueueGeneric)this.change(systemEnvironment);
            sDMSRunnableQueueGeneric.scopeId = l;
            sDMSRunnableQueueGeneric.state = n;
            sDMSRunnableQueueGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSRunnableQueueGeneric.changeTs = systemEnvironment.txTime();
            sDMSRunnableQueueGeneric.versions.table.index(systemEnvironment, sDMSRunnableQueueGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSRunnableQueueGeneric;
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSRunnableQueue(this);
    }

    protected SDMSRunnableQueueGeneric(Long l, Long l2, Long l3, Integer n, Long l4, Long l5, Long l6, Long l7, long l8, long l9) {
        this.id = l;
        this.smeId = l2;
        this.scopeId = l3;
        this.state = n;
        this.creatorUId = l4;
        this.createTs = l5;
        this.changerUId = l6;
        this.changeTs = l7;
        this.validFrom = l8;
        this.validTo = l9;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "RUNNABLE_QUEUE" + string3 + " (ID, " + string2 + "SME_ID" + string3 + ", " + string2 + "SCOPE_ID" + string3 + ", " + string2 + "STATE" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
                SDMSRunnableQueueGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "RunnableQueue: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setLong(2, this.smeId);
            if (this.scopeId == null) {
                preparedStatement.setNull(3, 4);
            } else {
                preparedStatement.setLong(3, this.scopeId);
            }
            preparedStatement.setInt(4, this.state);
            preparedStatement.setLong(5, this.creatorUId);
            preparedStatement.setLong(6, this.createTs);
            preparedStatement.setLong(7, this.changerUId);
            preparedStatement.setLong(8, this.changeTs);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "RunnableQueue: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pDelete[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "DELETE FROM " + string2 + "RUNNABLE_QUEUE" + string3 + " WHERE ID = ?";
                SDMSRunnableQueueGeneric.pDelete[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182001", "RunnableQueue: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pDelete[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182002", "RunnableQueue: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string2 + "RUNNABLE_QUEUE" + string3 + " SET " + string2 + "SME_ID" + string3 + " = ? , " + string2 + "SCOPE_ID" + string3 + " = ? , " + string2 + "STATE" + string3 + " = ? , " + string2 + "CREATOR_U_ID" + string3 + " = ? , " + string2 + "CREATE_TS" + string3 + " = ? , " + string2 + "CHANGER_U_ID" + string3 + " = ? , " + string2 + "CHANGE_TS" + string3 + " = ? WHERE ID = ?";
                SDMSRunnableQueueGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182005", "RunnableQueue: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.smeId);
            if (this.scopeId == null) {
                preparedStatement.setNull(2, 4);
            } else {
                preparedStatement.setLong(2, this.scopeId);
            }
            preparedStatement.setInt(3, this.state);
            preparedStatement.setLong(4, this.creatorUId);
            preparedStatement.setLong(5, this.createTs);
            preparedStatement.setLong(6, this.changerUId);
            preparedStatement.setLong(7, this.changeTs);
            preparedStatement.setLong(8, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182006", "RunnableQueue: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    public static boolean checkState(Integer n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : RunnableQueue", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "smeId : " + this.smeId, 2);
        SDMSThread.doTrace(null, "scopeId : " + this.scopeId, 2);
        SDMSThread.doTrace(null, "state : " + this.state, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "smeId      : " + this.smeId + "\n" + string + "scopeId    : " + this.scopeId + "\n" + string + "state      : " + this.state + "\n" + string + "creatorUId : " + this.creatorUId + "\n" + string + "createTs   : " + this.createTs + "\n" + string + "changerUId : " + this.changerUId + "\n" + string + "changeTs   : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

