/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSRunnableQueue;
import de.independit.scheduler.server.repository.SDMSRunnableQueueGeneric;
import de.independit.scheduler.server.repository.SDMSRunnableQueueTable;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSRunnableQueueTableGeneric
extends SDMSTable {
    public static final String tableName = "RUNNABLE_QUEUE";
    public static SDMSRunnableQueueTable table = null;
    public static final String[] columnNames = new String[]{"ID", "SME_ID", "SCOPE_ID", "STATE", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_smeId;
    public static SDMSIndex idx_scopeId;
    public static SDMSIndex idx_state;
    public static SDMSIndex idx_smeId_scopeId;
    public static SDMSIndex idx_scopeId_state;

    public SDMSRunnableQueueTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "RunnableQueue"));
        }
        table = (SDMSRunnableQueueTable)this;
        table = (SDMSRunnableQueueTable)this;
        this.isVersioned = false;
        idx_smeId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "smeId");
        idx_scopeId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "scopeId");
        idx_state = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "state");
        idx_smeId_scopeId = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "smeId_scopeId");
        idx_scopeId_state = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "scopeId_state");
    }

    public SDMSRunnableQueue create(SystemEnvironment systemEnvironment, Long l, Long l2, Integer n) throws SDMSException {
        SDMSRunnableQueue sDMSRunnableQueue;
        Long l3 = systemEnvironment.cEnv.uid();
        Long l4 = systemEnvironment.txTime();
        Long l5 = systemEnvironment.cEnv.uid();
        Long l6 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "RunnableQueue"));
        }
        this.validate(systemEnvironment, l, l2, n, l3, l4, l5, l6);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSRunnableQueueGeneric sDMSRunnableQueueGeneric = new SDMSRunnableQueueGeneric(systemEnvironment, l, l2, n, l3, l4, l5, l6);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSRunnableQueueGeneric.versions, true);
            table.put(systemEnvironment, sDMSRunnableQueueGeneric.id, sDMSRunnableQueueGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSRunnableQueue = (SDMSRunnableQueue)sDMSRunnableQueueGeneric.toProxy(systemEnvironment);
            sDMSRunnableQueue.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSRunnableQueue sDMSRunnableQueue2 = (SDMSRunnableQueue)sDMSRunnableQueueGeneric.toProxy(systemEnvironment);
            sDMSRunnableQueue2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSRunnableQueue)) {
            throw new AccessViolationException(sDMSRunnableQueue.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        return sDMSRunnableQueue;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSRunnableQueue sDMSRunnableQueue) throws SDMSException {
        return true;
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Long l2, Integer n, Long l3, Long l4, Long l5, Long l6) throws SDMSException {
        if (!SDMSRunnableQueueGeneric.checkState(n)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "RunnableQueue: $1 $2", "state", n));
        }
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Integer n;
        Long l7;
        Long l8;
        Long l9;
        try {
            l9 = resultSet.getLong(1);
            l8 = resultSet.getLong(2);
            l7 = resultSet.getLong(3);
            if (resultSet.wasNull()) {
                l7 = null;
            }
            n = resultSet.getInt(4);
            l6 = resultSet.getLong(5);
            l5 = resultSet.getLong(6);
            l4 = resultSet.getLong(7);
            l3 = resultSet.getLong(8);
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "RunnableQueue: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSRunnableQueueGeneric(l9, l8, l7, n, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "SME_ID" + string2 + ", " + string + "SCOPE_ID" + string2 + ", " + string + "STATE" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2 + "");
        while (resultSet.next()) {
            try {
                if (this.loadObject(systemEnvironment, resultSet)) {
                    ++n2;
                }
                ++n;
            }
            catch (Exception exception) {
                SDMSThread.doTrace(null, "Exception caught while loading table " + this.tableName() + ", ID = " + Long.valueOf(resultSet.getLong(1)), -1);
                throw exception;
            }
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_smeId.check(((SDMSRunnableQueueGeneric)sDMSObject).smeId, sDMSObject);
        string = string + "idx_smeId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_scopeId.check(((SDMSRunnableQueueGeneric)sDMSObject).scopeId, sDMSObject);
        string = string + "idx_scopeId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_state.check(((SDMSRunnableQueueGeneric)sDMSObject).state, sDMSObject);
        string = string + "idx_state: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSRunnableQueueGeneric)sDMSObject).smeId);
        sDMSKey.add(((SDMSRunnableQueueGeneric)sDMSObject).scopeId);
        bl = idx_smeId_scopeId.check(sDMSKey, sDMSObject);
        string = string + "idx_smeId_scopeId: " + (bl ? "ok" : "missing") + "\n";
        sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSRunnableQueueGeneric)sDMSObject).scopeId);
        sDMSKey.add(((SDMSRunnableQueueGeneric)sDMSObject).state);
        bl = idx_scopeId_state.check(sDMSKey, sDMSObject);
        string = string + "idx_scopeId_state: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_smeId.put(systemEnvironment, ((SDMSRunnableQueueGeneric)sDMSObject).smeId, sDMSObject, (1L & l) != 0L);
        idx_scopeId.put(systemEnvironment, ((SDMSRunnableQueueGeneric)sDMSObject).scopeId, sDMSObject, (2L & l) != 0L);
        idx_state.put(systemEnvironment, ((SDMSRunnableQueueGeneric)sDMSObject).state, sDMSObject, (4L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSRunnableQueueGeneric)sDMSObject).smeId);
        sDMSKey.add(((SDMSRunnableQueueGeneric)sDMSObject).scopeId);
        idx_smeId_scopeId.put(systemEnvironment, sDMSKey, sDMSObject, (8L & l) != 0L);
        sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSRunnableQueueGeneric)sDMSObject).scopeId);
        sDMSKey.add(((SDMSRunnableQueueGeneric)sDMSObject).state);
        idx_scopeId_state.put(systemEnvironment, sDMSKey, sDMSObject, (0x10L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_smeId.remove(systemEnvironment, ((SDMSRunnableQueueGeneric)sDMSObject).smeId, sDMSObject);
        idx_scopeId.remove(systemEnvironment, ((SDMSRunnableQueueGeneric)sDMSObject).scopeId, sDMSObject);
        idx_state.remove(systemEnvironment, ((SDMSRunnableQueueGeneric)sDMSObject).state, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSRunnableQueueGeneric)sDMSObject).smeId);
        sDMSKey.add(((SDMSRunnableQueueGeneric)sDMSObject).scopeId);
        idx_smeId_scopeId.remove(systemEnvironment, sDMSKey, sDMSObject);
        sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSRunnableQueueGeneric)sDMSObject).scopeId);
        sDMSKey.add(((SDMSRunnableQueueGeneric)sDMSObject).state);
        idx_scopeId_state.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSRunnableQueue getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSRunnableQueue)table.get(systemEnvironment, l);
    }

    public static SDMSRunnableQueue getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSRunnableQueue)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSRunnableQueue getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSRunnableQueue)table.get(systemEnvironment, l, l2);
    }

    public static SDMSRunnableQueue idx_smeId_scopeId_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSRunnableQueue)idx_smeId_scopeId.getUnique(systemEnvironment, object);
    }

    public static SDMSRunnableQueue idx_smeId_scopeId_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSRunnableQueue)idx_smeId_scopeId.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSRunnableQueue idx_smeId_scopeId_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSRunnableQueue)idx_smeId_scopeId.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

