/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSScheduledEvent;
import de.independit.scheduler.server.repository.SDMSScheduledEventTableGeneric;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSScheduledEventGeneric
extends SDMSObject
implements Cloneable {
    public static final boolean ACTIVE = true;
    public static final boolean INACTIVE = false;
    public static final boolean BROKEN = true;
    public static final boolean NOBROKEN = false;
    public static final int NONE = 0;
    public static final int LAST = 1;
    public static final int ALL = 2;
    public static final int MINUTE = 0;
    public static final int HOUR = 1;
    public static final int DAY = 2;
    public static final int WEEK = 3;
    public static final int MONTH = 4;
    public static final int YEAR = 5;
    public static final int nr_id = 1;
    public static final int nr_ownerId = 2;
    public static final int nr_sceId = 3;
    public static final int nr_evtId = 4;
    public static final int nr_isActive = 5;
    public static final int nr_isBroken = 6;
    public static final int nr_errorCode = 7;
    public static final int nr_errorMsg = 8;
    public static final int nr_lastStartTime = 9;
    public static final int nr_nextActivityTime = 10;
    public static final int nr_nextActivityIsTrigger = 11;
    public static final int nr_backlogHandling = 12;
    public static final int nr_suspendLimit = 13;
    public static final int nr_suspendLimitMultiplier = 14;
    public static final int nr_isCalendar = 15;
    public static final int nr_calendarHorizon = 16;
    public static final int nr_creatorUId = 17;
    public static final int nr_createTs = 18;
    public static final int nr_changerUId = 19;
    public static final int nr_changeTs = 20;
    public static String tableName = "SCHEDULED_EVENT";
    protected Long ownerId;
    protected Long sceId;
    protected Long evtId;
    protected Boolean isActive;
    protected Boolean isBroken;
    protected String errorCode;
    protected String errorMsg;
    protected Long lastStartTime;
    protected Long nextActivityTime;
    protected Boolean nextActivityIsTrigger;
    protected Integer backlogHandling;
    protected Integer suspendLimit;
    protected Integer suspendLimitMultiplier;
    protected Boolean isCalendar;
    protected Integer calendarHorizon;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSScheduledEventGeneric(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Boolean bl, Boolean bl2, String string, String string2, Long l4, Long l5, Boolean bl3, Integer n, Integer n2, Integer n3, Boolean bl4, Integer n4, Long l6, Long l7, Long l8, Long l9) throws SDMSException {
        super(systemEnvironment, SDMSScheduledEventTableGeneric.table);
        this.ownerId = l;
        this.sceId = l2;
        this.evtId = l3;
        this.isActive = bl;
        this.isBroken = bl2;
        if (string != null && string.length() > 32) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(ScheduledEvent) Length of $1 exceeds maximum length $2", "errorCode", "32"));
        }
        this.errorCode = string;
        if (string2 != null && string2.length() > 256) {
            string2 = string2.substring(0, 256);
        }
        this.errorMsg = string2;
        this.lastStartTime = l4;
        this.nextActivityTime = l5;
        this.nextActivityIsTrigger = bl3;
        this.backlogHandling = n;
        this.suspendLimit = n2;
        this.suspendLimitMultiplier = n3;
        this.isCalendar = bl4;
        this.calendarHorizon = n4;
        this.creatorUId = l6;
        this.createTs = l7;
        this.changerUId = l8;
        this.changeTs = l9;
    }

    public Long getOwnerId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.ownerId;
    }

    public void setOwnerId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.ownerId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ScheduledEvent) Change of system object not allowed"));
            }
            SDMSScheduledEventGeneric sDMSScheduledEventGeneric = (SDMSScheduledEventGeneric)this.change(systemEnvironment);
            sDMSScheduledEventGeneric.ownerId = l;
            sDMSScheduledEventGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSScheduledEventGeneric.changeTs = systemEnvironment.txTime();
            sDMSScheduledEventGeneric.versions.table.index(systemEnvironment, sDMSScheduledEventGeneric, 1L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getSceId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.sceId;
    }

    public void setSceId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.sceId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ScheduledEvent) Change of system object not allowed"));
            }
            SDMSScheduledEventGeneric sDMSScheduledEventGeneric = (SDMSScheduledEventGeneric)this.change(systemEnvironment);
            sDMSScheduledEventGeneric.sceId = l;
            sDMSScheduledEventGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSScheduledEventGeneric.changeTs = systemEnvironment.txTime();
            sDMSScheduledEventGeneric.versions.table.index(systemEnvironment, sDMSScheduledEventGeneric, 10L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getEvtId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.evtId;
    }

    public void setEvtId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.evtId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ScheduledEvent) Change of system object not allowed"));
            }
            SDMSScheduledEventGeneric sDMSScheduledEventGeneric = (SDMSScheduledEventGeneric)this.change(systemEnvironment);
            sDMSScheduledEventGeneric.evtId = l;
            sDMSScheduledEventGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSScheduledEventGeneric.changeTs = systemEnvironment.txTime();
            sDMSScheduledEventGeneric.versions.table.index(systemEnvironment, sDMSScheduledEventGeneric, 12L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Boolean getIsActive(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isActive;
    }

    public String getIsActiveAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Boolean bl = this.getIsActive(systemEnvironment);
        boolean bl2 = bl;
        if (bl2) {
            return "ACTIVE";
        }
        if (!bl2) {
            return "INACTIVE";
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown ScheduledEvent.isActive: $1", this.getIsActive(systemEnvironment)));
    }

    public void setIsActive(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.isActive.equals(bl)) {
            return;
        }
        SDMSScheduledEventGeneric sDMSScheduledEventGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ScheduledEvent) Change of system object not allowed"));
        }
        if (sDMSScheduledEventGeneric.versions.o_v == null || sDMSScheduledEventGeneric.versions.o_v.size() == 0 || sDMSScheduledEventGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScheduledEventGeneric = (SDMSScheduledEventGeneric)this.change(systemEnvironment);
        }
        sDMSScheduledEventGeneric.isActive = bl;
        sDMSScheduledEventGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSScheduledEventGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScheduledEventGeneric != this) {
            sDMSScheduledEventGeneric.versions.table.index(systemEnvironment, sDMSScheduledEventGeneric, 0L);
        }
    }

    public Boolean getIsBroken(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isBroken;
    }

    public String getIsBrokenAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Boolean bl = this.getIsBroken(systemEnvironment);
        boolean bl2 = bl;
        if (bl2) {
            return "BROKEN";
        }
        if (!bl2) {
            return "NOBROKEN";
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown ScheduledEvent.isBroken: $1", this.getIsBroken(systemEnvironment)));
    }

    public void setIsBroken(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.isBroken.equals(bl)) {
            return;
        }
        SDMSScheduledEventGeneric sDMSScheduledEventGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ScheduledEvent) Change of system object not allowed"));
        }
        if (sDMSScheduledEventGeneric.versions.o_v == null || sDMSScheduledEventGeneric.versions.o_v.size() == 0 || sDMSScheduledEventGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScheduledEventGeneric = (SDMSScheduledEventGeneric)this.change(systemEnvironment);
        }
        sDMSScheduledEventGeneric.isBroken = bl;
        sDMSScheduledEventGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSScheduledEventGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScheduledEventGeneric != this) {
            sDMSScheduledEventGeneric.versions.table.index(systemEnvironment, sDMSScheduledEventGeneric, 0L);
        }
    }

    public String getErrorCode(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.errorCode;
    }

    public void setErrorCode(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.errorCode)) {
            return;
        }
        if (string == null && this.errorCode == null) {
            return;
        }
        SDMSScheduledEventGeneric sDMSScheduledEventGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ScheduledEvent) Change of system object not allowed"));
        }
        if (sDMSScheduledEventGeneric.versions.o_v == null || sDMSScheduledEventGeneric.versions.o_v.size() == 0 || sDMSScheduledEventGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScheduledEventGeneric = (SDMSScheduledEventGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 32) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(ScheduledEvent) Length of $1 exceeds maximum length $2", "errorCode", "32"));
        }
        sDMSScheduledEventGeneric.errorCode = string;
        sDMSScheduledEventGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSScheduledEventGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScheduledEventGeneric != this) {
            sDMSScheduledEventGeneric.versions.table.index(systemEnvironment, sDMSScheduledEventGeneric, 0L);
        }
    }

    public String getErrorMsg(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.errorMsg;
    }

    public void setErrorMsg(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.errorMsg)) {
            return;
        }
        if (string == null && this.errorMsg == null) {
            return;
        }
        SDMSScheduledEventGeneric sDMSScheduledEventGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ScheduledEvent) Change of system object not allowed"));
        }
        if (sDMSScheduledEventGeneric.versions.o_v == null || sDMSScheduledEventGeneric.versions.o_v.size() == 0 || sDMSScheduledEventGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScheduledEventGeneric = (SDMSScheduledEventGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 256) {
            string = string.substring(0, 256);
        }
        sDMSScheduledEventGeneric.errorMsg = string;
        sDMSScheduledEventGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSScheduledEventGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScheduledEventGeneric != this) {
            sDMSScheduledEventGeneric.versions.table.index(systemEnvironment, sDMSScheduledEventGeneric, 0L);
        }
    }

    public Long getLastStartTime(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.lastStartTime;
    }

    public void setLastStartTime(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.lastStartTime)) {
            return;
        }
        if (l == null && this.lastStartTime == null) {
            return;
        }
        SDMSScheduledEventGeneric sDMSScheduledEventGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ScheduledEvent) Change of system object not allowed"));
        }
        if (sDMSScheduledEventGeneric.versions.o_v == null || sDMSScheduledEventGeneric.versions.o_v.size() == 0 || sDMSScheduledEventGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScheduledEventGeneric = (SDMSScheduledEventGeneric)this.change(systemEnvironment);
        }
        sDMSScheduledEventGeneric.lastStartTime = l;
        sDMSScheduledEventGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSScheduledEventGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScheduledEventGeneric != this) {
            sDMSScheduledEventGeneric.versions.table.index(systemEnvironment, sDMSScheduledEventGeneric, 0L);
        }
    }

    public Long getNextActivityTime(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.nextActivityTime;
    }

    public void setNextActivityTime(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.nextActivityTime)) {
            return;
        }
        if (l == null && this.nextActivityTime == null) {
            return;
        }
        SDMSScheduledEventGeneric sDMSScheduledEventGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ScheduledEvent) Change of system object not allowed"));
        }
        if (sDMSScheduledEventGeneric.versions.o_v == null || sDMSScheduledEventGeneric.versions.o_v.size() == 0 || sDMSScheduledEventGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScheduledEventGeneric = (SDMSScheduledEventGeneric)this.change(systemEnvironment);
        }
        sDMSScheduledEventGeneric.nextActivityTime = l;
        sDMSScheduledEventGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSScheduledEventGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScheduledEventGeneric != this) {
            sDMSScheduledEventGeneric.versions.table.index(systemEnvironment, sDMSScheduledEventGeneric, 0L);
        }
    }

    public Boolean getNextActivityIsTrigger(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.nextActivityIsTrigger;
    }

    public void setNextActivityIsTrigger(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (bl != null && bl.equals(this.nextActivityIsTrigger)) {
            return;
        }
        if (bl == null && this.nextActivityIsTrigger == null) {
            return;
        }
        SDMSScheduledEventGeneric sDMSScheduledEventGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ScheduledEvent) Change of system object not allowed"));
        }
        if (sDMSScheduledEventGeneric.versions.o_v == null || sDMSScheduledEventGeneric.versions.o_v.size() == 0 || sDMSScheduledEventGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScheduledEventGeneric = (SDMSScheduledEventGeneric)this.change(systemEnvironment);
        }
        sDMSScheduledEventGeneric.nextActivityIsTrigger = bl;
        sDMSScheduledEventGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSScheduledEventGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScheduledEventGeneric != this) {
            sDMSScheduledEventGeneric.versions.table.index(systemEnvironment, sDMSScheduledEventGeneric, 0L);
        }
    }

    public Integer getBacklogHandling(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.backlogHandling;
    }

    public String getBacklogHandlingAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getBacklogHandling(systemEnvironment);
        switch (n) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "LAST";
            }
            case 2: {
                return "ALL";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown ScheduledEvent.backlogHandling: $1", this.getBacklogHandling(systemEnvironment)));
    }

    public void setBacklogHandling(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.backlogHandling.equals(n)) {
            return;
        }
        SDMSScheduledEventGeneric sDMSScheduledEventGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ScheduledEvent) Change of system object not allowed"));
        }
        if (sDMSScheduledEventGeneric.versions.o_v == null || sDMSScheduledEventGeneric.versions.o_v.size() == 0 || sDMSScheduledEventGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScheduledEventGeneric = (SDMSScheduledEventGeneric)this.change(systemEnvironment);
        }
        sDMSScheduledEventGeneric.backlogHandling = n;
        sDMSScheduledEventGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSScheduledEventGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScheduledEventGeneric != this) {
            sDMSScheduledEventGeneric.versions.table.index(systemEnvironment, sDMSScheduledEventGeneric, 0L);
        }
    }

    public Integer getSuspendLimit(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.suspendLimit;
    }

    public String getSuspendLimitAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getSuspendLimit(systemEnvironment);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "MINUTE";
            }
            case 1: {
                return "HOUR";
            }
            case 2: {
                return "DAY";
            }
            case 3: {
                return "WEEK";
            }
            case 4: {
                return "MONTH";
            }
            case 5: {
                return "YEAR";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown ScheduledEvent.suspendLimit: $1", this.getSuspendLimit(systemEnvironment)));
    }

    public void setSuspendLimit(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.suspendLimit)) {
            return;
        }
        if (n == null && this.suspendLimit == null) {
            return;
        }
        SDMSScheduledEventGeneric sDMSScheduledEventGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ScheduledEvent) Change of system object not allowed"));
        }
        if (sDMSScheduledEventGeneric.versions.o_v == null || sDMSScheduledEventGeneric.versions.o_v.size() == 0 || sDMSScheduledEventGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScheduledEventGeneric = (SDMSScheduledEventGeneric)this.change(systemEnvironment);
        }
        sDMSScheduledEventGeneric.suspendLimit = n;
        sDMSScheduledEventGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSScheduledEventGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScheduledEventGeneric != this) {
            sDMSScheduledEventGeneric.versions.table.index(systemEnvironment, sDMSScheduledEventGeneric, 0L);
        }
    }

    public Integer getSuspendLimitMultiplier(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.suspendLimitMultiplier;
    }

    public void setSuspendLimitMultiplier(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.suspendLimitMultiplier)) {
            return;
        }
        if (n == null && this.suspendLimitMultiplier == null) {
            return;
        }
        SDMSScheduledEventGeneric sDMSScheduledEventGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ScheduledEvent) Change of system object not allowed"));
        }
        if (sDMSScheduledEventGeneric.versions.o_v == null || sDMSScheduledEventGeneric.versions.o_v.size() == 0 || sDMSScheduledEventGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScheduledEventGeneric = (SDMSScheduledEventGeneric)this.change(systemEnvironment);
        }
        sDMSScheduledEventGeneric.suspendLimitMultiplier = n;
        sDMSScheduledEventGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSScheduledEventGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScheduledEventGeneric != this) {
            sDMSScheduledEventGeneric.versions.table.index(systemEnvironment, sDMSScheduledEventGeneric, 0L);
        }
    }

    public Boolean getIsCalendar(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isCalendar;
    }

    public String getIsCalendarAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Boolean bl = this.getIsCalendar(systemEnvironment);
        boolean bl2 = bl;
        if (bl2) {
            return "ACTIVE";
        }
        if (!bl2) {
            return "INACTIVE";
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown ScheduledEvent.isCalendar: $1", this.getIsCalendar(systemEnvironment)));
    }

    public void setIsCalendar(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.isCalendar.equals(bl)) {
            return;
        }
        SDMSScheduledEventGeneric sDMSScheduledEventGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ScheduledEvent) Change of system object not allowed"));
        }
        if (sDMSScheduledEventGeneric.versions.o_v == null || sDMSScheduledEventGeneric.versions.o_v.size() == 0 || sDMSScheduledEventGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScheduledEventGeneric = (SDMSScheduledEventGeneric)this.change(systemEnvironment);
        }
        sDMSScheduledEventGeneric.isCalendar = bl;
        sDMSScheduledEventGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSScheduledEventGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScheduledEventGeneric != this) {
            sDMSScheduledEventGeneric.versions.table.index(systemEnvironment, sDMSScheduledEventGeneric, 0L);
        }
    }

    public Integer getCalendarHorizon(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.calendarHorizon;
    }

    public void setCalendarHorizon(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.calendarHorizon)) {
            return;
        }
        if (n == null && this.calendarHorizon == null) {
            return;
        }
        SDMSScheduledEventGeneric sDMSScheduledEventGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ScheduledEvent) Change of system object not allowed"));
        }
        if (sDMSScheduledEventGeneric.versions.o_v == null || sDMSScheduledEventGeneric.versions.o_v.size() == 0 || sDMSScheduledEventGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScheduledEventGeneric = (SDMSScheduledEventGeneric)this.change(systemEnvironment);
        }
        sDMSScheduledEventGeneric.calendarHorizon = n;
        sDMSScheduledEventGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSScheduledEventGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScheduledEventGeneric != this) {
            sDMSScheduledEventGeneric.versions.table.index(systemEnvironment, sDMSScheduledEventGeneric, 0L);
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSScheduledEventGeneric sDMSScheduledEventGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ScheduledEvent) Change of system object not allowed"));
        }
        if (sDMSScheduledEventGeneric.versions.o_v == null || sDMSScheduledEventGeneric.versions.o_v.size() == 0 || sDMSScheduledEventGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScheduledEventGeneric = (SDMSScheduledEventGeneric)this.change(systemEnvironment);
        }
        sDMSScheduledEventGeneric.creatorUId = l;
        sDMSScheduledEventGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSScheduledEventGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScheduledEventGeneric != this) {
            sDMSScheduledEventGeneric.versions.table.index(systemEnvironment, sDMSScheduledEventGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSScheduledEventGeneric sDMSScheduledEventGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ScheduledEvent) Change of system object not allowed"));
        }
        if (sDMSScheduledEventGeneric.versions.o_v == null || sDMSScheduledEventGeneric.versions.o_v.size() == 0 || sDMSScheduledEventGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScheduledEventGeneric = (SDMSScheduledEventGeneric)this.change(systemEnvironment);
        }
        sDMSScheduledEventGeneric.createTs = l;
        sDMSScheduledEventGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSScheduledEventGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScheduledEventGeneric != this) {
            sDMSScheduledEventGeneric.versions.table.index(systemEnvironment, sDMSScheduledEventGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSScheduledEventGeneric sDMSScheduledEventGeneric = this;
        if (sDMSScheduledEventGeneric.versions.o_v == null || sDMSScheduledEventGeneric.versions.o_v.size() == 0 || sDMSScheduledEventGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScheduledEventGeneric = (SDMSScheduledEventGeneric)this.change(systemEnvironment);
        }
        sDMSScheduledEventGeneric.changerUId = l;
        sDMSScheduledEventGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScheduledEventGeneric != this) {
            sDMSScheduledEventGeneric.versions.table.index(systemEnvironment, sDMSScheduledEventGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSScheduledEventGeneric sDMSScheduledEventGeneric = this;
        if (sDMSScheduledEventGeneric.versions.o_v == null || sDMSScheduledEventGeneric.versions.o_v.size() == 0 || sDMSScheduledEventGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScheduledEventGeneric = (SDMSScheduledEventGeneric)this.change(systemEnvironment);
        }
        sDMSScheduledEventGeneric.changeTs = l;
        sDMSScheduledEventGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSScheduledEventGeneric != this) {
            sDMSScheduledEventGeneric.versions.table.index(systemEnvironment, sDMSScheduledEventGeneric, 0L);
        }
    }

    public SDMSScheduledEventGeneric set_SceIdEvtId(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        SDMSScheduledEventGeneric sDMSScheduledEventGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(ScheduledEvent) Change of system object not allowed"));
            }
            sDMSScheduledEventGeneric = (SDMSScheduledEventGeneric)this.change(systemEnvironment);
            sDMSScheduledEventGeneric.sceId = l;
            sDMSScheduledEventGeneric.evtId = l2;
            sDMSScheduledEventGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSScheduledEventGeneric.changeTs = systemEnvironment.txTime();
            sDMSScheduledEventGeneric.versions.table.index(systemEnvironment, sDMSScheduledEventGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSScheduledEventGeneric;
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSScheduledEvent(this);
    }

    protected SDMSScheduledEventGeneric(Long l, Long l2, Long l3, Long l4, Boolean bl, Boolean bl2, String string, String string2, Long l5, Long l6, Boolean bl3, Integer n, Integer n2, Integer n3, Boolean bl4, Integer n4, Long l7, Long l8, Long l9, Long l10, long l11, long l12) {
        this.id = l;
        this.ownerId = l2;
        this.sceId = l3;
        this.evtId = l4;
        this.isActive = bl;
        this.isBroken = bl2;
        this.errorCode = string;
        this.errorMsg = string2;
        this.lastStartTime = l5;
        this.nextActivityTime = l6;
        this.nextActivityIsTrigger = bl3;
        this.backlogHandling = n;
        this.suspendLimit = n2;
        this.suspendLimitMultiplier = n3;
        this.isCalendar = bl4;
        this.calendarHorizon = n4;
        this.creatorUId = l7;
        this.createTs = l8;
        this.changerUId = l9;
        this.changeTs = l10;
        this.validFrom = l11;
        this.validTo = l12;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "SCHEDULED_EVENT" + string3 + " (ID, " + string2 + "OWNER_ID" + string3 + ", " + string2 + "SCE_ID" + string3 + ", " + string2 + "EVT_ID" + string3 + ", " + string2 + "ACTIVE" + string3 + ", " + string2 + "BROKEN" + string3 + ", " + string2 + "ERROR_CODE" + string3 + ", " + string2 + "ERROR_MSG" + string3 + ", " + string2 + "LAST_START_TIME" + string3 + ", " + string2 + "NEXT_START_TIME" + string3 + ", " + string2 + "NEXT_IS_TRIGGER" + string3 + ", " + string2 + "BACKLOG_HANDLING" + string3 + ", " + string2 + "SUSPEND_LIMIT" + string3 + ", " + string2 + "SUSPEND_LIMIT_MULTIPLIER" + string3 + ", " + string2 + "IS_CALENDAR" + string3 + ", " + string2 + "CALENDAR_HORIZON" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                SDMSScheduledEventGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "ScheduledEvent: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setLong(2, this.ownerId);
            preparedStatement.setLong(3, this.sceId);
            preparedStatement.setLong(4, this.evtId);
            preparedStatement.setInt(5, this.isActive != false ? 1 : 0);
            preparedStatement.setInt(6, this.isBroken != false ? 1 : 0);
            if (this.errorCode == null) {
                preparedStatement.setNull(7, 12);
            } else {
                preparedStatement.setString(7, this.errorCode);
            }
            if (this.errorMsg == null) {
                preparedStatement.setNull(8, 12);
            } else {
                preparedStatement.setString(8, this.errorMsg);
            }
            if (this.lastStartTime == null) {
                preparedStatement.setNull(9, 4);
            } else {
                preparedStatement.setLong(9, this.lastStartTime);
            }
            if (this.nextActivityTime == null) {
                preparedStatement.setNull(10, 4);
            } else {
                preparedStatement.setLong(10, this.nextActivityTime);
            }
            if (this.nextActivityIsTrigger == null) {
                preparedStatement.setNull(11, 4);
            } else {
                preparedStatement.setInt(11, this.nextActivityIsTrigger != false ? 1 : 0);
            }
            preparedStatement.setInt(12, this.backlogHandling);
            if (this.suspendLimit == null) {
                preparedStatement.setNull(13, 4);
            } else {
                preparedStatement.setInt(13, this.suspendLimit);
            }
            if (this.suspendLimitMultiplier == null) {
                preparedStatement.setNull(14, 4);
            } else {
                preparedStatement.setInt(14, this.suspendLimitMultiplier);
            }
            preparedStatement.setInt(15, this.isCalendar != false ? 1 : 0);
            if (this.calendarHorizon == null) {
                preparedStatement.setNull(16, 4);
            } else {
                preparedStatement.setInt(16, this.calendarHorizon);
            }
            preparedStatement.setLong(17, this.creatorUId);
            preparedStatement.setLong(18, this.createTs);
            preparedStatement.setLong(19, this.changerUId);
            preparedStatement.setLong(20, this.changeTs);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "ScheduledEvent: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pDelete[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "DELETE FROM " + string2 + "SCHEDULED_EVENT" + string3 + " WHERE ID = ?";
                SDMSScheduledEventGeneric.pDelete[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182001", "ScheduledEvent: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pDelete[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182002", "ScheduledEvent: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string2 + "SCHEDULED_EVENT" + string3 + " SET " + string2 + "OWNER_ID" + string3 + " = ? , " + string2 + "SCE_ID" + string3 + " = ? , " + string2 + "EVT_ID" + string3 + " = ? , " + string2 + "ACTIVE" + string3 + " = ? , " + string2 + "BROKEN" + string3 + " = ? , " + string2 + "ERROR_CODE" + string3 + " = ? , " + string2 + "ERROR_MSG" + string3 + " = ? , " + string2 + "LAST_START_TIME" + string3 + " = ? , " + string2 + "NEXT_START_TIME" + string3 + " = ? , " + string2 + "NEXT_IS_TRIGGER" + string3 + " = ? , " + string2 + "BACKLOG_HANDLING" + string3 + " = ? , " + string2 + "SUSPEND_LIMIT" + string3 + " = ? , " + string2 + "SUSPEND_LIMIT_MULTIPLIER" + string3 + " = ? , " + string2 + "IS_CALENDAR" + string3 + " = ? , " + string2 + "CALENDAR_HORIZON" + string3 + " = ? , " + string2 + "CREATOR_U_ID" + string3 + " = ? , " + string2 + "CREATE_TS" + string3 + " = ? , " + string2 + "CHANGER_U_ID" + string3 + " = ? , " + string2 + "CHANGE_TS" + string3 + " = ? WHERE ID = ?";
                SDMSScheduledEventGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182005", "ScheduledEvent: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.ownerId);
            preparedStatement.setLong(2, this.sceId);
            preparedStatement.setLong(3, this.evtId);
            preparedStatement.setInt(4, this.isActive != false ? 1 : 0);
            preparedStatement.setInt(5, this.isBroken != false ? 1 : 0);
            if (this.errorCode == null) {
                preparedStatement.setNull(6, 12);
            } else {
                preparedStatement.setString(6, this.errorCode);
            }
            if (this.errorMsg == null) {
                preparedStatement.setNull(7, 12);
            } else {
                preparedStatement.setString(7, this.errorMsg);
            }
            if (this.lastStartTime == null) {
                preparedStatement.setNull(8, 4);
            } else {
                preparedStatement.setLong(8, this.lastStartTime);
            }
            if (this.nextActivityTime == null) {
                preparedStatement.setNull(9, 4);
            } else {
                preparedStatement.setLong(9, this.nextActivityTime);
            }
            if (this.nextActivityIsTrigger == null) {
                preparedStatement.setNull(10, 4);
            } else {
                preparedStatement.setInt(10, this.nextActivityIsTrigger != false ? 1 : 0);
            }
            preparedStatement.setInt(11, this.backlogHandling);
            if (this.suspendLimit == null) {
                preparedStatement.setNull(12, 4);
            } else {
                preparedStatement.setInt(12, this.suspendLimit);
            }
            if (this.suspendLimitMultiplier == null) {
                preparedStatement.setNull(13, 4);
            } else {
                preparedStatement.setInt(13, this.suspendLimitMultiplier);
            }
            preparedStatement.setInt(14, this.isCalendar != false ? 1 : 0);
            if (this.calendarHorizon == null) {
                preparedStatement.setNull(15, 4);
            } else {
                preparedStatement.setInt(15, this.calendarHorizon);
            }
            preparedStatement.setLong(16, this.creatorUId);
            preparedStatement.setLong(17, this.createTs);
            preparedStatement.setLong(18, this.changerUId);
            preparedStatement.setLong(19, this.changeTs);
            preparedStatement.setLong(20, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182006", "ScheduledEvent: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    public static boolean checkIsActive(Boolean bl) {
        if (bl.booleanValue()) {
            return true;
        }
        return bl == false;
    }

    public static boolean checkIsBroken(Boolean bl) {
        if (bl.booleanValue()) {
            return true;
        }
        return bl == false;
    }

    public static boolean checkBacklogHandling(Integer n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkSuspendLimit(Integer n) {
        if (n == null) {
            return true;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkIsCalendar(Boolean bl) {
        if (bl.booleanValue()) {
            return true;
        }
        return bl == false;
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : ScheduledEvent", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "ownerId : " + this.ownerId, 2);
        SDMSThread.doTrace(null, "sceId : " + this.sceId, 2);
        SDMSThread.doTrace(null, "evtId : " + this.evtId, 2);
        SDMSThread.doTrace(null, "isActive : " + this.isActive, 2);
        SDMSThread.doTrace(null, "isBroken : " + this.isBroken, 2);
        SDMSThread.doTrace(null, "errorCode : " + this.errorCode, 2);
        SDMSThread.doTrace(null, "errorMsg : " + this.errorMsg, 2);
        SDMSThread.doTrace(null, "lastStartTime : " + this.lastStartTime, 2);
        SDMSThread.doTrace(null, "nextActivityTime : " + this.nextActivityTime, 2);
        SDMSThread.doTrace(null, "nextActivityIsTrigger : " + this.nextActivityIsTrigger, 2);
        SDMSThread.doTrace(null, "backlogHandling : " + this.backlogHandling, 2);
        SDMSThread.doTrace(null, "suspendLimit : " + this.suspendLimit, 2);
        SDMSThread.doTrace(null, "suspendLimitMultiplier : " + this.suspendLimitMultiplier, 2);
        SDMSThread.doTrace(null, "isCalendar : " + this.isCalendar, 2);
        SDMSThread.doTrace(null, "calendarHorizon : " + this.calendarHorizon, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "ownerId                : " + this.ownerId + "\n" + string + "sceId                  : " + this.sceId + "\n" + string + "evtId                  : " + this.evtId + "\n" + string + "isActive               : " + this.isActive + "\n" + string + "isBroken               : " + this.isBroken + "\n" + string + "errorCode              : " + this.errorCode + "\n" + string + "errorMsg               : " + this.errorMsg + "\n" + string + "lastStartTime          : " + this.lastStartTime + "\n" + string + "nextActivityTime       : " + this.nextActivityTime + "\n" + string + "nextActivityIsTrigger  : " + this.nextActivityIsTrigger + "\n" + string + "backlogHandling        : " + this.backlogHandling + "\n" + string + "suspendLimit           : " + this.suspendLimit + "\n" + string + "suspendLimitMultiplier : " + this.suspendLimitMultiplier + "\n" + string + "isCalendar             : " + this.isCalendar + "\n" + string + "calendarHorizon        : " + this.calendarHorizon + "\n" + string + "creatorUId             : " + this.creatorUId + "\n" + string + "createTs               : " + this.createTs + "\n" + string + "changerUId             : " + this.changerUId + "\n" + string + "changeTs               : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

