/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTableGeneric;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSSubmittedEntityGeneric
extends SDMSObject
implements Cloneable {
    public static final int SUBMITTED = 0;
    public static final int DEPENDENCY_WAIT = 1;
    public static final int SYNCHRONIZE_WAIT = 2;
    public static final int RESOURCE_WAIT = 3;
    public static final int RUNNABLE = 4;
    public static final int STARTING = 5;
    public static final int STARTED = 6;
    public static final int RUNNING = 7;
    public static final int TO_KILL = 8;
    public static final int KILLED = 9;
    public static final int CANCELLED = 10;
    public static final int FINISHED = 11;
    public static final int FINAL = 12;
    public static final int BROKEN_ACTIVE = 13;
    public static final int BROKEN_FINISHED = 14;
    public static final int ERROR = 15;
    public static final int UNREACHABLE = 16;
    public static final int SUSPENDED = 99;
    public static final int SUSPEND = 1;
    public static final int NOSUSPEND = 0;
    public static final int ADMINSUSPEND = 2;
    public static final int UH_IGNORE = 1;
    public static final int UH_ERROR = 2;
    public static final int UH_SUSPEND = 3;
    public static final int MERGE_LOCAL = 1;
    public static final int MERGE_GLOBAL = 2;
    public static final int NOMERGE = 3;
    public static final int FAILURE = 4;
    public static final char PID_SEP = '@';
    public static final int MINUTE = 0;
    public static final int HOUR = 1;
    public static final int DAY = 2;
    public static final int WEEK = 3;
    public static final int MONTH = 4;
    public static final int YEAR = 5;
    public static final int CANCEL_REVIEW = 1;
    public static final int CANCEL_APPROVAL = 2;
    public static final int RERUN_REVIEW = 4;
    public static final int RERUN_APPROVAL = 8;
    public static final int ENABLE_REVIEW = 16;
    public static final int ENABLE_APPROVAL = 32;
    public static final int SET_STATE_REVIEW = 64;
    public static final int SET_STATE_APPROVAL = 128;
    public static final int IGN_DEP_REVIEW = 256;
    public static final int IGN_DEP_APPROVAL = 512;
    public static final int IGN_RSS_REVIEW = 1024;
    public static final int IGN_RSS_APPROVAL = 2048;
    public static final int CLONE_REVIEW = 4096;
    public static final int CLONE_APPROVAL = 8192;
    public static final int SUSPEND_REVIEW = 16384;
    public static final int SUSPEND_APPROVAL = 32768;
    public static final int CLR_WARN_REVIEW = 65536;
    public static final int CLR_WARN_APPROVAL = 131072;
    public static final int PRIORITY_REVIEW = 262144;
    public static final int PRIORITY_APPROVAL = 524288;
    public static final int EDIT_PARM_REVIEW = 0x100000;
    public static final int EDIT_PARM_APPROVAL = 0x200000;
    public static final int KILL_REVIEW = 0x400000;
    public static final int KILL_APPROVAL = 0x800000;
    public static final int SET_JOB_STATE_REVIEW = 0x1000000;
    public static final int SET_JOB_STATE_APPROVAL = 0x2000000;
    public static final int CANCEL_BITS = 3;
    public static final int RERUN_BITS = 12;
    public static final int ENABLE_BITS = 48;
    public static final int SET_STATE_BITS = 192;
    public static final int IGN_DEP_BITS = 768;
    public static final int IGN_RSS_BITS = 3072;
    public static final int CLONE_BITS = 12288;
    public static final int SUSPEND_BITS = 49152;
    public static final int CLR_WARN_BITS = 196608;
    public static final int PRIORITY_BITS = 786432;
    public static final int EDIT_PARM_BITS = 0x300000;
    public static final int KILL_BITS = 0xC00000;
    public static final int SET_JOB_STATE_BITS = 0x3000000;
    public static final int nr_id = 1;
    public static final int nr_accessKey = 2;
    public static final int nr_masterId = 3;
    public static final int nr_submitTag = 4;
    public static final int nr_unresolvedHandling = 5;
    public static final int nr_seId = 6;
    public static final int nr_childTag = 7;
    public static final int nr_seVersion = 8;
    public static final int nr_ownerId = 9;
    public static final int nr_parentId = 10;
    public static final int nr_scopeId = 11;
    public static final int nr_isStatic = 12;
    public static final int nr_isDisabled = 13;
    public static final int nr_oldState = 14;
    public static final int nr_mergeMode = 15;
    public static final int nr_state = 16;
    public static final int nr_jobEsdId = 17;
    public static final int nr_jobEsdPref = 18;
    public static final int nr_jobIsFinal = 19;
    public static final int nr_jobIsRestartable = 20;
    public static final int nr_finalEsdId = 21;
    public static final int nr_exitCode = 22;
    public static final int nr_commandline = 23;
    public static final int nr_rrCommandline = 24;
    public static final int nr_rerunSeq = 25;
    public static final int nr_isReplaced = 26;
    public static final int nr_isCancelled = 27;
    public static final int nr_baseSmeId = 28;
    public static final int nr_reasonSmeId = 29;
    public static final int nr_fireSmeId = 30;
    public static final int nr_fireSeId = 31;
    public static final int nr_trId = 32;
    public static final int nr_trSdIdOld = 33;
    public static final int nr_trSdIdNew = 34;
    public static final int nr_trSeq = 35;
    public static final int nr_workdir = 36;
    public static final int nr_logfile = 37;
    public static final int nr_errlogfile = 38;
    public static final int nr_pid = 39;
    public static final int nr_extPid = 40;
    public static final int nr_errorMsg = 41;
    public static final int nr_killId = 42;
    public static final int nr_killExitCode = 43;
    public static final int nr_isSuspended = 44;
    public static final int nr_isSuspendedLocal = 45;
    public static final int nr_priority = 46;
    public static final int nr_rawPriority = 47;
    public static final int nr_nice = 48;
    public static final int nr_npNice = 49;
    public static final int nr_minPriority = 50;
    public static final int nr_agingAmount = 51;
    public static final int nr_parentSuspended = 52;
    public static final int nr_childSuspended = 53;
    public static final int nr_warnCount = 54;
    public static final int nr_warnLink = 55;
    public static final int nr_approvalMode = 56;
    public static final int nr_childApprovalMode = 57;
    public static final int nr_submitTs = 58;
    public static final int nr_resumeTs = 59;
    public static final int nr_syncTs = 60;
    public static final int nr_resourceTs = 61;
    public static final int nr_runnableTs = 62;
    public static final int nr_startTs = 63;
    public static final int nr_finishTs = 64;
    public static final int nr_finalTs = 65;
    public static final int nr_cntSubmitted = 66;
    public static final int nr_cntDependencyWait = 67;
    public static final int nr_cntSynchronizeWait = 68;
    public static final int nr_cntResourceWait = 69;
    public static final int nr_cntRunnable = 70;
    public static final int nr_cntStarting = 71;
    public static final int nr_cntStarted = 72;
    public static final int nr_cntRunning = 73;
    public static final int nr_cntToKill = 74;
    public static final int nr_cntKilled = 75;
    public static final int nr_cntCancelled = 76;
    public static final int nr_cntFinished = 77;
    public static final int nr_cntFinal = 78;
    public static final int nr_cntBrokenActive = 79;
    public static final int nr_cntBrokenFinished = 80;
    public static final int nr_cntError = 81;
    public static final int nr_cntUnreachable = 82;
    public static final int nr_cntRestartable = 83;
    public static final int nr_cntWarn = 84;
    public static final int nr_cntPending = 85;
    public static final int nr_idleTs = 86;
    public static final int nr_idleTime = 87;
    public static final int nr_statisticTs = 88;
    public static final int nr_dependencyWaitTime = 89;
    public static final int nr_suspendTime = 90;
    public static final int nr_syncTime = 91;
    public static final int nr_resourceTime = 92;
    public static final int nr_jobserverTime = 93;
    public static final int nr_restartableTime = 94;
    public static final int nr_childWaitTime = 95;
    public static final int nr_opSusresTs = 96;
    public static final int nr_npeId = 97;
    public static final int nr_timeZone = 98;
    public static final int nr_creatorUId = 99;
    public static final int nr_createTs = 100;
    public static final int nr_changerUId = 101;
    public static final int nr_changeTs = 102;
    public static String tableName = "SUBMITTED_ENTITY";
    protected Long accessKey;
    protected Long masterId;
    protected String submitTag;
    protected Integer unresolvedHandling;
    protected Long seId;
    protected String childTag;
    protected Long seVersion;
    protected Long ownerId;
    protected Long parentId;
    protected Long scopeId;
    protected Boolean isStatic;
    protected Boolean isDisabled;
    protected Integer oldState;
    protected Integer mergeMode;
    protected Integer state;
    protected Long jobEsdId;
    protected Integer jobEsdPref;
    protected Boolean jobIsFinal;
    protected Boolean jobIsRestartable;
    protected Long finalEsdId;
    protected Integer exitCode;
    protected String commandline;
    protected String rrCommandline;
    protected Integer rerunSeq;
    protected Boolean isReplaced;
    protected Boolean isCancelled;
    protected Long baseSmeId;
    protected Long reasonSmeId;
    protected Long fireSmeId;
    protected Long fireSeId;
    protected Long trId;
    protected Long trSdIdOld;
    protected Long trSdIdNew;
    protected Integer trSeq;
    protected String workdir;
    protected String logfile;
    protected String errlogfile;
    protected String pid;
    protected String extPid;
    protected String errorMsg;
    protected Long killId;
    protected Integer killExitCode;
    protected Integer isSuspended;
    protected Boolean isSuspendedLocal;
    protected Integer priority;
    protected Integer rawPriority;
    protected Integer nice;
    protected Integer npNice;
    protected Integer minPriority;
    protected Integer agingAmount;
    protected Integer parentSuspended;
    protected Integer childSuspended;
    protected Integer warnCount;
    protected Long warnLink;
    protected Integer approvalMode;
    protected Integer childApprovalMode;
    protected Long submitTs;
    protected Long resumeTs;
    protected Long syncTs;
    protected Long resourceTs;
    protected Long runnableTs;
    protected Long startTs;
    protected Long finishTs;
    protected Long finalTs;
    protected Integer cntSubmitted;
    protected Integer cntDependencyWait;
    protected Integer cntSynchronizeWait;
    protected Integer cntResourceWait;
    protected Integer cntRunnable;
    protected Integer cntStarting;
    protected Integer cntStarted;
    protected Integer cntRunning;
    protected Integer cntToKill;
    protected Integer cntKilled;
    protected Integer cntCancelled;
    protected Integer cntFinished;
    protected Integer cntFinal;
    protected Integer cntBrokenActive;
    protected Integer cntBrokenFinished;
    protected Integer cntError;
    protected Integer cntUnreachable;
    protected Integer cntRestartable;
    protected Integer cntWarn;
    protected Integer cntPending;
    protected Integer idleTs;
    protected Integer idleTime;
    protected Integer statisticTs;
    protected Integer dependencyWaitTime;
    protected Integer suspendTime;
    protected Integer syncTime;
    protected Integer resourceTime;
    protected Integer jobserverTime;
    protected Integer restartableTime;
    protected Integer childWaitTime;
    protected Long opSusresTs;
    protected Long npeId;
    protected String timeZone;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSSubmittedEntityGeneric(SystemEnvironment systemEnvironment, Long l, Long l2, String string, Integer n, Long l3, String string2, Long l4, Long l5, Long l6, Long l7, Boolean bl, Boolean bl2, Integer n2, Integer n3, Integer n4, Long l8, Integer n5, Boolean bl3, Boolean bl4, Long l9, Integer n6, String string3, String string4, Integer n7, Boolean bl5, Boolean bl6, Long l10, Long l11, Long l12, Long l13, Long l14, Long l15, Long l16, Integer n8, String string5, String string6, String string7, String string8, String string9, String string10, Long l17, Integer n9, Integer n10, Boolean bl7, Integer n11, Integer n12, Integer n13, Integer n14, Integer n15, Integer n16, Integer n17, Integer n18, Integer n19, Long l18, Integer n20, Integer n21, Long l19, Long l20, Long l21, Long l22, Long l23, Long l24, Long l25, Long l26, Integer n22, Integer n23, Integer n24, Integer n25, Integer n26, Integer n27, Integer n28, Integer n29, Integer n30, Integer n31, Integer n32, Integer n33, Integer n34, Integer n35, Integer n36, Integer n37, Integer n38, Integer n39, Integer n40, Integer n41, Integer n42, Integer n43, Integer n44, Integer n45, Integer n46, Integer n47, Integer n48, Integer n49, Integer n50, Integer n51, Long l27, Long l28, String string11, Long l29, Long l30, Long l31, Long l32) throws SDMSException {
        super(systemEnvironment, SDMSSubmittedEntityTableGeneric.table);
        this.accessKey = l;
        this.masterId = l2;
        if (string != null && string.length() > 32) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(SubmittedEntity) Length of $1 exceeds maximum length $2", "submitTag", "32"));
        }
        this.submitTag = string;
        this.unresolvedHandling = n;
        this.seId = l3;
        if (string2 != null && string2.length() > 70) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(SubmittedEntity) Length of $1 exceeds maximum length $2", "childTag", "70"));
        }
        this.childTag = string2;
        this.seVersion = l4;
        this.ownerId = l5;
        this.parentId = l6;
        this.scopeId = l7;
        this.isStatic = bl;
        this.isDisabled = bl2;
        this.oldState = n2;
        this.mergeMode = n3;
        this.state = n4;
        this.jobEsdId = l8;
        this.jobEsdPref = n5;
        this.jobIsFinal = bl3;
        this.jobIsRestartable = bl4;
        this.finalEsdId = l9;
        this.exitCode = n6;
        if (string3 != null && string3.length() > 512) {
            string3 = string3.substring(0, 512);
        }
        this.commandline = string3;
        if (string4 != null && string4.length() > 512) {
            string4 = string4.substring(0, 512);
        }
        this.rrCommandline = string4;
        this.rerunSeq = n7;
        this.isReplaced = bl5;
        this.isCancelled = bl6;
        this.baseSmeId = l10;
        this.reasonSmeId = l11;
        this.fireSmeId = l12;
        this.fireSeId = l13;
        this.trId = l14;
        this.trSdIdOld = l15;
        this.trSdIdNew = l16;
        this.trSeq = n8;
        if (string5 != null && string5.length() > 512) {
            string5 = string5.substring(0, 512);
        }
        this.workdir = string5;
        if (string6 != null && string6.length() > 512) {
            string6 = string6.substring(0, 512);
        }
        this.logfile = string6;
        if (string7 != null && string7.length() > 512) {
            string7 = string7.substring(0, 512);
        }
        this.errlogfile = string7;
        if (string8 != null && string8.length() > 32) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(SubmittedEntity) Length of $1 exceeds maximum length $2", "pid", "32"));
        }
        this.pid = string8;
        if (string9 != null && string9.length() > 32) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(SubmittedEntity) Length of $1 exceeds maximum length $2", "extPid", "32"));
        }
        this.extPid = string9;
        if (string10 != null && string10.length() > 256) {
            string10 = string10.substring(0, 256);
        }
        this.errorMsg = string10;
        this.killId = l17;
        this.killExitCode = n9;
        this.isSuspended = n10;
        this.isSuspendedLocal = bl7;
        this.priority = n11;
        this.rawPriority = n12;
        this.nice = n13;
        this.npNice = n14;
        this.minPriority = n15;
        this.agingAmount = n16;
        this.parentSuspended = n17;
        this.childSuspended = n18;
        this.warnCount = n19;
        this.warnLink = l18;
        this.approvalMode = n20;
        this.childApprovalMode = n21;
        this.submitTs = l19;
        this.resumeTs = l20;
        this.syncTs = l21;
        this.resourceTs = l22;
        this.runnableTs = l23;
        this.startTs = l24;
        this.finishTs = l25;
        this.finalTs = l26;
        this.cntSubmitted = n22;
        this.cntDependencyWait = n23;
        this.cntSynchronizeWait = n24;
        this.cntResourceWait = n25;
        this.cntRunnable = n26;
        this.cntStarting = n27;
        this.cntStarted = n28;
        this.cntRunning = n29;
        this.cntToKill = n30;
        this.cntKilled = n31;
        this.cntCancelled = n32;
        this.cntFinished = n33;
        this.cntFinal = n34;
        this.cntBrokenActive = n35;
        this.cntBrokenFinished = n36;
        this.cntError = n37;
        this.cntUnreachable = n38;
        this.cntRestartable = n39;
        this.cntWarn = n40;
        this.cntPending = n41;
        this.idleTs = n42;
        this.idleTime = n43;
        this.statisticTs = n44;
        this.dependencyWaitTime = n45;
        this.suspendTime = n46;
        this.syncTime = n47;
        this.resourceTime = n48;
        this.jobserverTime = n49;
        this.restartableTime = n50;
        this.childWaitTime = n51;
        this.opSusresTs = l27;
        this.npeId = l28;
        if (string11 != null && string11.length() > 32) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(SubmittedEntity) Length of $1 exceeds maximum length $2", "timeZone", "32"));
        }
        this.timeZone = string11;
        this.creatorUId = l29;
        this.createTs = l30;
        this.changerUId = l31;
        this.changeTs = l32;
    }

    public Long getAccessKey(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.accessKey;
    }

    public void setAccessKey(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.accessKey.equals(l)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.accessKey = l;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Long getMasterId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.masterId;
    }

    public void setMasterId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.masterId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
            }
            SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
            sDMSSubmittedEntityGeneric.masterId = l;
            sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 1409L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public String getSubmitTag(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.submitTag;
    }

    public void setSubmitTag(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.submitTag)) {
            return;
        }
        if (string == null && this.submitTag == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
            }
            SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
            if (string != null && string.length() > 32) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(SubmittedEntity) Length of $1 exceeds maximum length $2", "submitTag", "32"));
            }
            sDMSSubmittedEntityGeneric.submitTag = string;
            sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 2L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getUnresolvedHandling(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.unresolvedHandling;
    }

    public String getUnresolvedHandlingAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getUnresolvedHandling(systemEnvironment);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return "UH_IGNORE";
            }
            case 3: {
                return "UH_SUSPEND";
            }
            case 2: {
                return "UH_ERROR";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown SubmittedEntity.unresolvedHandling: $1", this.getUnresolvedHandling(systemEnvironment)));
    }

    public void setUnresolvedHandling(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.unresolvedHandling)) {
            return;
        }
        if (n == null && this.unresolvedHandling == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.unresolvedHandling = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Long getSeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.seId;
    }

    public void setSeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.seId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
            }
            SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
            sDMSSubmittedEntityGeneric.seId = l;
            sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 3460L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public String getChildTag(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.childTag;
    }

    public void setChildTag(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.childTag)) {
            return;
        }
        if (string == null && this.childTag == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
            }
            SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
            if (string != null && string.length() > 70) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(SubmittedEntity) Length of $1 exceeds maximum length $2", "childTag", "70"));
            }
            sDMSSubmittedEntityGeneric.childTag = string;
            sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 1024L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getSeVersion(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.seVersion;
    }

    public void setSeVersion(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.seVersion.equals(l)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.seVersion = l;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Long getOwnerId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.ownerId;
    }

    public void setOwnerId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.ownerId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
            }
            SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
            sDMSSubmittedEntityGeneric.ownerId = l;
            sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 8L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getParentId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.parentId;
    }

    public void setParentId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.parentId)) {
            return;
        }
        if (l == null && this.parentId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
            }
            SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
            sDMSSubmittedEntityGeneric.parentId = l;
            sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 7184L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getScopeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.scopeId;
    }

    public void setScopeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.scopeId)) {
            return;
        }
        if (l == null && this.scopeId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
            }
            SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
            sDMSSubmittedEntityGeneric.scopeId = l;
            sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 32L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Boolean getIsStatic(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isStatic;
    }

    public void setIsStatic(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.isStatic.equals(bl)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.isStatic = bl;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Boolean getIsDisabled(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isDisabled;
    }

    public void setIsDisabled(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.isDisabled.equals(bl)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.isDisabled = bl;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getOldState(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.oldState;
    }

    public void setOldState(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.oldState)) {
            return;
        }
        if (n == null && this.oldState == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.oldState = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getMergeMode(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.mergeMode;
    }

    public String getMergeModeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getMergeMode(systemEnvironment);
        switch (n) {
            case 1: {
                return "MERGE_LOCAL";
            }
            case 2: {
                return "MERGE_GLOBAL";
            }
            case 3: {
                return "NOMERGE";
            }
            case 4: {
                return "FAILURE";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown SubmittedEntity.mergeMode: $1", this.getMergeMode(systemEnvironment)));
    }

    public void setMergeMode(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.mergeMode.equals(n)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
            }
            SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
            sDMSSubmittedEntityGeneric.mergeMode = n;
            sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 128L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getState(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.state;
    }

    public String getStateAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getState(systemEnvironment);
        switch (n) {
            case 0: {
                return "SUBMITTED";
            }
            case 1: {
                return "DEPENDENCY_WAIT";
            }
            case 2: {
                return "SYNCHRONIZE_WAIT";
            }
            case 3: {
                return "RESOURCE_WAIT";
            }
            case 4: {
                return "RUNNABLE";
            }
            case 5: {
                return "STARTING";
            }
            case 6: {
                return "STARTED";
            }
            case 7: {
                return "RUNNING";
            }
            case 8: {
                return "TO_KILL";
            }
            case 9: {
                return "KILLED";
            }
            case 10: {
                return "CANCELLED";
            }
            case 11: {
                return "FINISHED";
            }
            case 12: {
                return "FINAL";
            }
            case 13: {
                return "BROKEN_ACTIVE";
            }
            case 14: {
                return "BROKEN_FINISHED";
            }
            case 15: {
                return "ERROR";
            }
            case 16: {
                return "UNREACHABLE";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown SubmittedEntity.state: $1", this.getState(systemEnvironment)));
    }

    public void setState(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.state.equals(n)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
            }
            SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
            sDMSSubmittedEntityGeneric.state = n;
            sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 64L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getJobEsdId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.jobEsdId;
    }

    public void setJobEsdId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.jobEsdId)) {
            return;
        }
        if (l == null && this.jobEsdId == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.jobEsdId = l;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getJobEsdPref(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.jobEsdPref;
    }

    public void setJobEsdPref(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.jobEsdPref)) {
            return;
        }
        if (n == null && this.jobEsdPref == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.jobEsdPref = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Boolean getJobIsFinal(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.jobIsFinal;
    }

    public void setJobIsFinal(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.jobIsFinal.equals(bl)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.jobIsFinal = bl;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Boolean getJobIsRestartable(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.jobIsRestartable;
    }

    public void setJobIsRestartable(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.jobIsRestartable.equals(bl)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.jobIsRestartable = bl;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Long getFinalEsdId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.finalEsdId;
    }

    public void setFinalEsdId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.finalEsdId)) {
            return;
        }
        if (l == null && this.finalEsdId == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.finalEsdId = l;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getExitCode(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.exitCode;
    }

    public void setExitCode(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.exitCode)) {
            return;
        }
        if (n == null && this.exitCode == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.exitCode = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public String getCommandline(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.commandline;
    }

    public void setCommandline(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.commandline)) {
            return;
        }
        if (string == null && this.commandline == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 512) {
            string = string.substring(0, 512);
        }
        sDMSSubmittedEntityGeneric.commandline = string;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public String getRrCommandline(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.rrCommandline;
    }

    public void setRrCommandline(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.rrCommandline)) {
            return;
        }
        if (string == null && this.rrCommandline == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 512) {
            string = string.substring(0, 512);
        }
        sDMSSubmittedEntityGeneric.rrCommandline = string;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getRerunSeq(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.rerunSeq;
    }

    public void setRerunSeq(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.rerunSeq.equals(n)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.rerunSeq = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Boolean getIsReplaced(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isReplaced;
    }

    public void setIsReplaced(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.isReplaced.equals(bl)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.isReplaced = bl;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Boolean getIsCancelled(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isCancelled;
    }

    public void setIsCancelled(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (bl != null && bl.equals(this.isCancelled)) {
            return;
        }
        if (bl == null && this.isCancelled == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.isCancelled = bl;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Long getBaseSmeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.baseSmeId;
    }

    public void setBaseSmeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.baseSmeId)) {
            return;
        }
        if (l == null && this.baseSmeId == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.baseSmeId = l;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Long getReasonSmeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.reasonSmeId;
    }

    public void setReasonSmeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.reasonSmeId)) {
            return;
        }
        if (l == null && this.reasonSmeId == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.reasonSmeId = l;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Long getFireSmeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.fireSmeId;
    }

    public void setFireSmeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.fireSmeId)) {
            return;
        }
        if (l == null && this.fireSmeId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
            }
            SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
            sDMSSubmittedEntityGeneric.fireSmeId = l;
            sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 512L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getFireSeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.fireSeId;
    }

    public void setFireSeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.fireSeId)) {
            return;
        }
        if (l == null && this.fireSeId == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.fireSeId = l;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Long getTrId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.trId;
    }

    public void setTrId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.trId)) {
            return;
        }
        if (l == null && this.trId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
            }
            SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
            sDMSSubmittedEntityGeneric.trId = l;
            sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 4608L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getTrSdIdOld(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.trSdIdOld;
    }

    public void setTrSdIdOld(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.trSdIdOld)) {
            return;
        }
        if (l == null && this.trSdIdOld == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.trSdIdOld = l;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Long getTrSdIdNew(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.trSdIdNew;
    }

    public void setTrSdIdNew(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.trSdIdNew)) {
            return;
        }
        if (l == null && this.trSdIdNew == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.trSdIdNew = l;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getTrSeq(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.trSeq;
    }

    public void setTrSeq(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.trSeq.equals(n)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.trSeq = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public String getWorkdir(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.workdir;
    }

    public void setWorkdir(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.workdir)) {
            return;
        }
        if (string == null && this.workdir == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 512) {
            string = string.substring(0, 512);
        }
        sDMSSubmittedEntityGeneric.workdir = string;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public String getLogfile(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.logfile;
    }

    public void setLogfile(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.logfile)) {
            return;
        }
        if (string == null && this.logfile == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 512) {
            string = string.substring(0, 512);
        }
        sDMSSubmittedEntityGeneric.logfile = string;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public String getErrlogfile(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.errlogfile;
    }

    public void setErrlogfile(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.errlogfile)) {
            return;
        }
        if (string == null && this.errlogfile == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 512) {
            string = string.substring(0, 512);
        }
        sDMSSubmittedEntityGeneric.errlogfile = string;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public String getPid(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.pid;
    }

    public void setPid(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.pid)) {
            return;
        }
        if (string == null && this.pid == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 32) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(SubmittedEntity) Length of $1 exceeds maximum length $2", "pid", "32"));
        }
        sDMSSubmittedEntityGeneric.pid = string;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public String getExtPid(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.extPid;
    }

    public void setExtPid(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.extPid)) {
            return;
        }
        if (string == null && this.extPid == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 32) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(SubmittedEntity) Length of $1 exceeds maximum length $2", "extPid", "32"));
        }
        sDMSSubmittedEntityGeneric.extPid = string;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public String getErrorMsg(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.errorMsg;
    }

    public void setErrorMsg(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.errorMsg)) {
            return;
        }
        if (string == null && this.errorMsg == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 256) {
            string = string.substring(0, 256);
        }
        sDMSSubmittedEntityGeneric.errorMsg = string;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Long getKillId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.killId;
    }

    public void setKillId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.killId)) {
            return;
        }
        if (l == null && this.killId == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.killId = l;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getKillExitCode(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.killExitCode;
    }

    public void setKillExitCode(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.killExitCode)) {
            return;
        }
        if (n == null && this.killExitCode == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.killExitCode = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getIsSuspended(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isSuspended;
    }

    public String getIsSuspendedAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getIsSuspended(systemEnvironment);
        switch (n) {
            case 2: {
                return "ADMINSUSPEND";
            }
            case 1: {
                return "SUSPEND";
            }
            case 0: {
                return "NOSUSPEND";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown SubmittedEntity.isSuspended: $1", this.getIsSuspended(systemEnvironment)));
    }

    public void setIsSuspended(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.isSuspended.equals(n)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.isSuspended = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Boolean getIsSuspendedLocal(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isSuspendedLocal;
    }

    public void setIsSuspendedLocal(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (bl != null && bl.equals(this.isSuspendedLocal)) {
            return;
        }
        if (bl == null && this.isSuspendedLocal == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.isSuspendedLocal = bl;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getPriority(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.priority;
    }

    public void setPriority(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.priority.equals(n)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.priority = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getRawPriority(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.rawPriority;
    }

    public void setRawPriority(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.rawPriority.equals(n)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.rawPriority = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getNice(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.nice;
    }

    public void setNice(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.nice.equals(n)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.nice = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getNpNice(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.npNice;
    }

    public void setNpNice(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.npNice.equals(n)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.npNice = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getMinPriority(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.minPriority;
    }

    public void setMinPriority(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.minPriority.equals(n)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.minPriority = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getAgingAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.agingAmount;
    }

    public void setAgingAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.agingAmount.equals(n)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.agingAmount = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getParentSuspended(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.parentSuspended;
    }

    public void setParentSuspended(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.parentSuspended.equals(n)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.parentSuspended = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getChildSuspended(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.childSuspended;
    }

    public void setChildSuspended(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.childSuspended.equals(n)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.childSuspended = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getWarnCount(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.warnCount;
    }

    public void setWarnCount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.warnCount.equals(n)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.warnCount = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Long getWarnLink(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.warnLink;
    }

    public void setWarnLink(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.warnLink)) {
            return;
        }
        if (l == null && this.warnLink == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.warnLink = l;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getApprovalMode(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.approvalMode;
    }

    public void setApprovalMode(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.approvalMode.equals(n)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.approvalMode = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getChildApprovalMode(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.childApprovalMode;
    }

    public void setChildApprovalMode(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.childApprovalMode.equals(n)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.childApprovalMode = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Long getSubmitTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.submitTs;
    }

    public void setSubmitTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.submitTs.equals(l)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.submitTs = l;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Long getResumeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.resumeTs;
    }

    public void setResumeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.resumeTs)) {
            return;
        }
        if (l == null && this.resumeTs == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.resumeTs = l;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Long getSyncTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.syncTs;
    }

    public void setSyncTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.syncTs)) {
            return;
        }
        if (l == null && this.syncTs == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.syncTs = l;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Long getResourceTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.resourceTs;
    }

    public void setResourceTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.resourceTs)) {
            return;
        }
        if (l == null && this.resourceTs == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.resourceTs = l;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Long getRunnableTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.runnableTs;
    }

    public void setRunnableTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.runnableTs)) {
            return;
        }
        if (l == null && this.runnableTs == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.runnableTs = l;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Long getStartTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.startTs;
    }

    public void setStartTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.startTs)) {
            return;
        }
        if (l == null && this.startTs == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.startTs = l;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Long getFinishTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.finishTs;
    }

    public void setFinishTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.finishTs)) {
            return;
        }
        if (l == null && this.finishTs == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.finishTs = l;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Long getFinalTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.finalTs;
    }

    public void setFinalTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.finalTs)) {
            return;
        }
        if (l == null && this.finalTs == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.finalTs = l;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getCntSubmitted(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.cntSubmitted;
    }

    public void setCntSubmitted(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.cntSubmitted.equals(n)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.cntSubmitted = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getCntDependencyWait(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.cntDependencyWait;
    }

    public void setCntDependencyWait(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.cntDependencyWait.equals(n)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.cntDependencyWait = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getCntSynchronizeWait(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.cntSynchronizeWait;
    }

    public void setCntSynchronizeWait(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.cntSynchronizeWait.equals(n)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.cntSynchronizeWait = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getCntResourceWait(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.cntResourceWait;
    }

    public void setCntResourceWait(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.cntResourceWait.equals(n)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.cntResourceWait = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getCntRunnable(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.cntRunnable;
    }

    public void setCntRunnable(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.cntRunnable.equals(n)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.cntRunnable = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getCntStarting(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.cntStarting;
    }

    public void setCntStarting(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.cntStarting.equals(n)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.cntStarting = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getCntStarted(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.cntStarted;
    }

    public void setCntStarted(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.cntStarted.equals(n)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.cntStarted = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getCntRunning(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.cntRunning;
    }

    public void setCntRunning(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.cntRunning.equals(n)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.cntRunning = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getCntToKill(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.cntToKill;
    }

    public void setCntToKill(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.cntToKill.equals(n)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.cntToKill = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getCntKilled(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.cntKilled;
    }

    public void setCntKilled(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.cntKilled.equals(n)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.cntKilled = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getCntCancelled(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.cntCancelled;
    }

    public void setCntCancelled(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.cntCancelled.equals(n)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.cntCancelled = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getCntFinished(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.cntFinished;
    }

    public void setCntFinished(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.cntFinished.equals(n)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.cntFinished = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getCntFinal(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.cntFinal;
    }

    public void setCntFinal(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.cntFinal.equals(n)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.cntFinal = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getCntBrokenActive(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.cntBrokenActive;
    }

    public void setCntBrokenActive(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.cntBrokenActive.equals(n)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.cntBrokenActive = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getCntBrokenFinished(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.cntBrokenFinished;
    }

    public void setCntBrokenFinished(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.cntBrokenFinished.equals(n)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.cntBrokenFinished = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getCntError(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.cntError;
    }

    public void setCntError(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.cntError.equals(n)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.cntError = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getCntUnreachable(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.cntUnreachable;
    }

    public void setCntUnreachable(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.cntUnreachable.equals(n)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.cntUnreachable = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getCntRestartable(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.cntRestartable;
    }

    public void setCntRestartable(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.cntRestartable.equals(n)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.cntRestartable = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getCntWarn(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.cntWarn;
    }

    public void setCntWarn(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.cntWarn.equals(n)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.cntWarn = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getCntPending(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.cntPending;
    }

    public void setCntPending(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.cntPending.equals(n)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.cntPending = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getIdleTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.idleTs;
    }

    public void setIdleTs(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.idleTs)) {
            return;
        }
        if (n == null && this.idleTs == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.idleTs = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getIdleTime(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.idleTime;
    }

    public void setIdleTime(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.idleTime)) {
            return;
        }
        if (n == null && this.idleTime == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.idleTime = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getStatisticTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.statisticTs;
    }

    public void setStatisticTs(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.statisticTs)) {
            return;
        }
        if (n == null && this.statisticTs == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.statisticTs = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getDependencyWaitTime(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.dependencyWaitTime;
    }

    public void setDependencyWaitTime(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.dependencyWaitTime)) {
            return;
        }
        if (n == null && this.dependencyWaitTime == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.dependencyWaitTime = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getSuspendTime(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.suspendTime;
    }

    public void setSuspendTime(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.suspendTime)) {
            return;
        }
        if (n == null && this.suspendTime == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.suspendTime = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getSyncTime(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.syncTime;
    }

    public void setSyncTime(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.syncTime)) {
            return;
        }
        if (n == null && this.syncTime == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.syncTime = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getResourceTime(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.resourceTime;
    }

    public void setResourceTime(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.resourceTime)) {
            return;
        }
        if (n == null && this.resourceTime == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.resourceTime = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getJobserverTime(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.jobserverTime;
    }

    public void setJobserverTime(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.jobserverTime)) {
            return;
        }
        if (n == null && this.jobserverTime == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.jobserverTime = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getRestartableTime(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.restartableTime;
    }

    public void setRestartableTime(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.restartableTime)) {
            return;
        }
        if (n == null && this.restartableTime == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.restartableTime = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Integer getChildWaitTime(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.childWaitTime;
    }

    public void setChildWaitTime(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.childWaitTime)) {
            return;
        }
        if (n == null && this.childWaitTime == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.childWaitTime = n;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Long getOpSusresTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.opSusresTs;
    }

    public void setOpSusresTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.opSusresTs)) {
            return;
        }
        if (l == null && this.opSusresTs == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.opSusresTs = l;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Long getNpeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.npeId;
    }

    public void setNpeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.npeId)) {
            return;
        }
        if (l == null && this.npeId == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.npeId = l;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public String getTimeZone(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.timeZone;
    }

    public void setTimeZone(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.timeZone)) {
            return;
        }
        if (string == null && this.timeZone == null) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 32) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(SubmittedEntity) Length of $1 exceeds maximum length $2", "timeZone", "32"));
        }
        sDMSSubmittedEntityGeneric.timeZone = string;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.creatorUId = l;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntity) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.createTs = l;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.changerUId = l;
        sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric = this;
        if (sDMSSubmittedEntityGeneric.versions.o_v == null || sDMSSubmittedEntityGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityGeneric.changeTs = l;
        sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSSubmittedEntityGeneric != this) {
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric, 0L);
        }
    }

    public SDMSSubmittedEntityGeneric set_MasterIdSeIdMergeMode(SystemEnvironment systemEnvironment, Long l, Long l2, Integer n) throws SDMSException {
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(SubmittedEntity) Change of system object not allowed"));
            }
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
            sDMSSubmittedEntityGeneric.masterId = l;
            sDMSSubmittedEntityGeneric.seId = l2;
            sDMSSubmittedEntityGeneric.mergeMode = n;
            sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSSubmittedEntityGeneric;
    }

    public SDMSSubmittedEntityGeneric set_MasterIdSeId(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(SubmittedEntity) Change of system object not allowed"));
            }
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
            sDMSSubmittedEntityGeneric.masterId = l;
            sDMSSubmittedEntityGeneric.seId = l2;
            sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSSubmittedEntityGeneric;
    }

    public SDMSSubmittedEntityGeneric set_FireSmeIdTrId(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(SubmittedEntity) Change of system object not allowed"));
            }
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
            sDMSSubmittedEntityGeneric.fireSmeId = l;
            sDMSSubmittedEntityGeneric.trId = l2;
            sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSSubmittedEntityGeneric;
    }

    public SDMSSubmittedEntityGeneric set_MasterIdParentIdSeIdChildTag(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, String string) throws SDMSException {
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(SubmittedEntity) Change of system object not allowed"));
            }
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
            sDMSSubmittedEntityGeneric.masterId = l;
            sDMSSubmittedEntityGeneric.parentId = l2;
            sDMSSubmittedEntityGeneric.seId = l3;
            if (string != null && string.length() > 70) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01201290025", "(SubmittedEntity) Length of $1 exceeds maximum length $2", "changeTs", "70"));
            }
            sDMSSubmittedEntityGeneric.childTag = string;
            sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSSubmittedEntityGeneric;
    }

    public SDMSSubmittedEntityGeneric set_ParentIdSeId(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(SubmittedEntity) Change of system object not allowed"));
            }
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
            sDMSSubmittedEntityGeneric.parentId = l;
            sDMSSubmittedEntityGeneric.seId = l2;
            sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSSubmittedEntityGeneric;
    }

    public SDMSSubmittedEntityGeneric set_ParentIdTrId(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        SDMSSubmittedEntityGeneric sDMSSubmittedEntityGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(SubmittedEntity) Change of system object not allowed"));
            }
            sDMSSubmittedEntityGeneric = (SDMSSubmittedEntityGeneric)this.change(systemEnvironment);
            sDMSSubmittedEntityGeneric.parentId = l;
            sDMSSubmittedEntityGeneric.trId = l2;
            sDMSSubmittedEntityGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSubmittedEntityGeneric.changeTs = systemEnvironment.txTime();
            sDMSSubmittedEntityGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSSubmittedEntityGeneric;
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSSubmittedEntity(this);
    }

    protected SDMSSubmittedEntityGeneric(Long l, Long l2, Long l3, String string, Integer n, Long l4, String string2, Long l5, Long l6, Long l7, Long l8, Boolean bl, Boolean bl2, Integer n2, Integer n3, Integer n4, Long l9, Integer n5, Boolean bl3, Boolean bl4, Long l10, Integer n6, String string3, String string4, Integer n7, Boolean bl5, Boolean bl6, Long l11, Long l12, Long l13, Long l14, Long l15, Long l16, Long l17, Integer n8, String string5, String string6, String string7, String string8, String string9, String string10, Long l18, Integer n9, Integer n10, Boolean bl7, Integer n11, Integer n12, Integer n13, Integer n14, Integer n15, Integer n16, Integer n17, Integer n18, Integer n19, Long l19, Integer n20, Integer n21, Long l20, Long l21, Long l22, Long l23, Long l24, Long l25, Long l26, Long l27, Integer n22, Integer n23, Integer n24, Integer n25, Integer n26, Integer n27, Integer n28, Integer n29, Integer n30, Integer n31, Integer n32, Integer n33, Integer n34, Integer n35, Integer n36, Integer n37, Integer n38, Integer n39, Integer n40, Integer n41, Integer n42, Integer n43, Integer n44, Integer n45, Integer n46, Integer n47, Integer n48, Integer n49, Integer n50, Integer n51, Long l28, Long l29, String string11, Long l30, Long l31, Long l32, Long l33, long l34, long l35) {
        this.id = l;
        this.accessKey = l2;
        this.masterId = l3;
        this.submitTag = string;
        this.unresolvedHandling = n;
        this.seId = l4;
        this.childTag = string2;
        this.seVersion = l5;
        this.ownerId = l6;
        this.parentId = l7;
        this.scopeId = l8;
        this.isStatic = bl;
        this.isDisabled = bl2;
        this.oldState = n2;
        this.mergeMode = n3;
        this.state = n4;
        this.jobEsdId = l9;
        this.jobEsdPref = n5;
        this.jobIsFinal = bl3;
        this.jobIsRestartable = bl4;
        this.finalEsdId = l10;
        this.exitCode = n6;
        this.commandline = string3;
        this.rrCommandline = string4;
        this.rerunSeq = n7;
        this.isReplaced = bl5;
        this.isCancelled = bl6;
        this.baseSmeId = l11;
        this.reasonSmeId = l12;
        this.fireSmeId = l13;
        this.fireSeId = l14;
        this.trId = l15;
        this.trSdIdOld = l16;
        this.trSdIdNew = l17;
        this.trSeq = n8;
        this.workdir = string5;
        this.logfile = string6;
        this.errlogfile = string7;
        this.pid = string8;
        this.extPid = string9;
        this.errorMsg = string10;
        this.killId = l18;
        this.killExitCode = n9;
        this.isSuspended = n10;
        this.isSuspendedLocal = bl7;
        this.priority = n11;
        this.rawPriority = n12;
        this.nice = n13;
        this.npNice = n14;
        this.minPriority = n15;
        this.agingAmount = n16;
        this.parentSuspended = n17;
        this.childSuspended = n18;
        this.warnCount = n19;
        this.warnLink = l19;
        this.approvalMode = n20;
        this.childApprovalMode = n21;
        this.submitTs = l20;
        this.resumeTs = l21;
        this.syncTs = l22;
        this.resourceTs = l23;
        this.runnableTs = l24;
        this.startTs = l25;
        this.finishTs = l26;
        this.finalTs = l27;
        this.cntSubmitted = n22;
        this.cntDependencyWait = n23;
        this.cntSynchronizeWait = n24;
        this.cntResourceWait = n25;
        this.cntRunnable = n26;
        this.cntStarting = n27;
        this.cntStarted = n28;
        this.cntRunning = n29;
        this.cntToKill = n30;
        this.cntKilled = n31;
        this.cntCancelled = n32;
        this.cntFinished = n33;
        this.cntFinal = n34;
        this.cntBrokenActive = n35;
        this.cntBrokenFinished = n36;
        this.cntError = n37;
        this.cntUnreachable = n38;
        this.cntRestartable = n39;
        this.cntWarn = n40;
        this.cntPending = n41;
        this.idleTs = n42;
        this.idleTime = n43;
        this.statisticTs = n44;
        this.dependencyWaitTime = n45;
        this.suspendTime = n46;
        this.syncTime = n47;
        this.resourceTime = n48;
        this.jobserverTime = n49;
        this.restartableTime = n50;
        this.childWaitTime = n51;
        this.opSusresTs = l28;
        this.npeId = l29;
        this.timeZone = string11;
        this.creatorUId = l30;
        this.createTs = l31;
        this.changerUId = l32;
        this.changeTs = l33;
        this.validFrom = l34;
        this.validTo = l35;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "SUBMITTED_ENTITY" + string3 + " (ID, " + string2 + "ACCESS_KEY" + string3 + ", " + string2 + "MASTER_ID" + string3 + ", " + string2 + "SUBMIT_TAG" + string3 + ", " + string2 + "UNRESOLVED_HANDLING" + string3 + ", " + string2 + "SE_ID" + string3 + ", " + string2 + "CHILD_TAG" + string3 + ", " + string2 + "SE_VERSION" + string3 + ", " + string2 + "OWNER_ID" + string3 + ", " + string2 + "PARENT_ID" + string3 + ", " + string2 + "SCOPE_ID" + string3 + ", " + string2 + "IS_STATIC" + string3 + ", " + string2 + "IS_DISABLED" + string3 + ", " + string2 + "OLD_STATE" + string3 + ", " + string2 + "MERGE_MODE" + string3 + ", " + string2 + "STATE" + string3 + ", " + string2 + "JOB_ESD_ID" + string3 + ", " + string2 + "JOB_ESD_PREF" + string3 + ", " + string2 + "JOB_IS_FINAL" + string3 + ", " + string2 + "JOB_IS_RESTARTABLE" + string3 + ", " + string2 + "FINAL_ESD_ID" + string3 + ", " + string2 + "EXIT_CODE" + string3 + ", " + string2 + "COMMANDLINE" + string3 + ", " + string2 + "RR_COMMANDLINE" + string3 + ", " + string2 + "RERUN_SEQ" + string3 + ", " + string2 + "IS_REPLACED" + string3 + ", " + string2 + "IS_CANCELLED" + string3 + ", " + string2 + "BASE_SME_ID" + string3 + ", " + string2 + "REASON_SME_ID" + string3 + ", " + string2 + "FIRE_SME_ID" + string3 + ", " + string2 + "FIRE_SE_ID" + string3 + ", " + string2 + "TR_ID" + string3 + ", " + string2 + "TR_SD_ID_OLD" + string3 + ", " + string2 + "TR_SD_ID_NEW" + string3 + ", " + string2 + "TR_SEQ" + string3 + ", " + string2 + "WORKDIR" + string3 + ", " + string2 + "LOGFILE" + string3 + ", " + string2 + "ERRLOGFILE" + string3 + ", " + string2 + "PID" + string3 + ", " + string2 + "EXTPID" + string3 + ", " + string2 + "ERROR_MSG" + string3 + ", " + string2 + "KILL_ID" + string3 + ", " + string2 + "KILL_EXIT_CODE" + string3 + ", " + string2 + "IS_SUSPENDED" + string3 + ", " + string2 + "IS_SUSPENDED_LOCAL" + string3 + ", " + string2 + "PRIORITY" + string3 + ", " + string2 + "RAW_PRIORITY" + string3 + ", " + string2 + "NICE" + string3 + ", " + string2 + "NP_NICE" + string3 + ", " + string2 + "MIN_PRIORITY" + string3 + ", " + string2 + "AGING_AMOUNT" + string3 + ", " + string2 + "PARENT_SUSPENDED" + string3 + ", " + string2 + "CHILD_SUSPENDED" + string3 + ", " + string2 + "WARN_COUNT" + string3 + ", " + string2 + "WARN_LINK" + string3 + ", " + string2 + "APPROVAL_MODE" + string3 + ", " + string2 + "CHILD_APPROVAL_MODE" + string3 + ", " + string2 + "SUBMIT_TS" + string3 + ", " + string2 + "RESUME_TS" + string3 + ", " + string2 + "SYNC_TS" + string3 + ", " + string2 + "RESOURCE_TS" + string3 + ", " + string2 + "RUNNABLE_TS" + string3 + ", " + string2 + "START_TS" + string3 + ", " + string2 + "FINSH_TS" + string3 + ", " + string2 + "FINAL_TS" + string3 + ", " + string2 + "CNT_SUBMITTED" + string3 + ", " + string2 + "CNT_DEPENDENCY_WAIT" + string3 + ", " + string2 + "CNT_SYNCHRONIZE_WAIT" + string3 + ", " + string2 + "CNT_RESOURCE_WAIT" + string3 + ", " + string2 + "CNT_RUNNABLE" + string3 + ", " + string2 + "CNT_STARTING" + string3 + ", " + string2 + "CNT_STARTED" + string3 + ", " + string2 + "CNT_RUNNING" + string3 + ", " + string2 + "CNT_TO_KILL" + string3 + ", " + string2 + "CNT_KILLED" + string3 + ", " + string2 + "CNT_CANCELLED" + string3 + ", " + string2 + "CNT_FINISHED" + string3 + ", " + string2 + "CNT_FINAL" + string3 + ", " + string2 + "CNT_BROKEN_ACTIVE" + string3 + ", " + string2 + "CNT_BROKEN_FINISHED" + string3 + ", " + string2 + "CNT_ERROR" + string3 + ", " + string2 + "CNT_UNREACHABLE" + string3 + ", " + string2 + "CNT_RESTARTABLE" + string3 + ", " + string2 + "CNT_WARN" + string3 + ", " + string2 + "CNT_PENDING" + string3 + ", " + string2 + "IDLE_TS" + string3 + ", " + string2 + "IDLE_TIME" + string3 + ", " + string2 + "STATISTIC_TS" + string3 + ", " + string2 + "DEPENDENCY_WAIT_TIME" + string3 + ", " + string2 + "SUSPEND_TIME" + string3 + ", " + string2 + "SYNC_TIME" + string3 + ", " + string2 + "RESOURCE_TIME" + string3 + ", " + string2 + "JOBSERVER_TIME" + string3 + ", " + string2 + "RESTARTABLE_TIME" + string3 + ", " + string2 + "CHILD_WAIT_TIME" + string3 + ", " + string2 + "OP_SUSRES_TS" + string3 + ", " + string2 + "NPE_ID" + string3 + ", " + string2 + "TIME_ZONE" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                SDMSSubmittedEntityGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "SubmittedEntity: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setLong(2, this.accessKey);
            preparedStatement.setLong(3, this.masterId);
            if (this.submitTag == null) {
                preparedStatement.setNull(4, 12);
            } else {
                preparedStatement.setString(4, this.submitTag);
            }
            if (this.unresolvedHandling == null) {
                preparedStatement.setNull(5, 4);
            } else {
                preparedStatement.setInt(5, this.unresolvedHandling);
            }
            preparedStatement.setLong(6, this.seId);
            if (this.childTag == null) {
                preparedStatement.setNull(7, 12);
            } else {
                preparedStatement.setString(7, this.childTag);
            }
            preparedStatement.setLong(8, this.seVersion);
            preparedStatement.setLong(9, this.ownerId);
            if (this.parentId == null) {
                preparedStatement.setNull(10, 4);
            } else {
                preparedStatement.setLong(10, this.parentId);
            }
            if (this.scopeId == null) {
                preparedStatement.setNull(11, 4);
            } else {
                preparedStatement.setLong(11, this.scopeId);
            }
            preparedStatement.setInt(12, this.isStatic != false ? 1 : 0);
            preparedStatement.setInt(13, this.isDisabled != false ? 1 : 0);
            if (this.oldState == null) {
                preparedStatement.setNull(14, 4);
            } else {
                preparedStatement.setInt(14, this.oldState);
            }
            preparedStatement.setInt(15, this.mergeMode);
            preparedStatement.setInt(16, this.state);
            if (this.jobEsdId == null) {
                preparedStatement.setNull(17, 4);
            } else {
                preparedStatement.setLong(17, this.jobEsdId);
            }
            if (this.jobEsdPref == null) {
                preparedStatement.setNull(18, 4);
            } else {
                preparedStatement.setInt(18, this.jobEsdPref);
            }
            preparedStatement.setInt(19, this.jobIsFinal != false ? 1 : 0);
            preparedStatement.setInt(20, this.jobIsRestartable != false ? 1 : 0);
            if (this.finalEsdId == null) {
                preparedStatement.setNull(21, 4);
            } else {
                preparedStatement.setLong(21, this.finalEsdId);
            }
            if (this.exitCode == null) {
                preparedStatement.setNull(22, 4);
            } else {
                preparedStatement.setInt(22, this.exitCode);
            }
            if (this.commandline == null) {
                preparedStatement.setNull(23, 12);
            } else {
                preparedStatement.setString(23, this.commandline);
            }
            if (this.rrCommandline == null) {
                preparedStatement.setNull(24, 12);
            } else {
                preparedStatement.setString(24, this.rrCommandline);
            }
            preparedStatement.setInt(25, this.rerunSeq);
            preparedStatement.setInt(26, this.isReplaced != false ? 1 : 0);
            if (this.isCancelled == null) {
                preparedStatement.setNull(27, 4);
            } else {
                preparedStatement.setInt(27, this.isCancelled != false ? 1 : 0);
            }
            if (this.baseSmeId == null) {
                preparedStatement.setNull(28, 4);
            } else {
                preparedStatement.setLong(28, this.baseSmeId);
            }
            if (this.reasonSmeId == null) {
                preparedStatement.setNull(29, 4);
            } else {
                preparedStatement.setLong(29, this.reasonSmeId);
            }
            if (this.fireSmeId == null) {
                preparedStatement.setNull(30, 4);
            } else {
                preparedStatement.setLong(30, this.fireSmeId);
            }
            if (this.fireSeId == null) {
                preparedStatement.setNull(31, 4);
            } else {
                preparedStatement.setLong(31, this.fireSeId);
            }
            if (this.trId == null) {
                preparedStatement.setNull(32, 4);
            } else {
                preparedStatement.setLong(32, this.trId);
            }
            if (this.trSdIdOld == null) {
                preparedStatement.setNull(33, 4);
            } else {
                preparedStatement.setLong(33, this.trSdIdOld);
            }
            if (this.trSdIdNew == null) {
                preparedStatement.setNull(34, 4);
            } else {
                preparedStatement.setLong(34, this.trSdIdNew);
            }
            preparedStatement.setInt(35, this.trSeq);
            if (this.workdir == null) {
                preparedStatement.setNull(36, 12);
            } else {
                preparedStatement.setString(36, this.workdir);
            }
            if (this.logfile == null) {
                preparedStatement.setNull(37, 12);
            } else {
                preparedStatement.setString(37, this.logfile);
            }
            if (this.errlogfile == null) {
                preparedStatement.setNull(38, 12);
            } else {
                preparedStatement.setString(38, this.errlogfile);
            }
            if (this.pid == null) {
                preparedStatement.setNull(39, 12);
            } else {
                preparedStatement.setString(39, this.pid);
            }
            if (this.extPid == null) {
                preparedStatement.setNull(40, 12);
            } else {
                preparedStatement.setString(40, this.extPid);
            }
            if (this.errorMsg == null) {
                preparedStatement.setNull(41, 12);
            } else {
                preparedStatement.setString(41, this.errorMsg);
            }
            if (this.killId == null) {
                preparedStatement.setNull(42, 4);
            } else {
                preparedStatement.setLong(42, this.killId);
            }
            if (this.killExitCode == null) {
                preparedStatement.setNull(43, 4);
            } else {
                preparedStatement.setInt(43, this.killExitCode);
            }
            preparedStatement.setInt(44, this.isSuspended);
            if (this.isSuspendedLocal == null) {
                preparedStatement.setNull(45, 4);
            } else {
                preparedStatement.setInt(45, this.isSuspendedLocal != false ? 1 : 0);
            }
            preparedStatement.setInt(46, this.priority);
            preparedStatement.setInt(47, this.rawPriority);
            preparedStatement.setInt(48, this.nice);
            preparedStatement.setInt(49, this.npNice);
            preparedStatement.setInt(50, this.minPriority);
            preparedStatement.setInt(51, this.agingAmount);
            preparedStatement.setInt(52, this.parentSuspended);
            preparedStatement.setInt(53, this.childSuspended);
            preparedStatement.setInt(54, this.warnCount);
            if (this.warnLink == null) {
                preparedStatement.setNull(55, 4);
            } else {
                preparedStatement.setLong(55, this.warnLink);
            }
            preparedStatement.setInt(56, this.approvalMode);
            preparedStatement.setInt(57, this.childApprovalMode);
            preparedStatement.setLong(58, this.submitTs);
            if (this.resumeTs == null) {
                preparedStatement.setNull(59, 4);
            } else {
                preparedStatement.setLong(59, this.resumeTs);
            }
            if (this.syncTs == null) {
                preparedStatement.setNull(60, 4);
            } else {
                preparedStatement.setLong(60, this.syncTs);
            }
            if (this.resourceTs == null) {
                preparedStatement.setNull(61, 4);
            } else {
                preparedStatement.setLong(61, this.resourceTs);
            }
            if (this.runnableTs == null) {
                preparedStatement.setNull(62, 4);
            } else {
                preparedStatement.setLong(62, this.runnableTs);
            }
            if (this.startTs == null) {
                preparedStatement.setNull(63, 4);
            } else {
                preparedStatement.setLong(63, this.startTs);
            }
            if (this.finishTs == null) {
                preparedStatement.setNull(64, 4);
            } else {
                preparedStatement.setLong(64, this.finishTs);
            }
            if (this.finalTs == null) {
                preparedStatement.setNull(65, 4);
            } else {
                preparedStatement.setLong(65, this.finalTs);
            }
            preparedStatement.setInt(66, this.cntSubmitted);
            preparedStatement.setInt(67, this.cntDependencyWait);
            preparedStatement.setInt(68, this.cntSynchronizeWait);
            preparedStatement.setInt(69, this.cntResourceWait);
            preparedStatement.setInt(70, this.cntRunnable);
            preparedStatement.setInt(71, this.cntStarting);
            preparedStatement.setInt(72, this.cntStarted);
            preparedStatement.setInt(73, this.cntRunning);
            preparedStatement.setInt(74, this.cntToKill);
            preparedStatement.setInt(75, this.cntKilled);
            preparedStatement.setInt(76, this.cntCancelled);
            preparedStatement.setInt(77, this.cntFinished);
            preparedStatement.setInt(78, this.cntFinal);
            preparedStatement.setInt(79, this.cntBrokenActive);
            preparedStatement.setInt(80, this.cntBrokenFinished);
            preparedStatement.setInt(81, this.cntError);
            preparedStatement.setInt(82, this.cntUnreachable);
            preparedStatement.setInt(83, this.cntRestartable);
            preparedStatement.setInt(84, this.cntWarn);
            preparedStatement.setInt(85, this.cntPending);
            if (this.idleTs == null) {
                preparedStatement.setNull(86, 4);
            } else {
                preparedStatement.setInt(86, this.idleTs);
            }
            if (this.idleTime == null) {
                preparedStatement.setNull(87, 4);
            } else {
                preparedStatement.setInt(87, this.idleTime);
            }
            if (this.statisticTs == null) {
                preparedStatement.setNull(88, 4);
            } else {
                preparedStatement.setInt(88, this.statisticTs);
            }
            if (this.dependencyWaitTime == null) {
                preparedStatement.setNull(89, 4);
            } else {
                preparedStatement.setInt(89, this.dependencyWaitTime);
            }
            if (this.suspendTime == null) {
                preparedStatement.setNull(90, 4);
            } else {
                preparedStatement.setInt(90, this.suspendTime);
            }
            if (this.syncTime == null) {
                preparedStatement.setNull(91, 4);
            } else {
                preparedStatement.setInt(91, this.syncTime);
            }
            if (this.resourceTime == null) {
                preparedStatement.setNull(92, 4);
            } else {
                preparedStatement.setInt(92, this.resourceTime);
            }
            if (this.jobserverTime == null) {
                preparedStatement.setNull(93, 4);
            } else {
                preparedStatement.setInt(93, this.jobserverTime);
            }
            if (this.restartableTime == null) {
                preparedStatement.setNull(94, 4);
            } else {
                preparedStatement.setInt(94, this.restartableTime);
            }
            if (this.childWaitTime == null) {
                preparedStatement.setNull(95, 4);
            } else {
                preparedStatement.setInt(95, this.childWaitTime);
            }
            if (this.opSusresTs == null) {
                preparedStatement.setNull(96, 4);
            } else {
                preparedStatement.setLong(96, this.opSusresTs);
            }
            if (this.npeId == null) {
                preparedStatement.setNull(97, 4);
            } else {
                preparedStatement.setLong(97, this.npeId);
            }
            if (this.timeZone == null) {
                preparedStatement.setNull(98, 12);
            } else {
                preparedStatement.setString(98, this.timeZone);
            }
            preparedStatement.setLong(99, this.creatorUId);
            preparedStatement.setLong(100, this.createTs);
            preparedStatement.setLong(101, this.changerUId);
            preparedStatement.setLong(102, this.changeTs);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "SubmittedEntity: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pDelete[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "DELETE FROM " + string2 + "SUBMITTED_ENTITY" + string3 + " WHERE ID = ?";
                SDMSSubmittedEntityGeneric.pDelete[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182001", "SubmittedEntity: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pDelete[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182002", "SubmittedEntity: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string2 + "SUBMITTED_ENTITY" + string3 + " SET " + string2 + "ACCESS_KEY" + string3 + " = ? , " + string2 + "MASTER_ID" + string3 + " = ? , " + string2 + "SUBMIT_TAG" + string3 + " = ? , " + string2 + "UNRESOLVED_HANDLING" + string3 + " = ? , " + string2 + "SE_ID" + string3 + " = ? , " + string2 + "CHILD_TAG" + string3 + " = ? , " + string2 + "SE_VERSION" + string3 + " = ? , " + string2 + "OWNER_ID" + string3 + " = ? , " + string2 + "PARENT_ID" + string3 + " = ? , " + string2 + "SCOPE_ID" + string3 + " = ? , " + string2 + "IS_STATIC" + string3 + " = ? , " + string2 + "IS_DISABLED" + string3 + " = ? , " + string2 + "OLD_STATE" + string3 + " = ? , " + string2 + "MERGE_MODE" + string3 + " = ? , " + string2 + "STATE" + string3 + " = ? , " + string2 + "JOB_ESD_ID" + string3 + " = ? , " + string2 + "JOB_ESD_PREF" + string3 + " = ? , " + string2 + "JOB_IS_FINAL" + string3 + " = ? , " + string2 + "JOB_IS_RESTARTABLE" + string3 + " = ? , " + string2 + "FINAL_ESD_ID" + string3 + " = ? , " + string2 + "EXIT_CODE" + string3 + " = ? , " + string2 + "COMMANDLINE" + string3 + " = ? , " + string2 + "RR_COMMANDLINE" + string3 + " = ? , " + string2 + "RERUN_SEQ" + string3 + " = ? , " + string2 + "IS_REPLACED" + string3 + " = ? , " + string2 + "IS_CANCELLED" + string3 + " = ? , " + string2 + "BASE_SME_ID" + string3 + " = ? , " + string2 + "REASON_SME_ID" + string3 + " = ? , " + string2 + "FIRE_SME_ID" + string3 + " = ? , " + string2 + "FIRE_SE_ID" + string3 + " = ? , " + string2 + "TR_ID" + string3 + " = ? , " + string2 + "TR_SD_ID_OLD" + string3 + " = ? , " + string2 + "TR_SD_ID_NEW" + string3 + " = ? , " + string2 + "TR_SEQ" + string3 + " = ? , " + string2 + "WORKDIR" + string3 + " = ? , " + string2 + "LOGFILE" + string3 + " = ? , " + string2 + "ERRLOGFILE" + string3 + " = ? , " + string2 + "PID" + string3 + " = ? , " + string2 + "EXTPID" + string3 + " = ? , " + string2 + "ERROR_MSG" + string3 + " = ? , " + string2 + "KILL_ID" + string3 + " = ? , " + string2 + "KILL_EXIT_CODE" + string3 + " = ? , " + string2 + "IS_SUSPENDED" + string3 + " = ? , " + string2 + "IS_SUSPENDED_LOCAL" + string3 + " = ? , " + string2 + "PRIORITY" + string3 + " = ? , " + string2 + "RAW_PRIORITY" + string3 + " = ? , " + string2 + "NICE" + string3 + " = ? , " + string2 + "NP_NICE" + string3 + " = ? , " + string2 + "MIN_PRIORITY" + string3 + " = ? , " + string2 + "AGING_AMOUNT" + string3 + " = ? , " + string2 + "PARENT_SUSPENDED" + string3 + " = ? , " + string2 + "CHILD_SUSPENDED" + string3 + " = ? , " + string2 + "WARN_COUNT" + string3 + " = ? , " + string2 + "WARN_LINK" + string3 + " = ? , " + string2 + "APPROVAL_MODE" + string3 + " = ? , " + string2 + "CHILD_APPROVAL_MODE" + string3 + " = ? , " + string2 + "SUBMIT_TS" + string3 + " = ? , " + string2 + "RESUME_TS" + string3 + " = ? , " + string2 + "SYNC_TS" + string3 + " = ? , " + string2 + "RESOURCE_TS" + string3 + " = ? , " + string2 + "RUNNABLE_TS" + string3 + " = ? , " + string2 + "START_TS" + string3 + " = ? , " + string2 + "FINSH_TS" + string3 + " = ? , " + string2 + "FINAL_TS" + string3 + " = ? , " + string2 + "CNT_SUBMITTED" + string3 + " = ? , " + string2 + "CNT_DEPENDENCY_WAIT" + string3 + " = ? , " + string2 + "CNT_SYNCHRONIZE_WAIT" + string3 + " = ? , " + string2 + "CNT_RESOURCE_WAIT" + string3 + " = ? , " + string2 + "CNT_RUNNABLE" + string3 + " = ? , " + string2 + "CNT_STARTING" + string3 + " = ? , " + string2 + "CNT_STARTED" + string3 + " = ? , " + string2 + "CNT_RUNNING" + string3 + " = ? , " + string2 + "CNT_TO_KILL" + string3 + " = ? , " + string2 + "CNT_KILLED" + string3 + " = ? , " + string2 + "CNT_CANCELLED" + string3 + " = ? , " + string2 + "CNT_FINISHED" + string3 + " = ? , " + string2 + "CNT_FINAL" + string3 + " = ? , " + string2 + "CNT_BROKEN_ACTIVE" + string3 + " = ? , " + string2 + "CNT_BROKEN_FINISHED" + string3 + " = ? , " + string2 + "CNT_ERROR" + string3 + " = ? , " + string2 + "CNT_UNREACHABLE" + string3 + " = ? , " + string2 + "CNT_RESTARTABLE" + string3 + " = ? , " + string2 + "CNT_WARN" + string3 + " = ? , " + string2 + "CNT_PENDING" + string3 + " = ? , " + string2 + "IDLE_TS" + string3 + " = ? , " + string2 + "IDLE_TIME" + string3 + " = ? , " + string2 + "STATISTIC_TS" + string3 + " = ? , " + string2 + "DEPENDENCY_WAIT_TIME" + string3 + " = ? , " + string2 + "SUSPEND_TIME" + string3 + " = ? , " + string2 + "SYNC_TIME" + string3 + " = ? , " + string2 + "RESOURCE_TIME" + string3 + " = ? , " + string2 + "JOBSERVER_TIME" + string3 + " = ? , " + string2 + "RESTARTABLE_TIME" + string3 + " = ? , " + string2 + "CHILD_WAIT_TIME" + string3 + " = ? , " + string2 + "OP_SUSRES_TS" + string3 + " = ? , " + string2 + "NPE_ID" + string3 + " = ? , " + string2 + "TIME_ZONE" + string3 + " = ? , " + string2 + "CREATOR_U_ID" + string3 + " = ? , " + string2 + "CREATE_TS" + string3 + " = ? , " + string2 + "CHANGER_U_ID" + string3 + " = ? , " + string2 + "CHANGE_TS" + string3 + " = ? WHERE ID = ?";
                SDMSSubmittedEntityGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182005", "SubmittedEntity: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.accessKey);
            preparedStatement.setLong(2, this.masterId);
            if (this.submitTag == null) {
                preparedStatement.setNull(3, 12);
            } else {
                preparedStatement.setString(3, this.submitTag);
            }
            if (this.unresolvedHandling == null) {
                preparedStatement.setNull(4, 4);
            } else {
                preparedStatement.setInt(4, this.unresolvedHandling);
            }
            preparedStatement.setLong(5, this.seId);
            if (this.childTag == null) {
                preparedStatement.setNull(6, 12);
            } else {
                preparedStatement.setString(6, this.childTag);
            }
            preparedStatement.setLong(7, this.seVersion);
            preparedStatement.setLong(8, this.ownerId);
            if (this.parentId == null) {
                preparedStatement.setNull(9, 4);
            } else {
                preparedStatement.setLong(9, this.parentId);
            }
            if (this.scopeId == null) {
                preparedStatement.setNull(10, 4);
            } else {
                preparedStatement.setLong(10, this.scopeId);
            }
            preparedStatement.setInt(11, this.isStatic != false ? 1 : 0);
            preparedStatement.setInt(12, this.isDisabled != false ? 1 : 0);
            if (this.oldState == null) {
                preparedStatement.setNull(13, 4);
            } else {
                preparedStatement.setInt(13, this.oldState);
            }
            preparedStatement.setInt(14, this.mergeMode);
            preparedStatement.setInt(15, this.state);
            if (this.jobEsdId == null) {
                preparedStatement.setNull(16, 4);
            } else {
                preparedStatement.setLong(16, this.jobEsdId);
            }
            if (this.jobEsdPref == null) {
                preparedStatement.setNull(17, 4);
            } else {
                preparedStatement.setInt(17, this.jobEsdPref);
            }
            preparedStatement.setInt(18, this.jobIsFinal != false ? 1 : 0);
            preparedStatement.setInt(19, this.jobIsRestartable != false ? 1 : 0);
            if (this.finalEsdId == null) {
                preparedStatement.setNull(20, 4);
            } else {
                preparedStatement.setLong(20, this.finalEsdId);
            }
            if (this.exitCode == null) {
                preparedStatement.setNull(21, 4);
            } else {
                preparedStatement.setInt(21, this.exitCode);
            }
            if (this.commandline == null) {
                preparedStatement.setNull(22, 12);
            } else {
                preparedStatement.setString(22, this.commandline);
            }
            if (this.rrCommandline == null) {
                preparedStatement.setNull(23, 12);
            } else {
                preparedStatement.setString(23, this.rrCommandline);
            }
            preparedStatement.setInt(24, this.rerunSeq);
            preparedStatement.setInt(25, this.isReplaced != false ? 1 : 0);
            if (this.isCancelled == null) {
                preparedStatement.setNull(26, 4);
            } else {
                preparedStatement.setInt(26, this.isCancelled != false ? 1 : 0);
            }
            if (this.baseSmeId == null) {
                preparedStatement.setNull(27, 4);
            } else {
                preparedStatement.setLong(27, this.baseSmeId);
            }
            if (this.reasonSmeId == null) {
                preparedStatement.setNull(28, 4);
            } else {
                preparedStatement.setLong(28, this.reasonSmeId);
            }
            if (this.fireSmeId == null) {
                preparedStatement.setNull(29, 4);
            } else {
                preparedStatement.setLong(29, this.fireSmeId);
            }
            if (this.fireSeId == null) {
                preparedStatement.setNull(30, 4);
            } else {
                preparedStatement.setLong(30, this.fireSeId);
            }
            if (this.trId == null) {
                preparedStatement.setNull(31, 4);
            } else {
                preparedStatement.setLong(31, this.trId);
            }
            if (this.trSdIdOld == null) {
                preparedStatement.setNull(32, 4);
            } else {
                preparedStatement.setLong(32, this.trSdIdOld);
            }
            if (this.trSdIdNew == null) {
                preparedStatement.setNull(33, 4);
            } else {
                preparedStatement.setLong(33, this.trSdIdNew);
            }
            preparedStatement.setInt(34, this.trSeq);
            if (this.workdir == null) {
                preparedStatement.setNull(35, 12);
            } else {
                preparedStatement.setString(35, this.workdir);
            }
            if (this.logfile == null) {
                preparedStatement.setNull(36, 12);
            } else {
                preparedStatement.setString(36, this.logfile);
            }
            if (this.errlogfile == null) {
                preparedStatement.setNull(37, 12);
            } else {
                preparedStatement.setString(37, this.errlogfile);
            }
            if (this.pid == null) {
                preparedStatement.setNull(38, 12);
            } else {
                preparedStatement.setString(38, this.pid);
            }
            if (this.extPid == null) {
                preparedStatement.setNull(39, 12);
            } else {
                preparedStatement.setString(39, this.extPid);
            }
            if (this.errorMsg == null) {
                preparedStatement.setNull(40, 12);
            } else {
                preparedStatement.setString(40, this.errorMsg);
            }
            if (this.killId == null) {
                preparedStatement.setNull(41, 4);
            } else {
                preparedStatement.setLong(41, this.killId);
            }
            if (this.killExitCode == null) {
                preparedStatement.setNull(42, 4);
            } else {
                preparedStatement.setInt(42, this.killExitCode);
            }
            preparedStatement.setInt(43, this.isSuspended);
            if (this.isSuspendedLocal == null) {
                preparedStatement.setNull(44, 4);
            } else {
                preparedStatement.setInt(44, this.isSuspendedLocal != false ? 1 : 0);
            }
            preparedStatement.setInt(45, this.priority);
            preparedStatement.setInt(46, this.rawPriority);
            preparedStatement.setInt(47, this.nice);
            preparedStatement.setInt(48, this.npNice);
            preparedStatement.setInt(49, this.minPriority);
            preparedStatement.setInt(50, this.agingAmount);
            preparedStatement.setInt(51, this.parentSuspended);
            preparedStatement.setInt(52, this.childSuspended);
            preparedStatement.setInt(53, this.warnCount);
            if (this.warnLink == null) {
                preparedStatement.setNull(54, 4);
            } else {
                preparedStatement.setLong(54, this.warnLink);
            }
            preparedStatement.setInt(55, this.approvalMode);
            preparedStatement.setInt(56, this.childApprovalMode);
            preparedStatement.setLong(57, this.submitTs);
            if (this.resumeTs == null) {
                preparedStatement.setNull(58, 4);
            } else {
                preparedStatement.setLong(58, this.resumeTs);
            }
            if (this.syncTs == null) {
                preparedStatement.setNull(59, 4);
            } else {
                preparedStatement.setLong(59, this.syncTs);
            }
            if (this.resourceTs == null) {
                preparedStatement.setNull(60, 4);
            } else {
                preparedStatement.setLong(60, this.resourceTs);
            }
            if (this.runnableTs == null) {
                preparedStatement.setNull(61, 4);
            } else {
                preparedStatement.setLong(61, this.runnableTs);
            }
            if (this.startTs == null) {
                preparedStatement.setNull(62, 4);
            } else {
                preparedStatement.setLong(62, this.startTs);
            }
            if (this.finishTs == null) {
                preparedStatement.setNull(63, 4);
            } else {
                preparedStatement.setLong(63, this.finishTs);
            }
            if (this.finalTs == null) {
                preparedStatement.setNull(64, 4);
            } else {
                preparedStatement.setLong(64, this.finalTs);
            }
            preparedStatement.setInt(65, this.cntSubmitted);
            preparedStatement.setInt(66, this.cntDependencyWait);
            preparedStatement.setInt(67, this.cntSynchronizeWait);
            preparedStatement.setInt(68, this.cntResourceWait);
            preparedStatement.setInt(69, this.cntRunnable);
            preparedStatement.setInt(70, this.cntStarting);
            preparedStatement.setInt(71, this.cntStarted);
            preparedStatement.setInt(72, this.cntRunning);
            preparedStatement.setInt(73, this.cntToKill);
            preparedStatement.setInt(74, this.cntKilled);
            preparedStatement.setInt(75, this.cntCancelled);
            preparedStatement.setInt(76, this.cntFinished);
            preparedStatement.setInt(77, this.cntFinal);
            preparedStatement.setInt(78, this.cntBrokenActive);
            preparedStatement.setInt(79, this.cntBrokenFinished);
            preparedStatement.setInt(80, this.cntError);
            preparedStatement.setInt(81, this.cntUnreachable);
            preparedStatement.setInt(82, this.cntRestartable);
            preparedStatement.setInt(83, this.cntWarn);
            preparedStatement.setInt(84, this.cntPending);
            if (this.idleTs == null) {
                preparedStatement.setNull(85, 4);
            } else {
                preparedStatement.setInt(85, this.idleTs);
            }
            if (this.idleTime == null) {
                preparedStatement.setNull(86, 4);
            } else {
                preparedStatement.setInt(86, this.idleTime);
            }
            if (this.statisticTs == null) {
                preparedStatement.setNull(87, 4);
            } else {
                preparedStatement.setInt(87, this.statisticTs);
            }
            if (this.dependencyWaitTime == null) {
                preparedStatement.setNull(88, 4);
            } else {
                preparedStatement.setInt(88, this.dependencyWaitTime);
            }
            if (this.suspendTime == null) {
                preparedStatement.setNull(89, 4);
            } else {
                preparedStatement.setInt(89, this.suspendTime);
            }
            if (this.syncTime == null) {
                preparedStatement.setNull(90, 4);
            } else {
                preparedStatement.setInt(90, this.syncTime);
            }
            if (this.resourceTime == null) {
                preparedStatement.setNull(91, 4);
            } else {
                preparedStatement.setInt(91, this.resourceTime);
            }
            if (this.jobserverTime == null) {
                preparedStatement.setNull(92, 4);
            } else {
                preparedStatement.setInt(92, this.jobserverTime);
            }
            if (this.restartableTime == null) {
                preparedStatement.setNull(93, 4);
            } else {
                preparedStatement.setInt(93, this.restartableTime);
            }
            if (this.childWaitTime == null) {
                preparedStatement.setNull(94, 4);
            } else {
                preparedStatement.setInt(94, this.childWaitTime);
            }
            if (this.opSusresTs == null) {
                preparedStatement.setNull(95, 4);
            } else {
                preparedStatement.setLong(95, this.opSusresTs);
            }
            if (this.npeId == null) {
                preparedStatement.setNull(96, 4);
            } else {
                preparedStatement.setLong(96, this.npeId);
            }
            if (this.timeZone == null) {
                preparedStatement.setNull(97, 12);
            } else {
                preparedStatement.setString(97, this.timeZone);
            }
            preparedStatement.setLong(98, this.creatorUId);
            preparedStatement.setLong(99, this.createTs);
            preparedStatement.setLong(100, this.changerUId);
            preparedStatement.setLong(101, this.changeTs);
            preparedStatement.setLong(102, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182006", "SubmittedEntity: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    public static boolean checkUnresolvedHandling(Integer n) {
        if (n == null) {
            return true;
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkMergeMode(Integer n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkState(Integer n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkIsSuspended(Integer n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : SubmittedEntity", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "accessKey : " + this.accessKey, 2);
        SDMSThread.doTrace(null, "masterId : " + this.masterId, 2);
        SDMSThread.doTrace(null, "submitTag : " + this.submitTag, 2);
        SDMSThread.doTrace(null, "unresolvedHandling : " + this.unresolvedHandling, 2);
        SDMSThread.doTrace(null, "seId : " + this.seId, 2);
        SDMSThread.doTrace(null, "childTag : " + this.childTag, 2);
        SDMSThread.doTrace(null, "seVersion : " + this.seVersion, 2);
        SDMSThread.doTrace(null, "ownerId : " + this.ownerId, 2);
        SDMSThread.doTrace(null, "parentId : " + this.parentId, 2);
        SDMSThread.doTrace(null, "scopeId : " + this.scopeId, 2);
        SDMSThread.doTrace(null, "isStatic : " + this.isStatic, 2);
        SDMSThread.doTrace(null, "isDisabled : " + this.isDisabled, 2);
        SDMSThread.doTrace(null, "oldState : " + this.oldState, 2);
        SDMSThread.doTrace(null, "mergeMode : " + this.mergeMode, 2);
        SDMSThread.doTrace(null, "state : " + this.state, 2);
        SDMSThread.doTrace(null, "jobEsdId : " + this.jobEsdId, 2);
        SDMSThread.doTrace(null, "jobEsdPref : " + this.jobEsdPref, 2);
        SDMSThread.doTrace(null, "jobIsFinal : " + this.jobIsFinal, 2);
        SDMSThread.doTrace(null, "jobIsRestartable : " + this.jobIsRestartable, 2);
        SDMSThread.doTrace(null, "finalEsdId : " + this.finalEsdId, 2);
        SDMSThread.doTrace(null, "exitCode : " + this.exitCode, 2);
        SDMSThread.doTrace(null, "commandline : " + this.commandline, 2);
        SDMSThread.doTrace(null, "rrCommandline : " + this.rrCommandline, 2);
        SDMSThread.doTrace(null, "rerunSeq : " + this.rerunSeq, 2);
        SDMSThread.doTrace(null, "isReplaced : " + this.isReplaced, 2);
        SDMSThread.doTrace(null, "isCancelled : " + this.isCancelled, 2);
        SDMSThread.doTrace(null, "baseSmeId : " + this.baseSmeId, 2);
        SDMSThread.doTrace(null, "reasonSmeId : " + this.reasonSmeId, 2);
        SDMSThread.doTrace(null, "fireSmeId : " + this.fireSmeId, 2);
        SDMSThread.doTrace(null, "fireSeId : " + this.fireSeId, 2);
        SDMSThread.doTrace(null, "trId : " + this.trId, 2);
        SDMSThread.doTrace(null, "trSdIdOld : " + this.trSdIdOld, 2);
        SDMSThread.doTrace(null, "trSdIdNew : " + this.trSdIdNew, 2);
        SDMSThread.doTrace(null, "trSeq : " + this.trSeq, 2);
        SDMSThread.doTrace(null, "workdir : " + this.workdir, 2);
        SDMSThread.doTrace(null, "logfile : " + this.logfile, 2);
        SDMSThread.doTrace(null, "errlogfile : " + this.errlogfile, 2);
        SDMSThread.doTrace(null, "pid : " + this.pid, 2);
        SDMSThread.doTrace(null, "extPid : " + this.extPid, 2);
        SDMSThread.doTrace(null, "errorMsg : " + this.errorMsg, 2);
        SDMSThread.doTrace(null, "killId : " + this.killId, 2);
        SDMSThread.doTrace(null, "killExitCode : " + this.killExitCode, 2);
        SDMSThread.doTrace(null, "isSuspended : " + this.isSuspended, 2);
        SDMSThread.doTrace(null, "isSuspendedLocal : " + this.isSuspendedLocal, 2);
        SDMSThread.doTrace(null, "priority : " + this.priority, 2);
        SDMSThread.doTrace(null, "rawPriority : " + this.rawPriority, 2);
        SDMSThread.doTrace(null, "nice : " + this.nice, 2);
        SDMSThread.doTrace(null, "npNice : " + this.npNice, 2);
        SDMSThread.doTrace(null, "minPriority : " + this.minPriority, 2);
        SDMSThread.doTrace(null, "agingAmount : " + this.agingAmount, 2);
        SDMSThread.doTrace(null, "parentSuspended : " + this.parentSuspended, 2);
        SDMSThread.doTrace(null, "childSuspended : " + this.childSuspended, 2);
        SDMSThread.doTrace(null, "warnCount : " + this.warnCount, 2);
        SDMSThread.doTrace(null, "warnLink : " + this.warnLink, 2);
        SDMSThread.doTrace(null, "approvalMode : " + this.approvalMode, 2);
        SDMSThread.doTrace(null, "childApprovalMode : " + this.childApprovalMode, 2);
        SDMSThread.doTrace(null, "submitTs : " + this.submitTs, 2);
        SDMSThread.doTrace(null, "resumeTs : " + this.resumeTs, 2);
        SDMSThread.doTrace(null, "syncTs : " + this.syncTs, 2);
        SDMSThread.doTrace(null, "resourceTs : " + this.resourceTs, 2);
        SDMSThread.doTrace(null, "runnableTs : " + this.runnableTs, 2);
        SDMSThread.doTrace(null, "startTs : " + this.startTs, 2);
        SDMSThread.doTrace(null, "finishTs : " + this.finishTs, 2);
        SDMSThread.doTrace(null, "finalTs : " + this.finalTs, 2);
        SDMSThread.doTrace(null, "cntSubmitted : " + this.cntSubmitted, 2);
        SDMSThread.doTrace(null, "cntDependencyWait : " + this.cntDependencyWait, 2);
        SDMSThread.doTrace(null, "cntSynchronizeWait : " + this.cntSynchronizeWait, 2);
        SDMSThread.doTrace(null, "cntResourceWait : " + this.cntResourceWait, 2);
        SDMSThread.doTrace(null, "cntRunnable : " + this.cntRunnable, 2);
        SDMSThread.doTrace(null, "cntStarting : " + this.cntStarting, 2);
        SDMSThread.doTrace(null, "cntStarted : " + this.cntStarted, 2);
        SDMSThread.doTrace(null, "cntRunning : " + this.cntRunning, 2);
        SDMSThread.doTrace(null, "cntToKill : " + this.cntToKill, 2);
        SDMSThread.doTrace(null, "cntKilled : " + this.cntKilled, 2);
        SDMSThread.doTrace(null, "cntCancelled : " + this.cntCancelled, 2);
        SDMSThread.doTrace(null, "cntFinished : " + this.cntFinished, 2);
        SDMSThread.doTrace(null, "cntFinal : " + this.cntFinal, 2);
        SDMSThread.doTrace(null, "cntBrokenActive : " + this.cntBrokenActive, 2);
        SDMSThread.doTrace(null, "cntBrokenFinished : " + this.cntBrokenFinished, 2);
        SDMSThread.doTrace(null, "cntError : " + this.cntError, 2);
        SDMSThread.doTrace(null, "cntUnreachable : " + this.cntUnreachable, 2);
        SDMSThread.doTrace(null, "cntRestartable : " + this.cntRestartable, 2);
        SDMSThread.doTrace(null, "cntWarn : " + this.cntWarn, 2);
        SDMSThread.doTrace(null, "cntPending : " + this.cntPending, 2);
        SDMSThread.doTrace(null, "idleTs : " + this.idleTs, 2);
        SDMSThread.doTrace(null, "idleTime : " + this.idleTime, 2);
        SDMSThread.doTrace(null, "statisticTs : " + this.statisticTs, 2);
        SDMSThread.doTrace(null, "dependencyWaitTime : " + this.dependencyWaitTime, 2);
        SDMSThread.doTrace(null, "suspendTime : " + this.suspendTime, 2);
        SDMSThread.doTrace(null, "syncTime : " + this.syncTime, 2);
        SDMSThread.doTrace(null, "resourceTime : " + this.resourceTime, 2);
        SDMSThread.doTrace(null, "jobserverTime : " + this.jobserverTime, 2);
        SDMSThread.doTrace(null, "restartableTime : " + this.restartableTime, 2);
        SDMSThread.doTrace(null, "childWaitTime : " + this.childWaitTime, 2);
        SDMSThread.doTrace(null, "opSusresTs : " + this.opSusresTs, 2);
        SDMSThread.doTrace(null, "npeId : " + this.npeId, 2);
        SDMSThread.doTrace(null, "timeZone : " + this.timeZone, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "accessKey          : " + this.accessKey + "\n" + string + "masterId           : " + this.masterId + "\n" + string + "submitTag          : " + this.submitTag + "\n" + string + "unresolvedHandling : " + this.unresolvedHandling + "\n" + string + "seId               : " + this.seId + "\n" + string + "childTag           : " + this.childTag + "\n" + string + "seVersion          : " + this.seVersion + "\n" + string + "ownerId            : " + this.ownerId + "\n" + string + "parentId           : " + this.parentId + "\n" + string + "scopeId            : " + this.scopeId + "\n" + string + "isStatic           : " + this.isStatic + "\n" + string + "isDisabled         : " + this.isDisabled + "\n" + string + "oldState           : " + this.oldState + "\n" + string + "mergeMode          : " + this.mergeMode + "\n" + string + "state              : " + this.state + "\n" + string + "jobEsdId           : " + this.jobEsdId + "\n" + string + "jobEsdPref         : " + this.jobEsdPref + "\n" + string + "jobIsFinal         : " + this.jobIsFinal + "\n" + string + "jobIsRestartable   : " + this.jobIsRestartable + "\n" + string + "finalEsdId         : " + this.finalEsdId + "\n" + string + "exitCode           : " + this.exitCode + "\n" + string + "commandline        : " + this.commandline + "\n" + string + "rrCommandline      : " + this.rrCommandline + "\n" + string + "rerunSeq           : " + this.rerunSeq + "\n" + string + "isReplaced         : " + this.isReplaced + "\n" + string + "isCancelled        : " + this.isCancelled + "\n" + string + "baseSmeId          : " + this.baseSmeId + "\n" + string + "reasonSmeId        : " + this.reasonSmeId + "\n" + string + "fireSmeId          : " + this.fireSmeId + "\n" + string + "fireSeId           : " + this.fireSeId + "\n" + string + "trId               : " + this.trId + "\n" + string + "trSdIdOld          : " + this.trSdIdOld + "\n" + string + "trSdIdNew          : " + this.trSdIdNew + "\n" + string + "trSeq              : " + this.trSeq + "\n" + string + "workdir            : " + this.workdir + "\n" + string + "logfile            : " + this.logfile + "\n" + string + "errlogfile         : " + this.errlogfile + "\n" + string + "pid                : " + this.pid + "\n" + string + "extPid             : " + this.extPid + "\n" + string + "errorMsg           : " + this.errorMsg + "\n" + string + "killId             : " + this.killId + "\n" + string + "killExitCode       : " + this.killExitCode + "\n" + string + "isSuspended        : " + this.isSuspended + "\n" + string + "isSuspendedLocal   : " + this.isSuspendedLocal + "\n" + string + "priority           : " + this.priority + "\n" + string + "rawPriority        : " + this.rawPriority + "\n" + string + "nice               : " + this.nice + "\n" + string + "npNice             : " + this.npNice + "\n" + string + "minPriority        : " + this.minPriority + "\n" + string + "agingAmount        : " + this.agingAmount + "\n" + string + "parentSuspended    : " + this.parentSuspended + "\n" + string + "childSuspended     : " + this.childSuspended + "\n" + string + "warnCount          : " + this.warnCount + "\n" + string + "warnLink           : " + this.warnLink + "\n" + string + "approvalMode       : " + this.approvalMode + "\n" + string + "childApprovalMode  : " + this.childApprovalMode + "\n" + string + "submitTs           : " + this.submitTs + "\n" + string + "resumeTs           : " + this.resumeTs + "\n" + string + "syncTs             : " + this.syncTs + "\n" + string + "resourceTs         : " + this.resourceTs + "\n" + string + "runnableTs         : " + this.runnableTs + "\n" + string + "startTs            : " + this.startTs + "\n" + string + "finishTs           : " + this.finishTs + "\n" + string + "finalTs            : " + this.finalTs + "\n" + string + "cntSubmitted       : " + this.cntSubmitted + "\n" + string + "cntDependencyWait  : " + this.cntDependencyWait + "\n" + string + "cntSynchronizeWait : " + this.cntSynchronizeWait + "\n" + string + "cntResourceWait    : " + this.cntResourceWait + "\n" + string + "cntRunnable        : " + this.cntRunnable + "\n" + string + "cntStarting        : " + this.cntStarting + "\n" + string + "cntStarted         : " + this.cntStarted + "\n" + string + "cntRunning         : " + this.cntRunning + "\n" + string + "cntToKill          : " + this.cntToKill + "\n" + string + "cntKilled          : " + this.cntKilled + "\n" + string + "cntCancelled       : " + this.cntCancelled + "\n" + string + "cntFinished        : " + this.cntFinished + "\n" + string + "cntFinal           : " + this.cntFinal + "\n" + string + "cntBrokenActive    : " + this.cntBrokenActive + "\n" + string + "cntBrokenFinished  : " + this.cntBrokenFinished + "\n" + string + "cntError           : " + this.cntError + "\n" + string + "cntUnreachable     : " + this.cntUnreachable + "\n" + string + "cntRestartable     : " + this.cntRestartable + "\n" + string + "cntWarn            : " + this.cntWarn + "\n" + string + "cntPending         : " + this.cntPending + "\n" + string + "idleTs             : " + this.idleTs + "\n" + string + "idleTime           : " + this.idleTime + "\n" + string + "statisticTs        : " + this.statisticTs + "\n" + string + "dependencyWaitTime : " + this.dependencyWaitTime + "\n" + string + "suspendTime        : " + this.suspendTime + "\n" + string + "syncTime           : " + this.syncTime + "\n" + string + "resourceTime       : " + this.resourceTime + "\n" + string + "jobserverTime      : " + this.jobserverTime + "\n" + string + "restartableTime    : " + this.restartableTime + "\n" + string + "childWaitTime      : " + this.childWaitTime + "\n" + string + "opSusresTs         : " + this.opSusresTs + "\n" + string + "npeId              : " + this.npeId + "\n" + string + "timeZone           : " + this.timeZone + "\n" + string + "creatorUId         : " + this.creatorUId + "\n" + string + "createTs           : " + this.createTs + "\n" + string + "changerUId         : " + this.changerUId + "\n" + string + "changeTs           : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

