/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSRepository;
import de.independit.scheduler.server.repository.SDMSSystemMessage;
import de.independit.scheduler.server.repository.SDMSSystemMessageGeneric;
import de.independit.scheduler.server.repository.SDMSSystemMessageTable;
import de.independit.scheduler.server.repository.SDMSTable;
import java.util.HashMap;
import java.util.Vector;

public class SDMSSystemMessageProxyGeneric
extends SDMSProxy {
    public static final int CANCEL = 1;
    public static final int RERUN = 2;
    public static final int ENABLE = 3;
    public static final int SET_STATE = 4;
    public static final int IGN_DEPENDENCY = 5;
    public static final int IGN_RESOURCE = 6;
    public static final int CLONE = 7;
    public static final int MODIFY_PARAMETER = 11;
    public static final int KILL = 12;
    public static final int SET_JOB_STATE = 13;
    public static final int DISABLE = 23;
    public static final int APPROVAL = 1;
    public static final long privilegeMask = 0x31111111BL;
    public static final int requestMsg_size = 512;
    public static final int comment_size = 1024;
    private static SDMSTable[] masterTables = null;

    protected SDMSSystemMessageProxyGeneric(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    protected static SDMSSystemMessage getProxy(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) {
        int n = SDMSSystemMessageTable.table.tableIndex;
        SDMSProxy sDMSProxy = SDMSRepository.getProxy(n);
        if (sDMSProxy == null) {
            sDMSProxy = new SDMSSystemMessage(sDMSObject);
        } else {
            sDMSProxy.initProxy(sDMSObject);
        }
        systemEnvironment.tx.addUsedProxy(n, sDMSProxy);
        return (SDMSSystemMessage)sDMSProxy;
    }

    public Integer getMsgType(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSystemMessageGeneric)this.object).getMsgType(systemEnvironment);
    }

    public String getMsgTypeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSystemMessageGeneric)this.object).getMsgTypeAsString(systemEnvironment);
    }

    public void setMsgType(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        this.touchMaster(systemEnvironment);
        ((SDMSSystemMessageGeneric)this.object).setMsgType(systemEnvironment, n);
    }

    public Long getSmeId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSystemMessageGeneric)this.object).getSmeId(systemEnvironment);
    }

    public void setSmeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        this.touchMaster(systemEnvironment);
        ((SDMSSystemMessageGeneric)this.object).setSmeId(systemEnvironment, l);
    }

    public Long getMasterId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSystemMessageGeneric)this.object).getMasterId(systemEnvironment);
    }

    public void setMasterId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        this.touchMaster(systemEnvironment);
        ((SDMSSystemMessageGeneric)this.object).setMasterId(systemEnvironment, l);
    }

    public Integer getOperation(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSystemMessageGeneric)this.object).getOperation(systemEnvironment);
    }

    public String getOperationAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSystemMessageGeneric)this.object).getOperationAsString(systemEnvironment);
    }

    public void setOperation(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        this.touchMaster(systemEnvironment);
        ((SDMSSystemMessageGeneric)this.object).setOperation(systemEnvironment, n);
    }

    public Boolean getIsMandatory(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSystemMessageGeneric)this.object).getIsMandatory(systemEnvironment);
    }

    public void setIsMandatory(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        this.checkWrite(systemEnvironment);
        this.touchMaster(systemEnvironment);
        ((SDMSSystemMessageGeneric)this.object).setIsMandatory(systemEnvironment, bl);
    }

    public Long getRequestUId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSystemMessageGeneric)this.object).getRequestUId(systemEnvironment);
    }

    public void setRequestUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        this.touchMaster(systemEnvironment);
        ((SDMSSystemMessageGeneric)this.object).setRequestUId(systemEnvironment, l);
    }

    public Long getRequestTs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSystemMessageGeneric)this.object).getRequestTs(systemEnvironment);
    }

    public void setRequestTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        this.touchMaster(systemEnvironment);
        ((SDMSSystemMessageGeneric)this.object).setRequestTs(systemEnvironment, l);
    }

    public String getRequestMsg(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSystemMessageGeneric)this.object).getRequestMsg(systemEnvironment);
    }

    public void setRequestMsg(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        this.checkWrite(systemEnvironment);
        this.touchMaster(systemEnvironment);
        ((SDMSSystemMessageGeneric)this.object).setRequestMsg(systemEnvironment, string);
    }

    public static int getRequestMsgMaxLength() {
        return 512;
    }

    public Long getAdditionalLong(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSystemMessageGeneric)this.object).getAdditionalLong(systemEnvironment);
    }

    public void setAdditionalLong(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        this.touchMaster(systemEnvironment);
        ((SDMSSystemMessageGeneric)this.object).setAdditionalLong(systemEnvironment, l);
    }

    public Boolean getAdditionalBool(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSystemMessageGeneric)this.object).getAdditionalBool(systemEnvironment);
    }

    public void setAdditionalBool(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        this.checkWrite(systemEnvironment);
        this.touchMaster(systemEnvironment);
        ((SDMSSystemMessageGeneric)this.object).setAdditionalBool(systemEnvironment, bl);
    }

    public Long getSecondLong(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSystemMessageGeneric)this.object).getSecondLong(systemEnvironment);
    }

    public void setSecondLong(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        this.touchMaster(systemEnvironment);
        ((SDMSSystemMessageGeneric)this.object).setSecondLong(systemEnvironment, l);
    }

    public String getComment(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSystemMessageGeneric)this.object).getComment(systemEnvironment);
    }

    public void setComment(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        this.checkWrite(systemEnvironment);
        this.touchMaster(systemEnvironment);
        ((SDMSSystemMessageGeneric)this.object).setComment(systemEnvironment, string);
    }

    public static int getCommentMaxLength() {
        return 1024;
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSystemMessageGeneric)this.object).getCreatorUId(systemEnvironment);
    }

    private void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        this.touchMaster(systemEnvironment);
        ((SDMSSystemMessageGeneric)this.object).setCreatorUId(systemEnvironment, l);
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSystemMessageGeneric)this.object).getCreateTs(systemEnvironment);
    }

    private void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        this.touchMaster(systemEnvironment);
        ((SDMSSystemMessageGeneric)this.object).setCreateTs(systemEnvironment, l);
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSystemMessageGeneric)this.object).getChangerUId(systemEnvironment);
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        this.touchMaster(systemEnvironment);
        ((SDMSSystemMessageGeneric)this.object).setChangerUId(systemEnvironment, l);
    }

    protected SDMSSystemMessage setChangerUIdNoCheck(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        this.touchMaster(systemEnvironment);
        ((SDMSSystemMessageGeneric)this.object).setChangerUId(systemEnvironment, l);
        return (SDMSSystemMessage)this;
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSSystemMessageGeneric)this.object).getChangeTs(systemEnvironment);
    }

    private void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        this.touchMaster(systemEnvironment);
        ((SDMSSystemMessageGeneric)this.object).setChangeTs(systemEnvironment, l);
    }

    protected SDMSSystemMessage setChangeTsNoCheck(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        this.touchMaster(systemEnvironment);
        ((SDMSSystemMessageGeneric)this.object).setChangeTs(systemEnvironment, l);
        return (SDMSSystemMessage)this;
    }

    @Override
    public SDMSKey getSortKey(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSKey sDMSKey = null;
        Long l = this.getId(systemEnvironment);
        if (systemEnvironment.tx.sortKeyMap == null) {
            systemEnvironment.tx.sortKeyMap = new HashMap();
        } else {
            sDMSKey = (SDMSKey)systemEnvironment.tx.sortKeyMap.get(l);
        }
        if (sDMSKey != null) {
            return sDMSKey;
        }
        boolean bl = false;
        sDMSKey = new SDMSKey();
        sDMSKey.add(this.getRequestTs(systemEnvironment));
        systemEnvironment.tx.sortKeyMap.put(l, sDMSKey);
        return sDMSKey;
    }

    @Override
    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        this.touchMaster(systemEnvironment);
        super.delete(systemEnvironment);
    }

    @Override
    public final boolean checkPrivileges(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        return (this.getPrivileges(systemEnvironment, l, true, null) & l) == l;
    }

    @Override
    public long getPrivilegeMask() {
        return 0x31111111BL;
    }

    @Override
    public final SDMSPrivilege getPrivileges(SystemEnvironment systemEnvironment) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 0x31111111BL, false, null));
    }

    @Override
    public final SDMSPrivilege getPrivilegesForGroups(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 0x31111111BL, false, vector));
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector) throws SDMSException {
        if (vector == null) {
            Vector vector2 = new Vector();
        } else {
            Vector vector3 = vector;
        }
        long l2 = 0L;
        l2 = l;
        SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SUBMITTED_ENTITY");
        try {
            SDMSProxy sDMSProxy = sDMSTable.get(systemEnvironment, this.getSmeId(systemEnvironment));
            long l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x31111111BL, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l2 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return l2;
    }

    @Override
    public SDMSMessage accessViolationMessage(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        SDMSMessage sDMSMessage = new SDMSMessage(systemEnvironment, string, "Insufficient privileges accessing SystemMessage $1", this.getId(systemEnvironment));
        return sDMSMessage;
    }

    void touchMaster(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SUBMITTED_ENTITY");
        try {
            SDMSProxy sDMSProxy = sDMSTable.get(systemEnvironment, this.getSmeId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Override
    protected void touch(SystemEnvironment systemEnvironment) throws SDMSException {
        this.setChangerUIdNoCheck(systemEnvironment, systemEnvironment.cEnv.uid());
        this.setChangeTsNoCheck(systemEnvironment, systemEnvironment.txTime());
    }

    public void print() {
        ((SDMSSystemMessageGeneric)this.object).print();
    }
}

