/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSSystemMessage;
import de.independit.scheduler.server.repository.SDMSSystemMessageGeneric;
import de.independit.scheduler.server.repository.SDMSSystemMessageTable;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSSystemMessageTableGeneric
extends SDMSTable {
    public static final String tableName = "SYSTEM_MESSAGE";
    public static SDMSSystemMessageTable table = null;
    public static final String[] columnNames = new String[]{"ID", "MSG_TYPE", "SME_ID", "MASTER_ID", "OPERATION", "IS_MANDATORY", "REQUEST_U_ID", "REQUEST_TS", "REQUEST_MSG", "ADDITIONAL_LONG", "ADDITIONAL_BOOL", "SECOND_LONG", "COMMENT", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_smeId;
    public static SDMSIndex idx_masterId;

    public SDMSSystemMessageTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "SystemMessage"));
        }
        table = (SDMSSystemMessageTable)this;
        table = (SDMSSystemMessageTable)this;
        this.isVersioned = false;
        idx_smeId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "smeId");
        idx_masterId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "masterId");
    }

    public SDMSSystemMessage create(SystemEnvironment systemEnvironment, Integer n, Long l, Long l2, Integer n2, Boolean bl, Long l3, Long l4, String string, Long l5, Boolean bl2, Long l6, String string2) throws SDMSException {
        SDMSSystemMessage sDMSSystemMessage;
        Long l7 = systemEnvironment.cEnv.uid();
        Long l8 = systemEnvironment.txTime();
        Long l9 = systemEnvironment.cEnv.uid();
        Long l10 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "SystemMessage"));
        }
        this.validate(systemEnvironment, n, l, l2, n2, bl, l3, l4, string, l5, bl2, l6, string2, l7, l8, l9, l10);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSSystemMessageGeneric sDMSSystemMessageGeneric = new SDMSSystemMessageGeneric(systemEnvironment, n, l, l2, n2, bl, l3, l4, string, l5, bl2, l6, string2, l7, l8, l9, l10);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSSystemMessageGeneric.versions, true);
            table.put(systemEnvironment, sDMSSystemMessageGeneric.id, sDMSSystemMessageGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSSystemMessage = (SDMSSystemMessage)sDMSSystemMessageGeneric.toProxy(systemEnvironment);
            sDMSSystemMessage.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSSystemMessage sDMSSystemMessage2 = (SDMSSystemMessage)sDMSSystemMessageGeneric.toProxy(systemEnvironment);
            sDMSSystemMessage2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSSystemMessage)) {
            throw new AccessViolationException(sDMSSystemMessage.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSSystemMessage.touchMaster(systemEnvironment);
        return sDMSSystemMessage;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSSystemMessage sDMSSystemMessage) throws SDMSException {
        return true;
    }

    protected void validate(SystemEnvironment systemEnvironment, Integer n, Long l, Long l2, Integer n2, Boolean bl, Long l3, Long l4, String string, Long l5, Boolean bl2, Long l6, String string2, Long l7, Long l8, Long l9, Long l10) throws SDMSException {
        if (!SDMSSystemMessageGeneric.checkMsgType(n)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "SystemMessage: $1 $2", "msgType", n));
        }
        if (!SDMSSystemMessageGeneric.checkOperation(n2)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "SystemMessage: $1 $2", "operation", n2));
        }
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        String string;
        Long l7;
        Boolean bl;
        Long l8;
        String string2;
        Long l9;
        Long l10;
        Boolean bl2;
        Integer n;
        Long l11;
        Long l12;
        Integer n2;
        Long l13;
        try {
            l13 = resultSet.getLong(1);
            n2 = resultSet.getInt(2);
            l12 = resultSet.getLong(3);
            l11 = resultSet.getLong(4);
            n = resultSet.getInt(5);
            bl2 = resultSet.getInt(6) != 0;
            l10 = resultSet.getLong(7);
            l9 = resultSet.getLong(8);
            string2 = resultSet.getString(9);
            if (resultSet.wasNull()) {
                string2 = null;
            }
            l8 = resultSet.getLong(10);
            if (resultSet.wasNull()) {
                l8 = null;
            }
            bl = resultSet.getInt(11) != 0;
            if (resultSet.wasNull()) {
                bl = null;
            }
            l7 = resultSet.getLong(12);
            if (resultSet.wasNull()) {
                l7 = null;
            }
            string = resultSet.getString(13);
            if (resultSet.wasNull()) {
                string = null;
            }
            l6 = resultSet.getLong(14);
            l5 = resultSet.getLong(15);
            l4 = resultSet.getLong(16);
            l3 = resultSet.getLong(17);
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "SystemMessage: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSSystemMessageGeneric(l13, n2, l12, l11, n, bl2, l10, l9, string2, l8, bl, l7, string, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "MSG_TYPE" + string2 + ", " + string + "SME_ID" + string2 + ", " + string + "MASTER_ID" + string2 + ", " + string + "OPERATION" + string2 + ", " + string + "IS_MANDATORY" + string2 + ", " + string + "REQUEST_U_ID" + string2 + ", " + string + "REQUEST_TS" + string2 + ", " + string + "REQUEST_MSG" + string2 + ", " + string + "ADDITIONAL_LONG" + string2 + ", " + string + "ADDITIONAL_BOOL" + string2 + ", " + string + "SECOND_LONG" + string2 + ", " + string + "COMMENT" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2 + "");
        while (resultSet.next()) {
            try {
                if (this.loadObject(systemEnvironment, resultSet)) {
                    ++n2;
                }
                ++n;
            }
            catch (Exception exception) {
                SDMSThread.doTrace(null, "Exception caught while loading table " + this.tableName() + ", ID = " + Long.valueOf(resultSet.getLong(1)), -1);
                throw exception;
            }
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_smeId.check(((SDMSSystemMessageGeneric)sDMSObject).smeId, sDMSObject);
        string = string + "idx_smeId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_masterId.check(((SDMSSystemMessageGeneric)sDMSObject).masterId, sDMSObject);
        string = string + "idx_masterId: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_smeId.put(systemEnvironment, ((SDMSSystemMessageGeneric)sDMSObject).smeId, sDMSObject, (1L & l) != 0L);
        idx_masterId.put(systemEnvironment, ((SDMSSystemMessageGeneric)sDMSObject).masterId, sDMSObject, (2L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_smeId.remove(systemEnvironment, ((SDMSSystemMessageGeneric)sDMSObject).smeId, sDMSObject);
        idx_masterId.remove(systemEnvironment, ((SDMSSystemMessageGeneric)sDMSObject).masterId, sDMSObject);
    }

    public static SDMSSystemMessage getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSSystemMessage)table.get(systemEnvironment, l);
    }

    public static SDMSSystemMessage getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSSystemMessage)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSSystemMessage getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSSystemMessage)table.get(systemEnvironment, l, l2);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

