/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.repository.SDMSTemplateVariable;
import de.independit.scheduler.server.repository.SDMSTemplateVariableGeneric;
import de.independit.scheduler.server.repository.SDMSTemplateVariableTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSTemplateVariableTableGeneric
extends SDMSTable {
    public static final String tableName = "TEMPLATE_VARIABLE";
    public static SDMSTemplateVariableTable table = null;
    public static final String[] columnNames = new String[]{"ID", "PD_ID", "RT_ID", "VALUE", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_pdId;
    public static SDMSIndex idx_rtId;
    public static SDMSIndex idx_pdId_rtId;

    public SDMSTemplateVariableTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "TemplateVariable"));
        }
        table = (SDMSTemplateVariableTable)this;
        table = (SDMSTemplateVariableTable)this;
        this.isVersioned = true;
        idx_pdId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "pdId");
        idx_rtId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "rtId");
        idx_pdId_rtId = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "pdId_rtId");
    }

    public SDMSTemplateVariable create(SystemEnvironment systemEnvironment, Long l, Long l2, String string) throws SDMSException {
        SDMSTemplateVariable sDMSTemplateVariable;
        Long l3 = systemEnvironment.cEnv.uid();
        Long l4 = systemEnvironment.txTime();
        Long l5 = systemEnvironment.cEnv.uid();
        Long l6 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "TemplateVariable"));
        }
        this.validate(systemEnvironment, l, l2, string, l3, l4, l5, l6);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSTemplateVariableGeneric sDMSTemplateVariableGeneric = new SDMSTemplateVariableGeneric(systemEnvironment, l, l2, string, l3, l4, l5, l6);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSTemplateVariableGeneric.versions, true);
            table.put(systemEnvironment, sDMSTemplateVariableGeneric.id, sDMSTemplateVariableGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSTemplateVariable = (SDMSTemplateVariable)sDMSTemplateVariableGeneric.toProxy(systemEnvironment);
            sDMSTemplateVariable.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSTemplateVariable sDMSTemplateVariable2 = (SDMSTemplateVariable)sDMSTemplateVariableGeneric.toProxy(systemEnvironment);
            sDMSTemplateVariable2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSTemplateVariable)) {
            throw new AccessViolationException(sDMSTemplateVariable.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSTemplateVariable.touchMaster(systemEnvironment);
        return sDMSTemplateVariable;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSTemplateVariable sDMSTemplateVariable) throws SDMSException {
        return sDMSTemplateVariable.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Long l2, String string, Long l3, Long l4, Long l5, Long l6) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        String string;
        Long l7;
        Long l8;
        Long l9;
        try {
            l9 = resultSet.getLong(1);
            l8 = resultSet.getLong(2);
            l7 = resultSet.getLong(3);
            string = resultSet.getString(4);
            l6 = resultSet.getLong(5);
            l5 = resultSet.getLong(6);
            l4 = resultSet.getLong(7);
            l3 = resultSet.getLong(8);
            l2 = resultSet.getLong(9);
            l = resultSet.getLong(10);
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "TemplateVariable: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSTemplateVariableGeneric(l9, l8, l7, string, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "PD_ID" + string2 + ", " + string + "RT_ID" + string2 + ", " + string + "VALUE" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + ", VALID_FROM, VALID_TO  FROM " + string + this.tableName() + string2 + " WHERE VALID_TO >= " + (bl ? "CAST ('" + systemEnvironment.lowestActiveVersion + "' AS DECIMAL)" : "" + systemEnvironment.lowestActiveVersion) + "");
        while (resultSet.next()) {
            try {
                if (this.loadObject(systemEnvironment, resultSet)) {
                    ++n2;
                }
                ++n;
            }
            catch (Exception exception) {
                SDMSThread.doTrace(null, "Exception caught while loading table " + this.tableName() + ", ID = " + Long.valueOf(resultSet.getLong(1)), -1);
                throw exception;
            }
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_pdId.check(((SDMSTemplateVariableGeneric)sDMSObject).pdId, sDMSObject);
        string = string + "idx_pdId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_rtId.check(((SDMSTemplateVariableGeneric)sDMSObject).rtId, sDMSObject);
        string = string + "idx_rtId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSTemplateVariableGeneric)sDMSObject).pdId);
        sDMSKey.add(((SDMSTemplateVariableGeneric)sDMSObject).rtId);
        bl = idx_pdId_rtId.check(sDMSKey, sDMSObject);
        string = string + "idx_pdId_rtId: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_pdId.put(systemEnvironment, ((SDMSTemplateVariableGeneric)sDMSObject).pdId, sDMSObject, (1L & l) != 0L);
        idx_rtId.put(systemEnvironment, ((SDMSTemplateVariableGeneric)sDMSObject).rtId, sDMSObject, (2L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSTemplateVariableGeneric)sDMSObject).pdId);
        sDMSKey.add(((SDMSTemplateVariableGeneric)sDMSObject).rtId);
        idx_pdId_rtId.put(systemEnvironment, sDMSKey, sDMSObject, (4L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_pdId.remove(systemEnvironment, ((SDMSTemplateVariableGeneric)sDMSObject).pdId, sDMSObject);
        idx_rtId.remove(systemEnvironment, ((SDMSTemplateVariableGeneric)sDMSObject).rtId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSTemplateVariableGeneric)sDMSObject).pdId);
        sDMSKey.add(((SDMSTemplateVariableGeneric)sDMSObject).rtId);
        idx_pdId_rtId.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSTemplateVariable getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSTemplateVariable)table.get(systemEnvironment, l);
    }

    public static SDMSTemplateVariable getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSTemplateVariable)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSTemplateVariable getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSTemplateVariable)table.get(systemEnvironment, l, l2);
    }

    public static SDMSTemplateVariable idx_pdId_rtId_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSTemplateVariable)idx_pdId_rtId.getUnique(systemEnvironment, object);
    }

    public static SDMSTemplateVariable idx_pdId_rtId_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSTemplateVariable)idx_pdId_rtId.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSTemplateVariable idx_pdId_rtId_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSTemplateVariable)idx_pdId_rtId.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

