/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.repository.SDMSUserExtents;
import de.independit.scheduler.server.repository.SDMSUserExtentsGeneric;
import de.independit.scheduler.server.repository.SDMSUserExtentsTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSUserExtentsTableGeneric
extends SDMSTable {
    public static final String tableName = "USER_EXTENTS";
    public static SDMSUserExtentsTable table = null;
    public static final String[] columnNames = new String[]{"ID", "UP_ID", "SEQUENCE", "EXTENT", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_upId;

    public SDMSUserExtentsTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "UserExtents"));
        }
        table = (SDMSUserExtentsTable)this;
        table = (SDMSUserExtentsTable)this;
        this.isVersioned = false;
        idx_upId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "upId");
    }

    public SDMSUserExtents create(SystemEnvironment systemEnvironment, Long l, Integer n, String string) throws SDMSException {
        SDMSUserExtents sDMSUserExtents;
        Long l2 = systemEnvironment.cEnv.uid();
        Long l3 = systemEnvironment.txTime();
        Long l4 = systemEnvironment.cEnv.uid();
        Long l5 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "UserExtents"));
        }
        this.validate(systemEnvironment, l, n, string, l2, l3, l4, l5);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSUserExtentsGeneric sDMSUserExtentsGeneric = new SDMSUserExtentsGeneric(systemEnvironment, l, n, string, l2, l3, l4, l5);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSUserExtentsGeneric.versions, true);
            table.put(systemEnvironment, sDMSUserExtentsGeneric.id, sDMSUserExtentsGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSUserExtents = (SDMSUserExtents)sDMSUserExtentsGeneric.toProxy(systemEnvironment);
            sDMSUserExtents.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSUserExtents sDMSUserExtents2 = (SDMSUserExtents)sDMSUserExtentsGeneric.toProxy(systemEnvironment);
            sDMSUserExtents2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSUserExtents)) {
            throw new AccessViolationException(sDMSUserExtents.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        return sDMSUserExtents;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSUserExtents sDMSUserExtents) throws SDMSException {
        return true;
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Integer n, String string, Long l2, Long l3, Long l4, Long l5) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        String string;
        Integer n;
        Long l7;
        Long l8;
        try {
            l8 = resultSet.getLong(1);
            l7 = resultSet.getLong(2);
            n = resultSet.getInt(3);
            string = resultSet.getString(4);
            l6 = resultSet.getLong(5);
            l5 = resultSet.getLong(6);
            l4 = resultSet.getLong(7);
            l3 = resultSet.getLong(8);
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "UserExtents: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSUserExtentsGeneric(l8, l7, n, string, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "UP_ID" + string2 + ", " + string + "SEQUENCE" + string2 + ", " + string + "EXTENT" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2 + "");
        while (resultSet.next()) {
            try {
                if (this.loadObject(systemEnvironment, resultSet)) {
                    ++n2;
                }
                ++n;
            }
            catch (Exception exception) {
                SDMSThread.doTrace(null, "Exception caught while loading table " + this.tableName() + ", ID = " + Long.valueOf(resultSet.getLong(1)), -1);
                throw exception;
            }
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_upId.check(((SDMSUserExtentsGeneric)sDMSObject).upId, sDMSObject);
        string = string + "idx_upId: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_upId.put(systemEnvironment, ((SDMSUserExtentsGeneric)sDMSObject).upId, sDMSObject, (1L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_upId.remove(systemEnvironment, ((SDMSUserExtentsGeneric)sDMSObject).upId, sDMSObject);
    }

    public static SDMSUserExtents getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSUserExtents)table.get(systemEnvironment, l);
    }

    public static SDMSUserExtents getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSUserExtents)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSUserExtents getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSUserExtents)table.get(systemEnvironment, l, l2);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

