/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSPurgeSet;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.repository.SDMSTransaction;
import de.independit.scheduler.server.util.SDMSThread;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public class SDMSVersions {
    public static final String __version = "@(#) $Id: SDMSVersions.java,v 2.8.2.2 2013/07/30 07:49:09 dieter Exp $";
    Vector versions;
    public LinkedList o_v;
    public SDMSTransaction tx;
    SDMSTable table;
    public Long id;
    public static final String STAT_VERSION_COUNT = "VERSION_COUNT";
    public static final String STAT_LOW_VERSION = "LOW_VERSION";

    protected SDMSVersions(SDMSTable sDMSTable, Long l) {
        this.id = l;
        this.versions = new Vector();
        this.o_v = null;
        this.tx = null;
        this.table = sDMSTable;
    }

    protected void flush(SystemEnvironment systemEnvironment, boolean bl) throws SDMSException {
        if (systemEnvironment.tx.versionId == -1L) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03110181544", "Cannot flush without transaction versionId"));
        }
        if (this.o_v == null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "02110261539", "Cannot flush an unchanged versions"));
        }
        if (this.o_v.size() == 0) {
            return;
        }
        SDMSObject sDMSObject = (SDMSObject)this.o_v.getFirst();
        if (bl) {
            if (!sDMSObject.isCurrent) {
                return;
            }
            if (!sDMSObject.isDeleted) {
                sDMSObject.insertDBObject(systemEnvironment);
            }
        } else if (!sDMSObject.isDeleted) {
            sDMSObject.updateDBObject(systemEnvironment, (SDMSObject)this.versions.lastElement());
        } else if (!sDMSObject.memOnly) {
            ((SDMSObject)this.versions.lastElement()).deleteDBObject(systemEnvironment);
        }
    }

    protected synchronized void commitOrRollback(SystemEnvironment systemEnvironment, long l, boolean bl, boolean bl2) throws SDMSException {
        SDMSPurgeSet sDMSPurgeSet;
        if (this.o_v == null) {
            return;
        }
        long l2 = systemEnvironment.roTxList.first(systemEnvironment);
        if (this.table.getIsVersioned()) {
            long l3 = systemEnvironment.seVersionList.first(systemEnvironment);
            if (l3 < l2) {
                l2 = l3;
            }
            sDMSPurgeSet = systemEnvironment.vPurgeSet;
        } else {
            sDMSPurgeSet = systemEnvironment.nvPurgeSet;
        }
        if (this.o_v.size() == 0) {
            this.tx = null;
            this.o_v = null;
            sDMSPurgeSet.add(systemEnvironment, this);
            return;
        }
        SDMSObject sDMSObject = (SDMSObject)this.o_v.getFirst();
        int n = this.versions.size();
        if (bl2) {
            if (!bl) {
                if (n == 0) {
                    throw new FatalException(new SDMSMessage(systemEnvironment, "03110181545", "Cannot update or delete commit empty versions"));
                }
                ((SDMSObject)this.versions.lastElement()).validTo = l;
            }
            if (!sDMSObject.isDeleted) {
                sDMSObject.validFrom = l;
                sDMSObject.validTo = Long.MAX_VALUE;
                this.versions.addElement(sDMSObject);
            }
            if ((n = this.versions.size()) > 1 || n == 1 && ((SDMSObject)this.versions.lastElement()).validTo != Long.MAX_VALUE) {
                sDMSPurgeSet.add(systemEnvironment, this);
            }
        } else {
            sDMSObject.isCurrent = false;
            if (!sDMSObject.isDeleted) {
                this.table.unIndex(systemEnvironment, sDMSObject);
            }
            if (!bl) {
                if (n == 0) {
                    throw new FatalException(new SDMSMessage(systemEnvironment, "03111021305", "Cannot update or delete rollback empty versions"));
                }
                ((SDMSObject)this.versions.lastElement()).isCurrent = true;
            }
            sDMSPurgeSet.add(systemEnvironment, this);
        }
        this.tx = null;
        this.o_v = null;
    }

    protected void add(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        int n;
        if (!this.id.equals(sDMSObject.id)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03110181546", "versions id ( $1 ) does not match objects id ( $2 )", this.id, sDMSObject.id));
        }
        for (n = this.versions.size() - 1; n >= 0 && ((SDMSObject)this.versions.elementAt((int)n)).validTo > sDMSObject.validFrom; --n) {
        }
        this.versions.insertElementAt(sDMSObject, n + 1);
        sDMSObject.versions = this;
        if (sDMSObject.validTo == Long.MAX_VALUE) {
            sDMSObject.isCurrent = true;
        }
    }

    public synchronized boolean purge(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        boolean bl = false;
        int n = this.versions.size();
        long l2 = 1L;
        if (n > 0) {
            l2 = ((SDMSObject)this.versions.elementAt((int)0)).validFrom;
        }
        while (n > 0 && ((SDMSObject)this.versions.elementAt((int)0)).validTo < l) {
            this.table.unIndex(systemEnvironment, (SDMSObject)this.versions.elementAt(0));
            this.versions.remove(0);
            --n;
        }
        if (n == 0 || n == 1 && ((SDMSObject)this.versions.elementAt((int)0)).validTo == Long.MAX_VALUE) {
            bl = true;
        }
        if (n == 0) {
            this.table.hashMapRemove(this.id);
        } else if (!this.table.isVersioned) {
            ((SDMSObject)this.versions.elementAt((int)0)).validFrom = l2;
        }
        return bl;
    }

    protected SDMSObject get(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSObject sDMSObject = this.getRaw(systemEnvironment, false);
        if (sDMSObject == null) {
            this.raiseNotFoundException(systemEnvironment, 0L);
        }
        return sDMSObject;
    }

    protected synchronized SDMSObject getRaw(SystemEnvironment systemEnvironment, boolean bl) throws SDMSException {
        if (this.tx == systemEnvironment.tx) {
            if (this.o_v.size() == 0) {
                SDMSObject sDMSObject = this.getRaw(systemEnvironment, Long.MAX_VALUE);
                if (sDMSObject == null) {
                    return null;
                }
                if (!sDMSObject.isCurrent) {
                    System.out.println("get returned non current version:\ntx:\n" + this.tx + "env.tx:\n" + systemEnvironment.tx);
                    System.out.println(this.toString());
                    throw new FatalException(new SDMSMessage(systemEnvironment, "02110301833", "get returned non current version"));
                }
                return sDMSObject;
            }
            SDMSObject sDMSObject = (SDMSObject)this.o_v.getLast();
            if (!sDMSObject.isDeleted) {
                if (!sDMSObject.isCurrent) {
                    System.out.println("get returned non current version:\ntx:\n" + this.tx + "env.tx:\n" + systemEnvironment.tx);
                    System.out.println(this.toString());
                    throw new FatalException(new SDMSMessage(systemEnvironment, "02110301834", "get returned non current version"));
                }
                return sDMSObject;
            }
            return null;
        }
        if (systemEnvironment.tx.mode == 1) {
            return this.getRaw(systemEnvironment, systemEnvironment.tx.versionId);
        }
        SDMSObject sDMSObject = this.getRaw(systemEnvironment, Long.MAX_VALUE);
        if (sDMSObject != null && !sDMSObject.isCurrent) {
            if (!bl) {
                System.out.println("get returned non current version:\ntx:\n" + this.tx + "env.tx:\n" + systemEnvironment.tx);
                System.out.println(this.toString());
                throw new FatalException(new SDMSMessage(systemEnvironment, "02110301835", "get returned non current version"));
            }
            sDMSObject = null;
        }
        return sDMSObject;
    }

    protected synchronized SDMSObject get(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        SDMSObject sDMSObject = this.getRaw(systemEnvironment, l);
        if (sDMSObject == null) {
            this.raiseNotFoundException(systemEnvironment, l);
        }
        return sDMSObject;
    }

    private void raiseNotFoundException(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        if (l == 0L) {
            l = systemEnvironment.tx.mode == 1 ? systemEnvironment.tx.versionId : Long.MAX_VALUE;
        }
        if (SystemEnvironment.traceLevel >= 3) {
            SDMSThread.doTrace(systemEnvironment.cEnv, "Version " + l + " of id " + this.id + " not found\n" + this, 3);
        }
        throw new NotFoundException(new SDMSMessage(systemEnvironment, "03210252200", "Version $1 of id $2 not found", l, this.id));
    }

    protected synchronized SDMSObject getRaw(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        int n = this.versions.size();
        if (n == 0) {
            return null;
        }
        SDMSObject sDMSObject = (SDMSObject)this.versions.elementAt(n - 1);
        if (sDMSObject.validTo <= l && sDMSObject.validTo != Long.MAX_VALUE) {
            if (SystemEnvironment.maxWriter > 1 && systemEnvironment.tx.mode == 1) {
                for (int i = 0; i < systemEnvironment.tx.commitingTx.length; ++i) {
                    if (systemEnvironment.tx.commitingTx[i] > sDMSObject.validTo) {
                        return null;
                    }
                    if (systemEnvironment.tx.commitingTx[i] != sDMSObject.validTo) continue;
                    return sDMSObject;
                }
            }
            return null;
        }
        while (true) {
            if (sDMSObject.validFrom <= l) {
                if (SystemEnvironment.maxWriter > 1 && systemEnvironment.tx.mode == 1) {
                    int n2;
                    for (n2 = 0; n2 < systemEnvironment.tx.commitingTx.length; ++n2) {
                        if (systemEnvironment.tx.commitingTx[n2] > sDMSObject.validFrom) {
                            return sDMSObject;
                        }
                        if (systemEnvironment.tx.commitingTx[n2] == sDMSObject.validFrom) break;
                    }
                    if (n2 == systemEnvironment.tx.commitingTx.length) {
                        return sDMSObject;
                    }
                } else {
                    return sDMSObject;
                }
            }
            if (--n == 0) break;
            sDMSObject = (SDMSObject)this.versions.elementAt(n - 1);
        }
        return null;
    }

    public void dump() {
        this.dump(3);
    }

    public void dump(int n) {
        SDMSThread.doTrace(null, this.toString(), n);
    }

    public String toShortString() {
        return "SDMSVersions of " + this.table.tableName() + "(" + this.id.toString() + ")";
    }

    public String toString(int n) {
        try {
            StringBuilder stringBuilder = new StringBuilder("-- Start SDMSVersions dump --\nDump of SDMSVersions object for Object : " + this.id.toString() + "\nObject is a " + this.table.tableName() + "\nTx : " + (this.tx == null ? "null" : "\n" + this.tx.toString()) + "\n-- Start Committed Versions --\n");
            for (SDMSObject sDMSObject : this.versions) {
                if (sDMSObject == null) {
                    stringBuilder.append("\n==========================\no is null\n");
                    continue;
                }
                stringBuilder.append("\n==========================\nvalidFrom : " + sDMSObject.validFrom + "\nvalidTo : " + sDMSObject.validTo + "\nsubTxId : " + sDMSObject.subTxId + "\nisDeleted : " + sDMSObject.isDeleted + "\nisCurrent : " + sDMSObject.isCurrent + "\nmemOnly : " + sDMSObject.memOnly + "\n--------------------------\n" + sDMSObject.toString(n) + "- - - - - - - - - - - - - \n" + this.table.checkIndex(sDMSObject));
            }
            stringBuilder.append("-- End Committed Versions --\n");
            if (this.o_v != null) {
                stringBuilder.append("-- Start Uncommitted Versions --\n");
                Iterator iterator = this.o_v.listIterator(0);
                while (iterator.hasNext()) {
                    SDMSObject sDMSObject;
                    sDMSObject = (SDMSObject)iterator.next();
                    stringBuilder.append(sDMSObject.toString(n) + "- - - - - - - - - - - - - \n" + this.table.checkIndex(sDMSObject) + "----------------------------\nsubTxId : " + sDMSObject.subTxId + "\nisDeleted : " + sDMSObject.isDeleted + "\nisCurrent : " + sDMSObject.isCurrent + "\nmemOnly : " + sDMSObject.memOnly + "\n============================\n");
                }
                stringBuilder.append("-- End Uncommitted Versions --\n");
            }
            stringBuilder.append("-- End SDMSVersions dump --\n");
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Dump of Versions Object run into an Exception : " + exception.toString() + "\n");
            StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                stringBuffer.append(stackTraceElementArray[i].toString());
                stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }
    }

    public String toString() {
        return this.toString(0);
    }

    public synchronized HashMap stat(SystemEnvironment systemEnvironment) throws SDMSException {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        long l = Long.MAX_VALUE;
        long l2 = 0L;
        Iterator iterator = this.versions.iterator();
        while (iterator.hasNext()) {
            ++l2;
            SDMSObject sDMSObject = (SDMSObject)iterator.next();
            if (sDMSObject.validTo >= l) continue;
            l = sDMSObject.validTo;
        }
        hashMap.put(STAT_VERSION_COUNT, l2);
        hashMap.put(STAT_LOW_VERSION, l);
        return hashMap;
    }
}

