/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.timer;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.timer.TimerUnit;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class TimerDate
extends Date {
    public static final String __version = "@(#) $Id: TimerDate.java,v 2.4.2.1 2013/03/14 10:25:28 ronald Exp $";
    public static final int NaD = Integer.MIN_VALUE;
    private static final GregorianCalendar gc = SystemEnvironment.newGregorianCalendar();
    private boolean isNaD;
    private static final SimpleDateFormat df;

    public final boolean isNaD() {
        return this.isNaD;
    }

    public TimerDate() {
        this.isNaD = true;
    }

    public TimerDate(int n) {
        super(TimerDate.toMillis(n));
        this.isNaD = n == Integer.MIN_VALUE;
    }

    public TimerDate(long l) {
        super(l * 60L * 1000L);
        this.isNaD = l == Integer.MIN_VALUE;
    }

    public TimerDate(Date date) {
        super(date.getTime());
        this.isNaD = false;
    }

    public TimerDate(TimerDate timerDate) {
        super(timerDate.getTime());
        this.set(timerDate);
    }

    public static final long toMillis(int n) {
        return (long)n * 60000L;
    }

    public static final int fromMillis(long l) {
        return (int)(l / 60000L);
    }

    public final boolean eq(TimerDate timerDate) {
        return this.isNaD || timerDate.isNaD ? false : this.equals(timerDate);
    }

    public final boolean ne(TimerDate timerDate) {
        return this.isNaD || timerDate.isNaD ? true : !this.equals(timerDate);
    }

    public final boolean gt(TimerDate timerDate) {
        this.ensureNoNaD(timerDate);
        return this.after(timerDate);
    }

    public final boolean ge(TimerDate timerDate) {
        this.ensureNoNaD(timerDate);
        return !this.before(timerDate);
    }

    public final boolean lt(TimerDate timerDate) {
        this.ensureNoNaD(timerDate);
        return this.before(timerDate);
    }

    public final boolean le(TimerDate timerDate) {
        this.ensureNoNaD(timerDate);
        return !this.after(timerDate);
    }

    private final void ensureNoNaD(TimerDate timerDate) {
        if (this.isNaD) {
            throw new IllegalStateException("(04304041900) TimerDate is NaD");
        }
        if (timerDate.isNaD) {
            throw new IllegalArgumentException("(04304041901) TimerDate is NaD");
        }
    }

    public final TimerDate set(int n) {
        boolean bl = this.isNaD = n == Integer.MIN_VALUE;
        if (!this.isNaD) {
            this.setTime(TimerDate.toMillis(n));
        }
        return this;
    }

    public final TimerDate set(TimerDate timerDate) {
        this.isNaD = timerDate.isNaD;
        if (!this.isNaD) {
            this.setTime(timerDate.getTime());
        }
        return this;
    }

    public final int toMinutes() {
        return this.isNaD ? Integer.MIN_VALUE : TimerDate.fromMillis(this.getTime());
    }

    public final int plus(int n) {
        return this.isNaD ? Integer.MIN_VALUE : this.toMinutes() + n;
    }

    public final int plus(TimerUnit timerUnit) {
        return this.plus(1, timerUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int plus(int n, TimerUnit timerUnit) {
        if (timerUnit.isINF()) {
            throw new IllegalArgumentException("(04304041904) TimerUnit is INF");
        }
        if (this.isNaD) {
            return this.toMinutes();
        }
        GregorianCalendar gregorianCalendar = gc;
        synchronized (gregorianCalendar) {
            gc.setTime(this);
            switch (timerUnit.unit()) {
                case 5: {
                    gc.add(1, n * timerUnit.mult());
                    break;
                }
                case 4: {
                    gc.add(2, n * timerUnit.mult());
                    break;
                }
                case 3: {
                    gc.add(3, n * timerUnit.mult());
                    break;
                }
                case 2: {
                    gc.add(5, n * timerUnit.mult());
                    break;
                }
                case 1: {
                    gc.add(11, n * timerUnit.mult());
                    break;
                }
                case 0: {
                    gc.add(12, n * timerUnit.mult());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("(04304041905) unexpected TimerUnit: " + timerUnit);
                }
            }
            return TimerDate.fromMillis(gc.getTimeInMillis());
        }
    }

    @Override
    public final String toString() {
        return this.toString(SystemEnvironment.systemTimeZone, true);
    }

    public final String toString(boolean bl) {
        return this.toString(SystemEnvironment.systemTimeZone, bl);
    }

    public final String toString(TimeZone timeZone) {
        return this.toString(timeZone, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String toString(TimeZone timeZone, boolean bl) {
        if (this.isNaD) {
            return "NaD";
        }
        SimpleDateFormat simpleDateFormat = df;
        synchronized (simpleDateFormat) {
            if (timeZone != null) {
                df.setTimeZone(timeZone);
            } else {
                df.setTimeZone(SystemEnvironment.systemTimeZone);
            }
            if (bl) {
                return df.format(this) + " " + timeZone.getID();
            }
            return df.format(this);
        }
    }

    static {
        gc.setTimeZone(TimeZone.getDefault());
        df = new SimpleDateFormat("dd'.'MM'.'yyyy'-'HH':'mm", SystemEnvironment.systemLocale);
    }
}

