-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE GRANTS (
    ID                             bigint NOT NULL
    , OBJECT_ID                      bigint          NOT NULL
    , G_ID                           bigint          NOT NULL
    , OBJECT_TYPE                    integer         NOT NULL
    , PRIVS                          bigint          NOT NULL
    , DELETE_VERSION                 bigint              NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_GRANTS
ON GRANTS(ID);
CREATE VIEW SCI_GRANTS AS
SELECT 
    ID 
    , OBJECT_ID                      AS OBJECT_ID
    , G_ID                           AS G_ID
    , DECODE (OBJECT_TYPE, 1, 'ENVIRONMENT', 18, 'EVENT', 6, 'FOLDER', 19, 'INTERVAL', 17, 'JOB', 9, 'JOB_DEFINITION', 10, 'NAMED_RESOURCE', 20, 'SCHEDULE', 22, 'SCHEDULED_EVENT', 15, 'SCOPE', 21, 'GROUP', 11, 'RESOURCE', 2, 'EXIT_STATE_DEFINITION', 31, 'NICE_PROFILE', 3, 'EXIT_STATE_PROFILE', 4, 'EXIT_STATE_MAPPING', 5, 'EXIT_STATE_TRANSLATION', 13, 'RESOURCE_STATE_DEFINITION', 14, 'RESOURCE_STATE_PROFILE', 29, 'WATCH_TYPE', 12, 'RESOURCE_STATE_MAPPING', 7, 'FOOTPRINT', 8, 'USER', 30, 'OBJECT_MONITOR', 0, 'SYSTEM') AS OBJECT_TYPE
    , PRIVS                          AS PRIVS
    , DELETE_VERSION                 AS DELETE_VERSION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM GRANTS;
