-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE NAMED_RESOURCE (
    ID                             bigint NOT NULL
    , NAME                           varchar(64)     NOT NULL
    , OWNER_ID                       bigint          NOT NULL
    , PARENT_ID                      bigint              NULL
    , USAGE                          integer         NOT NULL
    , RSP_ID                         bigint              NULL
    , FACTOR                         float               NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , INHERIT_PRIVS                  bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_NAMED_RESOURCE
ON NAMED_RESOURCE(ID);
CREATE VIEW SCI_NAMED_RESOURCE AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , PARENT_ID                      AS PARENT_ID
    , DECODE (USAGE, 1, 'STATIC', 2, 'SYSTEM', 4, 'SYNCHRONIZING', 8, 'CATEGORY', 3, 'POOL') AS USAGE
    , RSP_ID                         AS RSP_ID
    , FACTOR                         AS FACTOR
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , INHERIT_PRIVS                  AS INHERIT_PRIVS
  FROM NAMED_RESOURCE;
