-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE RUNNABLE_QUEUE (
    ID                             bigint NOT NULL
    , SME_ID                         bigint          NOT NULL
    , SCOPE_ID                       bigint              NULL
    , STATE                          integer         NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_RUNNABLE_QUEUE
ON RUNNABLE_QUEUE(ID);
CREATE VIEW SCI_RUNNABLE_QUEUE AS
SELECT 
    ID 
    , SME_ID                         AS SME_ID
    , SCOPE_ID                       AS SCOPE_ID
    , DECODE (STATE, 1, 'DEPENDENCY_WAIT', 2, 'SYNCHRONIZE_WAIT', 3, 'RESOURCE_WAIT', 4, 'RUNNABLE', 5, 'STARTING') AS STATE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM RUNNABLE_QUEUE;
