-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE SCHEDULED_EVENT (
    ID                             bigint NOT NULL
    , OWNER_ID                       bigint          NOT NULL
    , SCE_ID                         bigint          NOT NULL
    , EVT_ID                         bigint          NOT NULL
    , ACTIVE                         integer         NOT NULL
    , BROKEN                         integer         NOT NULL
    , ERROR_CODE                     varchar(32)         NULL
    , ERROR_MSG                      varchar(256)        NULL
    , LAST_START_TIME                bigint              NULL
    , NEXT_START_TIME                bigint              NULL
    , NEXT_IS_TRIGGER                integer             NULL
    , BACKLOG_HANDLING               integer         NOT NULL
    , SUSPEND_LIMIT                  integer             NULL
    , SUSPEND_LIMIT_MULTIPLIER       integer             NULL
    , IS_CALENDAR                    integer         NOT NULL
    , CALENDAR_HORIZON               integer             NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_SCHEDULED_EVENT
ON SCHEDULED_EVENT(ID);
CREATE VIEW SCI_SCHEDULED_EVENT AS
SELECT 
    ID 
    , OWNER_ID                       AS OWNER_ID
    , SCE_ID                         AS SCE_ID
    , EVT_ID                         AS EVT_ID
    , DECODE (ACTIVE, 1, 'ACTIVE', 0, 'INACTIVE') AS ACTIVE
    , DECODE (BROKEN, 1, 'BROKEN', 0, 'NOBROKEN') AS BROKEN
    , ERROR_CODE                     AS ERROR_CODE
    , ERROR_MSG                      AS ERROR_MSG
    , timestamp('1970-01-01-00.00.00') + int(mod(LAST_START_TIME, 1125899906842624)/1000) seconds AS LAST_START_TIME
    , timestamp('1970-01-01-00.00.00') + int(mod(NEXT_START_TIME, 1125899906842624)/1000) seconds AS NEXT_START_TIME
    , DECODE (NEXT_IS_TRIGGER, 1, 'TRUE', 0, 'FALSE') AS NEXT_IS_TRIGGER
    , DECODE (BACKLOG_HANDLING, 0, 'NONE', 1, 'LAST', 2, 'ALL') AS BACKLOG_HANDLING
    , DECODE (SUSPEND_LIMIT, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS SUSPEND_LIMIT
    , SUSPEND_LIMIT_MULTIPLIER       AS SUSPEND_LIMIT_MULTIPLIER
    , DECODE (IS_CALENDAR, 1, 'ACTIVE', 0, 'INACTIVE') AS IS_CALENDAR
    , CALENDAR_HORIZON               AS CALENDAR_HORIZON
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM SCHEDULED_EVENT;
