-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE WATCH_TYPE_PARAMETER (
    ID                             bigint NOT NULL
    , NAME                           varchar(64)     NOT NULL
    , DEFAULTVALUE                   varchar(256)        NULL
    , WT_ID                          bigint          NOT NULL
    , IS_SUBMIT_PAR                  integer         NOT NULL
    , TYPE                           integer         NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_WATCH_TYPE_PARAMETER
ON WATCH_TYPE_PARAMETER(ID);
CREATE VIEW SCI_WATCH_TYPE_PARAMETER AS
SELECT 
    ID 
    , NAME                           AS NAME
    , DEFAULTVALUE                   AS DEFAULTVALUE
    , WT_ID                          AS WT_ID
    , DECODE (IS_SUBMIT_PAR, 1, 'TRUE', 0, 'FALSE') AS IS_SUBMIT_PAR
    , DECODE (TYPE, 1, 'CONFIG', 2, 'VALUE', 3, 'INFO') AS TYPE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM WATCH_TYPE_PARAMETER;
