-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE DEPENDENCY_INSTANCE (
    ID                             bigint NOT NULL
    , DD_ID                          bigint          NOT NULL
    , DEPENDENT_ID                   bigint          NOT NULL
    , DEPENDENT_ID_ORIG              bigint          NOT NULL
    , DEPENDENCY_OPERATION           int8            NOT NULL
    , REQUIRED_ID                    bigint          NOT NULL
    , REQUIRED_SE_ID                 bigint              NULL
    , STATE                          int8            NOT NULL
    , IGNORE                         int8            NOT NULL
    , DI_ID_ORIG                     bigint          NOT NULL
    , SE_VERSION                     bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_DEPENDENCY_INSTANCE
ON DEPENDENCY_INSTANCE(ID);
CREATE VIEW SCI_DEPENDENCY_INSTANCE (ID,DD_ID,DEPENDENT_ID,DEPENDENT_ID_ORIG,DEPENDENCY_OPERATION,REQUIRED_ID,REQUIRED_SE_ID,STATE,IGNORE,DI_ID_ORIG,SE_VERSION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , DD_ID                          AS DD_ID
    , DEPENDENT_ID                   AS DEPENDENT_ID
    , DEPENDENT_ID_ORIG              AS DEPENDENT_ID_ORIG
    , DECODE (DEPENDENCY_OPERATION, 1, 'AND', 2, 'OR') AS DEPENDENCY_OPERATION
    , REQUIRED_ID                    AS REQUIRED_ID
    , REQUIRED_SE_ID                 AS REQUIRED_SE_ID
    , DECODE (STATE, 0, 'OPEN', 1, 'FULFILLED', 2, 'FAILED', 3, 'BROKEN', 4, 'DEFERRED', 8, 'CANCELLED') AS STATE
    , DECODE (IGNORE, 0, 'NO', 1, 'YES', 2, 'RECURSIVE') AS IGNORE
    , DI_ID_ORIG                     AS DI_ID_ORIG
    , SE_VERSION                     AS SE_VERSION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM DEPENDENCY_INSTANCE;
CREATE TABLE ARC_DEPENDENCY_INSTANCE (
    ID                             bigint NOT NULL
    , DD_ID                          bigint           NULL
    , DEPENDENT_ID                   bigint           NULL
    , DEPENDENT_ID_ORIG              bigint           NULL
    , DEPENDENCY_OPERATION           int8             NULL
    , REQUIRED_ID                    bigint           NULL
    , REQUIRED_SE_ID                 bigint           NULL
    , STATE                          int8             NULL
    , IGNORE                         int8             NULL
    , DI_ID_ORIG                     bigint           NULL
    , SE_VERSION                     bigint           NULL
    , CREATOR_U_ID                   bigint           NULL
    , CREATE_TS                      bigint           NULL
    , CHANGER_U_ID                   bigint           NULL
    , CHANGE_TS                      bigint           NULL
);
