-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE HIERARCHY_INSTANCE (
    ID                             bigint NOT NULL
    , PARENT_ID                      bigint          NOT NULL
    , CHILD_ID                       bigint          NOT NULL
    , SH_ID                          bigint          NOT NULL
    , NICE                           int8            NOT NULL
    , CHILD_ESD_ID                   bigint              NULL
    , CHILD_ES_PREFERENCE            int8                NULL
    , SE_VERSION                     bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_HIERARCHY_INSTANCE
ON HIERARCHY_INSTANCE(ID);
CREATE VIEW SCI_HIERARCHY_INSTANCE (ID,PARENT_ID,CHILD_ID,SH_ID,NICE,CHILD_ESD_ID,CHILD_ES_PREFERENCE,SE_VERSION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , PARENT_ID                      AS PARENT_ID
    , CHILD_ID                       AS CHILD_ID
    , SH_ID                          AS SH_ID
    , NICE                           AS NICE
    , CHILD_ESD_ID                   AS CHILD_ESD_ID
    , CHILD_ES_PREFERENCE            AS CHILD_ES_PREFERENCE
    , SE_VERSION                     AS SE_VERSION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM HIERARCHY_INSTANCE;
CREATE TABLE ARC_HIERARCHY_INSTANCE (
    ID                             bigint NOT NULL
    , PARENT_ID                      bigint           NULL
    , CHILD_ID                       bigint           NULL
    , SH_ID                          bigint           NULL
    , NICE                           int8             NULL
    , CHILD_ESD_ID                   bigint           NULL
    , CHILD_ES_PREFERENCE            int8             NULL
    , SE_VERSION                     bigint           NULL
    , CREATOR_U_ID                   bigint           NULL
    , CREATE_TS                      bigint           NULL
    , CHANGER_U_ID                   bigint           NULL
    , CHANGE_TS                      bigint           NULL
);
