-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE IGNORED_DEPENDENCY (
    ID                             bigint NOT NULL
    , SH_ID                          bigint          NOT NULL
    , DD_NAME                        lvarchar(64)    NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_IGNORED_DEPENDENCY
ON IGNORED_DEPENDENCY(ID);
CREATE VIEW SCI_C_IGNORED_DEPENDENCY (ID,SH_ID,DD_NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , SH_ID                          AS SH_ID
    , DD_NAME                        AS DD_NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM IGNORED_DEPENDENCY
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_IGNORED_DEPENDENCY (ID,SH_ID,DD_NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , SH_ID                          AS SH_ID
    , DD_NAME                        AS DD_NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM IGNORED_DEPENDENCY;
