DROP VIEW SCI_AUDIT_TRAIL;
CREATE VIEW SCI_AUDIT_TRAIL (ID,USER_ID,TS,TXID,ACTION,OBJECT_TYPE,OBJECT_ID,ORIGIN_ID,IS_SET_WARNING,ACTION_INFO,ACTION_COMMENT,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , USER_ID                        AS USER_ID
    , dbinfo ('utc_to_datetime', round(mod(TS, 1125899906842624)/1000)) AS TS
    , TXID                           AS TXID
    , DECODE (ACTION, 1, 'RERUN', 2, 'RERUN_RECURSIVE', 3, 'CANCEL', 4, 'SUSPEND', 5, 'RESUME', 6, 'SET_STATE', 7, 'SET_EXIT_STATE', 8, 'IGNORE_DEPENDENCY', 9, 'IGNORE_DEP_RECURSIVE', 10, 'IGNORE_RESOURCE', 11, 'KILL', 12, 'ALTER_RUN_PROGRAM', 13, 'ALTER_RERUN_PROGRAM', 14, 'COMMENT_JOB', 15, 'SUBMITTED', 16, 'TRIGGER_FAILED', 17, 'TRIGGER_SUBMIT', 18, 'JOB_RESTARTABLE', 19, 'CHANGE_PRIORITY', 20, 'RENICE', 21, 'SUBMIT_SUSPENDED', 22, 'IGNORE_NAMED_RESOURCE', 23, 'TIMEOUT', 24, 'SET_RESOURCE_STATE', 25, 'JOB_IN_ERROR', 26, 'CLEAR_WARNING', 27, 'SET_WARNING', 28, 'JOB_UNREACHABLE', 29, 'SET_PARAMETERS', 30, 'DISABLE', 31, 'ENABLE', 32, 'CLONE', 33, 'APPROVE', 34, 'REJECT', 35, 'APPROVAL_REQUEST', 36, 'REVIEW_REQUEST', 37, 'KILL_RECURSIVE') AS ACTION
    , DECODE (OBJECT_TYPE, 17, 'JOB') AS OBJECT_TYPE
    , OBJECT_ID                      AS OBJECT_ID
    , ORIGIN_ID                      AS ORIGIN_ID
    , DECODE (IS_SET_WARNING, 1, 'TRUE', 0, 'FALSE') AS IS_SET_WARNING
    , ACTION_INFO                    AS ACTION_INFO
    , ACTION_COMMENT                 AS ACTION_COMMENT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM AUDIT_TRAIL;
DROP VIEW SCI_CALENDAR;
CREATE VIEW SCI_CALENDAR (ID,SCEV_ID,STARTTIME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , SCEV_ID                        AS SCEV_ID
    , dbinfo ('utc_to_datetime', round(mod(STARTTIME, 1125899906842624)/1000)) AS STARTTIME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM CALENDAR;
DROP VIEW SCI_C_DEPENDENCY_DEFINITION;
DROP VIEW SCI_V_DEPENDENCY_DEFINITION;
CREATE VIEW SCI_C_DEPENDENCY_DEFINITION (ID,SE_DEPENDENT_ID,SE_REQUIRED_ID,NAME,UNRESOLVED_HANDLING,DMODE,STATE_SELECTION,CONDITION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , SE_DEPENDENT_ID                AS SE_DEPENDENT_ID
    , SE_REQUIRED_ID                 AS SE_REQUIRED_ID
    , NAME                           AS NAME
    , DECODE (UNRESOLVED_HANDLING, 1, 'IGNORE', 2, 'ERROR', 3, 'SUSPEND', 4, 'DEFER', 5, 'DEFER_IGNORE') AS UNRESOLVED_HANDLING
    , DECODE (DMODE, 1, 'ALL_FINAL', 2, 'JOB_FINAL') AS DMODE
    , DECODE (STATE_SELECTION, 0, 'FINAL', 1, 'ALL_REACHABLE', 2, 'UNREACHABLE', 3, 'DEFAULT') AS STATE_SELECTION
    , CONDITION                      AS CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM DEPENDENCY_DEFINITION
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_DEPENDENCY_DEFINITION (ID,SE_DEPENDENT_ID,SE_REQUIRED_ID,NAME,UNRESOLVED_HANDLING,DMODE,STATE_SELECTION,CONDITION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , SE_DEPENDENT_ID                AS SE_DEPENDENT_ID
    , SE_REQUIRED_ID                 AS SE_REQUIRED_ID
    , NAME                           AS NAME
    , DECODE (UNRESOLVED_HANDLING, 1, 'IGNORE', 2, 'ERROR', 3, 'SUSPEND', 4, 'DEFER', 5, 'DEFER_IGNORE') AS UNRESOLVED_HANDLING
    , DECODE (DMODE, 1, 'ALL_FINAL', 2, 'JOB_FINAL') AS DMODE
    , DECODE (STATE_SELECTION, 0, 'FINAL', 1, 'ALL_REACHABLE', 2, 'UNREACHABLE', 3, 'DEFAULT') AS STATE_SELECTION
    , CONDITION                      AS CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM DEPENDENCY_DEFINITION;
DROP VIEW SCI_DEPENDENCY_INSTANCE;
CREATE VIEW SCI_DEPENDENCY_INSTANCE (ID,DD_ID,DEPENDENT_ID,DEPENDENT_ID_ORIG,DEPENDENCY_OPERATION,REQUIRED_ID,STATE,IGNORE,DI_ID_ORIG,SE_VERSION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , DD_ID                          AS DD_ID
    , DEPENDENT_ID                   AS DEPENDENT_ID
    , DEPENDENT_ID_ORIG              AS DEPENDENT_ID_ORIG
    , DECODE (DEPENDENCY_OPERATION, 1, 'AND', 2, 'OR') AS DEPENDENCY_OPERATION
    , REQUIRED_ID                    AS REQUIRED_ID
    , DECODE (STATE, 0, 'OPEN', 1, 'FULFILLED', 2, 'FAILED', 3, 'BROKEN', 4, 'DEFERRED', 8, 'CANCELLED') AS STATE
    , DECODE (IGNORE, 0, 'NO', 1, 'YES', 2, 'RECURSIVE') AS IGNORE
    , DI_ID_ORIG                     AS DI_ID_ORIG
    , SE_VERSION                     AS SE_VERSION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM DEPENDENCY_INSTANCE;
DROP VIEW SCI_C_DEPENDENCY_STATE;
DROP VIEW SCI_V_DEPENDENCY_STATE;
CREATE VIEW SCI_C_DEPENDENCY_STATE (ID,DD_ID,ESD_ID,CONDITION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , DD_ID                          AS DD_ID
    , ESD_ID                         AS ESD_ID
    , CONDITION                      AS CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM DEPENDENCY_STATE
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_DEPENDENCY_STATE (ID,DD_ID,ESD_ID,CONDITION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , DD_ID                          AS DD_ID
    , ESD_ID                         AS ESD_ID
    , CONDITION                      AS CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM DEPENDENCY_STATE;
DROP VIEW SCI_ENTITY_VARIABLE;
CREATE VIEW SCI_ENTITY_VARIABLE (ID,SME_ID,NAME,VALUE,IS_LOCAL,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , SME_ID                         AS SME_ID
    , NAME                           AS NAME
    , VALUE                          AS VALUE
    , DECODE (IS_LOCAL, 1, 'TRUE', 0, 'FALSE') AS IS_LOCAL
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM ENTITY_VARIABLE;
DROP VIEW SCI_C_ENVIRONMENT;
DROP VIEW SCI_V_ENVIRONMENT;
CREATE VIEW SCI_C_ENVIRONMENT (ID,NE_ID,NR_ID,CONDITION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NE_ID                          AS NE_ID
    , NR_ID                          AS NR_ID
    , CONDITION                      AS CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM ENVIRONMENT
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_ENVIRONMENT (ID,NE_ID,NR_ID,CONDITION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , NE_ID                          AS NE_ID
    , NR_ID                          AS NR_ID
    , CONDITION                      AS CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM ENVIRONMENT;
DROP VIEW SCI_EVENT;
CREATE VIEW SCI_EVENT (ID,NAME,OWNER_ID,SE_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , SE_ID                          AS SE_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM EVENT;
DROP VIEW SCI_EVENT_PARAMETER;
CREATE VIEW SCI_EVENT_PARAMETER (ID,KEY,VALUE,EVT_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , KEY                            AS KEY
    , VALUE                          AS VALUE
    , EVT_ID                         AS EVT_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM EVENT_PARAMETER;
DROP VIEW SCI_C_EXIT_STATE;
DROP VIEW SCI_V_EXIT_STATE;
CREATE VIEW SCI_C_EXIT_STATE (ID,PREFERENCE,IS_FINAL,IS_RESTARTABLE,IS_UNREACHABLE,IS_BROKEN,IS_BATCH_DEFAULT,IS_DEPENDENCY_DEFAULT,ESP_ID,ESD_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , PREFERENCE                     AS PREFERENCE
    , DECODE (IS_FINAL, 1, 'TRUE', 0, 'FALSE') AS IS_FINAL
    , DECODE (IS_RESTARTABLE, 1, 'TRUE', 0, 'FALSE') AS IS_RESTARTABLE
    , DECODE (IS_UNREACHABLE, 1, 'TRUE', 0, 'FALSE') AS IS_UNREACHABLE
    , DECODE (IS_BROKEN, 1, 'TRUE', 0, 'FALSE') AS IS_BROKEN
    , DECODE (IS_BATCH_DEFAULT, 1, 'TRUE', 0, 'FALSE') AS IS_BATCH_DEFAULT
    , DECODE (IS_DEPENDENCY_DEFAULT, 1, 'TRUE', 0, 'FALSE') AS IS_DEPENDENCY_DEFAULT
    , ESP_ID                         AS ESP_ID
    , ESD_ID                         AS ESD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM EXIT_STATE
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_EXIT_STATE (ID,PREFERENCE,IS_FINAL,IS_RESTARTABLE,IS_UNREACHABLE,IS_BROKEN,IS_BATCH_DEFAULT,IS_DEPENDENCY_DEFAULT,ESP_ID,ESD_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , PREFERENCE                     AS PREFERENCE
    , DECODE (IS_FINAL, 1, 'TRUE', 0, 'FALSE') AS IS_FINAL
    , DECODE (IS_RESTARTABLE, 1, 'TRUE', 0, 'FALSE') AS IS_RESTARTABLE
    , DECODE (IS_UNREACHABLE, 1, 'TRUE', 0, 'FALSE') AS IS_UNREACHABLE
    , DECODE (IS_BROKEN, 1, 'TRUE', 0, 'FALSE') AS IS_BROKEN
    , DECODE (IS_BATCH_DEFAULT, 1, 'TRUE', 0, 'FALSE') AS IS_BATCH_DEFAULT
    , DECODE (IS_DEPENDENCY_DEFAULT, 1, 'TRUE', 0, 'FALSE') AS IS_DEPENDENCY_DEFAULT
    , ESP_ID                         AS ESP_ID
    , ESD_ID                         AS ESD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM EXIT_STATE;
DROP VIEW SCI_C_EXIT_STATE_DEFINITION;
DROP VIEW SCI_V_EXIT_STATE_DEFINITION;
CREATE VIEW SCI_C_EXIT_STATE_DEFINITION (ID,NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM EXIT_STATE_DEFINITION
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_EXIT_STATE_DEFINITION (ID,NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM EXIT_STATE_DEFINITION;
DROP VIEW SCI_C_EXIT_STATE_MAPPING;
DROP VIEW SCI_V_EXIT_STATE_MAPPING;
CREATE VIEW SCI_C_EXIT_STATE_MAPPING (ID,ESMP_ID,ESD_ID,ECR_START,ECR_END,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , ESMP_ID                        AS ESMP_ID
    , ESD_ID                         AS ESD_ID
    , ECR_START                      AS ECR_START
    , ECR_END                        AS ECR_END
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM EXIT_STATE_MAPPING
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_EXIT_STATE_MAPPING (ID,ESMP_ID,ESD_ID,ECR_START,ECR_END,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , ESMP_ID                        AS ESMP_ID
    , ESD_ID                         AS ESD_ID
    , ECR_START                      AS ECR_START
    , ECR_END                        AS ECR_END
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM EXIT_STATE_MAPPING;
DROP VIEW SCI_C_EXIT_STATE_MAP_PROFILE;
DROP VIEW SCI_V_EXIT_STATE_MAP_PROFILE;
CREATE VIEW SCI_C_EXIT_STATE_MAP_PROFILE (ID,NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM EXIT_STATE_MAPPING_PROFILE
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_EXIT_STATE_MAP_PROFILE (ID,NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM EXIT_STATE_MAPPING_PROFILE;
DROP VIEW SCI_C_EXIT_STATE_PROFILE;
DROP VIEW SCI_V_EXIT_STATE_PROFILE;
CREATE VIEW SCI_C_EXIT_STATE_PROFILE (ID,NAME,DEFAULT_ESMP_ID,IS_VALID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , DEFAULT_ESMP_ID                AS DEFAULT_ESMP_ID
    , DECODE (IS_VALID, 1, 'TRUE', 0, 'FALSE') AS IS_VALID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM EXIT_STATE_PROFILE
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_EXIT_STATE_PROFILE (ID,NAME,DEFAULT_ESMP_ID,IS_VALID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , DEFAULT_ESMP_ID                AS DEFAULT_ESMP_ID
    , DECODE (IS_VALID, 1, 'TRUE', 0, 'FALSE') AS IS_VALID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM EXIT_STATE_PROFILE;
DROP VIEW SCI_C_EXIT_STATE_TRANSLATION;
DROP VIEW SCI_V_EXIT_STATE_TRANSLATION;
CREATE VIEW SCI_C_EXIT_STATE_TRANSLATION (ID,ESTP_ID,FROM_ESD_ID,TO_ESD_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , ESTP_ID                        AS ESTP_ID
    , FROM_ESD_ID                    AS FROM_ESD_ID
    , TO_ESD_ID                      AS TO_ESD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM EXIT_STATE_TRANSLATION
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_EXIT_STATE_TRANSLATION (ID,ESTP_ID,FROM_ESD_ID,TO_ESD_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , ESTP_ID                        AS ESTP_ID
    , FROM_ESD_ID                    AS FROM_ESD_ID
    , TO_ESD_ID                      AS TO_ESD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM EXIT_STATE_TRANSLATION;
DROP VIEW SCI_C_EXIT_STATE_TRANS_PROFILE;
DROP VIEW SCI_V_EXIT_STATE_TRANS_PROFILE;
CREATE VIEW SCI_C_EXIT_STATE_TRANS_PROFILE (ID,NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM EXIT_STATE_TRANS_PROFILE
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_EXIT_STATE_TRANS_PROFILE (ID,NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM EXIT_STATE_TRANS_PROFILE;
DROP VIEW SCI_C_FOLDER;
DROP VIEW SCI_V_FOLDER;
CREATE VIEW SCI_C_FOLDER (ID,NAME,OWNER_ID,ENV_ID,PARENT_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS,INHERIT_PRIVS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , ENV_ID                         AS ENV_ID
    , PARENT_ID                      AS PARENT_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , INHERIT_PRIVS                  AS INHERIT_PRIVS
  FROM FOLDER
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_FOLDER (ID,NAME,OWNER_ID,ENV_ID,PARENT_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS,INHERIT_PRIVS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , ENV_ID                         AS ENV_ID
    , PARENT_ID                      AS PARENT_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , INHERIT_PRIVS                  AS INHERIT_PRIVS
    , VALID_FROM
    , VALID_TO
  FROM FOLDER;
DROP VIEW SCI_FOOTPRINT;
CREATE VIEW SCI_FOOTPRINT (ID,NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM FOOTPRINT;
DROP VIEW SCI_GRANTS;
CREATE VIEW SCI_GRANTS (ID,OBJECT_ID,G_ID,OBJECT_TYPE,PRIVS,DELETE_VERSION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , OBJECT_ID                      AS OBJECT_ID
    , G_ID                           AS G_ID
    , DECODE (OBJECT_TYPE, 1, 'ENVIRONMENT', 18, 'EVENT', 6, 'FOLDER', 19, 'INTERVAL', 17, 'JOB', 9, 'JOB_DEFINITION', 10, 'NAMED_RESOURCE', 20, 'SCHEDULE', 22, 'SCHEDULED_EVENT', 15, 'SCOPE', 21, 'GROUP', 11, 'RESOURCE', 2, 'EXIT_STATE_DEFINITION', 31, 'NICE_PROFILE', 3, 'EXIT_STATE_PROFILE', 4, 'EXIT_STATE_MAPPING', 5, 'EXIT_STATE_TRANSLATION', 13, 'RESOURCE_STATE_DEFINITION', 14, 'RESOURCE_STATE_PROFILE', 29, 'WATCH_TYPE', 12, 'RESOURCE_STATE_MAPPING', 7, 'FOOTPRINT', 8, 'USER', 30, 'OBJECT_MONITOR', 0, 'SYSTEM') AS OBJECT_TYPE
    , PRIVS                          AS PRIVS
    , DELETE_VERSION                 AS DELETE_VERSION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM GRANTS;
DROP VIEW SCI_GROUPS;
CREATE VIEW SCI_GROUPS (ID,NAME,DELETE_VERSION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , DELETE_VERSION                 AS DELETE_VERSION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM GROUPS;
DROP VIEW SCI_HIERARCHY_INSTANCE;
CREATE VIEW SCI_HIERARCHY_INSTANCE (ID,PARENT_ID,CHILD_ID,SH_ID,NICE,CHILD_ESD_ID,CHILD_ES_PREFERENCE,SE_VERSION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , PARENT_ID                      AS PARENT_ID
    , CHILD_ID                       AS CHILD_ID
    , SH_ID                          AS SH_ID
    , NICE                           AS NICE
    , CHILD_ESD_ID                   AS CHILD_ESD_ID
    , CHILD_ES_PREFERENCE            AS CHILD_ES_PREFERENCE
    , SE_VERSION                     AS SE_VERSION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM HIERARCHY_INSTANCE;
DROP VIEW SCI_C_IGNORED_DEPENDENCY;
DROP VIEW SCI_V_IGNORED_DEPENDENCY;
CREATE VIEW SCI_C_IGNORED_DEPENDENCY (ID,SH_ID,DD_NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , SH_ID                          AS SH_ID
    , DD_NAME                        AS DD_NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM IGNORED_DEPENDENCY
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_IGNORED_DEPENDENCY (ID,SH_ID,DD_NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , SH_ID                          AS SH_ID
    , DD_NAME                        AS DD_NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM IGNORED_DEPENDENCY;
DROP VIEW SCI_INSTANCE_VALUE;
CREATE VIEW SCI_INSTANCE_VALUE (ID,VALUE,OI_ID,WTP_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , VALUE                          AS VALUE
    , OI_ID                          AS OI_ID
    , WTP_ID                         AS WTP_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM INSTANCE_VALUE;
DROP VIEW SCI_INTERVALL;
CREATE VIEW SCI_INTERVALL (ID,NAME,OWNER_ID,START_TIME,END_TIME,DELAY,BASE_INTERVAL,BASE_INTERVAL_MULTIPLIER,DURATION,DURATION_MULTIPLIER,SYNC_TIME,IS_INVERSE,IS_MERGE,EMBEDDED_INT_ID,SE_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , dbinfo ('utc_to_datetime', round(mod(START_TIME, 1125899906842624)/1000)) AS START_TIME
    , dbinfo ('utc_to_datetime', round(mod(END_TIME, 1125899906842624)/1000)) AS END_TIME
    , DELAY                          AS DELAY
    , DECODE (BASE_INTERVAL, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS BASE_INTERVAL
    , BASE_INTERVAL_MULTIPLIER       AS BASE_INTERVAL_MULTIPLIER
    , DECODE (DURATION, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS DURATION
    , DURATION_MULTIPLIER            AS DURATION_MULTIPLIER
    , dbinfo ('utc_to_datetime', round(mod(SYNC_TIME, 1125899906842624)/1000)) AS SYNC_TIME
    , DECODE (IS_INVERSE, 1, 'TRUE', 0, 'FALSE') AS IS_INVERSE
    , DECODE (IS_MERGE, 1, 'TRUE', 0, 'FALSE') AS IS_MERGE
    , EMBEDDED_INT_ID                AS EMBEDDED_INT_ID
    , SE_ID                          AS SE_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM INTERVALL;
DROP VIEW SCI_INTERVAL_HIERARCHY;
CREATE VIEW SCI_INTERVAL_HIERARCHY (ID,CHILD_ID,PARENT_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , CHILD_ID                       AS CHILD_ID
    , PARENT_ID                      AS PARENT_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM INTERVAL_HIERARCHY;
DROP VIEW SCI_INTERVAL_SELECTION;
CREATE VIEW SCI_INTERVAL_SELECTION (ID,INT_ID,VALUE,PERIOD_FROM,PERIOD_TO,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , INT_ID                         AS INT_ID
    , VALUE                          AS VALUE
    , PERIOD_FROM                    AS PERIOD_FROM
    , PERIOD_TO                      AS PERIOD_TO
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM INTERVAL_SELECTION;
DROP VIEW SCI_KILL_JOB;
CREATE VIEW SCI_KILL_JOB (ID,SE_ID,SE_VERSION,SME_ID,SCOPE_ID,STATE,EXIT_CODE,COMMANDLINE,LOGFILE,ERRLOGFILE,PID,EXTPID,ERROR_MSG,RUNNABLE_TS,START_TS,FINSH_TS,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , SE_ID                          AS SE_ID
    , SE_VERSION                     AS SE_VERSION
    , SME_ID                         AS SME_ID
    , SCOPE_ID                       AS SCOPE_ID
    , DECODE (STATE, 4, 'RUNNABLE', 5, 'STARTING', 6, 'STARTED', 7, 'RUNNING', 11, 'FINISHED', 13, 'BROKEN_ACTIVE', 14, 'BROKEN_FINISHED', 15, 'ERROR') AS STATE
    , EXIT_CODE                      AS EXIT_CODE
    , COMMANDLINE                    AS COMMANDLINE
    , LOGFILE                        AS LOGFILE
    , ERRLOGFILE                     AS ERRLOGFILE
    , PID                            AS PID
    , EXTPID                         AS EXTPID
    , ERROR_MSG                      AS ERROR_MSG
    , dbinfo ('utc_to_datetime', round(mod(RUNNABLE_TS, 1125899906842624)/1000)) AS RUNNABLE_TS
    , dbinfo ('utc_to_datetime', round(mod(START_TS, 1125899906842624)/1000)) AS START_TS
    , dbinfo ('utc_to_datetime', round(mod(FINSH_TS, 1125899906842624)/1000)) AS FINSH_TS
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM KILL_JOB;
DROP VIEW SCI_C_NAMED_ENVIRONMENT;
DROP VIEW SCI_V_NAMED_ENVIRONMENT;
CREATE VIEW SCI_C_NAMED_ENVIRONMENT (ID,NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM NAMED_ENVIRONMENT
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_NAMED_ENVIRONMENT (ID,NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM NAMED_ENVIRONMENT;
DROP VIEW SCI_NAMED_RESOURCE;
CREATE VIEW SCI_NAMED_RESOURCE (ID,NAME,OWNER_ID,PARENT_ID,USAGE,RSP_ID,FACTOR,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS,INHERIT_PRIVS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , PARENT_ID                      AS PARENT_ID
    , DECODE (USAGE, 1, 'STATIC', 2, 'SYSTEM', 4, 'SYNCHRONIZING', 8, 'CATEGORY', 3, 'POOL') AS USAGE
    , RSP_ID                         AS RSP_ID
    , FACTOR                         AS FACTOR
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , INHERIT_PRIVS                  AS INHERIT_PRIVS
  FROM NAMED_RESOURCE;
DROP VIEW SCI_MEMBER;
CREATE VIEW SCI_MEMBER (ID,G_ID,U_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , G_ID                           AS G_ID
    , U_ID                           AS U_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM MEMBER;
DROP VIEW SCI_C_OBJECT_COMMENT;
DROP VIEW SCI_V_OBJECT_COMMENT;
CREATE VIEW SCI_C_OBJECT_COMMENT (ID,OBJECT_ID,OBJECT_TYPE,INFO_TYPE,SEQUENCE_NUMBER,DESCRIPTION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , OBJECT_ID                      AS OBJECT_ID
    , DECODE (OBJECT_TYPE, 9, 'JOB_DEFINITION', 2, 'EXIT_STATE_DEFINITION', 3, 'EXIT_STATE_PROFILE', 4, 'EXIT_STATE_MAPPING', 5, 'EXIT_STATE_TRANSLATION', 6, 'FOLDER', 15, 'SCOPE', 10, 'NAMED_RESOURCE', 31, 'NICE_PROFILE', 11, 'RESOURCE', 1, 'ENVIRONMENT', 7, 'FOOTPRINT', 13, 'RESOURCE_STATE_DEFINITION', 14, 'RESOURCE_STATE_PROFILE', 12, 'RESOURCE_STATE_MAPPING', 8, 'USER', 16, 'TRIGGER', 17, 'JOB', 18, 'EVENT', 19, 'INTERVAL', 20, 'SCHEDULE', 22, 'SCHEDULED_EVENT', 21, 'GROUP', 23, 'PARAMETER', 24, 'POOL', 25, 'DISTRIBUTION', 29, 'WATCH_TYPE', 30, 'OBJECT_MONITOR') AS OBJECT_TYPE
    , DECODE (INFO_TYPE, 0, 'TEXT', 1, 'URL') AS INFO_TYPE
    , SEQUENCE_NUMBER                AS SEQUENCE_NUMBER
    , DESCRIPTION                    AS DESCRIPTION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM OBJECT_COMMENT
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_OBJECT_COMMENT (ID,OBJECT_ID,OBJECT_TYPE,INFO_TYPE,SEQUENCE_NUMBER,DESCRIPTION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , OBJECT_ID                      AS OBJECT_ID
    , DECODE (OBJECT_TYPE, 9, 'JOB_DEFINITION', 2, 'EXIT_STATE_DEFINITION', 3, 'EXIT_STATE_PROFILE', 4, 'EXIT_STATE_MAPPING', 5, 'EXIT_STATE_TRANSLATION', 6, 'FOLDER', 15, 'SCOPE', 10, 'NAMED_RESOURCE', 31, 'NICE_PROFILE', 11, 'RESOURCE', 1, 'ENVIRONMENT', 7, 'FOOTPRINT', 13, 'RESOURCE_STATE_DEFINITION', 14, 'RESOURCE_STATE_PROFILE', 12, 'RESOURCE_STATE_MAPPING', 8, 'USER', 16, 'TRIGGER', 17, 'JOB', 18, 'EVENT', 19, 'INTERVAL', 20, 'SCHEDULE', 22, 'SCHEDULED_EVENT', 21, 'GROUP', 23, 'PARAMETER', 24, 'POOL', 25, 'DISTRIBUTION', 29, 'WATCH_TYPE', 30, 'OBJECT_MONITOR') AS OBJECT_TYPE
    , DECODE (INFO_TYPE, 0, 'TEXT', 1, 'URL') AS INFO_TYPE
    , SEQUENCE_NUMBER                AS SEQUENCE_NUMBER
    , DESCRIPTION                    AS DESCRIPTION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM OBJECT_COMMENT;
DROP VIEW SCI_OBJECT_EVENT;
CREATE VIEW SCI_OBJECT_EVENT (ID,TR_ID,OI_ID,EVENT_TYPE,SME_ID,SE_ID,SUBMIT_TS,FINAL_TS,FINAL_ESD_ID,MAIN_SME_ID,MAIN_SE_ID,MAIN_FINAL_TS,MAIN_FINAL_ESD_ID,SE_VERSION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , TR_ID                          AS TR_ID
    , OI_ID                          AS OI_ID
    , DECODE (EVENT_TYPE, 1, 'CREATE', 2, 'CHANGE', 3, 'DELETE') AS EVENT_TYPE
    , SME_ID                         AS SME_ID
    , SE_ID                          AS SE_ID
    , dbinfo ('utc_to_datetime', round(mod(SUBMIT_TS, 1125899906842624)/1000)) AS SUBMIT_TS
    , dbinfo ('utc_to_datetime', round(mod(FINAL_TS, 1125899906842624)/1000)) AS FINAL_TS
    , FINAL_ESD_ID                   AS FINAL_ESD_ID
    , MAIN_SME_ID                    AS MAIN_SME_ID
    , MAIN_SE_ID                     AS MAIN_SE_ID
    , dbinfo ('utc_to_datetime', round(mod(MAIN_FINAL_TS, 1125899906842624)/1000)) AS MAIN_FINAL_TS
    , MAIN_FINAL_ESD_ID              AS MAIN_FINAL_ESD_ID
    , SE_VERSION                     AS SE_VERSION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM OBJECT_EVENT;
DROP VIEW SCI_OBJECT_INSTANCE;
CREATE VIEW SCI_OBJECT_INSTANCE (ID,UNIQUE_NAME,OM_ID,MODIFY_TS,REMOVE_TS,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , UNIQUE_NAME                    AS UNIQUE_NAME
    , OM_ID                          AS OM_ID
    , dbinfo ('utc_to_datetime', round(mod(MODIFY_TS, 1125899906842624)/1000)) AS MODIFY_TS
    , dbinfo ('utc_to_datetime', round(mod(REMOVE_TS, 1125899906842624)/1000)) AS REMOVE_TS
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM OBJECT_INSTANCE;
DROP VIEW SCI_OBJECT_MONITOR;
CREATE VIEW SCI_OBJECT_MONITOR (ID,NAME,OWNER_ID,WT_ID,RECREATE_HANDLING,WATCH_SE_ID,DELETE_AMOUNT,DELETE_BASE,EVENT_DELETE_AMOUNT,EVENT_DELETE_BASE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , WT_ID                          AS WT_ID
    , DECODE (RECREATE_HANDLING, 0, 'NONE', 1, 'CREATE', 2, 'CHANGE') AS RECREATE_HANDLING
    , WATCH_SE_ID                    AS WATCH_SE_ID
    , DELETE_AMOUNT                  AS DELETE_AMOUNT
    , DECODE (DELETE_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS DELETE_BASE
    , EVENT_DELETE_AMOUNT            AS EVENT_DELETE_AMOUNT
    , DECODE (EVENT_DELETE_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS EVENT_DELETE_BASE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM OBJECT_MONITOR;
DROP VIEW SCI_OBJECT_MONITOR_PARAMETER;
CREATE VIEW SCI_OBJECT_MONITOR_PARAMETER (ID,VALUE,OM_ID,WTP_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , VALUE                          AS VALUE
    , OM_ID                          AS OM_ID
    , WTP_ID                         AS WTP_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM OBJECT_MONITOR_PARAMETER;
DROP VIEW SCI_C_PARAMETER_DEFINITION;
DROP VIEW SCI_V_PARAMETER_DEFINITION;
CREATE VIEW SCI_C_PARAMETER_DEFINITION (ID,SE_ID,NAME,TYPE,AGG_FUNCTION,DEFAULTVALUE,IS_LOCAL,LINK_PD_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , SE_ID                          AS SE_ID
    , NAME                           AS NAME
    , DECODE (TYPE, 10, 'REFERENCE', 20, 'CHILDREFERENCE', 30, 'CONSTANT', 40, 'RESULT', 50, 'PARAMETER', 60, 'EXPRESSION', 70, 'IMPORT', 71, 'IMPORT_UNRESOLVED', 80, 'DYNAMIC', 81, 'DYNAMICVALUE', 90, 'LOCAL_CONSTANT', 91, 'RESOURCEREFERENCE') AS TYPE
    , DECODE (AGG_FUNCTION, 0, 'NONE', 61, 'AVG', 62, 'COUNT', 63, 'MIN', 64, 'MAX', 65, 'SUM') AS AGG_FUNCTION
    , DEFAULTVALUE                   AS DEFAULTVALUE
    , DECODE (IS_LOCAL, 1, 'TRUE', 0, 'FALSE') AS IS_LOCAL
    , LINK_PD_ID                     AS LINK_PD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM PARAMETER_DEFINITION
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_PARAMETER_DEFINITION (ID,SE_ID,NAME,TYPE,AGG_FUNCTION,DEFAULTVALUE,IS_LOCAL,LINK_PD_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , SE_ID                          AS SE_ID
    , NAME                           AS NAME
    , DECODE (TYPE, 10, 'REFERENCE', 20, 'CHILDREFERENCE', 30, 'CONSTANT', 40, 'RESULT', 50, 'PARAMETER', 60, 'EXPRESSION', 70, 'IMPORT', 71, 'IMPORT_UNRESOLVED', 80, 'DYNAMIC', 81, 'DYNAMICVALUE', 90, 'LOCAL_CONSTANT', 91, 'RESOURCEREFERENCE') AS TYPE
    , DECODE (AGG_FUNCTION, 0, 'NONE', 61, 'AVG', 62, 'COUNT', 63, 'MIN', 64, 'MAX', 65, 'SUM') AS AGG_FUNCTION
    , DEFAULTVALUE                   AS DEFAULTVALUE
    , DECODE (IS_LOCAL, 1, 'TRUE', 0, 'FALSE') AS IS_LOCAL
    , LINK_PD_ID                     AS LINK_PD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM PARAMETER_DEFINITION;
DROP VIEW SCI_PERSISTENT_VALUE;
CREATE VIEW SCI_PERSISTENT_VALUE (ID,NAME,INT_VALUE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , INT_VALUE                      AS INT_VALUE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM PERSISTENT_VALUE;
DROP VIEW SCI_POOL;
CREATE VIEW SCI_POOL (ID,NR_ID,SCOPE_ID,OWNER_ID,MANAGER_ID,DIST_ID,DEFINED_AMOUNT,AMOUNT,FREE_AMOUNT,CHILD_ALLOCATED,EVALUATION_CYCLE,NEXT_EVALUATION_TIME,TAG,TRACE_INTERVAL,TRACE_BASE,TRACE_BASE_MULTIPLIER,TD0_AVG,TD1_AVG,TD2_AVG,LW_AVG,LAST_EVAL,LAST_WRITE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NR_ID                          AS NR_ID
    , SCOPE_ID                       AS SCOPE_ID
    , OWNER_ID                       AS OWNER_ID
    , MANAGER_ID                     AS MANAGER_ID
    , DIST_ID                        AS DIST_ID
    , DEFINED_AMOUNT                 AS DEFINED_AMOUNT
    , AMOUNT                         AS AMOUNT
    , FREE_AMOUNT                    AS FREE_AMOUNT
    , CHILD_ALLOCATED                AS CHILD_ALLOCATED
    , EVALUATION_CYCLE               AS EVALUATION_CYCLE
    , NEXT_EVALUATION_TIME           AS NEXT_EVALUATION_TIME
    , TAG                            AS TAG
    , TRACE_INTERVAL                 AS TRACE_INTERVAL
    , TRACE_BASE                     AS TRACE_BASE
    , TRACE_BASE_MULTIPLIER          AS TRACE_BASE_MULTIPLIER
    , TD0_AVG                        AS TD0_AVG
    , TD1_AVG                        AS TD1_AVG
    , TD2_AVG                        AS TD2_AVG
    , LW_AVG                         AS LW_AVG
    , dbinfo ('utc_to_datetime', round(mod(LAST_EVAL, 1125899906842624)/1000)) AS LAST_EVAL
    , dbinfo ('utc_to_datetime', round(mod(LAST_WRITE, 1125899906842624)/1000)) AS LAST_WRITE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM POOL;
DROP VIEW SCI_POOL_DIST_CONFIG;
CREATE VIEW SCI_POOL_DIST_CONFIG (ID,PLD_ID,PR_ID,IS_MANAGED,NOM_PCT,FREE_PCT,MIN_PCT,MAX_PCT,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , PLD_ID                         AS PLD_ID
    , PR_ID                          AS PR_ID
    , DECODE (IS_MANAGED, 1, 'TRUE', 0, 'FALSE') AS IS_MANAGED
    , NOM_PCT                        AS NOM_PCT
    , FREE_PCT                       AS FREE_PCT
    , MIN_PCT                        AS MIN_PCT
    , MAX_PCT                        AS MAX_PCT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM POOL_DIST_CONFIG;
DROP VIEW SCI_POOL_DISTRIBUTION;
CREATE VIEW SCI_POOL_DISTRIBUTION (ID,NAME,P_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , P_ID                           AS P_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM POOL_DISTRIBUTION;
DROP VIEW SCI_POOLED_RESOURCE;
CREATE VIEW SCI_POOLED_RESOURCE (ID,P_ID,R_ID,IS_POOL,IS_MANAGED,NOM_PCT,FREE_PCT,MIN_PCT,MAX_PCT,ACT_IS_MANAGED,ACT_NOM_PCT,ACT_FREE_PCT,ACT_MIN_PCT,ACT_MAX_PCT,TARGET_AMOUNT,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , P_ID                           AS P_ID
    , R_ID                           AS R_ID
    , DECODE (IS_POOL, 1, 'TRUE', 0, 'FALSE') AS IS_POOL
    , DECODE (IS_MANAGED, 1, 'TRUE', 0, 'FALSE') AS IS_MANAGED
    , NOM_PCT                        AS NOM_PCT
    , FREE_PCT                       AS FREE_PCT
    , MIN_PCT                        AS MIN_PCT
    , MAX_PCT                        AS MAX_PCT
    , DECODE (ACT_IS_MANAGED, 1, 'TRUE', 0, 'FALSE') AS ACT_IS_MANAGED
    , ACT_NOM_PCT                    AS ACT_NOM_PCT
    , ACT_FREE_PCT                   AS ACT_FREE_PCT
    , ACT_MIN_PCT                    AS ACT_MIN_PCT
    , ACT_MAX_PCT                    AS ACT_MAX_PCT
    , TARGET_AMOUNT                  AS TARGET_AMOUNT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM POOLED_RESOURCE;
DROP VIEW SCI_RESSOURCE;
CREATE VIEW SCI_RESSOURCE (ID,NR_ID,SCOPE_ID,MASTER_ID,OWNER_ID,LINK_ID,MANAGER_ID,TAG,RSD_ID,RSD_TIME,DEFINED_AMOUNT,REQUESTABLE_AMOUNT,AMOUNT,FREE_AMOUNT,IS_ONLINE,FACTOR,TRACE_INTERVAL,TRACE_BASE,TRACE_BASE_MULTIPLIER,TD0_AVG,TD1_AVG,TD2_AVG,LW_AVG,LAST_EVAL,LAST_WRITE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NR_ID                          AS NR_ID
    , SCOPE_ID                       AS SCOPE_ID
    , MASTER_ID                      AS MASTER_ID
    , OWNER_ID                       AS OWNER_ID
    , LINK_ID                        AS LINK_ID
    , MANAGER_ID                     AS MANAGER_ID
    , TAG                            AS TAG
    , RSD_ID                         AS RSD_ID
    , dbinfo ('utc_to_datetime', round(mod(RSD_TIME, 1125899906842624)/1000)) AS RSD_TIME
    , DEFINED_AMOUNT                 AS DEFINED_AMOUNT
    , REQUESTABLE_AMOUNT             AS REQUESTABLE_AMOUNT
    , AMOUNT                         AS AMOUNT
    , FREE_AMOUNT                    AS FREE_AMOUNT
    , DECODE (IS_ONLINE, 1, 'TRUE', 0, 'FALSE') AS IS_ONLINE
    , FACTOR                         AS FACTOR
    , TRACE_INTERVAL                 AS TRACE_INTERVAL
    , TRACE_BASE                     AS TRACE_BASE
    , TRACE_BASE_MULTIPLIER          AS TRACE_BASE_MULTIPLIER
    , TD0_AVG                        AS TD0_AVG
    , TD1_AVG                        AS TD1_AVG
    , TD2_AVG                        AS TD2_AVG
    , LW_AVG                         AS LW_AVG
    , dbinfo ('utc_to_datetime', round(mod(LAST_EVAL, 1125899906842624)/1000)) AS LAST_EVAL
    , dbinfo ('utc_to_datetime', round(mod(LAST_WRITE, 1125899906842624)/1000)) AS LAST_WRITE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM RESSOURCE;
ALTER TABLE RESOURCE_ALLOCATION ADD (
    STICKY_NAME lvarchar(64),
    STICKY_PARENT bigint
);
DROP VIEW SCI_RESOURCE_ALLOCATION;
CREATE VIEW SCI_RESOURCE_ALLOCATION (ID,R_ID,SME_ID,NR_ID,AMOUNT,ORIG_AMOUNT,KEEP_MODE,IS_STICKY,STICKY_NAME,STICKY_PARENT,ALLOCATION_TYPE,RSMP_ID,LOCKMODE,REFCOUNT,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , R_ID                           AS R_ID
    , SME_ID                         AS SME_ID
    , NR_ID                          AS NR_ID
    , AMOUNT                         AS AMOUNT
    , ORIG_AMOUNT                    AS ORIG_AMOUNT
    , DECODE (KEEP_MODE, 0, 'NOKEEP', 1, 'KEEP', 2, 'KEEP_FINAL') AS KEEP_MODE
    , DECODE (IS_STICKY, 1, 'TRUE', 0, 'FALSE') AS IS_STICKY
    , STICKY_NAME                    AS STICKY_NAME
    , STICKY_PARENT                  AS STICKY_PARENT
    , DECODE (ALLOCATION_TYPE, 1, 'REQUEST', 6, 'MASTER_REQUEST', 2, 'RESERVATION', 3, 'MASTER_RESERVATION', 4, 'ALLOCATION', 5, 'IGNORE') AS ALLOCATION_TYPE
    , RSMP_ID                        AS RSMP_ID
    , DECODE (LOCKMODE, 255, 'N', 0, 'X', 2, 'SX', 4, 'S', 6, 'SC') AS LOCKMODE
    , REFCOUNT                       AS REFCOUNT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM RESOURCE_ALLOCATION;
DROP VIEW SCI_C_RESOURCE_REQ_STATES;
DROP VIEW SCI_V_RESOURCE_REQ_STATES;
CREATE VIEW SCI_C_RESOURCE_REQ_STATES (ID,RR_ID,RSD_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , RR_ID                          AS RR_ID
    , RSD_ID                         AS RSD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM RESOURCE_REQ_STATES
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_RESOURCE_REQ_STATES (ID,RR_ID,RSD_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , RR_ID                          AS RR_ID
    , RSD_ID                         AS RSD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM RESOURCE_REQ_STATES;
ALTER TABLE RESOURCE_REQUIREMENT ADD (
    STICKY_NAME lvarchar(64),
    STICKY_PARENT bigint
);
DROP VIEW SCI_C_RESOURCE_REQUIREMENT;
DROP VIEW SCI_V_RESOURCE_REQUIREMENT;
CREATE VIEW SCI_C_RESOURCE_REQUIREMENT (ID,NR_ID,SE_ID,AMOUNT,KEEP_MODE,IS_STICKY,STICKY_NAME,STICKY_PARENT,RSMP_ID,EXPIRED_AMOUNT,EXPIRED_BASE,LOCKMODE,CONDITION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NR_ID                          AS NR_ID
    , SE_ID                          AS SE_ID
    , AMOUNT                         AS AMOUNT
    , DECODE (KEEP_MODE, 0, 'NOKEEP', 1, 'KEEP', 2, 'KEEP_FINAL') AS KEEP_MODE
    , DECODE (IS_STICKY, 1, 'TRUE', 0, 'FALSE') AS IS_STICKY
    , STICKY_NAME                    AS STICKY_NAME
    , STICKY_PARENT                  AS STICKY_PARENT
    , RSMP_ID                        AS RSMP_ID
    , EXPIRED_AMOUNT                 AS EXPIRED_AMOUNT
    , DECODE (EXPIRED_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS EXPIRED_BASE
    , DECODE (LOCKMODE, 255, 'N', 0, 'X', 2, 'SX', 4, 'S', 6, 'SC') AS LOCKMODE
    , CONDITION                      AS CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM RESOURCE_REQUIREMENT
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_RESOURCE_REQUIREMENT (ID,NR_ID,SE_ID,AMOUNT,KEEP_MODE,IS_STICKY,STICKY_NAME,STICKY_PARENT,RSMP_ID,EXPIRED_AMOUNT,EXPIRED_BASE,LOCKMODE,CONDITION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , NR_ID                          AS NR_ID
    , SE_ID                          AS SE_ID
    , AMOUNT                         AS AMOUNT
    , DECODE (KEEP_MODE, 0, 'NOKEEP', 1, 'KEEP', 2, 'KEEP_FINAL') AS KEEP_MODE
    , DECODE (IS_STICKY, 1, 'TRUE', 0, 'FALSE') AS IS_STICKY
    , STICKY_NAME                    AS STICKY_NAME
    , STICKY_PARENT                  AS STICKY_PARENT
    , RSMP_ID                        AS RSMP_ID
    , EXPIRED_AMOUNT                 AS EXPIRED_AMOUNT
    , DECODE (EXPIRED_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS EXPIRED_BASE
    , DECODE (LOCKMODE, 255, 'N', 0, 'X', 2, 'SX', 4, 'S', 6, 'SC') AS LOCKMODE
    , CONDITION                      AS CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM RESOURCE_REQUIREMENT;
DROP VIEW SCI_RESOURCE_STATE;
CREATE VIEW SCI_RESOURCE_STATE (ID,RSD_ID,RSP_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , RSD_ID                         AS RSD_ID
    , RSP_ID                         AS RSP_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM RESOURCE_STATE;
DROP VIEW SCI_RESOURCE_STATE_DEFINITION;
CREATE VIEW SCI_RESOURCE_STATE_DEFINITION (ID,NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM RESOURCE_STATE_DEFINITION;
DROP VIEW SCI_C_RESOURCE_STATE_MAPPING;
DROP VIEW SCI_V_RESOURCE_STATE_MAPPING;
CREATE VIEW SCI_C_RESOURCE_STATE_MAPPING (ID,RSMP_ID,ESD_ID,FROM_RSD_ID,TO_RSD_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , RSMP_ID                        AS RSMP_ID
    , ESD_ID                         AS ESD_ID
    , FROM_RSD_ID                    AS FROM_RSD_ID
    , TO_RSD_ID                      AS TO_RSD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM RESOURCE_STATE_MAPPING
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_RESOURCE_STATE_MAPPING (ID,RSMP_ID,ESD_ID,FROM_RSD_ID,TO_RSD_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , RSMP_ID                        AS RSMP_ID
    , ESD_ID                         AS ESD_ID
    , FROM_RSD_ID                    AS FROM_RSD_ID
    , TO_RSD_ID                      AS TO_RSD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM RESOURCE_STATE_MAPPING;
DROP VIEW SCI_C_RESOURCE_STATE_MAP_PROF;
DROP VIEW SCI_V_RESOURCE_STATE_MAP_PROF;
CREATE VIEW SCI_C_RESOURCE_STATE_MAP_PROF (ID,NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM RESOURCE_STATE_MAP_PROF
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_RESOURCE_STATE_MAP_PROF (ID,NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM RESOURCE_STATE_MAP_PROF;
DROP VIEW SCI_RESOURCE_STATE_PROFILE;
CREATE VIEW SCI_RESOURCE_STATE_PROFILE (ID,NAME,INITIAL_RSD_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , INITIAL_RSD_ID                 AS INITIAL_RSD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM RESOURCE_STATE_PROFILE;
DROP VIEW SCI_C_RESOURCE_TEMPLATE;
DROP VIEW SCI_V_RESOURCE_TEMPLATE;
CREATE VIEW SCI_C_RESOURCE_TEMPLATE (ID,NR_ID,SE_ID,OWNER_ID,RSD_ID,REQUESTABLE_AMOUNT,AMOUNT,IS_ONLINE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NR_ID                          AS NR_ID
    , SE_ID                          AS SE_ID
    , OWNER_ID                       AS OWNER_ID
    , RSD_ID                         AS RSD_ID
    , REQUESTABLE_AMOUNT             AS REQUESTABLE_AMOUNT
    , AMOUNT                         AS AMOUNT
    , DECODE (IS_ONLINE, 1, 'TRUE', 0, 'FALSE') AS IS_ONLINE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM RESOURCE_TEMPLATE
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_RESOURCE_TEMPLATE (ID,NR_ID,SE_ID,OWNER_ID,RSD_ID,REQUESTABLE_AMOUNT,AMOUNT,IS_ONLINE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , NR_ID                          AS NR_ID
    , SE_ID                          AS SE_ID
    , OWNER_ID                       AS OWNER_ID
    , RSD_ID                         AS RSD_ID
    , REQUESTABLE_AMOUNT             AS REQUESTABLE_AMOUNT
    , AMOUNT                         AS AMOUNT
    , DECODE (IS_ONLINE, 1, 'TRUE', 0, 'FALSE') AS IS_ONLINE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM RESOURCE_TEMPLATE;
DROP VIEW SCI_RESOURCE_VARIABLE;
CREATE VIEW SCI_RESOURCE_VARIABLE (ID,PD_ID,R_ID,VALUE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , PD_ID                          AS PD_ID
    , R_ID                           AS R_ID
    , VALUE                          AS VALUE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM RESOURCE_VARIABLE;
DROP VIEW SCI_RUNNABLE_QUEUE;
CREATE VIEW SCI_RUNNABLE_QUEUE (ID,SME_ID,SCOPE_ID,STATE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , SME_ID                         AS SME_ID
    , SCOPE_ID                       AS SCOPE_ID
    , DECODE (STATE, 1, 'DEPENDENCY_WAIT', 2, 'SYNCHRONIZE_WAIT', 3, 'RESOURCE_WAIT', 4, 'RUNNABLE', 5, 'STARTING') AS STATE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM RUNNABLE_QUEUE;
DROP VIEW SCI_SCHEDULE;
CREATE VIEW SCI_SCHEDULE (ID,NAME,OWNER_ID,INT_ID,PARENT_ID,TIME_ZONE,SE_ID,ACTIVE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS,INHERIT_PRIVS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , INT_ID                         AS INT_ID
    , PARENT_ID                      AS PARENT_ID
    , TIME_ZONE                      AS TIME_ZONE
    , SE_ID                          AS SE_ID
    , DECODE (ACTIVE, 1, 'ACTIVE', 0, 'INACTIVE') AS ACTIVE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , INHERIT_PRIVS                  AS INHERIT_PRIVS
  FROM SCHEDULE;
DROP VIEW SCI_SCHEDULED_EVENT;
CREATE VIEW SCI_SCHEDULED_EVENT (ID,OWNER_ID,SCE_ID,EVT_ID,ACTIVE,BROKEN,ERROR_CODE,ERROR_MSG,LAST_START_TIME,NEXT_START_TIME,NEXT_IS_TRIGGER,BACKLOG_HANDLING,SUSPEND_LIMIT,SUSPEND_LIMIT_MULTIPLIER,IS_CALENDAR,CALENDAR_HORIZON,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , OWNER_ID                       AS OWNER_ID
    , SCE_ID                         AS SCE_ID
    , EVT_ID                         AS EVT_ID
    , DECODE (ACTIVE, 1, 'ACTIVE', 0, 'INACTIVE') AS ACTIVE
    , DECODE (BROKEN, 1, 'BROKEN', 0, 'NOBROKEN') AS BROKEN
    , ERROR_CODE                     AS ERROR_CODE
    , ERROR_MSG                      AS ERROR_MSG
    , dbinfo ('utc_to_datetime', round(mod(LAST_START_TIME, 1125899906842624)/1000)) AS LAST_START_TIME
    , dbinfo ('utc_to_datetime', round(mod(NEXT_START_TIME, 1125899906842624)/1000)) AS NEXT_START_TIME
    , DECODE (NEXT_IS_TRIGGER, 1, 'TRUE', 0, 'FALSE') AS NEXT_IS_TRIGGER
    , DECODE (BACKLOG_HANDLING, 0, 'NONE', 1, 'LAST', 2, 'ALL') AS BACKLOG_HANDLING
    , DECODE (SUSPEND_LIMIT, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS SUSPEND_LIMIT
    , SUSPEND_LIMIT_MULTIPLIER       AS SUSPEND_LIMIT_MULTIPLIER
    , DECODE (IS_CALENDAR, 1, 'ACTIVE', 0, 'INACTIVE') AS IS_CALENDAR
    , CALENDAR_HORIZON               AS CALENDAR_HORIZON
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM SCHEDULED_EVENT;
DROP VIEW SCI_C_SCHEDULING_ENTITY;
DROP VIEW SCI_V_SCHEDULING_ENTITY;
CREATE VIEW SCI_C_SCHEDULING_ENTITY (ID,NAME,FOLDER_ID,OWNER_ID,TYPE,RUN_PROGRAM,RERUN_PROGRAM,KILL_PROGRAM,WORKDIR,LOGFILE,TRUNC_LOG,ERRLOGFILE,TRUNC_ERRLOG,EXPECTED_RUNTIME,EXPECTED_FINALTIME,GET_EXPECTED_RUNTIME,PRIORITY,MIN_PRIORITY,AGING_AMOUNT,AGING_BASE,SUBMIT_SUSPENDED,RESUME_AT,RESUME_IN,RESUME_BASE,MASTER_SUBMITTABLE,TIMEOUT_AMOUNT,TIMEOUT_BASE,TIMEOUT_STATE_ID,DEPENDENCY_OPERATION,ESMP_ID,ESP_ID,NE_ID,FP_ID,INHERIT_PRIVS,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , FOLDER_ID                      AS FOLDER_ID
    , OWNER_ID                       AS OWNER_ID
    , DECODE (TYPE, 1, 'JOB', 2, 'BATCH', 3, 'MILESTONE') AS TYPE
    , RUN_PROGRAM                    AS RUN_PROGRAM
    , RERUN_PROGRAM                  AS RERUN_PROGRAM
    , KILL_PROGRAM                   AS KILL_PROGRAM
    , WORKDIR                        AS WORKDIR
    , LOGFILE                        AS LOGFILE
    , DECODE (TRUNC_LOG, 0, 'NOTRUNC', 1, 'TRUNC') AS TRUNC_LOG
    , ERRLOGFILE                     AS ERRLOGFILE
    , DECODE (TRUNC_ERRLOG, 0, 'NOTRUNC', 1, 'TRUNC') AS TRUNC_ERRLOG
    , EXPECTED_RUNTIME               AS EXPECTED_RUNTIME
    , EXPECTED_FINALTIME             AS EXPECTED_FINALTIME
    , GET_EXPECTED_RUNTIME           AS GET_EXPECTED_RUNTIME
    , PRIORITY                       AS PRIORITY
    , MIN_PRIORITY                   AS MIN_PRIORITY
    , AGING_AMOUNT                   AS AGING_AMOUNT
    , DECODE (AGING_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS AGING_BASE
    , DECODE (SUBMIT_SUSPENDED, 1, 'SUSPEND', 0, 'NOSUSPEND') AS SUBMIT_SUSPENDED
    , RESUME_AT                      AS RESUME_AT
    , RESUME_IN                      AS RESUME_IN
    , DECODE (RESUME_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS RESUME_BASE
    , DECODE (MASTER_SUBMITTABLE, 1, 'MASTER', 0, 'NOMASTER') AS MASTER_SUBMITTABLE
    , TIMEOUT_AMOUNT                 AS TIMEOUT_AMOUNT
    , DECODE (TIMEOUT_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS TIMEOUT_BASE
    , TIMEOUT_STATE_ID               AS TIMEOUT_STATE_ID
    , DECODE (DEPENDENCY_OPERATION, 1, 'AND', 2, 'OR') AS DEPENDENCY_OPERATION
    , ESMP_ID                        AS ESMP_ID
    , ESP_ID                         AS ESP_ID
    , NE_ID                          AS NE_ID
    , FP_ID                          AS FP_ID
    , INHERIT_PRIVS                  AS INHERIT_PRIVS
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM SCHEDULING_ENTITY
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_SCHEDULING_ENTITY (ID,NAME,FOLDER_ID,OWNER_ID,TYPE,RUN_PROGRAM,RERUN_PROGRAM,KILL_PROGRAM,WORKDIR,LOGFILE,TRUNC_LOG,ERRLOGFILE,TRUNC_ERRLOG,EXPECTED_RUNTIME,EXPECTED_FINALTIME,GET_EXPECTED_RUNTIME,PRIORITY,MIN_PRIORITY,AGING_AMOUNT,AGING_BASE,SUBMIT_SUSPENDED,RESUME_AT,RESUME_IN,RESUME_BASE,MASTER_SUBMITTABLE,TIMEOUT_AMOUNT,TIMEOUT_BASE,TIMEOUT_STATE_ID,DEPENDENCY_OPERATION,ESMP_ID,ESP_ID,NE_ID,FP_ID,INHERIT_PRIVS,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , FOLDER_ID                      AS FOLDER_ID
    , OWNER_ID                       AS OWNER_ID
    , DECODE (TYPE, 1, 'JOB', 2, 'BATCH', 3, 'MILESTONE') AS TYPE
    , RUN_PROGRAM                    AS RUN_PROGRAM
    , RERUN_PROGRAM                  AS RERUN_PROGRAM
    , KILL_PROGRAM                   AS KILL_PROGRAM
    , WORKDIR                        AS WORKDIR
    , LOGFILE                        AS LOGFILE
    , DECODE (TRUNC_LOG, 0, 'NOTRUNC', 1, 'TRUNC') AS TRUNC_LOG
    , ERRLOGFILE                     AS ERRLOGFILE
    , DECODE (TRUNC_ERRLOG, 0, 'NOTRUNC', 1, 'TRUNC') AS TRUNC_ERRLOG
    , EXPECTED_RUNTIME               AS EXPECTED_RUNTIME
    , EXPECTED_FINALTIME             AS EXPECTED_FINALTIME
    , GET_EXPECTED_RUNTIME           AS GET_EXPECTED_RUNTIME
    , PRIORITY                       AS PRIORITY
    , MIN_PRIORITY                   AS MIN_PRIORITY
    , AGING_AMOUNT                   AS AGING_AMOUNT
    , DECODE (AGING_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS AGING_BASE
    , DECODE (SUBMIT_SUSPENDED, 1, 'SUSPEND', 0, 'NOSUSPEND') AS SUBMIT_SUSPENDED
    , RESUME_AT                      AS RESUME_AT
    , RESUME_IN                      AS RESUME_IN
    , DECODE (RESUME_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS RESUME_BASE
    , DECODE (MASTER_SUBMITTABLE, 1, 'MASTER', 0, 'NOMASTER') AS MASTER_SUBMITTABLE
    , TIMEOUT_AMOUNT                 AS TIMEOUT_AMOUNT
    , DECODE (TIMEOUT_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS TIMEOUT_BASE
    , TIMEOUT_STATE_ID               AS TIMEOUT_STATE_ID
    , DECODE (DEPENDENCY_OPERATION, 1, 'AND', 2, 'OR') AS DEPENDENCY_OPERATION
    , ESMP_ID                        AS ESMP_ID
    , ESP_ID                         AS ESP_ID
    , NE_ID                          AS NE_ID
    , FP_ID                          AS FP_ID
    , INHERIT_PRIVS                  AS INHERIT_PRIVS
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM SCHEDULING_ENTITY;
DROP VIEW SCI_C_SCHEDULING_HIERARCHY;
DROP VIEW SCI_V_SCHEDULING_HIERARCHY;
CREATE VIEW SCI_C_SCHEDULING_HIERARCHY (ID,SE_PARENT_ID,SE_CHILD_ID,ALIAS_NAME,IS_STATIC,PRIORITY,SUSPEND,RESUME_AT,RESUME_IN,RESUME_BASE,MERGE_MODE,ESTP_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , SE_PARENT_ID                   AS SE_PARENT_ID
    , SE_CHILD_ID                    AS SE_CHILD_ID
    , ALIAS_NAME                     AS ALIAS_NAME
    , DECODE (IS_STATIC, 1, 'STATIC', 0, 'DYNAMIC') AS IS_STATIC
    , PRIORITY                       AS PRIORITY
    , DECODE (SUSPEND, 1, 'CHILDSUSPEND', 2, 'NOSUSPEND', 3, 'SUSPEND') AS SUSPEND
    , RESUME_AT                      AS RESUME_AT
    , RESUME_IN                      AS RESUME_IN
    , DECODE (RESUME_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS RESUME_BASE
    , DECODE (MERGE_MODE, 1, 'MERGE_LOCAL', 2, 'MERGE_GLOBAL', 3, 'NOMERGE', 4, 'FAILURE') AS MERGE_MODE
    , ESTP_ID                        AS ESTP_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM SCHEDULING_HIERARCHY
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_SCHEDULING_HIERARCHY (ID,SE_PARENT_ID,SE_CHILD_ID,ALIAS_NAME,IS_STATIC,PRIORITY,SUSPEND,RESUME_AT,RESUME_IN,RESUME_BASE,MERGE_MODE,ESTP_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , SE_PARENT_ID                   AS SE_PARENT_ID
    , SE_CHILD_ID                    AS SE_CHILD_ID
    , ALIAS_NAME                     AS ALIAS_NAME
    , DECODE (IS_STATIC, 1, 'STATIC', 0, 'DYNAMIC') AS IS_STATIC
    , PRIORITY                       AS PRIORITY
    , DECODE (SUSPEND, 1, 'CHILDSUSPEND', 2, 'NOSUSPEND', 3, 'SUSPEND') AS SUSPEND
    , RESUME_AT                      AS RESUME_AT
    , RESUME_IN                      AS RESUME_IN
    , DECODE (RESUME_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS RESUME_BASE
    , DECODE (MERGE_MODE, 1, 'MERGE_LOCAL', 2, 'MERGE_GLOBAL', 3, 'NOMERGE', 4, 'FAILURE') AS MERGE_MODE
    , ESTP_ID                        AS ESTP_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM SCHEDULING_HIERARCHY;
ALTER TABLE SCOPE ADD (
    SALT lvarchar(64),
    METHOD int8 DEFAULT 0 NOT NULL
);
DROP VIEW SCI_SCOPE;
CREATE VIEW SCI_SCOPE (ID,NAME,OWNER_ID,PARENT_ID,TYPE,IS_TERMINATE,HAS_ALTEREDCONFIG,IS_SUSPENDED,IS_ENABLED,IS_REGISTERED,STATE,PID,NODE,ERRMSG,LAST_ACTIVE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS,INHERIT_PRIVS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , PARENT_ID                      AS PARENT_ID
    , DECODE (TYPE, 1, 'SCOPE', 2, 'SERVER') AS TYPE
    , DECODE (IS_TERMINATE, 1, 'TRUE', 0, 'FALSE') AS IS_TERMINATE
    , DECODE (HAS_ALTEREDCONFIG, 1, 'TRUE', 0, 'FALSE') AS HAS_ALTEREDCONFIG
    , DECODE (IS_SUSPENDED, 1, 'TRUE', 0, 'FALSE') AS IS_SUSPENDED
    , DECODE (IS_ENABLED, 1, 'TRUE', 0, 'FALSE') AS IS_ENABLED
    , DECODE (IS_REGISTERED, 1, 'TRUE', 0, 'FALSE') AS IS_REGISTERED
    , DECODE (STATE, 1, 'NOMINAL', 2, 'NONFATAL', 3, 'FATAL') AS STATE
    , PID                            AS PID
    , NODE                           AS NODE
    , ERRMSG                         AS ERRMSG
    , LAST_ACTIVE                    AS LAST_ACTIVE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , INHERIT_PRIVS                  AS INHERIT_PRIVS
  FROM SCOPE;
DROP VIEW SCI_SCOPE_CONFIG;
CREATE VIEW SCI_SCOPE_CONFIG (ID,KEY,VALUE,S_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , KEY                            AS KEY
    , VALUE                          AS VALUE
    , S_ID                           AS S_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM SCOPE_CONFIG;
DROP VIEW SCI_SCOPE_CONFIG_ENVMAPPING;
CREATE VIEW SCI_SCOPE_CONFIG_ENVMAPPING (ID,KEY,VALUE,S_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , KEY                            AS KEY
    , VALUE                          AS VALUE
    , S_ID                           AS S_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM SCOPE_CONFIG_ENVMAPPING;
DROP VIEW SCI_SME_COUNTER;
CREATE VIEW SCI_SME_COUNTER (ID,JAHR,MONAT,TAG,ANZAHL,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , JAHR                           AS JAHR
    , MONAT                          AS MONAT
    , TAG                            AS TAG
    , ANZAHL                         AS ANZAHL
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM SME_COUNTER;
DROP VIEW SCI_SUBMITTED_ENTITY;
CREATE VIEW SCI_SUBMITTED_ENTITY (ID,MASTER_ID,SUBMIT_TAG,UNRESOLVED_HANDLING,SE_ID,CHILD_TAG,SE_VERSION,OWNER_ID,PARENT_ID,SCOPE_ID,IS_STATIC,MERGE_MODE,STATE,JOB_ESD_ID,JOB_ESD_PREF,JOB_IS_FINAL,JOB_IS_RESTARTABLE,FINAL_ESD_ID,EXIT_CODE,COMMANDLINE,RR_COMMANDLINE,RERUN_SEQ,IS_REPLACED,IS_CANCELLED,BASE_SME_ID,REASON_SME_ID,FIRE_SME_ID,FIRE_SE_ID,TR_ID,TR_SD_ID_OLD,TR_SD_ID_NEW,TR_SEQ,WORKDIR,LOGFILE,ERRLOGFILE,PID,EXTPID,ERROR_MSG,KILL_ID,KILL_EXIT_CODE,IS_SUSPENDED,IS_SUSPENDED_LOCAL,PRIORITY,NICE,MIN_PRIORITY,AGING_AMOUNT,PARENT_SUSPENDED,CHILD_SUSPENDED,WARN_COUNT,WARN_LINK,SUBMIT_TS,RESUME_TS,SYNC_TS,RESOURCE_TS,RUNNABLE_TS,START_TS,FINSH_TS,FINAL_TS,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS,PROCESS_TIME) AS
SELECT 
    ID 
    , MASTER_ID                      AS MASTER_ID
    , SUBMIT_TAG                     AS SUBMIT_TAG
    , DECODE (UNRESOLVED_HANDLING, 1, 'UH_IGNORE', 3, 'UH_SUSPEND', 2, 'UH_ERROR') AS UNRESOLVED_HANDLING
    , SE_ID                          AS SE_ID
    , CHILD_TAG                      AS CHILD_TAG
    , SE_VERSION                     AS SE_VERSION
    , OWNER_ID                       AS OWNER_ID
    , PARENT_ID                      AS PARENT_ID
    , SCOPE_ID                       AS SCOPE_ID
    , DECODE (IS_STATIC, 1, 'TRUE', 0, 'FALSE') AS IS_STATIC
    , DECODE (MERGE_MODE, 1, 'MERGE_LOCAL', 2, 'MERGE_GLOBAL', 3, 'NOMERGE', 4, 'FAILURE') AS MERGE_MODE
    , DECODE (STATE, 0, 'SUBMITTED', 1, 'DEPENDENCY_WAIT', 2, 'SYNCHRONIZE_WAIT', 3, 'RESOURCE_WAIT', 4, 'RUNNABLE', 5, 'STARTING', 6, 'STARTED', 7, 'RUNNING', 8, 'TO_KILL', 9, 'KILLED', 10, 'CANCELLED', 11, 'FINISHED', 12, 'FINAL', 13, 'BROKEN_ACTIVE', 14, 'BROKEN_FINISHED', 15, 'ERROR', 16, 'UNREACHABLE') AS STATE
    , JOB_ESD_ID                     AS JOB_ESD_ID
    , JOB_ESD_PREF                   AS JOB_ESD_PREF
    , DECODE (JOB_IS_FINAL, 1, 'TRUE', 0, 'FALSE') AS JOB_IS_FINAL
    , DECODE (JOB_IS_RESTARTABLE, 1, 'TRUE', 0, 'FALSE') AS JOB_IS_RESTARTABLE
    , FINAL_ESD_ID                   AS FINAL_ESD_ID
    , EXIT_CODE                      AS EXIT_CODE
    , COMMANDLINE                    AS COMMANDLINE
    , RR_COMMANDLINE                 AS RR_COMMANDLINE
    , RERUN_SEQ                      AS RERUN_SEQ
    , DECODE (IS_REPLACED, 1, 'TRUE', 0, 'FALSE') AS IS_REPLACED
    , DECODE (IS_CANCELLED, 1, 'TRUE', 0, 'FALSE') AS IS_CANCELLED
    , BASE_SME_ID                    AS BASE_SME_ID
    , REASON_SME_ID                  AS REASON_SME_ID
    , FIRE_SME_ID                    AS FIRE_SME_ID
    , FIRE_SE_ID                     AS FIRE_SE_ID
    , TR_ID                          AS TR_ID
    , TR_SD_ID_OLD                   AS TR_SD_ID_OLD
    , TR_SD_ID_NEW                   AS TR_SD_ID_NEW
    , TR_SEQ                         AS TR_SEQ
    , WORKDIR                        AS WORKDIR
    , LOGFILE                        AS LOGFILE
    , ERRLOGFILE                     AS ERRLOGFILE
    , PID                            AS PID
    , EXTPID                         AS EXTPID
    , ERROR_MSG                      AS ERROR_MSG
    , KILL_ID                        AS KILL_ID
    , KILL_EXIT_CODE                 AS KILL_EXIT_CODE
    , DECODE (IS_SUSPENDED, 2, 'ADMINSUSPEND', 1, 'SUSPEND', 0, 'NOSUSPEND') AS IS_SUSPENDED
    , DECODE (IS_SUSPENDED_LOCAL, 1, 'TRUE', 0, 'FALSE') AS IS_SUSPENDED_LOCAL
    , PRIORITY                       AS PRIORITY
    , NICE                           AS NICE
    , MIN_PRIORITY                   AS MIN_PRIORITY
    , AGING_AMOUNT                   AS AGING_AMOUNT
    , PARENT_SUSPENDED               AS PARENT_SUSPENDED
    , CHILD_SUSPENDED                AS CHILD_SUSPENDED
    , WARN_COUNT                     AS WARN_COUNT
    , WARN_LINK                      AS WARN_LINK
    , dbinfo ('utc_to_datetime', round(mod(SUBMIT_TS, 1125899906842624)/1000)) AS SUBMIT_TS
    , dbinfo ('utc_to_datetime', round(mod(RESUME_TS, 1125899906842624)/1000)) AS RESUME_TS
    , dbinfo ('utc_to_datetime', round(mod(SYNC_TS, 1125899906842624)/1000)) AS SYNC_TS
    , dbinfo ('utc_to_datetime', round(mod(RESOURCE_TS, 1125899906842624)/1000)) AS RESOURCE_TS
    , dbinfo ('utc_to_datetime', round(mod(RUNNABLE_TS, 1125899906842624)/1000)) AS RUNNABLE_TS
    , dbinfo ('utc_to_datetime', round(mod(START_TS, 1125899906842624)/1000)) AS START_TS
    , dbinfo ('utc_to_datetime', round(mod(FINSH_TS, 1125899906842624)/1000)) AS FINSH_TS
    , dbinfo ('utc_to_datetime', round(mod(FINAL_TS, 1125899906842624)/1000)) AS FINAL_TS
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , ((NVL(FINAL_TS, dbinfo ('utc_current') * 1000) - SUBMIT_TS) / 1000) - DEPENDENCY_WAIT_TIME AS PROCESS_TIME
  FROM SUBMITTED_ENTITY;
DROP VIEW SCI_C_TEMPLATE_VARIABLE;
DROP VIEW SCI_V_TEMPLATE_VARIABLE;
CREATE VIEW SCI_C_TEMPLATE_VARIABLE (ID,PD_ID,RT_ID,VALUE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , PD_ID                          AS PD_ID
    , RT_ID                          AS RT_ID
    , VALUE                          AS VALUE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM TEMPLATE_VARIABLE
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_TEMPLATE_VARIABLE (ID,PD_ID,RT_ID,VALUE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , PD_ID                          AS PD_ID
    , RT_ID                          AS RT_ID
    , VALUE                          AS VALUE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM TEMPLATE_VARIABLE;
DROP VIEW SCI_C_TRIGGER_DEFINITION;
DROP VIEW SCI_V_TRIGGER_DEFINITION;
CREATE VIEW SCI_C_TRIGGER_DEFINITION (ID,NAME,FIRE_ID,OBJECT_TYPE,SE_ID,MAIN_SE_ID,PARENT_SE_ID,IS_ACTIVE,ACTION,TYPE,IS_MASTER,IS_SUSPEND,IS_CREATE,IS_CHANGE,IS_DELETE,IS_GROUP,RESUME_AT,RESUME_IN,RESUME_BASE,IS_WARN_ON_LIMIT,MAX_RETRY,SUBMIT_OWNER_ID,CONDITION,CHECK_AMOUNT,CHECK_BASE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , FIRE_ID                        AS FIRE_ID
    , DECODE (OBJECT_TYPE, 0, 'JOB_DEFINITION', 1, 'RESOURCE', 2, 'NAMED_RESOURCE', 3, 'OBJECT_MONITOR') AS OBJECT_TYPE
    , SE_ID                          AS SE_ID
    , MAIN_SE_ID                     AS MAIN_SE_ID
    , PARENT_SE_ID                   AS PARENT_SE_ID
    , DECODE (IS_ACTIVE, 1, 'TRUE', 0, 'FALSE') AS IS_ACTIVE
    , DECODE (ACTION, 0, 'SUBMIT', 1, 'RERUN') AS ACTION
    , DECODE (TYPE, 0, 'IMMEDIATE_LOCAL', 2, 'BEFORE_FINAL', 3, 'AFTER_FINAL', 1, 'IMMEDIATE_MERGE', 4, 'FINISH_CHILD', 5, 'UNTIL_FINISHED', 6, 'UNTIL_FINAL', 7, 'WARNING') AS TYPE
    , DECODE (IS_MASTER, 1, 'MASTER', 0, 'NOMASTER') AS IS_MASTER
    , DECODE (IS_SUSPEND, 1, 'SUSPEND', 0, 'NOSUSPEND') AS IS_SUSPEND
    , DECODE (IS_CREATE, 1, 'TRUE', 0, 'FALSE') AS IS_CREATE
    , DECODE (IS_CHANGE, 1, 'TRUE', 0, 'FALSE') AS IS_CHANGE
    , DECODE (IS_DELETE, 1, 'TRUE', 0, 'FALSE') AS IS_DELETE
    , DECODE (IS_GROUP, 1, 'TRUE', 0, 'FALSE') AS IS_GROUP
    , RESUME_AT                      AS RESUME_AT
    , RESUME_IN                      AS RESUME_IN
    , DECODE (RESUME_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS RESUME_BASE
    , DECODE (IS_WARN_ON_LIMIT, 1, 'TRUE', 0, 'FALSE') AS IS_WARN_ON_LIMIT
    , MAX_RETRY                      AS MAX_RETRY
    , SUBMIT_OWNER_ID                AS SUBMIT_OWNER_ID
    , CONDITION                      AS CONDITION
    , CHECK_AMOUNT                   AS CHECK_AMOUNT
    , DECODE (CHECK_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS CHECK_BASE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM TRIGGER_DEFINITION
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_TRIGGER_DEFINITION (ID,NAME,FIRE_ID,OBJECT_TYPE,SE_ID,MAIN_SE_ID,PARENT_SE_ID,IS_ACTIVE,ACTION,TYPE,IS_MASTER,IS_SUSPEND,IS_CREATE,IS_CHANGE,IS_DELETE,IS_GROUP,RESUME_AT,RESUME_IN,RESUME_BASE,IS_WARN_ON_LIMIT,MAX_RETRY,SUBMIT_OWNER_ID,CONDITION,CHECK_AMOUNT,CHECK_BASE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , FIRE_ID                        AS FIRE_ID
    , DECODE (OBJECT_TYPE, 0, 'JOB_DEFINITION', 1, 'RESOURCE', 2, 'NAMED_RESOURCE', 3, 'OBJECT_MONITOR') AS OBJECT_TYPE
    , SE_ID                          AS SE_ID
    , MAIN_SE_ID                     AS MAIN_SE_ID
    , PARENT_SE_ID                   AS PARENT_SE_ID
    , DECODE (IS_ACTIVE, 1, 'TRUE', 0, 'FALSE') AS IS_ACTIVE
    , DECODE (ACTION, 0, 'SUBMIT', 1, 'RERUN') AS ACTION
    , DECODE (TYPE, 0, 'IMMEDIATE_LOCAL', 2, 'BEFORE_FINAL', 3, 'AFTER_FINAL', 1, 'IMMEDIATE_MERGE', 4, 'FINISH_CHILD', 5, 'UNTIL_FINISHED', 6, 'UNTIL_FINAL', 7, 'WARNING') AS TYPE
    , DECODE (IS_MASTER, 1, 'MASTER', 0, 'NOMASTER') AS IS_MASTER
    , DECODE (IS_SUSPEND, 1, 'SUSPEND', 0, 'NOSUSPEND') AS IS_SUSPEND
    , DECODE (IS_CREATE, 1, 'TRUE', 0, 'FALSE') AS IS_CREATE
    , DECODE (IS_CHANGE, 1, 'TRUE', 0, 'FALSE') AS IS_CHANGE
    , DECODE (IS_DELETE, 1, 'TRUE', 0, 'FALSE') AS IS_DELETE
    , DECODE (IS_GROUP, 1, 'TRUE', 0, 'FALSE') AS IS_GROUP
    , RESUME_AT                      AS RESUME_AT
    , RESUME_IN                      AS RESUME_IN
    , DECODE (RESUME_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS RESUME_BASE
    , DECODE (IS_WARN_ON_LIMIT, 1, 'TRUE', 0, 'FALSE') AS IS_WARN_ON_LIMIT
    , MAX_RETRY                      AS MAX_RETRY
    , SUBMIT_OWNER_ID                AS SUBMIT_OWNER_ID
    , CONDITION                      AS CONDITION
    , CHECK_AMOUNT                   AS CHECK_AMOUNT
    , DECODE (CHECK_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS CHECK_BASE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM TRIGGER_DEFINITION;
DROP VIEW SCI_TRIGGER_QUEUE;
CREATE VIEW SCI_TRIGGER_QUEUE (ID,SME_ID,TR_ID,NEXT_TRIGGER_TIME,TIMES_CHECKED,TIMES_TRIGGERED,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , SME_ID                         AS SME_ID
    , TR_ID                          AS TR_ID
    , NEXT_TRIGGER_TIME              AS NEXT_TRIGGER_TIME
    , TIMES_CHECKED                  AS TIMES_CHECKED
    , TIMES_TRIGGERED                AS TIMES_TRIGGERED
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM TRIGGER_QUEUE;
DROP VIEW SCI_C_TRIGGER_STATE;
DROP VIEW SCI_V_TRIGGER_STATE;
CREATE VIEW SCI_C_TRIGGER_STATE (ID,TRIGGER_ID,FROM_STATE_ID,TO_STATE_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , TRIGGER_ID                     AS TRIGGER_ID
    , FROM_STATE_ID                  AS FROM_STATE_ID
    , TO_STATE_ID                    AS TO_STATE_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM TRIGGER_STATE
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_TRIGGER_STATE (ID,TRIGGER_ID,FROM_STATE_ID,TO_STATE_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , TRIGGER_ID                     AS TRIGGER_ID
    , FROM_STATE_ID                  AS FROM_STATE_ID
    , TO_STATE_ID                    AS TO_STATE_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM TRIGGER_STATE;
ALTER TABLE USERS ADD (
    SALT lvarchar(64),
    METHOD int8 DEFAULT 0 NOT NULL
);
DROP VIEW SCI_USERS;
CREATE VIEW SCI_USERS (ID,NAME,IS_ENABLED,DEFAULT_G_ID,DELETE_VERSION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , DECODE (IS_ENABLED, 1, 'TRUE', 0, 'FALSE') AS IS_ENABLED
    , DEFAULT_G_ID                   AS DEFAULT_G_ID
    , DELETE_VERSION                 AS DELETE_VERSION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM USERS;
DROP VIEW SCI_C_WATCH_TYPE;
DROP VIEW SCI_V_WATCH_TYPE;
CREATE VIEW SCI_C_WATCH_TYPE (ID,NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM WATCH_TYPE
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_WATCH_TYPE (ID,NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM WATCH_TYPE;
DROP VIEW SCI_WATCH_TYPE_PARAMETER;
CREATE VIEW SCI_WATCH_TYPE_PARAMETER (ID,NAME,DEFAULTVALUE,WT_ID,IS_SUBMIT_PAR,TYPE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , DEFAULTVALUE                   AS DEFAULTVALUE
    , WT_ID                          AS WT_ID
    , DECODE (IS_SUBMIT_PAR, 1, 'TRUE', 0, 'FALSE') AS IS_SUBMIT_PAR
    , DECODE (TYPE, 1, 'CONFIG', 2, 'VALUE', 3, 'INFO') AS TYPE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM WATCH_TYPE_PARAMETER;
DROP VIEW SCI_RESOURCE_TRACE;
CREATE VIEW SCI_RESOURCE_TRACE (R_ID,TAG,TRACE_INTERVAL,TRACE_BASE,TRACE_BASE_MULTIPLIER,TD0_AVG,TD1_AVG,TD2_AVG,LW_AVG,WRITE_TIME,LAST_WRITE) AS
SELECT 
    R_ID                           AS R_ID
    , TAG                            AS TAG
    , TRACE_INTERVAL                 AS TRACE_INTERVAL
    , TRACE_BASE                     AS TRACE_BASE
    , TRACE_BASE_MULTIPLIER          AS TRACE_BASE_MULTIPLIER
    , TD0_AVG                        AS TD0_AVG
    , TD1_AVG                        AS TD1_AVG
    , TD2_AVG                        AS TD2_AVG
    , LW_AVG                         AS LW_AVG
    , dbinfo ('utc_to_datetime', round(mod(WRITE_TIME, 1125899906842624)/1000)) AS WRITE_TIME
    , dbinfo ('utc_to_datetime', round(mod(LAST_WRITE, 1125899906842624)/1000)) AS LAST_WRITE
  FROM RESOURCE_TRACE;
CREATE TABLE SME2LOAD (ID BIGINT NOT NULL);
CREATE INDEX SME2LOAD_IDX ON SME2LOAD (ID);
CREATE INDEX SME_IDX ON SUBMITTED_ENTITY (MASTER_ID, ID, STATE, FINAL_TS);
CREATE INDEX KILL_JOB_IDX ON KILL_JOB (SME_ID);
CREATE INDEX AUDIT_TRAIL_IDX ON AUDIT_TRAIL (OBJECT_ID);
CREATE INDEX ENTITY_VARIABLE_IDX ON ENTITY_VARIABLE (SME_ID);
CREATE INDEX DEPENDENCY_INSTANCE_IDX ON DEPENDENCY_INSTANCE (DEPENDENT_ID);
CREATE INDEX HIERARCHY_INSTANCE_IDX ON HIERARCHY_INSTANCE (CHILD_ID);
UPDATE RESOURCE_ALLOCATION
   SET STICKY_PARENT = (
       SELECT MASTER_ID
         FROM SUBMITTED_ENTITY
        WHERE ID = SME_ID
       )
 WHERE IS_STICKY = 1
   AND SME_ID > 0;
UPDATE RESOURCE_ALLOCATION
   SET STICKY_PARENT = -SME_ID
 WHERE IS_STICKY = 1
   AND SME_ID < 0;
ALTER TABLE SCOPE MODIFY (PASSWD VARCHAR(64));
commit;
