-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE [OBJECT_INSTANCE] (
    [ID]                           decimal (38) NOT NULL
    , [UNIQUE_NAME]                  varchar(256)    NOT NULL
    , [OM_ID]                        decimal (38)    NOT NULL
    , [MODIFY_TS]                    decimal (38)        NULL
    , [REMOVE_TS]                    decimal (38)        NULL
    , [CREATOR_U_ID]                 decimal (38)    NOT NULL
    , [CREATE_TS]                    decimal (38)    NOT NULL
    , [CHANGER_U_ID]                 decimal (38)    NOT NULL
    , [CHANGE_TS]                    decimal (38)    NOT NULL
);
go
CREATE UNIQUE INDEX PK_OBJECT_INSTANCE
ON [OBJECT_INSTANCE]([ID]);
go
CREATE VIEW SCI_OBJECT_INSTANCE AS
SELECT 
    ID 
    , [UNIQUE_NAME]                  AS [UNIQUE_NAME]
    , [OM_ID]                        AS [OM_ID]
    , dateadd(ss, round(([MODIFY_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [MODIFY_TS]
    , dateadd(ss, round(([REMOVE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [REMOVE_TS]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
  FROM [OBJECT_INSTANCE];
go
