-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE [POOL_DIST_CONFIG] (
    [ID]                           decimal (38) NOT NULL
    , [PLD_ID]                       decimal (38)    NOT NULL
    , [PR_ID]                        decimal (38)    NOT NULL
    , [IS_MANAGED]                   integer             NULL
    , [NOM_PCT]                      integer             NULL
    , [FREE_PCT]                     integer             NULL
    , [MIN_PCT]                      integer             NULL
    , [MAX_PCT]                      integer             NULL
    , [CREATOR_U_ID]                 decimal (38)    NOT NULL
    , [CREATE_TS]                    decimal (38)    NOT NULL
    , [CHANGER_U_ID]                 decimal (38)    NOT NULL
    , [CHANGE_TS]                    decimal (38)    NOT NULL
);
go
CREATE UNIQUE INDEX PK_POOL_DIST_CONFIG
ON [POOL_DIST_CONFIG]([ID]);
go
CREATE VIEW SCI_POOL_DIST_CONFIG AS
SELECT 
    ID 
    , [PLD_ID]                       AS [PLD_ID]
    , [PR_ID]                        AS [PR_ID]
    , CASE [IS_MANAGED] WHEN 1 THEN 'TRUE' WHEN 0 THEN 'FALSE' END AS [IS_MANAGED]
    , [NOM_PCT]                      AS [NOM_PCT]
    , [FREE_PCT]                     AS [FREE_PCT]
    , [MIN_PCT]                      AS [MIN_PCT]
    , [MAX_PCT]                      AS [MAX_PCT]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
  FROM [POOL_DIST_CONFIG];
go
