-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE [RESOURCE_VARIABLE] (
    [ID]                           decimal (38) NOT NULL
    , [PD_ID]                        decimal (38)    NOT NULL
    , [R_ID]                         decimal (38)    NOT NULL
    , [VALUE]                        varchar(256)    NOT NULL
    , [CREATOR_U_ID]                 decimal (38)    NOT NULL
    , [CREATE_TS]                    decimal (38)    NOT NULL
    , [CHANGER_U_ID]                 decimal (38)    NOT NULL
    , [CHANGE_TS]                    decimal (38)    NOT NULL
);
go
CREATE UNIQUE INDEX PK_RESOURCE_VARIABLE
ON [RESOURCE_VARIABLE]([ID]);
go
CREATE VIEW SCI_RESOURCE_VARIABLE AS
SELECT 
    ID 
    , [PD_ID]                        AS [PD_ID]
    , [R_ID]                         AS [R_ID]
    , [VALUE]                        AS [VALUE]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
  FROM [RESOURCE_VARIABLE];
go
