-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE [SME_COUNTER] (
    [ID]                           decimal (38) NOT NULL
    , [JAHR]                         integer         NOT NULL
    , [MONAT]                        integer         NOT NULL
    , [TAG]                          integer         NOT NULL
    , [ANZAHL]                       integer         NOT NULL
    , [CHECKSUM]                     decimal (38)    NOT NULL
    , [CREATOR_U_ID]                 decimal (38)    NOT NULL
    , [CREATE_TS]                    decimal (38)    NOT NULL
    , [CHANGER_U_ID]                 decimal (38)    NOT NULL
    , [CHANGE_TS]                    decimal (38)    NOT NULL
);
go
CREATE UNIQUE INDEX PK_SME_COUNTER
ON [SME_COUNTER]([ID]);
go
CREATE VIEW SCI_SME_COUNTER AS
SELECT 
    ID 
    , [JAHR]                         AS [JAHR]
    , [MONAT]                        AS [MONAT]
    , [TAG]                          AS [TAG]
    , [ANZAHL]                       AS [ANZAHL]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
  FROM [SME_COUNTER];
go
