-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE [USERS] (
    [ID]                           decimal (38) NOT NULL
    , [NAME]                         varchar(64)     NOT NULL
    , [PASSWD]                       varchar(64)     NOT NULL
    , [SALT]                         varchar(64)         NULL
    , [METHOD]                       integer         NOT NULL
    , [IS_ENABLED]                   integer         NOT NULL
    , [DEFAULT_G_ID]                 decimal (38)    NOT NULL
    , [CONNECTION_TYPE]              integer         NOT NULL
    , [DELETE_VERSION]               decimal (38)    NOT NULL
    , [CREATOR_U_ID]                 decimal (38)    NOT NULL
    , [CREATE_TS]                    decimal (38)    NOT NULL
    , [CHANGER_U_ID]                 decimal (38)    NOT NULL
    , [CHANGE_TS]                    decimal (38)    NOT NULL
);
go
CREATE UNIQUE INDEX PK_USERS
ON [USERS]([ID]);
go
CREATE VIEW SCI_USERS AS
SELECT 
    ID 
    , [NAME]                         AS [NAME]
    , CASE [IS_ENABLED] WHEN 1 THEN 'TRUE' WHEN 0 THEN 'FALSE' END AS [IS_ENABLED]
    , [DEFAULT_G_ID]                 AS [DEFAULT_G_ID]
    , CASE [CONNECTION_TYPE] WHEN 0 THEN 'PLAIN' WHEN 1 THEN 'SSL' WHEN 2 THEN 'SSL_AUTH' END AS [CONNECTION_TYPE]
    , [DELETE_VERSION]               AS [DELETE_VERSION]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
  FROM [USERS];
go
