-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE `EVENT_PARAMETER` (
    `ID`                           decimal(20) NOT NULL
    , `KEY`                          varchar(64)     NOT NULL
    , `VALUE`                        varchar(256)    NOT NULL
    , `EVT_ID`                       decimal(20)     NOT NULL
    , `CREATOR_U_ID`                 decimal(20)     NOT NULL
    , `CREATE_TS`                    decimal(20)     NOT NULL
    , `CHANGER_U_ID`                 decimal(20)     NOT NULL
    , `CHANGE_TS`                    decimal(20)     NOT NULL
) ENGINE = INNODB;
CREATE UNIQUE INDEX PK_EVENT_PARAMETER
ON `EVENT_PARAMETER`(`ID`);
CREATE VIEW SCI_EVENT_PARAMETER AS
SELECT 
    ID 
    , `KEY`                          AS `KEY`
    , `VALUE`                        AS `VALUE`
    , `EVT_ID`                       AS `EVT_ID`
    , `CREATOR_U_ID`                 AS `CREATOR_U_ID`
    , from_unixtime((`CREATE_TS` & ~1125899906842624)/1000) AS `CREATE_TS`
    , `CHANGER_U_ID`                 AS `CHANGER_U_ID`
    , from_unixtime((`CHANGE_TS` & ~1125899906842624)/1000) AS `CHANGE_TS`
  FROM `EVENT_PARAMETER`;
