-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE "FOLDER" (
    "ID"                           NUMBER (38) NOT NULL
    , "NAME"                         VARCHAR2 (64 CHAR)   NOT NULL
    , "OWNER_ID"                     NUMBER (38)          NOT NULL
    , "ENV_ID"                       NUMBER (38)              NULL
    , "PARENT_ID"                    NUMBER (38)              NULL
    , "CREATOR_U_ID"                 NUMBER (38)          NOT NULL
    , "CREATE_TS"                    NUMBER (38)          NOT NULL
    , "CHANGER_U_ID"                 NUMBER (38)          NOT NULL
    , "CHANGE_TS"                    NUMBER (38)          NOT NULL
    , "INHERIT_PRIVS"                NUMBER (38)          NOT NULL
    , "VALID_FROM"                 NUMBER (38) NOT NULL
    , "VALID_TO"                   NUMBER (38) NOT NULL
    , PRIMARY KEY (ID, VALID_TO)
);
CREATE OR REPLACE VIEW SCI_C_FOLDER AS
SELECT 
    ID 
    , "NAME"                         AS "NAME"
    , "OWNER_ID"                     AS "OWNER_ID"
    , "ENV_ID"                       AS "ENV_ID"
    , "PARENT_ID"                    AS "PARENT_ID"
    , "CREATOR_U_ID"                 AS "CREATOR_U_ID"
    , pkg_time.gmt2local("CREATE_TS") AS "CREATE_TS"
    , "CHANGER_U_ID"                 AS "CHANGER_U_ID"
    , pkg_time.gmt2local("CHANGE_TS") AS "CHANGE_TS"
    , "INHERIT_PRIVS"                AS "INHERIT_PRIVS"
  FROM "FOLDER"
 WHERE VALID_TO = 9223372036854775807;
CREATE OR REPLACE VIEW SCI_V_FOLDER AS
SELECT 
    ID 
    , "NAME"                         AS "NAME"
    , "OWNER_ID"                     AS "OWNER_ID"
    , "ENV_ID"                       AS "ENV_ID"
    , "PARENT_ID"                    AS "PARENT_ID"
    , "CREATOR_U_ID"                 AS "CREATOR_U_ID"
    , pkg_time.gmt2local("CREATE_TS") AS "CREATE_TS"
    , "CHANGER_U_ID"                 AS "CHANGER_U_ID"
    , pkg_time.gmt2local("CHANGE_TS") AS "CHANGE_TS"
    , "INHERIT_PRIVS"                AS "INHERIT_PRIVS"
    , VALID_FROM
    , VALID_TO
  FROM "FOLDER";
