-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE "NAMED_RESOURCE" (
    "ID"                           NUMBER (38) PRIMARY KEY
    , "NAME"                         VARCHAR2 (64 CHAR)   NOT NULL
    , "OWNER_ID"                     NUMBER (38)          NOT NULL
    , "PARENT_ID"                    NUMBER (38)              NULL
    , "USAGE"                        NUMBER (1)           NOT NULL
    , "RSP_ID"                       NUMBER (38)              NULL
    , "FACTOR"                       NUMBER                   NULL
    , "CREATOR_U_ID"                 NUMBER (38)          NOT NULL
    , "CREATE_TS"                    NUMBER (38)          NOT NULL
    , "CHANGER_U_ID"                 NUMBER (38)          NOT NULL
    , "CHANGE_TS"                    NUMBER (38)          NOT NULL
    , "INHERIT_PRIVS"                NUMBER (38)          NOT NULL
);
CREATE OR REPLACE VIEW SCI_NAMED_RESOURCE AS
SELECT 
    ID 
    , "NAME"                         AS "NAME"
    , "OWNER_ID"                     AS "OWNER_ID"
    , "PARENT_ID"                    AS "PARENT_ID"
    , DECODE (USAGE, 1, 'STATIC', 2, 'SYSTEM', 4, 'SYNCHRONIZING', 8, 'CATEGORY', 3, 'POOL') AS "USAGE"
    , "RSP_ID"                       AS "RSP_ID"
    , "FACTOR"                       AS "FACTOR"
    , "CREATOR_U_ID"                 AS "CREATOR_U_ID"
    , pkg_time.gmt2local("CREATE_TS") AS "CREATE_TS"
    , "CHANGER_U_ID"                 AS "CHANGER_U_ID"
    , pkg_time.gmt2local("CHANGE_TS") AS "CHANGE_TS"
    , "INHERIT_PRIVS"                AS "INHERIT_PRIVS"
  FROM "NAMED_RESOURCE";
