-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE "POOL_DIST_CONFIG" (
    "ID"                           NUMBER (38) PRIMARY KEY
    , "PLD_ID"                       NUMBER (38)          NOT NULL
    , "PR_ID"                        NUMBER (38)          NOT NULL
    , "IS_MANAGED"                   NUMBER (1)               NULL
    , "NOM_PCT"                      NUMBER (38)              NULL
    , "FREE_PCT"                     NUMBER (38)              NULL
    , "MIN_PCT"                      NUMBER (38)              NULL
    , "MAX_PCT"                      NUMBER (38)              NULL
    , "CREATOR_U_ID"                 NUMBER (38)          NOT NULL
    , "CREATE_TS"                    NUMBER (38)          NOT NULL
    , "CHANGER_U_ID"                 NUMBER (38)          NOT NULL
    , "CHANGE_TS"                    NUMBER (38)          NOT NULL
);
CREATE OR REPLACE VIEW SCI_POOL_DIST_CONFIG AS
SELECT 
    ID 
    , "PLD_ID"                       AS "PLD_ID"
    , "PR_ID"                        AS "PR_ID"
    , DECODE (IS_MANAGED, 1, 'TRUE', 0, 'FALSE') AS "IS_MANAGED"
    , "NOM_PCT"                      AS "NOM_PCT"
    , "FREE_PCT"                     AS "FREE_PCT"
    , "MIN_PCT"                      AS "MIN_PCT"
    , "MAX_PCT"                      AS "MAX_PCT"
    , "CREATOR_U_ID"                 AS "CREATOR_U_ID"
    , pkg_time.gmt2local("CREATE_TS") AS "CREATE_TS"
    , "CHANGER_U_ID"                 AS "CHANGER_U_ID"
    , pkg_time.gmt2local("CHANGE_TS") AS "CHANGE_TS"
  FROM "POOL_DIST_CONFIG";
