-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE "RESOURCE_TEMPLATE" (
    "ID"                           NUMBER (38) NOT NULL
    , "NR_ID"                        NUMBER (38)          NOT NULL
    , "SE_ID"                        NUMBER (38)          NOT NULL
    , "OWNER_ID"                     NUMBER (38)          NOT NULL
    , "RSD_ID"                       NUMBER (38)              NULL
    , "REQUESTABLE_AMOUNT"           NUMBER (38)              NULL
    , "AMOUNT"                       NUMBER (38)              NULL
    , "IS_ONLINE"                    NUMBER (1)           NOT NULL
    , "CREATOR_U_ID"                 NUMBER (38)          NOT NULL
    , "CREATE_TS"                    NUMBER (38)          NOT NULL
    , "CHANGER_U_ID"                 NUMBER (38)          NOT NULL
    , "CHANGE_TS"                    NUMBER (38)          NOT NULL
    , "VALID_FROM"                 NUMBER (38) NOT NULL
    , "VALID_TO"                   NUMBER (38) NOT NULL
    , PRIMARY KEY (ID, VALID_TO)
);
CREATE OR REPLACE VIEW SCI_C_RESOURCE_TEMPLATE AS
SELECT 
    ID 
    , "NR_ID"                        AS "NR_ID"
    , "SE_ID"                        AS "SE_ID"
    , "OWNER_ID"                     AS "OWNER_ID"
    , "RSD_ID"                       AS "RSD_ID"
    , "REQUESTABLE_AMOUNT"           AS "REQUESTABLE_AMOUNT"
    , "AMOUNT"                       AS "AMOUNT"
    , DECODE (IS_ONLINE, 1, 'TRUE', 0, 'FALSE') AS "IS_ONLINE"
    , "CREATOR_U_ID"                 AS "CREATOR_U_ID"
    , pkg_time.gmt2local("CREATE_TS") AS "CREATE_TS"
    , "CHANGER_U_ID"                 AS "CHANGER_U_ID"
    , pkg_time.gmt2local("CHANGE_TS") AS "CHANGE_TS"
  FROM "RESOURCE_TEMPLATE"
 WHERE VALID_TO = 9223372036854775807;
CREATE OR REPLACE VIEW SCI_V_RESOURCE_TEMPLATE AS
SELECT 
    ID 
    , "NR_ID"                        AS "NR_ID"
    , "SE_ID"                        AS "SE_ID"
    , "OWNER_ID"                     AS "OWNER_ID"
    , "RSD_ID"                       AS "RSD_ID"
    , "REQUESTABLE_AMOUNT"           AS "REQUESTABLE_AMOUNT"
    , "AMOUNT"                       AS "AMOUNT"
    , DECODE (IS_ONLINE, 1, 'TRUE', 0, 'FALSE') AS "IS_ONLINE"
    , "CREATOR_U_ID"                 AS "CREATOR_U_ID"
    , pkg_time.gmt2local("CREATE_TS") AS "CREATE_TS"
    , "CHANGER_U_ID"                 AS "CHANGER_U_ID"
    , pkg_time.gmt2local("CHANGE_TS") AS "CHANGE_TS"
    , VALID_FROM
    , VALID_TO
  FROM "RESOURCE_TEMPLATE";
