-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE "SCHEDULING_HIERARCHY" (
    "ID"                           NUMBER (38) NOT NULL
    , "SE_PARENT_ID"                 NUMBER (38)              NULL
    , "SE_CHILD_ID"                  NUMBER (38)              NULL
    , "ALIAS_NAME"                   VARCHAR2 (64 CHAR)       NULL
    , "IS_STATIC"                    NUMBER (1)           NOT NULL
    , "IS_DISABLED"                  NUMBER (1)           NOT NULL
    , "PRIORITY"                     NUMBER (38)          NOT NULL
    , "SUSPEND"                      NUMBER (38)          NOT NULL
    , "RESUME_AT"                    VARCHAR2 (20 CHAR)       NULL
    , "RESUME_IN"                    NUMBER (38)              NULL
    , "RESUME_BASE"                  NUMBER (38)              NULL
    , "MERGE_MODE"                   NUMBER (38)          NOT NULL
    , "ESTP_ID"                      NUMBER (38)              NULL
    , "INT_ID"                       NUMBER (38)              NULL
    , "ENABLE_CONDITION"             VARCHAR2 (2048 CHAR)     NULL
    , "ENABLE_MODE"                  NUMBER (38)          NOT NULL
    , "CREATOR_U_ID"                 NUMBER (38)          NOT NULL
    , "CREATE_TS"                    NUMBER (38)          NOT NULL
    , "CHANGER_U_ID"                 NUMBER (38)          NOT NULL
    , "CHANGE_TS"                    NUMBER (38)          NOT NULL
    , "VALID_FROM"                 NUMBER (38) NOT NULL
    , "VALID_TO"                   NUMBER (38) NOT NULL
    , PRIMARY KEY (ID, VALID_TO)
);
CREATE OR REPLACE VIEW SCI_C_SCHEDULING_HIERARCHY AS
SELECT 
    ID 
    , "SE_PARENT_ID"                 AS "SE_PARENT_ID"
    , "SE_CHILD_ID"                  AS "SE_CHILD_ID"
    , "ALIAS_NAME"                   AS "ALIAS_NAME"
    , DECODE (IS_STATIC, 1, 'STATIC', 0, 'DYNAMIC') AS "IS_STATIC"
    , DECODE (IS_DISABLED, 0, 'ENABLED', 1, 'DISABLED') AS "IS_DISABLED"
    , "PRIORITY"                     AS "PRIORITY"
    , DECODE (SUSPEND, 1, 'CHILDSUSPEND', 2, 'NOSUSPEND', 3, 'SUSPEND') AS "SUSPEND"
    , "RESUME_AT"                    AS "RESUME_AT"
    , "RESUME_IN"                    AS "RESUME_IN"
    , DECODE (RESUME_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS "RESUME_BASE"
    , DECODE (MERGE_MODE, 1, 'MERGE_LOCAL', 2, 'MERGE_GLOBAL', 3, 'NOMERGE', 4, 'FAILURE') AS "MERGE_MODE"
    , "ESTP_ID"                      AS "ESTP_ID"
    , "INT_ID"                       AS "INT_ID"
    , "ENABLE_CONDITION"             AS "ENABLE_CONDITION"
    , DECODE (ENABLE_MODE, 1, 'AND', 2, 'OR') AS "ENABLE_MODE"
    , "CREATOR_U_ID"                 AS "CREATOR_U_ID"
    , pkg_time.gmt2local("CREATE_TS") AS "CREATE_TS"
    , "CHANGER_U_ID"                 AS "CHANGER_U_ID"
    , pkg_time.gmt2local("CHANGE_TS") AS "CHANGE_TS"
  FROM "SCHEDULING_HIERARCHY"
 WHERE VALID_TO = 9223372036854775807;
CREATE OR REPLACE VIEW SCI_V_SCHEDULING_HIERARCHY AS
SELECT 
    ID 
    , "SE_PARENT_ID"                 AS "SE_PARENT_ID"
    , "SE_CHILD_ID"                  AS "SE_CHILD_ID"
    , "ALIAS_NAME"                   AS "ALIAS_NAME"
    , DECODE (IS_STATIC, 1, 'STATIC', 0, 'DYNAMIC') AS "IS_STATIC"
    , DECODE (IS_DISABLED, 0, 'ENABLED', 1, 'DISABLED') AS "IS_DISABLED"
    , "PRIORITY"                     AS "PRIORITY"
    , DECODE (SUSPEND, 1, 'CHILDSUSPEND', 2, 'NOSUSPEND', 3, 'SUSPEND') AS "SUSPEND"
    , "RESUME_AT"                    AS "RESUME_AT"
    , "RESUME_IN"                    AS "RESUME_IN"
    , DECODE (RESUME_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS "RESUME_BASE"
    , DECODE (MERGE_MODE, 1, 'MERGE_LOCAL', 2, 'MERGE_GLOBAL', 3, 'NOMERGE', 4, 'FAILURE') AS "MERGE_MODE"
    , "ESTP_ID"                      AS "ESTP_ID"
    , "INT_ID"                       AS "INT_ID"
    , "ENABLE_CONDITION"             AS "ENABLE_CONDITION"
    , DECODE (ENABLE_MODE, 1, 'AND', 2, 'OR') AS "ENABLE_MODE"
    , "CREATOR_U_ID"                 AS "CREATOR_U_ID"
    , pkg_time.gmt2local("CREATE_TS") AS "CREATE_TS"
    , "CHANGER_U_ID"                 AS "CHANGER_U_ID"
    , pkg_time.gmt2local("CHANGE_TS") AS "CHANGE_TS"
    , VALID_FROM
    , VALID_TO
  FROM "SCHEDULING_HIERARCHY";
