/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.proxy;

import de.independit.scheduler.proxy.Client;
import de.independit.scheduler.proxy.Config;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.util.SDMSThread;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

final class Proxy {
    public static final String __version = "@(#) $Id: Proxy.java,v 1.8.6.1 2013/03/14 10:24:08 ronald Exp $";
    private static final int RECONNECT_DELAY = 1000;
    private static final int CYCLE_DELAY = 9000;
    private static final int CLIENT_SLOT_DELAY = 1000;
    private static final int PROXY_SOCKET_TIMEOUT = 1000;
    private static final int SOCKET_TIMEOUT = 100;
    private final Config cfg;
    private ServerSocket proxySocket = null;
    private final Vector clients = new Vector();
    private int serverNumber = 0;

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                throw new FatalException("(04410221428) Missing config file path argument");
            }
            Config config = new Config(stringArray[0]);
            Proxy proxy = new Proxy(config);
            proxy.run();
        }
        catch (Throwable throwable) {
            SDMSThread.doTrace(null, throwable.getMessage(), -2);
        }
    }

    private static final void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            SDMSThread.doTrace(null, "Interrupted", 1);
        }
    }

    Proxy(Config config) throws FatalException {
        this.cfg = config;
        SDMSThread.doTrace(null, "Establishing proxy at port " + config.port + (config.use_ssl ? " using TLS/SSL" : ""), 2);
        SDMSThread.doTrace(null, "Accepting max. " + config.maxConnects + " concurrent connections", 3);
        for (int i = 0; i < config.hosts.length; ++i) {
            SDMSThread.doTrace(null, "Host [" + i + "]: " + config.hosts[i] + ":" + config.ports[i], 3);
        }
        try {
            if (config.use_ssl) {
                SSLServerSocketFactory sSLServerSocketFactory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
                SSLServerSocket sSLServerSocket = (SSLServerSocket)sSLServerSocketFactory.createServerSocket(config.port);
                sSLServerSocket.setNeedClientAuth(config.clientauth);
                this.proxySocket = sSLServerSocket;
            } else {
                this.proxySocket = new ServerSocket(config.port);
            }
            this.proxySocket.setSoTimeout(1000);
        }
        catch (IOException iOException) {
            throw new FatalException("(04410231949) Cannot establish server socket: " + iOException);
        }
    }

    final void run() {
        SDMSThread.doTrace(null, "-- SDMS -- Proxy -- ready --", 0);
        while (true) {
            Socket socket = null;
            try {
                socket = this.proxySocket.accept();
                socket.setKeepAlive(true);
                socket.setSoTimeout(100);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.cleanup();
                continue;
            }
            catch (IOException iOException) {
                SDMSThread.doTrace(null, "(04410221619) Error accepting connection: " + iOException, -1);
                if (socket == null) continue;
                this.close(socket);
                continue;
            }
            InetAddress inetAddress = socket.getInetAddress();
            inetAddress.getHostName();
            SDMSThread.doTrace(null, "Request from " + inetAddress + ":" + socket.getPort(), 2);
            while (this.clients.size() >= this.cfg.maxConnects) {
                SDMSThread.doTrace(null, "Out of client slots, waiting 1 second", 1);
                Proxy.sleep(1000);
                this.cleanup();
            }
            Socket socket2 = this.connect();
            try {
                Client client = new Client(socket, socket2);
                this.clients.add(client);
                client.start();
                continue;
            }
            catch (FatalException fatalException) {
                SDMSThread.doTrace(null, "(04410240020) Error initializing client: " + fatalException, -1);
                this.close(socket);
                this.close(socket2);
                continue;
            }
            break;
        }
    }

    private final void cleanup() {
        for (int i = this.clients.size() - 1; i >= 0; --i) {
            Client client = (Client)this.clients.get(i);
            if (client.isAlive()) continue;
            this.close(client.clientSocket);
            this.close(client.serverSocket);
            this.clients.remove(i);
        }
    }

    private final void close(Socket socket) {
        try {
            SDMSThread.doTrace(null, "Closing " + socket.getInetAddress(), 2);
            socket.close();
        }
        catch (IOException iOException) {
            SDMSThread.doTrace(null, "Error closing " + socket.getInetAddress() + ": " + iOException, 1);
        }
    }

    private final Socket connect() {
        while (true) {
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByName(this.cfg.hosts[this.serverNumber]);
            }
            catch (UnknownHostException unknownHostException) {
                SDMSThread.doTrace(null, "(04410232353): " + unknownHostException, -1);
                inetAddress = null;
            }
            if (inetAddress != null) {
                int n = this.cfg.ports[this.serverNumber];
                SDMSThread.doTrace(null, "Connecting " + inetAddress + ":" + n, 2);
                try {
                    Socket socket;
                    if (this.cfg.ssls[this.serverNumber]) {
                        SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                        SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(inetAddress, n);
                        socket = sSLSocket;
                    } else {
                        socket = new Socket();
                        socket.setPerformancePreferences(0, 1, 0);
                        socket.setTcpNoDelay(true);
                        socket.connect(new InetSocketAddress(inetAddress, n));
                    }
                    socket.setKeepAlive(true);
                    socket.setSoTimeout(100);
                    return socket;
                }
                catch (IOException iOException) {
                    SDMSThread.doTrace(null, "(04410240012) Connecting " + inetAddress + ":" + n + " failed: " + iOException, -1);
                    Proxy.sleep(1000);
                }
            }
            ++this.serverNumber;
            this.serverNumber %= this.cfg.hosts.length;
            if (this.serverNumber != 0) continue;
            SDMSThread.doTrace(null, "Cycling host list", 2);
            Proxy.sleep(9000);
        }
    }
}

