/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.dump;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.dump.Dump;
import de.independit.scheduler.server.dump.DumpGrant;
import de.independit.scheduler.server.dump.DumpGroup;
import de.independit.scheduler.server.dump.DumpNamedResource;
import de.independit.scheduler.server.dump.DumpResourceStateDefinition;
import de.independit.scheduler.server.dump.DumpResourceTemplateGeneric;
import de.independit.scheduler.server.dump.DumpSchedulingEntity;
import de.independit.scheduler.server.dump.DumpTrigger;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.repository.SDMSParameterDefinition;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionTable;
import de.independit.scheduler.server.repository.SDMSResourceTemplate;
import de.independit.scheduler.server.repository.SDMSTemplateVariable;
import de.independit.scheduler.server.repository.SDMSTemplateVariableTable;
import de.independit.scheduler.server.repository.SDMSTrigger;
import de.independit.scheduler.server.repository.SDMSTriggerTable;
import java.util.Vector;

class DumpResourceTemplate
extends DumpResourceTemplateGeneric {
    public static final String __version = "@(#) $Id: DumpResourceTemplate.java,v 2.7.14.1 2013/03/14 10:24:14 ronald Exp $";
    Long nrId;
    Long seId;
    private String nrName;
    private String seName;
    private Vector resourceDefs;
    private Vector parmList;

    DumpResourceTemplate(SystemEnvironment systemEnvironment, SDMSResourceTemplate sDMSResourceTemplate) throws SDMSException {
        super(systemEnvironment, sDMSResourceTemplate);
    }

    @Override
    final String initialize(SystemEnvironment systemEnvironment) throws SDMSException {
        super.initialize(systemEnvironment);
        this.nrId = this.rt.getNrId(systemEnvironment);
        this.seId = this.rt.getSeId(systemEnvironment);
        this.nrName = DumpNamedResource.getDumpedName(systemEnvironment, this.nrId);
        this.seName = DumpSchedulingEntity.getDumpedName(systemEnvironment, this.seId);
        return this.nrName + "\n\tin " + this.seName;
    }

    private final void loadTrigger(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector = SDMSTriggerTable.idx_fireId.getVector(systemEnvironment, this.rtId);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            SDMSTrigger sDMSTrigger = (SDMSTrigger)vector.get(i);
            Long l = sDMSTrigger.getId(systemEnvironment);
            DumpTrigger.getDumpedName(systemEnvironment, l);
        }
    }

    private final Vector loadParameters(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector<String> vector = new Vector<String>();
        Vector vector2 = SDMSTemplateVariableTable.idx_rtId.getVector(systemEnvironment, this.rt.getId(systemEnvironment));
        int n = vector2.size();
        for (int i = 0; i < n; ++i) {
            SDMSTemplateVariable sDMSTemplateVariable = (SDMSTemplateVariable)vector2.get(i);
            try {
                SDMSParameterDefinition sDMSParameterDefinition = SDMSParameterDefinitionTable.getObject(systemEnvironment, sDMSTemplateVariable.getPdId(systemEnvironment));
                String string = Dump.quotedName(sDMSParameterDefinition.getId(systemEnvironment), sDMSParameterDefinition.getName(systemEnvironment)) + " = " + Dump.quotedString(sDMSTemplateVariable.getValue(systemEnvironment).substring(1));
                vector.add(string);
                continue;
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        return vector.isEmpty() ? null : vector;
    }

    @Override
    final void collect(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n;
        this.resourceDefs = new Vector();
        Long l = this.rt.getRsdId(systemEnvironment);
        if (l != null) {
            this.resourceDefs.add("state = " + DumpResourceStateDefinition.getDumpedName(systemEnvironment, l));
        }
        if ((n = this.rt.getAmount(systemEnvironment)) == null) {
            this.resourceDefs.add("amount = infinite");
        } else {
            this.resourceDefs.add("amount = " + n);
        }
        Integer n2 = this.rt.getRequestableAmount(systemEnvironment);
        if (n2 == null) {
            this.resourceDefs.add("requestable_amount = infinite");
        } else {
            this.resourceDefs.add("requestable_amount = " + n2);
        }
        Boolean bl = this.rt.getIsOnline(systemEnvironment);
        if (bl != null) {
            this.resourceDefs.add(bl != false ? "online" : "offline");
        }
        Long l2 = this.rt.getOwnerId(systemEnvironment);
        this.resourceDefs.add("group = " + DumpGroup.getDumpedName(systemEnvironment, l2));
        this.parmList = this.loadParameters(systemEnvironment);
        this.loadTrigger(systemEnvironment);
        DumpGrant.getDumpedList(systemEnvironment, this.rtId);
    }

    @Override
    final void render(String string) {
        if (this.parmList != null) {
            DumpResourceTemplate.println("alter existing resource " + this.nrName);
            DumpResourceTemplate.println("\tin " + this.seName);
            DumpResourceTemplate.println("\twith");
            DumpResourceTemplate.println("\t\tparameters = none;");
            DumpResourceTemplate.println();
        }
        DumpResourceTemplate.println(string + " resource " + this.nrName);
        DumpResourceTemplate.println("\tin " + this.seName);
        DumpResourceTemplate.println("\twith");
        DumpResourceTemplate.println("\t\t" + DumpResourceTemplate.join(",\n\t\t", this.resourceDefs) + ',');
        DumpResourceTemplate.println("\t\tparameters = " + (this.parmList == null ? "none" : "(\n\t\t\t" + DumpResourceTemplate.join(",\n\t\t\t", this.parmList) + ")") + ";");
    }
}

