/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.dump;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.dump.DumpEvent;
import de.independit.scheduler.server.dump.DumpGroup;
import de.independit.scheduler.server.dump.DumpSchedule;
import de.independit.scheduler.server.dump.DumpScheduledEventGeneric;
import de.independit.scheduler.server.dump.DumpSchedulingEntity;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.parser.IntervalUtil;
import de.independit.scheduler.server.repository.SDMSEvent;
import de.independit.scheduler.server.repository.SDMSEventTable;
import de.independit.scheduler.server.repository.SDMSSchedule;
import de.independit.scheduler.server.repository.SDMSScheduleTable;
import de.independit.scheduler.server.repository.SDMSScheduledEvent;

class DumpScheduledEvent
extends DumpScheduledEventGeneric {
    public static final String __version = "@(#) $Id: DumpScheduledEvent.java,v 2.6.14.1 2013/03/14 10:24:14 ronald Exp $";
    Long sceId;
    Long evtId;
    String jobDefinition;
    private String active;
    private String backlogHandling;
    private String suspendLimit;
    private String group;

    DumpScheduledEvent(SystemEnvironment systemEnvironment, SDMSScheduledEvent sDMSScheduledEvent) throws SDMSException {
        super(systemEnvironment, sDMSScheduledEvent);
    }

    @Override
    final String initialize(SystemEnvironment systemEnvironment) throws SDMSException {
        super.initialize(systemEnvironment);
        this.sceId = this.se.getSceId(systemEnvironment);
        this.evtId = this.se.getEvtId(systemEnvironment);
        String string = DumpSchedule.getDumpedName(systemEnvironment, this.sceId);
        String string2 = DumpEvent.getDumpedName(systemEnvironment, this.evtId);
        return string + '.' + string2;
    }

    private final void loadJobDefinition(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSSchedule sDMSSchedule = SDMSScheduleTable.getObject(systemEnvironment, this.sceId);
        Long l = sDMSSchedule.getSeId(systemEnvironment);
        SDMSEvent sDMSEvent = SDMSEventTable.getObject(systemEnvironment, this.evtId);
        Long l2 = sDMSEvent.getSeId(systemEnvironment);
        if (l != null || l2 != null && IntervalUtil.matchesIdName(sDMSEvent.getName(systemEnvironment))) {
            this.jobDefinition = l == null == (l2 == null) && l.equals(l2) ? (l == null ? "none" : DumpSchedulingEntity.getDumpedName(systemEnvironment, l)) : "none /* dummy due to inconsistency:\n\t\t\t...of schedule = " + (l == null ? "none" : DumpSchedulingEntity.getDumpedName(systemEnvironment, l)) + "\n\t\t\t...of event = " + (l2 == null ? "none" : DumpSchedulingEntity.getDumpedName(systemEnvironment, l2)) + " */";
            this.comments.setJobDefinition(this.jobDefinition);
        }
    }

    private final void loadSuspendLimit(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = this.se.getSuspendLimitAsString(systemEnvironment);
        if (string == null) {
            this.suspendLimit = "default";
        } else {
            Integer n = this.se.getSuspendLimitMultiplier(systemEnvironment);
            this.suspendLimit = DumpScheduledEvent.intervalText(n, string);
        }
    }

    @Override
    final void collect(SystemEnvironment systemEnvironment) throws SDMSException {
        this.loadJobDefinition(systemEnvironment);
        Boolean bl = this.se.getIsActive(systemEnvironment);
        this.active = bl != false ? "active" : "inactive";
        this.backlogHandling = this.se.getBacklogHandlingAsString(systemEnvironment).toLowerCase();
        this.loadSuspendLimit(systemEnvironment);
        this.group = DumpGroup.getDumpedName(systemEnvironment, this.se.getOwnerId(systemEnvironment));
    }

    @Override
    final void render(String string) {
        DumpScheduledEvent.println(string + " scheduled_event " + this.getName());
        if (this.jobDefinition != null) {
            DumpScheduledEvent.println("\t\t(" + this.jobDefinition + ')');
        }
        DumpScheduledEvent.println("\twith");
        DumpScheduledEvent.println("\t\t" + this.active + ',');
        DumpScheduledEvent.println("\t\tbacklog_handling = " + this.backlogHandling + ',');
        DumpScheduledEvent.println("\t\tsuspend_limit = " + this.suspendLimit + ',');
        DumpScheduledEvent.println("\t\tgroup = " + this.group + ';');
    }
}

