/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.dump;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.dump.Compare;
import de.independit.scheduler.server.dump.DumpEvent;
import de.independit.scheduler.server.dump.DumpExitStateDefinition;
import de.independit.scheduler.server.dump.DumpExitStateMappingProfile;
import de.independit.scheduler.server.dump.DumpExitStateProfile;
import de.independit.scheduler.server.dump.DumpFolder;
import de.independit.scheduler.server.dump.DumpFootprint;
import de.independit.scheduler.server.dump.DumpGrant;
import de.independit.scheduler.server.dump.DumpGroup;
import de.independit.scheduler.server.dump.DumpNamedEnvironment;
import de.independit.scheduler.server.dump.DumpResourceRequirement;
import de.independit.scheduler.server.dump.DumpResourceTemplate;
import de.independit.scheduler.server.dump.DumpSchedulingEntityChildren;
import de.independit.scheduler.server.dump.DumpSchedulingEntityGeneric;
import de.independit.scheduler.server.dump.DumpSchedulingEntityParameter;
import de.independit.scheduler.server.dump.DumpSchedulingEntityRequired;
import de.independit.scheduler.server.dump.DumpTrigger;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSEvent;
import de.independit.scheduler.server.repository.SDMSEventTable;
import de.independit.scheduler.server.repository.SDMSParameterDefinition;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionTable;
import de.independit.scheduler.server.repository.SDMSResourceTemplate;
import de.independit.scheduler.server.repository.SDMSResourceTemplateTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSTrigger;
import de.independit.scheduler.server.repository.SDMSTriggerTable;
import java.util.Collections;
import java.util.Vector;

public class DumpSchedulingEntity
extends DumpSchedulingEntityGeneric {
    public static final String __version = "@(#) $Id: DumpSchedulingEntity.java,v 2.11.14.1 2013/03/14 10:24:14 ronald Exp $";
    private int type;
    private Vector withList;
    private Vector resReqList;
    private Vector parmList;

    public static final DumpSchedulingEntity loadDump(SystemEnvironment systemEnvironment, Vector vector, String string) throws SDMSException {
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.get(systemEnvironment, vector, string);
        DumpSchedulingEntity dumpSchedulingEntity = (DumpSchedulingEntity)DumpSchedulingEntity.getRef(systemEnvironment, 13, sDMSSchedulingEntity);
        if (dumpSchedulingEntity != null) {
            return dumpSchedulingEntity;
        }
        return new DumpSchedulingEntity(systemEnvironment, sDMSSchedulingEntity);
    }

    DumpSchedulingEntity(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        super(systemEnvironment, sDMSSchedulingEntity);
    }

    @Override
    final String initialize(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = super.initialize(systemEnvironment);
        Long l = this.se.getFolderId(systemEnvironment);
        String string2 = DumpFolder.getDumpedName(systemEnvironment, l);
        this.type = this.se.getType(systemEnvironment);
        return string2 + '.' + string;
    }

    private final void loadType(SystemEnvironment systemEnvironment) throws SDMSException {
        this.withList.add("TYPE".toLowerCase() + " = " + this.se.getTypeAsString(systemEnvironment).toLowerCase());
    }

    private final void loadRunProgram(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = this.se.getRunProgram(systemEnvironment);
        if (string == null) {
            this.withList.add("run_program = none");
        } else {
            this.withList.add("run_program = " + DumpSchedulingEntity.quotedString(string));
        }
    }

    private final void loadProfile(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.se.getEspId(systemEnvironment);
        if (l != null) {
            this.withList.add("profile = " + DumpExitStateProfile.getDumpedName(systemEnvironment, l));
        }
    }

    private final void loadMapping(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.se.getEsmpId(systemEnvironment);
        if (l == null) {
            this.withList.add("mapping = none");
        } else {
            this.withList.add("mapping = " + DumpExitStateMappingProfile.getDumpedName(systemEnvironment, l));
        }
    }

    private final void loadRerunProgram(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = this.se.getRerunProgram(systemEnvironment);
        if (string == null) {
            this.withList.add("rerun_program = none");
        } else {
            this.withList.add("rerun_program = " + DumpSchedulingEntity.quotedString(string));
        }
    }

    private final void loadKillProgram(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = this.se.getKillProgram(systemEnvironment);
        if (string == null) {
            this.withList.add("kill_program = none");
        } else {
            this.withList.add("kill_program = " + DumpSchedulingEntity.quotedString(string));
        }
    }

    private final void loadWorkdir(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = this.se.getWorkdir(systemEnvironment);
        if (string == null) {
            this.withList.add("workdir = none");
        } else {
            this.withList.add("workdir = " + DumpSchedulingEntity.quotedString(string));
        }
    }

    private final String getFilDef(String string, String string2) throws SDMSException {
        if (string == null) {
            return "none";
        }
        if (string2 == null) {
            return DumpSchedulingEntity.quotedString(string);
        }
        return DumpSchedulingEntity.quotedString(string) + ' ' + string2.toLowerCase();
    }

    private final void loadLogfile(SystemEnvironment systemEnvironment) throws SDMSException {
        this.withList.add("logfile = " + this.getFilDef(this.se.getLogfile(systemEnvironment), this.se.getTruncLogAsString(systemEnvironment)));
    }

    private final void loadErrlog(SystemEnvironment systemEnvironment) throws SDMSException {
        this.withList.add("errlog = " + this.getFilDef(this.se.getErrlogfile(systemEnvironment), this.se.getTruncErrlogAsString(systemEnvironment)));
    }

    private final void loadPriority(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.se.getPriority(systemEnvironment);
        this.withList.add((this.type == 2 ? "nicevalue" : "priority") + " = " + n.toString());
    }

    private final void loadMinPriority(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.se.getMinPriority(systemEnvironment);
        this.withList.add("min priority = " + (n == null ? "none" : n.toString()));
    }

    private final void loadAging(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.se.getAgingAmount(systemEnvironment);
        String string = this.se.getAgingBaseAsString(systemEnvironment);
        this.withList.add("aging = " + (n == null || string == null ? "none" : DumpSchedulingEntity.intervalText(n, string)));
    }

    private final void loadSuspend(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = this.se.getSubmitSuspendedAsString(systemEnvironment);
        this.withList.add(string.toLowerCase());
    }

    private final void loadMaster(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = this.se.getMasterSubmittableAsString(systemEnvironment);
        this.withList.add(string.toLowerCase());
    }

    private final void loadDependencyMode(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.se.getDependencyOperation(systemEnvironment);
        switch (n) {
            case 1: {
                this.withList.add("dependency_mode = all");
                break;
            }
            case 2: {
                this.withList.add("dependency_mode = any");
                break;
            }
            default: {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04205312140", "Unknown SchedulingEntity.DependencyOperation: $1", n));
            }
        }
    }

    private final void loadChildren(SystemEnvironment systemEnvironment) throws SDMSException {
        if (DumpSchedulingEntityChildren.getDumpedList(systemEnvironment, this.seId)) {
            this.withList.add("children = none /* dummy */");
        } else {
            this.withList.add("children = none");
        }
    }

    private final void loadRequired(SystemEnvironment systemEnvironment) throws SDMSException {
        if (DumpSchedulingEntityRequired.getDumpedList(systemEnvironment, this.seId)) {
            this.withList.add("required = none /* dummy */");
        } else {
            this.withList.add("required = none");
        }
    }

    private final void loadEnvironment(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.se.getNeId(systemEnvironment);
        if (l != null) {
            this.withList.add("environment = " + DumpNamedEnvironment.getDumpedName(systemEnvironment, l));
        }
    }

    private final void loadFootprint(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.se.getFpId(systemEnvironment);
        if (l != null) {
            this.withList.add("footprint = " + DumpFootprint.getDumpedName(systemEnvironment, l));
        }
    }

    private final void loadResources(SystemEnvironment systemEnvironment) throws SDMSException {
        this.resReqList = DumpResourceRequirement.getList(systemEnvironment, this.seId);
    }

    private final void loadTimeout(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.se.getTimeoutAmount(systemEnvironment);
        String string = this.se.getTimeoutBaseAsString(systemEnvironment);
        Long l = this.se.getTimeoutStateId(systemEnvironment);
        if (n == null) {
            this.withList.add("timeout = none");
        } else {
            String string2 = DumpExitStateDefinition.getDumpedName(systemEnvironment, l);
            this.withList.add("timeout = " + DumpSchedulingEntity.intervalText(n, string) + " state " + string2);
        }
    }

    private final void loadParameters(SystemEnvironment systemEnvironment) throws SDMSException {
        if (!DumpSchedulingEntityParameter.getDumpedList(systemEnvironment, this.seId)) {
            return;
        }
        Vector vector = SDMSParameterDefinitionTable.idx_seId.getVector(systemEnvironment, this.seId);
        int n = vector.size();
        this.parmList = new Vector(n);
        for (int i = 0; i < n; ++i) {
            SDMSParameterDefinition sDMSParameterDefinition = (SDMSParameterDefinition)vector.get(i);
            Long l = sDMSParameterDefinition.getId(systemEnvironment);
            String string = DumpSchedulingEntity.quotedName(l, sDMSParameterDefinition.getName(systemEnvironment));
            this.parmList.add(string + " parameter /* dummy */");
        }
        Collections.sort(this.parmList, Compare.Lexically);
    }

    private final void loadExpectedRuntime(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.se.getExpectedRuntime(systemEnvironment);
        if (n != null) {
            this.withList.add("runtime = " + n);
        }
    }

    private final void loadGroup(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.se.getOwnerId(systemEnvironment);
        String string = DumpGroup.getDumpedName(systemEnvironment, l);
        this.withList.add("group = " + string);
        DumpGrant.getDumpedList(systemEnvironment, this.seId);
    }

    private final void collectTrigger(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector = SDMSTriggerTable.idx_fireId.getVector(systemEnvironment, this.seId);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            SDMSTrigger sDMSTrigger = (SDMSTrigger)vector.get(i);
            Long l = sDMSTrigger.getId(systemEnvironment);
            DumpTrigger.getDumpedName(systemEnvironment, l);
        }
    }

    private final void collectEvents(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector = SDMSEventTable.idx_seId.getVector(systemEnvironment, this.seId);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            SDMSEvent sDMSEvent = (SDMSEvent)vector.get(i);
            Long l = sDMSEvent.getId(systemEnvironment);
            DumpEvent.getDumpedName(systemEnvironment, l);
        }
    }

    private final void collectLocalResources(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector = SDMSResourceTemplateTable.idx_seId.getVector(systemEnvironment, this.seId);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            SDMSResourceTemplate sDMSResourceTemplate = (SDMSResourceTemplate)vector.get(i);
            Long l = sDMSResourceTemplate.getId(systemEnvironment);
            DumpResourceTemplate.getDumpedName(systemEnvironment, l);
        }
    }

    @Override
    final void collect(SystemEnvironment systemEnvironment) throws SDMSException {
        this.withList = new Vector();
        this.loadType(systemEnvironment);
        switch (this.type) {
            case 1: {
                this.loadRunProgram(systemEnvironment);
                this.loadProfile(systemEnvironment);
                this.loadMapping(systemEnvironment);
                this.loadRerunProgram(systemEnvironment);
                this.loadKillProgram(systemEnvironment);
                this.loadWorkdir(systemEnvironment);
                this.loadLogfile(systemEnvironment);
                this.loadErrlog(systemEnvironment);
                this.loadPriority(systemEnvironment);
                this.loadMinPriority(systemEnvironment);
                this.loadAging(systemEnvironment);
                this.loadSuspend(systemEnvironment);
                this.loadMaster(systemEnvironment);
                this.loadDependencyMode(systemEnvironment);
                this.loadEnvironment(systemEnvironment);
                this.loadFootprint(systemEnvironment);
                this.loadChildren(systemEnvironment);
                this.loadRequired(systemEnvironment);
                this.loadResources(systemEnvironment);
                this.loadTimeout(systemEnvironment);
                this.loadParameters(systemEnvironment);
                this.loadExpectedRuntime(systemEnvironment);
                this.loadGroup(systemEnvironment);
                break;
            }
            case 2: {
                this.loadProfile(systemEnvironment);
                this.loadPriority(systemEnvironment);
                this.loadSuspend(systemEnvironment);
                this.loadMaster(systemEnvironment);
                this.loadDependencyMode(systemEnvironment);
                this.loadChildren(systemEnvironment);
                this.loadRequired(systemEnvironment);
                this.loadParameters(systemEnvironment);
                this.loadGroup(systemEnvironment);
                break;
            }
            case 3: {
                this.loadProfile(systemEnvironment);
                this.loadSuspend(systemEnvironment);
                this.loadDependencyMode(systemEnvironment);
                this.loadChildren(systemEnvironment);
                this.loadRequired(systemEnvironment);
                this.loadGroup(systemEnvironment);
                break;
            }
            default: {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04206052031", "Unknown job type: $1", this.se.getType(systemEnvironment)));
            }
        }
        this.collectTrigger(systemEnvironment);
        this.collectEvents(systemEnvironment);
        this.collectLocalResources(systemEnvironment);
    }

    @Override
    final void render(String string) {
        if (this.resReqList != null) {
            this.withList.add("resources = " + DumpSchedulingEntity.renderList(this.resReqList));
        }
        if (this.type != 3) {
            this.withList.add("parameters = " + (this.parmList == null ? "none" : DumpSchedulingEntity.renderList(this.parmList)));
        }
        DumpSchedulingEntity.print(string + " job_definition " + this.getName());
        if (!this.withList.isEmpty()) {
            DumpSchedulingEntity.println("\n\twith");
            DumpSchedulingEntity.print("\t\t" + DumpSchedulingEntity.join(",\n\t\t", this.withList));
        }
        DumpSchedulingEntity.println(';');
    }
}

